/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseFormQueryParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseFormQueryFilterUI;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAnalyseFormQueryFilterUI
extends AbstractBgAnalyseFormQueryFilterUI {
    private static final long serialVersionUID = -1544861537727835479L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseFormQueryFilterUI.class);
    private static final String BGFORMINFO_ID = "BGFORMINFO_ID";
    private static final String HAS_GATHER = "HAS_GATHER";
    private static final String BGITEMGROUP_ID = "bgItemGroupId";
    private static final String BGITEM_ID = "bgItemId";
    private String bgItemGroupId = null;
    private String bgItemId = null;

    public BgAnalyseFormQueryFilterUI() throws Exception {
    }

    public BgAnalyseFormQueryFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initComboBox();
        String text = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"bgFormQueryNote");
        this.lblNote.getFont().getSize();
        this.lblNote.setText("<html><font size=3>" + text + "</font></html>");
        this.lblNote.setToolTipText(text);
        this.lblNote.setForeground(Color.GRAY);
    }

    private void initComboBox() throws Exception {
        this.comBgForm.setLimitedSize(false);
        this.comBgForm.setComboPopupWidth(400);
        BgItemGroupInDialog gdlg = new BgItemGroupInDialog((IUIObject)this);
        gdlg.setIsOnlySelectLeaf(Boolean.TRUE);
        this.prmtBgItemGroup.setSelector((KDPromptSelector)gdlg);
        this.prmtBgItemGroup.setEditable(false);
        NewBgItemDialog idlg = new NewBgItemDialog((IUIObject)this);
        idlg.setMulSelect(false);
        idlg.setSelectCombinItem(false);
        idlg.setIsReturnEntry(Boolean.TRUE);
        String orgUnitId = null;
        if (this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo) {
            orgUnitId = ((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            idlg.setOrgUnitId("NULL_ORGUNITID");
        } else {
            idlg.setOrgUnitId(orgUnitId);
        }
        this.prmtBgItem.setSelector((KDPromptSelector)idlg);
        this.prmtBgItem.setEditable(false);
    }

    @Override
    protected void orgUnit_dataChanged(DataChangeEvent e) throws Exception {
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        bgItemSelect.setMulSelect(false);
        bgItemSelect.setSelectCombinItem(false);
        bgItemSelect.setIsReturnEntry(Boolean.TRUE);
        String orgUnitId = "";
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null) {
            if (obj instanceof FullOrgUnitInfo) {
                orgUnitId = ((FullOrgUnitInfo)obj).getId().toString();
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnitId = ((OrgUnitInfo[])obj)[0].getId().toString();
            }
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            bgItemSelect.setOrgUnitId("NULL_ORGUNITID");
        } else {
            bgItemSelect.setOrgUnitId(orgUnitId);
        }
        this.prmtBgItem.setSelector((KDPromptSelector)bgItemSelect);
        super.orgUnit_dataChanged(e);
    }

    @Override
    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseFormQueryResource", (String)"filterTitle");
    }

    @Override
    protected void initFilter() throws Exception {
        super.initFilter();
        this.comAnalyseType.addItem((Object)BgAnalyseHelper.getMessage("bgFormQueryTitle"));
        this.comAnalyseType.setSelectedItem((Object)BgAnalyseHelper.getMessage("bgFormQueryTitle"));
    }

    @Override
    protected void bgScheme_actionPerformed(ActionEvent e) throws Exception {
        this.comBgForm.removeAllItems();
        if (this.prmtOrgUnit.getData() != null && this.comBgScheme.getSelectedItem() != null) {
            HashSet<Object> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _tmpOrgUnit = null;
            OrgUnitInfo _currOrgUnit = null;
            Object obj = this.prmtOrgUnit.getData();
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.comBgScheme.getSelectedItem();
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<Object>();
            if (orgUnits != null && orgUnits.length > 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                int n = orgUnits.length;
                for (int i = 0; i < n; ++i) {
                    _tmpOrgUnit = orgUnits[i];
                    subOrgUnits.add(_tmpOrgUnit.getId());
                }
            }
            if (orgUnits != null && orgUnits.length == 1) {
                subOrgUnits.add(orgUnits[0].getId().toString());
            }
            BgFormCollection bgFormCol = null;
            try {
                bgFormCol = this.getBgFormInfo(bgSchemeInfo.getId(), subOrgUnits, this.isHasUseFund(), false);
                BgFormInfo info = null;
                for (int i = bgFormCol.size() - 1; i >= 0; --i) {
                    info = bgFormCol.get(i);
                    if (info.getBgTemplate() != null && BgTemFormTypeEnum.VIEWFORM.equals((Object)info.getBgTemplate().getFormType())) {
                        bgFormCol.removeObject(i);
                        continue;
                    }
                    if (this.bgItemId != null) {
                        if (info.getBgItem() == null) {
                            bgFormCol.removeObject(i);
                            continue;
                        }
                        if (info.getBgItem() == null || info.getBgItem().getId() == null || this.bgItemId.equals(info.getBgItem().getId().toString())) continue;
                        bgFormCol.removeObject(i);
                        continue;
                    }
                    if (this.bgItemGroupId == null) continue;
                    if (info.getBgItemGroup() == null) {
                        bgFormCol.removeObject(i);
                        continue;
                    }
                    if (info.getBgItemGroup() == null || info.getBgItemGroup().getId() == null || this.bgItemGroupId.equals(info.getBgItemGroup().getId().toString())) continue;
                    bgFormCol.removeObject(i);
                }
                this.comBgForm.addItems(bgFormCol.toArray());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    @Override
    protected void prmtBgItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBgItemGroup.getData() != null) {
            this.prmtBgItem.setData(null);
            BgItemGroupInfo info = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
            this.bgItemGroupId = info.getId().toString();
            NewBgItemDialog idlg = (NewBgItemDialog)this.prmtBgItem.getSelector();
            idlg.setItemGroup(info.getNumber());
        } else {
            this.bgItemGroupId = null;
            this.bgItemId = null;
            this.prmtBgItem.setData(null);
        }
        this.bgScheme_actionPerformed(null);
    }

    @Override
    protected void prmtBgItem_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBgItem.getData() != null) {
            BgItemObject itemObj = (BgItemObject)this.prmtBgItem.getData();
            this.bgItemId = itemObj.getResult().get(0).getId().toString();
        } else {
            this.bgItemId = null;
        }
        this.bgScheme_actionPerformed(null);
    }

    @Override
    protected void prmtBgItem_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgItemGroup.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"please.select.group.first"));
            SysUtil.abort();
        }
    }

    protected BgFormCollection getBgFormInfo(BOSUuid bgSchemeId, Set subOrgUnits, boolean hasUseFund, boolean isFund) throws Exception {
        return this.getInterface().getCommonBgForm(bgSchemeId, subOrgUnits, hasUseFund, isFund, true);
    }

    @Override
    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.prmtBgPeriodBegin.getData() == null && this.prmtBgPeriodEnd.getData() != null) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodBegin"));
                return false;
            }
            if (this.prmtBgPeriodEnd.getData() == null && this.prmtBgPeriodBegin.getData() != null) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodEnd"));
                return false;
            }
            if (this.comBgForm.getSelectedItem() == null) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgForm"));
                return false;
            }
            if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodEnd.getData() != null) {
                BgPeriodInfo _begin = null;
                BgPeriodInfo _end = null;
                _begin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
                _end = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
                if (_begin.getPeriodType().getValue() != _end.getPeriodType().getValue()) {
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodNoAccord"));
                    return false;
                }
            }
        }
        return re;
    }

    @Override
    public void clear() {
        super.clear();
        this.comBgForm.setSelectedItem(null);
        this.chkIsSum.setSelected(false);
        this.prmtBgItemGroup.setData(null);
        this.prmtBgItem.setData(null);
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgAnalyseFormQueryParam();
    }

    @Override
    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _fp = super.getFilterParam(mainParam, filterParam);
        BgAnalyseFormQueryParam _mainParam = null;
        BgAnalyseFormQueryParam _filterParam = null;
        if (_fp != null) {
            _mainParam = (BgAnalyseFormQueryParam)_fp;
            _filterParam = (BgAnalyseFormQueryParam)filterParam;
            if (_filterParam.getBgFormInfo() != null) {
                _mainParam.setBgFormInfo(_filterParam.getBgFormInfo());
            } else {
                _mainParam.setBgFormInfo(null);
            }
            if (_filterParam.isCol()) {
                _mainParam.setCol(_filterParam.isCol());
            } else {
                _mainParam.setCol(false);
            }
            if (_filterParam.getBgItemGroupInfo() != null) {
                _mainParam.setBgItemGroupInfo(_filterParam.getBgItemGroupInfo());
            } else {
                _mainParam.setBgItemGroupInfo(null);
            }
            if (_filterParam.getBgItemInfo() != null) {
                _mainParam.setBgItemInfo(_filterParam.getBgItemInfo());
            } else {
                _mainParam.setBgItemInfo(null);
            }
        }
        return _mainParam;
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseFormQueryParam) {
            BgAnalyseFormQueryParam _filterParam = (BgAnalyseFormQueryParam)filterParam;
            if (this.comBgForm.getSelectedItem() != null) {
                _filterParam.setBgFormInfo((BgFormInfo)this.comBgForm.getSelectedItem());
            } else {
                _filterParam.setBgFormInfo(null);
            }
            if (this.prmtBgItemGroup.getData() != null) {
                _filterParam.setBgItemGroupInfo((BgItemGroupInfo)this.prmtBgItemGroup.getData());
            } else {
                _filterParam.setBgItemGroupInfo(null);
            }
            if (this.prmtBgItem.getValue() != null) {
                BgItemObject itemObj = (BgItemObject)this.prmtBgItem.getData();
                _filterParam.setBgItemInfo(itemObj.getResult().get(0));
            } else {
                _filterParam.setBgItemInfo(null);
            }
            _filterParam.setCol(this.chkIsSum.isSelected());
        }
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseFormQueryParam) {
            BgAnalyseFormQueryParam _filterParam = (BgAnalyseFormQueryParam)filterParam;
            if (_filterParam.getBgItemGroupInfo() != null) {
                this.prmtBgItemGroup.setValue((Object)_filterParam.getBgItemGroupInfo());
            }
            if (_filterParam.getBgItemInfo() != null) {
                BgItemObject itemObj = new BgItemObject(new BgItemCollection());
                itemObj.getResult().add(_filterParam.getBgItemInfo());
                this.prmtBgItem.setData((Object)itemObj);
            }
            if (_filterParam.getBgFormInfo() != null) {
                int count = this.comBgForm.getItemCount();
                for (int i = 0; i < count; ++i) {
                    this.comBgForm.setSelectedIndex(i);
                    BgFormInfo info = (BgFormInfo)this.comBgForm.getSelectedItem();
                    if (info.getId().toString().equals(_filterParam.getBgFormInfo().getId().toString())) break;
                }
            }
            this.chkIsSum.setSelected(_filterParam.isCol());
        }
    }

    @Override
    protected boolean hasNewScheme() {
        return true;
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseFormQueryParam)) {
            return;
        }
        String _tmpStr = null;
        BgAnalyseFormQueryParam _filterParam = (BgAnalyseFormQueryParam)filterParam;
        try {
            _tmpStr = cp.getCustomerParam(BGFORMINFO_ID);
            if (!StringUtils.isEmpty((String)_tmpStr)) {
                _filterParam.setBgFormInfo(new BgFormInfo());
                _filterParam.getBgFormInfo().setId(BOSUuid.read((String)_tmpStr));
            } else {
                _filterParam.setBgFormInfo(null);
            }
            _tmpStr = cp.getCustomerParam(HAS_GATHER);
            if (!StringUtils.isEmpty((String)_tmpStr) && BgNConstants.TRUE_STE.equals(_tmpStr)) {
                _filterParam.setIsCol(Boolean.TRUE);
            } else {
                _filterParam.setIsCol(Boolean.FALSE);
            }
            _tmpStr = cp.getCustomerParam(BGITEMGROUP_ID);
            if (!StringUtils.isEmpty((String)_tmpStr)) {
                _filterParam.setBgItemGroupInfo(new BgItemGroupInfo());
                _filterParam.getBgItemGroupInfo().setId(BOSUuid.read((String)_tmpStr));
            } else {
                _filterParam.setBgItemGroupInfo(null);
            }
            _tmpStr = cp.getCustomerParam(BGITEM_ID);
            if (!StringUtils.isEmpty((String)_tmpStr)) {
                _filterParam.setBgItemInfo(new BgItemInfo());
                _filterParam.getBgItemInfo().setId(BOSUuid.read((String)_tmpStr));
            } else {
                _filterParam.setBgItemInfo(null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseFormQueryParam)) {
            return;
        }
        BgAnalyseFormQueryParam _filterParam = (BgAnalyseFormQueryParam)filterParam;
        try {
            if (_filterParam.getBgFormInfo() != null) {
                cp.addCustomerParam(BGFORMINFO_ID, _filterParam.getBgFormInfo().getId().toString());
            } else {
                cp.removeCustomerParam(BGFORMINFO_ID);
            }
            if (_filterParam.isCol()) {
                cp.addCustomerParam(HAS_GATHER, BgNConstants.TRUE_STE);
            } else {
                cp.addCustomerParam(HAS_GATHER, BgNConstants.FALSE_STR);
            }
            if (_filterParam.getBgItemGroupInfo() != null) {
                cp.addCustomerParam(BGITEMGROUP_ID, _filterParam.getBgItemGroupInfo().getId().toString());
            } else {
                cp.removeCustomerParam(BGITEMGROUP_ID);
            }
            if (_filterParam.getBgItemInfo() != null) {
                cp.addCustomerParam(BGITEM_ID, _filterParam.getBgItemInfo().getId().toString());
            } else {
                cp.removeCustomerParam(BGITEM_ID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

