/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseMuFilterUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFormFilterParam;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgAnalyseMuFilterUI
extends AbstractBgAnalyseMuFilterUI {
    private static final long serialVersionUID = 6831416558485942146L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseMuFilterUI.class);

    public BgAnalyseMuFilterUI() throws Exception {
    }

    public BgAnalyseMuFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgAnalyseFormFilterParam();
    }

    public void setPanelName(String panelName) {
        super.setPanelName(BgAnalyseHelper.getMessage("MeasureUnit"));
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initBgElementInfo();
        this.initMeasureUnit();
    }

    protected void initBgElementInfo() throws Exception {
        IRow row = null;
        IBgElement ibgElement = null;
        BgElementInfo bgEleInfo = null;
        BgElementCollection bgEleCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ibgElement = BgElementFactory.getRemoteInstance();
        if (ibgElement == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        bgEleCol = ibgElement.getBgElementCollection(view);
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        if (bgEleCol != null && !bgEleCol.isEmpty()) {
            this.tblMain.setRefresh(false);
            Iterator iter = bgEleCol.iterator();
            while (iter.hasNext()) {
                bgEleInfo = (BgElementInfo)iter.next();
                row = this.tblMain.addRow();
                row.getCell(0).setValue((Object)bgEleInfo);
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMeasureUnit() {
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("coefficient");
        muView.getSelector().addObjectCollection((IObjectCollection)sic);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        IMeasureUnit iMeasureUnit = null;
        MeasureUnitCollection muCol = null;
        try {
            iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
            if (iMeasureUnit == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            muCol = iMeasureUnit.getMeasureUnitCollection(muView);
            if (muCol != null && !muCol.isEmpty()) {
                Iterator iter = muCol.iterator();
                while (iter.hasNext()) {
                    model.addElement(iter.next());
                }
            }
            comboBox.setModel(model);
            this.tblMain.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _mainParam = null;
        return _mainParam;
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
    }
}

