/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgBalanceFilterParam;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.BgRptFilter2UI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import org.apache.log4j.Logger;

public class BgBalanceFilter2UI
extends BgRptFilter2UI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgBalanceFilter2UI");
    private BgBalanceFilterParam balFilterParam;

    public BgBalanceFilter2UI() throws Exception {
    }

    public BgBalanceFilter2UI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
        this.chkIsSum.setSelected(true);
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.balFilterParam == null) {
            this.balFilterParam = new BgBalanceFilterParam();
        }
        return this.balFilterParam;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.chkIsSum.setVisible(true);
        this.prmtBeginPeriod.setEditable(false);
        this.prmtEndPeriod.setEditable(false);
    }

    @Override
    protected void initScheme() {
        String orgUnitId = this.currentCompany.getId().toString();
        IBgScheme iBgScheme = null;
        try {
            iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (iBgScheme != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
            if (BgParamCHelper.isFodian()) {
                items.add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                items.add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString(" #0 and #1 ");
            view.setFilter(filter);
            BgSchemeCollection col = null;
            try {
                col = iBgScheme.getBgSchemeCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            BgHelper.sortCollection(col, new String[]{"number"});
            if (col != null && col.size() > 0) {
                this.comboBgScheme.removeAllItems();
                this.comboBgScheme.addItems(col.toArray());
                this.comboBgScheme.setSelectedIndex(0);
            }
        }
    }

    @Override
    public Object getParam() {
        BgRptFilterParam pa = (BgRptFilterParam)super.getParam();
        if (this.rptType.equals((Object)BgAnalysisTypeEnum.BGBALANCE)) {
            String stritem;
            BgBalanceFilterParam param = (BgBalanceFilterParam)pa;
            VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
            if (vi != null && vi.toString() == null) {
                vi = null;
            }
            param.objItemFrom = vi;
            if (vi != null) {
                stritem = (String)vi.get("number");
                if (stritem != null) {
                    stritem = stritem.replace(',', '_');
                }
                param.setItemFrom(stritem);
            } else {
                param.setItemFrom(null);
            }
            vi = (VisualItemInfo)this.prmtItemTo.getValue();
            if (vi != null && vi.toString() == null) {
                vi = null;
            }
            param.objItemTo = vi;
            if (vi != null) {
                stritem = (String)vi.get("number");
                if (stritem != null) {
                    stritem = stritem.replace(',', '_');
                }
                param.setItemTo(stritem);
            } else {
                param.setItemTo(null);
            }
            BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
            param.objElement = beinfo;
            if (beinfo != null) {
                String stritem2 = beinfo.getId().toString();
                param.setElement(stritem2);
            } else {
                param.setElement(null);
            }
            if (this.prmtCurrency.getValue() != null) {
                param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
            } else {
                try {
                    param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
                }
                catch (Exception e) {
                    param.setCurrency(null);
                }
            }
            param.setBgRptType(BgAnalysisTypeEnum.BGBALANCE);
        }
        return pa;
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        BgRptFilterParam pa = (BgRptFilterParam)this.getFilterObject(cp);
        BgBalanceFilterParam param = null;
        if (this.rptType.equals((Object)BgAnalysisTypeEnum.BGBALANCE)) {
            String stritem;
            param = (BgBalanceFilterParam)pa;
            VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
            if (vi != null && vi.toString() == null) {
                vi = null;
            }
            param.objItemFrom = vi;
            if (vi != null) {
                stritem = (String)vi.get("number");
                if (stritem != null) {
                    stritem = stritem.replace(',', '_');
                }
                param.setItemFrom(stritem);
            } else {
                param.setItemFrom(null);
            }
            vi = (VisualItemInfo)this.prmtItemTo.getValue();
            if (vi != null && vi.toString() == null) {
                vi = null;
            }
            param.objItemTo = vi;
            if (vi != null) {
                stritem = (String)vi.get("number");
                if (stritem != null) {
                    stritem = stritem.replace(',', '_');
                }
                param.setItemTo(stritem);
            } else {
                param.setItemTo(null);
            }
            BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
            param.objElement = beinfo;
            if (beinfo != null) {
                String stritem2 = beinfo.getId().toString();
                param.setElement(stritem2);
            } else {
                param.setElement(null);
            }
            if (this.prmtCurrency.getValue() != null) {
                param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
            } else {
                try {
                    param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
                }
                catch (Exception e) {
                    param.setCurrency(null);
                }
            }
            param.setBgRptType(BgAnalysisTypeEnum.BGBALANCE);
        }
        this.setFilterObject(cp, param);
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        BgBalanceFilterParam filterParam = (BgBalanceFilterParam)this.getFilterObject(cp);
        if (filterParam != null) {
            this.prmtItemFrom.setData(filterParam.objItemFrom);
            this.prmtItemTo.setData(filterParam.objItemTo);
            this.prmtElement.setData(filterParam.objElement);
            this.prmtCurrency.setData((Object)filterParam.getCurrency());
        }
    }

    @Override
    public boolean verify() {
        boolean bln = super.verify();
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        VisualItemInfo vi1 = (VisualItemInfo)this.prmtItemTo.getValue();
        if (vi != null && vi.toString() == null) {
            vi = null;
        }
        if (vi1 != null && vi1.toString() == null) {
            vi1 = null;
        }
        if (vi == null && vi1 != null || vi1 == null && vi != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"127_BgBalanceFilter2UI"));
            bln = false;
        }
        return bln;
    }
}

