/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgBalanceFilterParam;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgBalanceFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import org.apache.log4j.Logger;

public class BgBalanceFilterUI
extends AbstractBgBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgBalanceFilterUI.class);
    private BgBalanceFilterParam balFilterParam;

    public BgBalanceFilterUI() throws Exception {
    }

    public BgBalanceFilterUI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.comboBgPeriod.setEnabled(false);
        BgClientHelper.setSelectObject(this.comboBgRptType, (Object)BgAnalysisTypeEnum.BGBALANCE);
        this.comboBgRptType.setEnabled(false);
        if (this.isLoadBgBalance) {
            BgClientHelper.initComboBgScheme((Component)((Object)this), this.comboBgScheme, this.currentCompany.getId().toString(), true);
        } else {
            this.isLoadBgBalance = true;
        }
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.balFilterParam == null) {
            this.balFilterParam = new BgBalanceFilterParam();
        }
        return this.balFilterParam;
    }

    @Override
    public Object getParam() {
        BgBalanceFilterParam param = (BgBalanceFilterParam)super.getParam();
        param.setBgRptType(BgAnalysisTypeEnum.BGBALANCE);
        return param;
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        this.balFilterParam = (BgBalanceFilterParam)this.getFilterObject(cp);
        this.balFilterParam.setBgRptType(BgAnalysisTypeEnum.BGBALANCE);
        this.setFilterObject(cp, this.balFilterParam);
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
    }

    @Override
    public boolean verify() {
        boolean bln = super.verify();
        if (bln) {
            BgSchemeInfo schemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
            boolean isExecuted = schemeInfo.isIsFormal();
            if (!isExecuted) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"CheckBgSchemeExecuted"));
            }
            bln = isExecuted;
        }
        return bln;
    }
}

