/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.client.AbstractBgBalanceViewUI;
import com.kingdee.eas.ma.budget.client.BgAvlBalDetailUI;
import com.kingdee.eas.ma.budget.client.BgBizActualDetailUI;
import com.kingdee.eas.ma.budget.client.BgTraceFindBudgetUI;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgBalanceViewUI
extends AbstractBgBalanceViewUI {
    private static final long serialVersionUID = 8954030910240625567L;
    private static final Logger logger = CoreUIObject.getLogger(BgBalanceViewUI.class);
    Action actionTraceFindBudget = new AbstractAction(){
        private static final long serialVersionUID = 2750933550496592084L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BgBalanceViewUI.this.btnTraceFindBudget_actionPerformed(e);
            }
            catch (Exception ex) {
                BgBalanceViewUI.this.handleException(ex);
            }
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        IColumn column = this.tblMain.addColumn();
        column.setKey("periodNum");
        column.getStyleAttributes().setHided(true);
        this.processBalanceView();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTraceFindBudget.setVisible(false);
        String strKey = "CTRL_SHIFT_F12";
        KeyStroke ks = KeyStroke.getKeyStroke(123, 192, false);
        this.getActionMap().put(strKey, this.actionTraceFindBudget);
        this.getInputMap(2).put(ks, strKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBalanceView() throws BOSException, EASBizException {
        this.tblMain.removeRows();
        BgCtrlResultInfo ctrlResultInfo = null;
        BgCtrlResultCollection ctrlResultCol = null;
        Object ctrlResultColObj = this.getUIContext().get("BGBALANCE");
        Object upCtrlResultColObj = this.getUIContext().get("UPBGBALANCE");
        if (ctrlResultColObj == null || !(ctrlResultColObj instanceof BgCtrlResultCollection)) {
            return;
        }
        ctrlResultCol = (BgCtrlResultCollection)((Object)ctrlResultColObj);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return;
        }
        int precision = 2;
        BigDecimal bala = BgConstants.BIGZERO;
        HashMap dump = new HashMap();
        try {
            IRow row = null;
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                ctrlResultInfo = ctrlResultCol.get(i);
                String bgDataId = ctrlResultInfo.getBgDataId();
                if (bgDataId == null || dump.containsKey(bgDataId)) continue;
                dump.put(bgDataId, null);
                bala = ctrlResultInfo.getBalance();
                if (bala != null) {
                    precision = bala.scale();
                }
                DecimalFormat format = BgNationalFormatUIUtil.getDecimalFormat(precision);
                row = this.tblMain.addRow();
                String[] userObjects = new String[]{bgDataId, ctrlResultInfo.getOrgUnitId()};
                row.setUserObject((Object)userObjects);
                row.getCell("bgItem").setValue((Object)(!StringUtils.isEmpty((String)ctrlResultInfo.getItemCombinName()) ? ctrlResultInfo.getItemCombinName() : ctrlResultInfo.getBillItemName()));
                row.getCell("orgUnit").setValue((Object)ctrlResultInfo.getOrgUnitName());
                row.getCell("element").setValue((Object)ctrlResultInfo.getElementName());
                row.getCell("period").setValue((Object)ctrlResultInfo.getPeriodName());
                row.getCell("budget").setValue((Object)format.format(ctrlResultInfo.getBgValue()));
                row.getCell("actual").setValue((Object)format.format(ctrlResultInfo.getBizActual()));
                row.getCell("periodNum").setValue((Object)ctrlResultInfo.getBgPeriodNumber());
                if (!ctrlResultInfo.isIsMultiRuleCtrl() || ctrlResultInfo.getMultiRuleCtrlResult() == null || ctrlResultInfo.getMultiRuleCtrlResult().getBalance() == null) {
                    row.getCell("balance").setValue((Object)format.format(ctrlResultInfo.getBalance()));
                    continue;
                }
                BigDecimal realBalance = ctrlResultInfo.getMultiRuleCtrlResult().getBalance().divide(new BigDecimal("1.00"), precision, 6);
                BigDecimal multiRuleBalance = ctrlResultInfo.getBalance().divide(new BigDecimal("1.00"), precision, 6);
                String showBalance = format.format(realBalance) + "(" + format.format(multiRuleBalance) + ")";
                row.getCell("balance").setValue((Object)showBalance);
            }
            if (this.includeUpOrg.isSelected()) {
                BgCtrlResultCollection upCtrlResultCol = (BgCtrlResultCollection)((Object)upCtrlResultColObj);
                if (BudgetCtrlUtil.isEmpty((Object)upCtrlResultCol)) {
                    return;
                }
                for (int i = 0; i < upCtrlResultCol.size(); ++i) {
                    ctrlResultInfo = upCtrlResultCol.get(i);
                    String bgDataId = ctrlResultInfo.getBgDataId();
                    if (bgDataId == null || dump.containsKey(bgDataId)) continue;
                    dump.put(bgDataId, null);
                    bala = ctrlResultInfo.getBalance();
                    if (bala != null) {
                        precision = bala.scale();
                    }
                    DecimalFormat format = BgNationalFormatUIUtil.getDecimalFormat(precision);
                    row = this.tblMain.addRow();
                    String[] userObjects = new String[]{bgDataId, ctrlResultInfo.getOrgUnitId()};
                    row.setUserObject((Object)userObjects);
                    row.getCell("bgItem").setValue((Object)ctrlResultInfo.getItemCombinName());
                    row.getCell("orgUnit").setValue((Object)ctrlResultInfo.getOrgUnitName());
                    row.getCell("element").setValue((Object)ctrlResultInfo.getElementName());
                    row.getCell("period").setValue((Object)ctrlResultInfo.getPeriodName());
                    row.getCell("budget").setValue((Object)format.format(ctrlResultInfo.getBgValue()));
                    row.getCell("actual").setValue((Object)format.format(ctrlResultInfo.getBizActual()));
                    row.getCell("periodNum").setValue((Object)ctrlResultInfo.getBgPeriodNumber());
                    if (!ctrlResultInfo.isIsMultiRuleCtrl() || ctrlResultInfo.getMultiRuleCtrlResult() == null || ctrlResultInfo.getMultiRuleCtrlResult().getBalance() == null) {
                        row.getCell("balance").setValue((Object)format.format(ctrlResultInfo.getBalance()));
                        continue;
                    }
                    BigDecimal realBalance = ctrlResultInfo.getMultiRuleCtrlResult().getBalance();
                    BigDecimal multiRuleBalance = ctrlResultInfo.getBalance();
                    String showBalance = format.format(realBalance) + "(" + format.format(multiRuleBalance) + ")";
                    row.getCell("balance").setValue((Object)showBalance);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    @Override
    public void actionShowDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        String bgDataId;
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((bgDataId = ((String[])(row = this.tblMain.getRow(rowIndex)).getUserObject())[0]) == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bgDataId", (Object)bgDataId);
        uiContext.put((Object)"isCtrl", (Object)Boolean.TRUE);
        uiContext.put((Object)"balTypeEnum", (Object)BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAvlBalDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewActualDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        String bgDataId;
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((bgDataId = ((String[])(row = this.tblMain.getRow(rowIndex)).getUserObject())[0]) == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"title", (Object)this.btnViewActualDetail.getText());
        uiContext.put((Object)"bgDataId", (Object)bgDataId);
        uiContext.put((Object)"bgItemName", row.getCell("bgItem").getValue());
        uiContext.put((Object)"bgPeriodType", (Object)new Integer(BgNPeriodHelper.parserBgPeriodType((String)((String)row.getCell("periodNum").getValue()))));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgBizActualDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void btnTraceFindBudget_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue billInfo = (IObjectValue)this.getUIContext().get("billInfo");
        if (billInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"billInfo", (Object)billInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTraceFindBudgetUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewBgNFormProcess_actionPerformed(ActionEvent e) throws Exception {
        boolean bg022;
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(rowIndex);
        String bgDataId = ((String[])row.getUserObject())[0];
        BgDataInfo bgData = (BgDataInfo)BgDataFactory.getRemoteInstance().getValue("select id, bgFormId.id, bgTemplate.formType where id = '" + bgDataId + "'");
        String fullOrgUnitID = ((String[])row.getUserObject())[1];
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        boolean flag = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectStringPK(fullOrgUnitID), "bg_form03_view");
        if (!flag) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"129_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if (bg022 = BgSHelper.isBgPermissionUsed()) {
            boolean bg02201 = BgSHelper.isBgTemplatePerimissionForUse();
            boolean checkreuslt = BgFormFacadeFactory.getRemoteInstance().checkDatePermission(bgData.getBgFormId().getId().toString());
            if (!bg02201 && !checkreuslt) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"130_BgBalanceViewUI"));
                SysUtil.abort();
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgData.getBgFormId().getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgData.getBgTemplate().getFormType()) ? "com.kingdee.eas.ma.view.client.BgReportViewProcessUI" : BgNFormProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void includeUpOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        this.processBalanceView();
    }
}

