/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgBalanceFillInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.client.AbstractBgBalanceViewUI;
import com.kingdee.eas.ma.budget.client.BgAvlBalDetailUI;
import com.kingdee.eas.ma.budget.client.BgBizActualDetailUI;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class BgBalanceViewWithSubmitUI
extends AbstractBgBalanceViewUI {
    private static final long serialVersionUID = -2070473384931953520L;
    private static final Logger logger = CoreUIObject.getLogger(BgBalanceViewWithSubmitUI.class);
    private List bgBalanceFillCollection;
    Action actionSubmitBgViewBalance = new AbstractAction(){
        private static final long serialVersionUID = -3643610918416095758L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BgBalanceViewWithSubmitUI.this.actionSubmitBgViewBalance_actionPerformed(e);
            }
            catch (Exception ex) {
                BgBalanceViewWithSubmitUI.this.handleException(ex);
            }
        }
    };

    public BgBalanceViewWithSubmitUI() throws Exception {
        this.bgBalanceFillCollection = new ArrayList();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        IColumn column = this.tblMain.addColumn();
        column.setKey("periodNum");
        column.getStyleAttributes().setHided(true);
        this.btnSubmit.setAction(this.actionSubmitBgViewBalance);
        this.processBalanceView();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnSubmit.setText(EASCommonResource.getString((String)"ok", (Locale)SysContext.getSysContext().getLocale()));
        this.btnCancel.setText(EASCommonResource.getString((String)"cancel", (Locale)SysContext.getSysContext().getLocale()));
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"131_BgBalanceViewWithSubmitUI"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTraceFindBudget.setVisible(false);
        this.btnSubmit.setEnabled(true);
        this.btnSubmit.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBalanceView() throws BOSException, EASBizException {
        DecimalFormat DEFAULT_AMOUNT_FORMAT = BgNationalFormatUIUtil.getDecimalFormat(2);
        BgCtrlResultInfo ctrlResultInfo = null;
        BgCtrlResultCollection ctrlResultCol = null;
        Object ctrlResultColObj = this.getUIContext().get("BGBALANCE");
        if (ctrlResultColObj == null || !(ctrlResultColObj instanceof BgCtrlResultCollection)) {
            return;
        }
        ctrlResultCol = (BgCtrlResultCollection)((Object)ctrlResultColObj);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return;
        }
        HashMap dump = new HashMap();
        try {
            IRow row = null;
            for (int i = 0; i < ctrlResultCol.size(); ++i) {
                ctrlResultInfo = ctrlResultCol.get(i);
                String bgDataId = ctrlResultInfo.getBgDataId();
                if (bgDataId == null || dump.containsKey(bgDataId)) continue;
                dump.put(bgDataId, null);
                row = this.tblMain.addRow();
                row.setUserObject((Object)bgDataId);
                row.getCell("bgItem").setValue((Object)ctrlResultInfo.getItemCombinName());
                row.getCell("orgUnit").setValue((Object)ctrlResultInfo.getOrgUnitName());
                row.getCell("element").setValue((Object)ctrlResultInfo.getElementName());
                row.getCell("period").setValue((Object)ctrlResultInfo.getPeriodName());
                row.getCell("budget").setValue((Object)DEFAULT_AMOUNT_FORMAT.format(ctrlResultInfo.getBgValue()));
                row.getCell("actual").setValue((Object)DEFAULT_AMOUNT_FORMAT.format(ctrlResultInfo.getBizActual()));
                row.getCell("periodNum").setValue((Object)ctrlResultInfo.getBgPeriodNumber());
                if (!ctrlResultInfo.isIsMultiRuleCtrl() || ctrlResultInfo.getMultiRuleCtrlResult() == null || ctrlResultInfo.getMultiRuleCtrlResult().getBalance() == null) {
                    row.getCell("balance").setValue((Object)DEFAULT_AMOUNT_FORMAT.format(ctrlResultInfo.getBalance()));
                    continue;
                }
                BigDecimal realBalance = ctrlResultInfo.getMultiRuleCtrlResult().getBalance();
                BigDecimal multiRuleBalance = ctrlResultInfo.getBalance();
                String showBalance = DEFAULT_AMOUNT_FORMAT.format(realBalance) + "(" + DEFAULT_AMOUNT_FORMAT.format(multiRuleBalance) + ")";
                row.getCell("balance").setValue((Object)showBalance);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    @Override
    public void actionShowDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        String bgDataId;
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((bgDataId = (String)(row = this.tblMain.getRow(rowIndex)).getUserObject()) == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bgDataId", (Object)bgDataId);
        uiContext.put((Object)"isCtrl", (Object)Boolean.TRUE);
        uiContext.put((Object)"balTypeEnum", (Object)BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAvlBalDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewActualDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        String bgDataId;
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((bgDataId = (String)(row = this.tblMain.getRow(rowIndex)).getUserObject()) == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bgDataId", (Object)bgDataId);
        uiContext.put((Object)"bgItemName", row.getCell("bgItem").getValue());
        uiContext.put((Object)"bgPeriodType", (Object)new Integer(BgNPeriodHelper.parserBgPeriodType((String)((String)row.getCell("periodNum").getValue()))));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgBizActualDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionSubmitBgViewBalance_actionPerformed(ActionEvent e) throws Exception {
        BgCtrlResultInfo ctrlResultInfo = null;
        BgCtrlResultCollection ctrlResultCol = null;
        this.bgBalanceFillCollection.clear();
        Object ctrlResultColObj = this.getUIContext().get("BGBALANCE");
        if (ctrlResultColObj == null || !(ctrlResultColObj instanceof BgCtrlResultCollection)) {
            return;
        }
        ctrlResultCol = (BgCtrlResultCollection)((Object)ctrlResultColObj);
        String formula = null;
        List list = null;
        FormulaHint hint = null;
        String[] params = null;
        String itemKey = null;
        String bgPeriodNumber = null;
        BgPeriodEnum bgPeriodType = null;
        BigDecimal bgBalance = null;
        BgBalanceFillInfo balanceFillInfo = null;
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            ctrlResultInfo = ctrlResultCol.get(i);
            formula = ctrlResultInfo.getBgItemFormula();
            list = TableToolkit.parseFormula((String)formula, (boolean)false);
            if (list == null || list.isEmpty()) continue;
            hint = (FormulaHint)list.get(0);
            params = hint.getParams();
            itemKey = ctrlResultInfo.getOrgUnitId() + "\\@" + ctrlResultInfo.getBillItemNumber() + "\\@" + params[5] + "\\@" + params[2];
            bgPeriodNumber = ctrlResultInfo.getBgPeriodNumber();
            bgPeriodType = BgPeriodEnum.getEnum(BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber));
            bgBalance = ctrlResultInfo.getBalance();
            balanceFillInfo = new BgBalanceFillInfo(itemKey, bgBalance, bgPeriodNumber, bgPeriodType);
            this.bgBalanceFillCollection.add(balanceFillInfo);
        }
        this.actionExitCurrent_actionPerformed(e);
    }

    public List getBgBalanceFillCollection() {
        return this.bgBalanceFillCollection;
    }
}

