/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgActualDetailInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgBizActualDetailUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.List;

public class BgBizActualDetailUI
extends AbstractBgBizActualDetailUI {
    private static final long serialVersionUID = -7271869094040881820L;
    public static final String bgDataId = "bgDataId";
    public static final String bgItemName = "bgItemName";
    public static final String bgPeriodType = "bgPeriodType";

    public void onLoad() throws Exception {
        super.onLoad();
        String _bgDateId = (String)this.getUIContext().get(bgDataId);
        if (_bgDateId == null) {
            return;
        }
        int periodType = (Integer)this.getUIContext().get(bgPeriodType);
        String _bgItemName = (String)this.getUIContext().get(bgItemName);
        IBudgetCtrlFacade iCtrl = BudgetCtrlFacadeFactory.getRemoteInstance();
        List actDetailList = iCtrl.processActualDetailView(_bgDateId);
        if (actDetailList == null || actDetailList.isEmpty()) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    int index = e.getRowIndex();
                    if (index < 0) {
                        BgBizActualDetailUI.this.btnViewBill.setEnabled(false);
                        return;
                    }
                    Object traceType = BgBizActualDetailUI.this.tblMain.getRow(index).getCell(0).getUserObject();
                    if (!(traceType instanceof BgTraceTypeEnum)) {
                        BgBizActualDetailUI.this.btnViewBill.setEnabled(false);
                        return;
                    }
                    BgTraceTypeEnum _traceType = (BgTraceTypeEnum)((Object)traceType);
                    if (_traceType.getValue() != 3) {
                        BgBizActualDetailUI.this.btnViewBill.setEnabled(false);
                        return;
                    }
                    BgBizActualDetailUI.this.btnViewBill.setEnabled(true);
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    BgBizActualDetailUI.this.actionViewBill_actionPerformed(null);
                }
                catch (Exception exc) {
                    BgBizActualDetailUI.this.handUIException(exc);
                }
            }
        });
        boolean isHad = false;
        DateFormat dateFormat = BgNationalFormatUIUtil.getNationalDateFormat();
        DecimalFormat amtFormat = BgNationalFormatUIUtil.getDecimalFormat(2);
        BigDecimal sumBizActual = new BigDecimal("0.00");
        for (int i = 0; i < actDetailList.size(); ++i) {
            BgActualDetailInfo info = (BgActualDetailInfo)actDetailList.get(i);
            if (periodType != BgNPeriodHelper.parserBgPeriodType((String)info.getPeriodNumber())) continue;
            isHad = true;
            IRow row = this.tblMain.addRow();
            row.getCell("bgItem").setValue((Object)_bgItemName);
            row.getCell("period").setValue((Object)info.getPeriodName());
            row.getCell("currency").setValue((Object)info.getCurrecyName());
            row.getCell("billType").setValue((Object)info.getBillType());
            row.getCell("billNumber").setValue((Object)info.getBillNumber());
            row.getCell("bizDate").setValue((Object)dateFormat.format(info.getBizDate()));
            row.getCell("createDate").setValue((Object)dateFormat.format(info.getCreateTime()));
            row.getCell("bizActual").setValue((Object)amtFormat.format(info.getBizAcutal()));
            row.setUserObject((Object)info.getBillId());
            row.getCell(0).setUserObject((Object)BgTraceTypeEnum.getEnum(info.getBgTraceType()));
            sumBizActual = sumBizActual.add(info.getBizAcutal());
        }
        if (isHad) {
            IRow sumRow = this.tblMain.addRow();
            this.tblMain.getMergeManager().mergeBlock(sumRow.getRowIndex(), 0, sumRow.getRowIndex(), sumRow.getCell("bizActual").getColumnIndex() - 1);
            sumRow.getCell("bgItem").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"153_BgBizActualDetailUI"));
            sumRow.getCell("bizActual").setValue((Object)amtFormat.format(sumBizActual));
            sumRow.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
        }
        if (this.getUIContext().get("title") instanceof String) {
            this.setUITitle((String)this.getUIContext().get("title"));
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        Object billIdObj;
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"128_BgBalanceViewUI"));
            SysUtil.abort();
        }
        if ((billIdObj = this.tblMain.getRow(index).getUserObject()) == null || billIdObj.toString().length() == 0) {
            return;
        }
        String billId = billIdObj.toString();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        BgClientHelper.viewDetailBill((CoreUIObject)this, billId.trim(), company);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

