/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.RptFormulaBar;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgCommonException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemWithOrgFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgItemGroup;
import com.kingdee.eas.ma.budget.IBgItemWithOrg;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.MultiOrgMethodCodeExpr;
import com.kingdee.eas.ma.budget.PeriodDisplay;
import com.kingdee.eas.ma.budget.client.BgRptFilterUI;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public final class BgClientHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgClientHelper.class);
    public static final String COLLECTFORMRESOURCE = "com.kingdee.eas.ma.budget.BudgetResource";
    public static final String DECFORMRESOURCE = "com.kingdee.eas.ma.budget.BgDecomposerFormResource";
    public static final BigDecimal MAX_DECIMAL = new BigDecimal("9999999999999999.99999");
    public static final BigDecimal MIN_DECIMAL = new BigDecimal("-9999999999999999.99999");
    public static final HashMap mapPrecOfCurrency = new HashMap(32);
    public static final String RESOURCEPATH = "com.kingdee.eas.ma.budget.client.BgRptResource";
    public static final Color TOTAL_COLOR = new Color(0xF6F6B6);
    public static final String KDTABLEPERCENTFORMAT = "%r{0.00}p";

    public static OrgViewType[] getCurrentOrgTypes() {
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
        Vector vec = BgHelper.getOrgViewTypes(org);
        OrgViewType[] orgView = new OrgViewType[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            orgView[i] = (OrgViewType)vec.get(i);
        }
        return orgView;
    }

    public static void initComboBgScheme(Component ui, KDComboBox comboBoxBgScheme, String orgUnitId) throws BOSException, EASBizException {
        int i;
        HashSet<BOSUuid> subOrgUnits = new HashSet<BOSUuid>();
        subOrgUnits.add(BOSUuid.read((String)orgUnitId));
        BgSchemeCollection bgSchemes = BgAnalyseFacadeFactory.getRemoteInstance().getCommonBgScheme(BOSUuid.read((String)orgUnitId), subOrgUnits, false, false, true);
        BgSchemeCollection bgSchemesFD = new BgSchemeCollection();
        if (BgParamCHelper.isFodian() && bgSchemes != null && !((BgRptFilterUI)((Object)ui)).isFromFund()) {
            for (i = 0; i < bgSchemes.size(); ++i) {
                if (bgSchemes.get(i).getPeriod().getValue() == 4) continue;
                bgSchemesFD.add(bgSchemes.get(i));
            }
        }
        if (BgParamCHelper.isFodian() && bgSchemes != null && ((BgRptFilterUI)((Object)ui)).isFromFund()) {
            for (i = 0; i < bgSchemes.size(); ++i) {
                if (bgSchemes.get(i).getPeriod().getValue() != 4) continue;
                bgSchemesFD.add(bgSchemes.get(i));
            }
        }
        comboBoxBgScheme.removeAllItems();
        if (BgParamCHelper.isFodian() && bgSchemesFD.size() != 0) {
            comboBoxBgScheme.addItems(bgSchemesFD.toArray());
        } else {
            comboBoxBgScheme.addItems(bgSchemes.toArray());
        }
        if (comboBoxBgScheme.getItemCount() > 0) {
            comboBoxBgScheme.setSelectedIndex(0);
            comboBoxBgScheme.setEnabled(true);
        }
    }

    public static void initComboBgSchemeForAnalyse(Component ui, KDComboBox comboBoxBgScheme, String orgUnitId, boolean isFormFund) throws BOSException, EASBizException {
        int i;
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("orgunit.id", (Object)orgUnitId);
        filter.setMaskString(" #0 ");
        if (BgSHelper.isBgPermissionUsed()) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            HashSet<String> orgUnit = new HashSet<String>();
            orgUnit.add(orgUnitId);
            filter = BgPermissionHelper.addBgSchemePermission((String)userId, orgUnit, (FilterInfo)filter);
        }
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        BgSchemeCollection bgSchemes = iBgScheme.getBgSchemeCollection(viewInfo);
        BgSchemeCollection bgSchemesFD = new BgSchemeCollection();
        if (BgParamCHelper.isFodian() && bgSchemes != null && !isFormFund) {
            for (i = 0; i < bgSchemes.size(); ++i) {
                if (bgSchemes.get(i).getPeriod().getValue() == 4) continue;
                bgSchemesFD.add(bgSchemes.get(i));
            }
        }
        if (BgParamCHelper.isFodian() && bgSchemes != null && isFormFund) {
            for (i = 0; i < bgSchemes.size(); ++i) {
                if (bgSchemes.get(i).getPeriod().getValue() != 4) continue;
                bgSchemesFD.add(bgSchemes.get(i));
            }
        }
        comboBoxBgScheme.removeAllItems();
        if (BgParamCHelper.isFodian()) {
            if (bgSchemesFD.size() != 0) {
                comboBoxBgScheme.addItems(bgSchemesFD.toArray());
            }
        } else if (bgSchemes.size() != 0) {
            comboBoxBgScheme.addItems(bgSchemes.toArray());
        }
        if (comboBoxBgScheme.getItemCount() <= 0) {
            comboBoxBgScheme.removeAllItems();
        } else {
            comboBoxBgScheme.setSelectedIndex(0);
            comboBoxBgScheme.setEnabled(true);
        }
    }

    public static void initComboBgScheme(Component ui, KDComboBox comboBoxBgScheme, String orgUnitId, boolean isExecuted) throws BOSException, EASBizException {
        BgSchemeCollection bgSchemes = BgClientHelper.getBgSchemeCollection(orgUnitId, isExecuted);
        comboBoxBgScheme.removeAllItems();
        comboBoxBgScheme.addItems(bgSchemes.toArray());
        if (comboBoxBgScheme.getItemCount() <= 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"msgSelectBgScheme"));
        } else {
            comboBoxBgScheme.setSelectedIndex(0);
            comboBoxBgScheme.setEnabled(true);
        }
    }

    public static BgSchemeCollection getBgSchemeCollection(String orgUnitId, boolean isExecuted) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        if (isExecuted) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isFormal", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("period"));
        viewInfo.getSelector().add(new SelectorItemInfo("isFormal"));
        viewInfo.getSelector().add(new SelectorItemInfo("dateFrom"));
        viewInfo.getSelector().add(new SelectorItemInfo("dateTo"));
        BgSchemeCollection bgSchemes = iBgScheme.getBgSchemeCollection(viewInfo);
        return bgSchemes;
    }

    public static Frame getFrameAncestor(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            boolean found = false;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                CoreBaseInfo obj = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)obj.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static void viewFlow(Component ui, String id) throws Exception {
        int i;
        int n;
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        if (procInsts != null) {
            n = procInsts.length;
            for (i = 0; i < n; ++i) {
                if (!"open".equalsIgnoreCase(procInsts[i].getState().substring(0, 4))) continue;
                processInstInfo = procInsts[i];
            }
        }
        if (processInstInfo == null) {
            if (service != null && (procInsts = service.getAllProcessInstancesByBizobjId(id)) != null) {
                n = procInsts.length;
                for (i = 0; i < n; ++i) {
                    if (processInstInfo != null && !procInsts[i].getLastStateTime().after(processInstInfo.getLastStateTime())) continue;
                    processInstInfo = procInsts[i];
                }
            }
            if (processInstInfo == null && (id = BgClientHelper.getAdjustID(id)) != null && service != null && (procInsts = service.getAllProcessInstancesByBizobjId(id)) != null) {
                n = procInsts.length;
                for (i = 0; i < n; ++i) {
                    if (processInstInfo != null && !procInsts[i].getLastStateTime().after(processInstInfo.getLastStateTime())) continue;
                    processInstInfo = procInsts[i];
                }
            }
        }
        if (processInstInfo == null) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
        } else {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"id", (Object)processInstInfo.getProcInstId());
            String className = BasicWorkFlowMonitorPanel.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            uiWindow.show();
        }
    }

    private static String getAdjustID(String id) throws BOSException {
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        BgFormCollection col = iBgForm.getBgFormCollection("select id, versionNo where adjust.id = '" + id + "' and id <> '" + id + "' order by versionNo DESC");
        if (col == null || col.isEmpty()) {
            return null;
        }
        return col.get(0).getId().toString();
    }

    public static void viewIdea(Component ui, String id) throws BOSException, WfException, UIException {
        String adjustId = BgClientHelper.getAdjustID(id);
        if (adjustId != null) {
            id = adjustId;
        }
        MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)id), (String)UIModelDialogFactory.class.getName(), (Object)ui);
    }

    public static void checkIsOnCU(CoreUI ui, FullOrgUnitInfo org, CtrlUnitInfo orgCtrl) throws BOSException, EASBizException {
    }

    public static boolean isCreator(String bizObjectId, String type) throws Exception {
        String userId;
        boolean iscreator = true;
        IBgItemGroup io = BgItemGroupFactory.getRemoteInstance();
        BgItemGroupInfo info = io.getBgItemGroupInfo("select creator, reffield where id ='" + bizObjectId + "'");
        if (info.getRefField() != null && (info.getRefField().equals("F96") || info.getRefField().equals("F97") || info.getRefField().equals("F98")) && (info.getCreator() == null || info.getCreator().getId() == null)) {
            return !type.equals("remove");
        }
        String creatorId = null;
        if (info.getCreator() != null) {
            creatorId = info.getCreator().getId().toString();
        }
        if (!(userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString()).equals(creatorId)) {
            iscreator = false;
        }
        return iscreator;
    }

    public static void verifyBgPeriodBegin2End(CoreUIObject ui, KDBizPromptBox prmtBeginPeriod, KDBizPromptBox prmtEndPeriod) {
        boolean bln;
        BgPeriodInfo beginPeriod = (BgPeriodInfo)prmtBeginPeriod.getData();
        BgPeriodInfo endPeriod = (BgPeriodInfo)prmtEndPeriod.getData();
        if (beginPeriod == null && endPeriod != null && endPeriod.getPeriodType().getValue() == 8) {
            prmtBeginPeriod.setData(prmtEndPeriod.getData());
            return;
        }
        if (endPeriod == null && beginPeriod != null && beginPeriod.getPeriodType().getValue() == 8) {
            prmtEndPeriod.setData(prmtBeginPeriod.getData());
            return;
        }
        if (beginPeriod != null && endPeriod != null && beginPeriod.getPeriodType().getValue() == 8 && endPeriod.getPeriodType().getValue() == 8 && !beginPeriod.getId().equals((Object)endPeriod.getId())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"154_BgClientHelper"));
            SysUtil.abort();
        } else if (beginPeriod != null && endPeriod != null && (beginPeriod.getPeriodType().getValue() == 8 && endPeriod.getPeriodType().getValue() != 8 || beginPeriod.getPeriodType().getValue() != 8 && endPeriod.getPeriodType().getValue() == 8)) {
            MsgBox.showWarning((Component)ui, (String)BgAnalyseHelper.getMessage("selectBgPeriodNoAccord"));
            SysUtil.abort();
        } else if (beginPeriod != null && endPeriod != null && beginPeriod.getPeriodType().getValue() == 8 && endPeriod.getPeriodType().getValue() == 8 && beginPeriod.getId().equals((Object)endPeriod.getId())) {
            return;
        }
        if (prmtBeginPeriod.getData() == null) {
            prmtBeginPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginPeriodIsNull"));
            SysUtil.abort();
        }
        if (prmtEndPeriod.getData() == null) {
            prmtEndPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndPeriodIsNull"));
            SysUtil.abort();
        }
        if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBgPeriodType"));
            SysUtil.abort();
        }
        if (!(bln = BgHelper.compareBgPeriodBegin2End(beginPeriod, endPeriod))) {
            prmtBeginPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBgPeriodMsg"));
            SysUtil.abort();
        }
    }

    public static void verifyBgPeriodBegin2EndToBI(CoreUIObject ui, KDBizPromptBox prmtBeginPeriod, KDBizPromptBox prmtEndPeriod) {
        boolean bln;
        BgPeriodInfo beginPeriod = ((PeriodDisplay)prmtBeginPeriod.getData()).getArray()[0];
        BgPeriodInfo endPeriod = (BgPeriodInfo)prmtEndPeriod.getData();
        if (beginPeriod == null && endPeriod != null && endPeriod.getPeriodType().getValue() == 8) {
            prmtBeginPeriod.setData(prmtEndPeriod.getData());
            return;
        }
        if (endPeriod == null && beginPeriod != null && beginPeriod.getPeriodType().getValue() == 8) {
            prmtEndPeriod.setData(prmtBeginPeriod.getData());
            return;
        }
        if (beginPeriod != null && endPeriod != null && beginPeriod.getPeriodType().getValue() == 8 && endPeriod.getPeriodType().getValue() == 8 && !beginPeriod.getId().equals((Object)endPeriod.getId())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"154_BgClientHelper"));
            SysUtil.abort();
        } else if (beginPeriod != null && endPeriod != null && (beginPeriod.getPeriodType().getValue() == 8 && endPeriod.getPeriodType().getValue() != 8 || beginPeriod.getPeriodType().getValue() != 8 && endPeriod.getPeriodType().getValue() == 8)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"155_BgClientHelper"));
            SysUtil.abort();
        } else if (beginPeriod != null && endPeriod != null && beginPeriod.getPeriodType().getValue() == 8 && endPeriod.getPeriodType().getValue() == 8 && beginPeriod.getId().equals((Object)endPeriod.getId())) {
            return;
        }
        if (prmtBeginPeriod.getData() == null) {
            prmtBeginPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginPeriodIsNull"));
            SysUtil.abort();
        }
        if (prmtEndPeriod.getData() == null) {
            prmtEndPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndPeriodIsNull"));
            SysUtil.abort();
        }
        if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBgPeriodType"));
            SysUtil.abort();
        }
        if (!(bln = BgHelper.compareBgPeriodBegin2End(beginPeriod, endPeriod))) {
            prmtBeginPeriod.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBgPeriodMsg"));
            SysUtil.abort();
        }
    }

    public static String getNumberFtm(BOSUuid currencyId) {
        return "%r-[ ]0." + BgClientHelper.getPrecOfCurrency(currencyId) + "n";
    }

    public static String getNumberFtm(int precision) {
        return "%r-[ ]0." + precision + "n";
    }

    public static String getNumberFtm() {
        return "%r-[ ]{###,###,###.##}15.2n";
    }

    public static String getZeroByPrecision(BOSUuid currencyId) {
        return BgClientHelper.getZeroByPrecision(BgClientHelper.getPrecOfCurrency(currencyId));
    }

    public static String getZeroByPrecision(int precision) {
        StringBuffer strBuff = new StringBuffer("#0.");
        for (int i = 0; i < precision; ++i) {
            strBuff.append("0");
        }
        return strBuff.toString();
    }

    public static String getRateFormat(BOSUuid currencyId) {
        return BgClientHelper.getRateFormat(BgClientHelper.getPrecOfCurrency(currencyId));
    }

    public static String getRateFormat(int precision) {
        StringBuffer strBuff = new StringBuffer("#0.");
        for (int i = 0; i < precision; ++i) {
            strBuff.append("0");
        }
        strBuff.append("%");
        return strBuff.toString();
    }

    public static String getKDRateFormat(BOSUuid currencyId) {
        return BgClientHelper.getKDRateFormat(BgClientHelper.getPrecOfCurrency(currencyId));
    }

    public static String getKDRateFormat(int precision) {
        StringBuffer strBuff = new StringBuffer("%r{0.");
        for (int i = 0; i < precision; ++i) {
            strBuff.append("0");
        }
        strBuff.append("}p");
        return strBuff.toString();
    }

    public static String getNumberFormat(BOSUuid currencyId) {
        return BgClientHelper.getNumberFormat(BgClientHelper.getPrecOfCurrency(currencyId));
    }

    public static String getNumberFormat(int precision) {
        StringBuffer strBuff = new StringBuffer("##,##0.");
        for (int i = 0; i < precision; ++i) {
            strBuff.append("0");
        }
        return strBuff.toString();
    }

    public static String getNumberFormat() {
        return "#,##0.00";
    }

    public static int getPrecOfCurrency(BOSUuid currencyId) {
        if (mapPrecOfCurrency.size() == 0) {
            BgClientHelper.setPrecOfCurrenty(mapPrecOfCurrency);
        }
        if (!mapPrecOfCurrency.containsKey(currencyId)) {
            return 10;
        }
        return (Integer)mapPrecOfCurrency.get(currencyId);
    }

    private static void setPrecOfCurrenty(HashMap map) {
        String str = "select fid,fprecision from t_bd_currency";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                map.put(BOSUuid.read((String)rs.getString(1)), new Integer(rs.getInt(2)));
            }
        }
        catch (BOSException bose) {
            return;
        }
        catch (SQLException sqle) {
            return;
        }
    }

    public static boolean checkInProInst(String id) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createRemoteEnactService().getProcessInstanceByHoldedObjectId(id);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void batchApplyMutexService(Component ui, String[] ids, String userID) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            idList.add(ids[i]);
        }
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        Map batchResult = iMC.batchRequestObjIDForUpdate(idList);
        boolean isRequest = true;
        Iterator it = batchResult.keySet().iterator();
        while (it.hasNext()) {
            isRequest = (Boolean)batchResult.get(it.next());
            if (isRequest) continue;
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"lockInfo"));
            SysUtil.abort();
        }
    }

    public static void applyMutexService(Component ui, String id, String userID) {
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean isRequest = iMC.requestObjIDForUpdate(id, userID);
        if (!isRequest) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"lockInfo"));
            SysUtil.abort();
        }
    }

    public static boolean applyMutexServiceMutiHelp(Component ui, String id, String userID, IMutexServiceControl iMC) {
        boolean isRequest = iMC.requestObjIDForUpdate(id, userID);
        return isRequest;
    }

    public static void releaseMutexService(String id) {
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        iMC.releaseObjIDForUpdate(id);
    }

    public static void batchReleaseMutexService(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            idList.add(ids[i]);
        }
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        iMC.batchReleaseObjIDForUpdate(idList);
    }

    public static void isMutex(Component ui, String id, String userID) {
        boolean isMutex = false;
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean isRequest = iMC.requestObjIDForUpdate(id);
        if (isRequest) {
            iMC.releaseObjIDForUpdate(id);
        } else {
            isMutex = true;
        }
        if (isMutex) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"lockInfo"));
            SysUtil.abort();
        }
    }

    public static void isMutex_throwException(String id, String userID) throws BgCommonException {
        boolean isMutex = false;
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean isRequest = iMC.requestObjIDForUpdate(id);
        if (isRequest) {
            iMC.releaseObjIDForUpdate(id);
        } else {
            isMutex = true;
        }
        if (isMutex) {
            throw new BgCommonException(BgCommonException.LOCK);
        }
    }

    public static void exportTableToExcel(Component ui, KDTable table) throws Exception {
        BgClientHelper.exportTableToExcel(ui, table, false);
    }

    public static void exportTableToExcel(Component ui, KDTable table, boolean flag) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                totalFileName = fileName + ".xls";
            }
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            return;
        }
        if (filePath == null) {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        String sheetName = fileName;
        KDSSheet kdsSheet = flag ? table.getIOManager().saveToKDSSheet(kdsBook, true, false, sheetName) : table.getIOManager().saveToKDSSheet(kdsBook, true, false, false, sheetName);
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckFileOpen"));
        }
    }

    public static void exportTablesToExcel(Component ui, KDTabbedPane kdtabbed, boolean flag) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                totalFileName = fileName + ".xls";
            }
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            return;
        }
        if (filePath == null) {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        KDTable table = null;
        KDSSheet[] kdsSheet = new KDSSheet[kdtabbed.getTabCount()];
        for (int i = 0; i < kdtabbed.getTabCount(); ++i) {
            kdtabbed.setSelectedIndex(i);
            KDPanel panel = (KDPanel)kdtabbed.getComponentAt(i);
            for (int j = 0; j < panel.getComponentCount(); ++j) {
                if (!(panel.getComponent(j) instanceof KDTable)) continue;
                table = (KDTable)panel.getComponent(j);
                String sheetName = EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"156_BgClientHelper") + (i + 1) + " " + kdtabbed.getTitleAt(i);
                kdsSheet[i] = flag ? table.getIOManager().saveToKDSSheet(kdsBook, true, false, sheetName) : table.getIOManager().saveToKDSSheet(kdsBook, true, false, false, sheetName);
                kdsBook.addSheet(null, kdsSheet[i]);
            }
        }
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckFileOpen"));
        }
    }

    public static void exportKDTableToExcel(Component ui, KDTable kdtabbed, boolean flag) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        String fileSelecName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"excelFileName2");
        fileChooser.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + File.separator + fileSelecName));
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                totalFileName = fileName + ".xls";
            }
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            return;
        }
        if (filePath == null) {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        KDSSheet kdsSheet = new KDSSheet(kdsBook, fileName);
        kdsSheet = flag ? kdtabbed.getIOManager().saveToKDSSheet(kdsBook, true, false, fileName) : kdtabbed.getIOManager().saveToKDSSheet(kdsBook, true, false, false, fileName);
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckFileOpen"));
        }
    }

    public static void clearKDTableBlankArea(KDTable table) {
    }

    public static List getAllSelectedRow(KDTable tblMain) {
        ArrayList selectBlocks = tblMain.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        ArrayList<IRow> rowList = new ArrayList<IRow>();
        for (int i = 0; i < selectBlocks.size(); ++i) {
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = tblMain.getRow(j);
                rowList.add(row);
            }
        }
        return rowList;
    }

    public void checkSelected(Component ui, KDTable tblMain) {
        if (tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"157_BgClientHelper"));
            SysUtil.abort();
        }
    }

    public static void viewDetailBill(CoreUIObject owner, String billId, CompanyOrgUnitInfo company) throws Exception {
        String[] idList = new String[]{billId};
        BgClientHelper.viewDetailBill(owner, idList, company);
    }

    public static void viewDetailBill(CoreUIObject owner, String[] idList, CompanyOrgUnitInfo company) throws Exception {
        if (idList == null || idList.length == 0) {
            throw new Exception("idList is null or empty!");
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType bosType = BOSUuid.read((String)idList[0]).getType();
        EntityObjectInfo entity = loader.getEntity(bosType);
        String biz = entity.getBusinessInterface();
        Class<?> aa = Class.forName(biz);
        IBOSObject iBos = null;
        try {
            iBos = BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, aa);
            CoreBaseInfo info = ((ICoreBase)iBos).getValue("select company.* where id = '" + idList[0].trim() + "'");
            company = (CompanyOrgUnitInfo)info.get("company");
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        String popUi = null;
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"company", (Object)company);
        uiContext.put((Object)OrgType.Company, (Object)company);
        IUIWindow uiWindow = null;
        String infoID = null;
        uiContext.put((Object)"canResize", (Object)"true");
        if (idList.length == 1) {
            infoID = idList[0];
            uiContext.put((Object)"ID", (Object)infoID);
            popUi = entity.getExtendedProperty("editUI");
            uiWindow = UIFactory.createUIFactory((String)BgClientHelper.getEditUIMode(owner)).create(popUi, (Map)uiContext, null, "FINDVIEW");
        } else {
            uiContext.put((Object)"IDList", (Object)idList);
            popUi = entity.getExtendedProperty("listUI");
            uiWindow = UIFactory.createUIFactory((String)BgClientHelper.getEditUIMode(owner)).create(popUi, (Map)uiContext, null, "FINDVIEW");
        }
        Component comp = null;
        try {
            KDToolBar toolBar = uiWindow.getUIObject().getUIToolBar();
            int btnCount = toolBar.getComponentCount();
            for (int i = 0; i < btnCount; ++i) {
                comp = toolBar.getComponent(i);
                if (!BgClientHelper.isNotEnabled(comp)) continue;
                comp.setEnabled(false);
            }
            KDMenuBar menuBar = uiWindow.getUIObject().getUIMenuBar();
            int menuItemCount = menuBar.getComponentCount();
            for (int j = 0; j < menuItemCount; ++j) {
                menuBar.getComponent(j).setEnabled(false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        uiWindow.show();
    }

    private static boolean isNotEnabled(Component cp) {
        if (cp == null) {
            return false;
        }
        String name = cp.getName();
        String cpClass = cp.getClass().getName();
        return !"btnTraceUp".equalsIgnoreCase(name) && !"menuItemTraceUp".equalsIgnoreCase(name) && !"btnTraceDown".equalsIgnoreCase(name) && !"menuItemTraceDown".equalsIgnoreCase(name) && !"btnAttachment".equalsIgnoreCase(name) && !"menuItemAttachment".equalsIgnoreCase(name) && !"btnWorkFlowG".equalsIgnoreCase(name) && !"menuItemWFG".equalsIgnoreCase(name) && !"btnAuditResult".equalsIgnoreCase(name) && !"menuItemAuditResult".equalsIgnoreCase(name) && !"btnWFViewdoProccess".equalsIgnoreCase(name) && !"menuItemViewDoProccess".equalsIgnoreCase(name) && !"btnShowQtyAmnt".equalsIgnoreCase(name) && !"menuItemShowQtyAmnt".equalsIgnoreCase(name) && !"com.kingdee.bos.ctrl.swing.LittleArrowButton".equalsIgnoreCase(cpClass);
    }

    public static String getEditUIMode(CoreUIObject ui) {
        IUIWindow win = ui.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    public static int getStringNum(String string1, char char1) {
        int n = 0;
        if (string1 == null) {
            return 0;
        }
        for (int i = 0; i < string1.length(); ++i) {
            if (string1.charAt(i) != char1) continue;
            ++n;
        }
        return n;
    }

    public static BgItemCollection getBgItemCol(BgItemCollection col) {
        BgItemInfo info = null;
        String num = "";
        String itemSql = "where ";
        for (int i = 0; i < col.size(); ++i) {
            info = (BgItemInfo)col.getObject(i);
            num = info.getNumber().toString();
            itemSql = BgClientHelper.itemSQL(num, itemSql);
        }
        itemSql = itemSql + " fisEffective = 1 and";
        if ((itemSql = itemSql.substring(0, itemSql.length() - 4)) == null || col.size() <= 0) {
            return null;
        }
        try {
            IBgItem iBgItem = BgItemFactory.getRemoteInstance();
            String orgUnitId = BgSHelper.getIsolateOrg(((BgItemInfo)col.getObject(0)).getOrgUnit().getId().toString());
            itemSql = itemSql + " and FOrgUnitId = '" + orgUnitId + "' ";
            col = iBgItem.getBgItemCollection(itemSql);
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        BgHelper.sortCollection(col, new String[]{"number"});
        return col;
    }

    public static String itemSQL(String num, String itemSQL) {
        String itemNum = "";
        char[] number = num.toCharArray();
        char[] number1 = new char[300];
        itemSQL = itemSQL + "number = '" + num + "' or ";
        for (int n = 0; n < number.length; ++n) {
            number1[n] = number[n];
            if (number1[n] != '.') continue;
            itemNum = String.valueOf(number1).trim();
            itemNum = itemNum.substring(0, itemNum.length() - 1);
            itemSQL = itemSQL + "number = '" + itemNum + "' or ";
        }
        return itemSQL;
    }

    public static String getMessage(Context ctx, String resPath, String resName) {
        if (resPath == null || resName == null) {
            throw new IllegalArgumentException("resPath or resName is nul!");
        }
        String str = null;
        str = ctx != null ? ResourceBase.getString((String)resPath, (String)resName, (Locale)ctx.getLocale()) : EASResource.getString((String)resPath, (String)resName);
        return str;
    }

    public static String formatMessage(Context ctx, String resPath, String resName, Object[] args) {
        if (resPath == null || resName == null) {
            throw new IllegalArgumentException("resPath or resName is nul!");
        }
        String str = null;
        str = ctx != null ? ResourceBase.getString((String)resPath, (String)resName, (Locale)ctx.getLocale()) : EASResource.getString((String)resPath, (String)resName);
        if (args == null || args.length == 0) {
            return str;
        }
        return MessageFormat.format(str, args);
    }

    public static void getInsulateItem(OrgUnitInfo orgUnit, FilterInfo filter) {
        String[] orgUnitNum = new String[orgUnit.getLevel()];
        if (orgUnit.getLevel() > 1 && orgUnit.getLongNumber().toString().indexOf("!") > 0) {
            orgUnitNum = BgHelper.longNumberToNumber(orgUnit.getLongNumber().toString(), orgUnit.getLevel());
            String maskString = "";
            for (int i = 0; i < orgUnit.getLevel(); ++i) {
                if (orgUnitNum[i] == null) continue;
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnitNum[i], CompareType.EQUALS));
                maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") OR ";
            }
            if (!BgSHelper.isBgItemNumberRepeat()) {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.longNumber", (Object)(orgUnit.getLongNumber().toString() + "!%"), CompareType.LIKE));
                maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") ";
            }
            if (filter.getMaskString() == null) {
                filter.setMaskString(maskString);
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") AND (" + maskString + ")");
            }
        }
    }

    public static Vector getItemAndElement(String formulaString, String orgUnitId) {
        Vector<Map> itemElement = new Vector<Map>();
        String[] parameter = null;
        HashMap formulaMap = new HashMap();
        HashMap getItemsMap = new HashMap();
        Map visItemsMap = new HashMap();
        HashMap getElemetMap = new HashMap();
        Map bgElementMap = null;
        parameter = BgSHelper.getFormulaInfo(formulaMap, formulaString);
        if (parameter != null) {
            if (parameter[BgSHelper.paraItem] != null && !getItemsMap.containsKey(parameter[BgSHelper.paraItem])) {
                getItemsMap.put(parameter[BgSHelper.paraItem], null);
            }
            if (parameter[BgSHelper.paraElement] != null && !getElemetMap.containsKey(parameter[BgSHelper.paraElement])) {
                getElemetMap.put(parameter[BgSHelper.paraElement], null);
            }
        }
        try {
            bgElementMap = BgSHelper.getBgElementInfo(null, getElemetMap, null, null);
            visItemsMap = BgSHelper.getBgItemsInfo(null, getItemsMap, null, null, orgUnitId);
        }
        catch (EASBizException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        itemElement.add(0, visItemsMap);
        itemElement.add(1, bgElementMap);
        return itemElement;
    }

    public static void dealWith(KDTable table, String orgUnitId, RptFormulaBar barFormula, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula) throws BOSException, EASBizException {
        HashMap bgItemCombinMap = new HashMap();
        for (int i = 0; i < table.getBody().size(); ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                ICell cell = table.getCell(i, j);
                if (cell == null) continue;
                BgClientHelper.collectBgItemCombin(cell, bgItemCombinMap);
            }
        }
        IBgFormulaFacade iBgF = BgFormulaFacadeFactory.getRemoteInstance();
        bgItemCombinMap = iBgF.batchParseBgItemCombi(bgItemCombinMap, orgUnitId);
        for (int i = 0; i < table.getBody().size(); ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                ICell cell = table.getCell(i, j);
                if (cell == null) continue;
                BgClientHelper.dealWith(cell, bgItemCombinMap, barFormula, itemFormulaMap, isFromTemplate, isDealItemFormula);
            }
        }
        Object key2 = null;
        if (bgItemCombinMap == null || bgItemCombinMap.isEmpty()) {
            return;
        }
        for (Object key2 : bgItemCombinMap.keySet()) {
            Object[] obj;
            if (bgItemCombinMap.get(key2) == null || !(bgItemCombinMap.get(key2) instanceof Object[]) || (obj = (Object[])bgItemCombinMap.get(key2)).length < 2 || obj[1] == null || !((Boolean)obj[1]).booleanValue()) continue;
            throw new BgCommonException(BgCommonException.EXISTSAMEITEMGROUP);
        }
    }

    public static void collectBgItemCombin(ICell cell, HashMap bgItemCombinMap) {
        RptCell rCell;
        String itemFormula;
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && (itemFormula = (rCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) != null && rCell.getItemFormula() != null) {
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (params.length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
                String strItemCombi = params[0];
                bgItemCombinMap.put(strItemCombi, null);
            }
        }
        if (cell.getExpressions() != null) {
            String formula = cell.getExpressions();
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)formula, (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (hint != null && params != null && params.length == 7 && (hint.name.equalsIgnoreCase("BgFormula") || hint.name.equalsIgnoreCase("BgAct") || hint.name.equalsIgnoreCase("BgBal") || hint.name.equalsIgnoreCase("BgActutalS"))) {
                String strItemCombi = params[3];
                bgItemCombinMap.put(strItemCombi, null);
            }
        }
    }

    private static void dealWith(ICell cell, HashMap bgItemCombinMap, RptFormulaBar barFormula, Map itemFormulaMap, boolean isFromTemplate, boolean isDealItemFormula) {
        RptCell rCell;
        String itemFormula;
        if (bgItemCombinMap == null) {
            bgItemCombinMap = new HashMap();
        }
        if (!BgFSHelper.checkCanUpdateOfCell(cell)) {
            return;
        }
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && (itemFormula = (rCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) != null && rCell.getItemFormula() != null) {
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (params.length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
                String strItemCombi = params[0];
                String _strItemCombi = null;
                Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
                if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                    _strItemCombi = (String)obj[0];
                }
                if (_strItemCombi == null) {
                    rCell.setItemFormula("=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[5] + "\")");
                    if (barFormula != null) {
                        barFormula.setItemLine("=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")");
                    }
                    if (isDealItemFormula && isFromTemplate && itemFormulaMap != null) {
                        itemFormulaMap.put(itemFormula, "=BgItem(\"\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")");
                    }
                    return;
                }
                itemFormula = "=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[5] + "\")";
                rCell.setItemFormula(itemFormula);
                if (barFormula != null) {
                    barFormula.setItemLine("=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")");
                }
                if (isDealItemFormula && isFromTemplate && itemFormulaMap != null) {
                    itemFormulaMap.put(itemFormula, "=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")");
                }
            }
        }
        if (cell.getExpressions() != null) {
            String formula = cell.getExpressions();
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)formula, (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (hint != null && params != null && params.length == 7 && (hint.name.equalsIgnoreCase("BgFormula") || hint.name.equalsIgnoreCase("BgAct") || hint.name.equalsIgnoreCase("BgBal") || hint.name.equalsIgnoreCase("BgActutalS"))) {
                String strItemCombi = params[3];
                String _strItemCombi = null;
                Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
                if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                    _strItemCombi = (String)obj[0];
                }
                if (_strItemCombi == null) {
                    formula = "=" + hint.name + "(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"\",\"" + params[4] + "\",\"" + params[5] + "\",\"" + params[6] + "\")";
                    cell.setExpressions(formula);
                    return;
                }
                if (strItemCombi != null && _strItemCombi != null && !strItemCombi.equals(_strItemCombi) && !_strItemCombi.equals("")) {
                    formula = "=" + hint.name + "(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + _strItemCombi + "\",\"" + params[4] + "\",\"" + params[5] + "\",\"" + params[6] + "\")";
                    cell.setExpressions(formula);
                }
            }
        }
    }

    public static String rebuildExpressionForm(String param, MethodInvokeExpr codeExpr, BgFormInfo bgFormInfo) {
        if (param == null || "".equals(param)) {
            return "";
        }
        String strParam = param.toString();
        strParam = strParam.replaceAll(";", ",");
        String[] array = (strParam = strParam.replaceAll("\"", "")).split(",");
        int length = array.length;
        if (length == 1) {
            return "";
        }
        ArrayList list = (ArrayList)codeExpr.paramList;
        if (bgFormInfo != null) {
            String endPeriod;
            String beginPeriod;
            String currency;
            String scheme;
            CodeExpr param1 = (CodeExpr)list.get(1);
            CodeExpr param4 = (CodeExpr)list.get(4);
            CodeExpr param5 = (CodeExpr)list.get(5);
            CodeExpr param6 = (CodeExpr)list.get(6);
            if (param1 instanceof StringExpr && ((scheme = ((StringExpr)param1).text) == null || scheme.equals(""))) {
                ((StringExpr)param1).text = bgFormInfo.getBgScheme().getNumber();
            }
            if (param4 instanceof StringExpr && ((currency = ((StringExpr)param4).text) == null || currency.equals(""))) {
                ((StringExpr)param4).text = bgFormInfo.getCurrency().getNumber();
            }
            if (param5 instanceof StringExpr && ((beginPeriod = ((StringExpr)param5).text) == null || beginPeriod.equals(""))) {
                ((StringExpr)param5).text = bgFormInfo.getBgPeriod().getNumber();
            }
            if (param6 instanceof StringExpr && ((endPeriod = ((StringExpr)param6).text) == null || endPeriod.equals(""))) {
                ((StringExpr)param6).text = bgFormInfo.getBgPeriod().getNumber();
            }
        }
        Object[] objAry = new Object[length];
        for (int i = 0; i < length; ++i) {
            ArrayList tempList = (ArrayList)list.clone();
            StringExpr newParam0 = new StringExpr(array[i].trim());
            tempList.set(0, newParam0);
            objAry[i] = tempList;
        }
        MultiOrgMethodCodeExpr momc = new MultiOrgMethodCodeExpr(codeExpr, objAry);
        return momc.toString();
    }

    static String rebuildExpressionForm1(String param, MethodInvokeExpr codeExpr, BgFormInfo bgFormInfo) {
        if (param == null || "".equals(param)) {
            return "";
        }
        String strParam = param.toString();
        strParam = strParam.replaceAll(";", ",");
        String[] array = (strParam = strParam.replaceAll("\"", "")).split(",");
        int length = array.length;
        if (length == 1) {
            return "";
        }
        ArrayList list = (ArrayList)codeExpr.paramList;
        if (bgFormInfo != null) {
            String period;
            String scheme;
            CodeExpr param1 = (CodeExpr)list.get(1);
            CodeExpr param3 = (CodeExpr)list.get(3);
            if (param1 instanceof StringExpr && ((scheme = ((StringExpr)param1).text) == null || scheme.equals(""))) {
                ((StringExpr)param1).text = bgFormInfo.getBgScheme().getNumber();
            }
            if (param3 instanceof StringExpr && ((period = ((StringExpr)param3).text) == null || period.trim().length() == 0)) {
                ((StringExpr)param3).text = bgFormInfo.getBgPeriod().getNumber();
            }
        }
        Object[] objAry = new Object[length];
        for (int i = 0; i < length; ++i) {
            ArrayList tempList = (ArrayList)list.clone();
            StringExpr newParam0 = new StringExpr(array[i].trim());
            tempList.set(0, newParam0);
            objAry[i] = tempList;
        }
        MultiOrgMethodCodeExpr momc = new MultiOrgMethodCodeExpr(codeExpr, objAry);
        return momc.toString();
    }

    public static String splitFormula(String formula) throws Exception {
        Expression exp = ExcelFormulaPaserHelper.parse((String)formula);
        if (exp instanceof FunctionExpr) {
            exp = BgClientHelper.expand((Expression)((FunctionExpr)exp));
        }
        ExcelFormulaPaserHelper.walk((Expression)exp, (IExpressionHandler)new IExpressionHandler(){

            public void handle(Expression exp) {
                if (exp instanceof BinaryOperationExpr) {
                    ((BinaryOperationExpr)exp).left = BgClientHelper.expand(((BinaryOperationExpr)exp).left);
                    ((BinaryOperationExpr)exp).right = BgClientHelper.expand(((BinaryOperationExpr)exp).right);
                } else if (exp instanceof UnaryOperationExpr) {
                    ((UnaryOperationExpr)exp).operand = BgClientHelper.expand(((UnaryOperationExpr)exp).operand);
                } else if (exp instanceof FunctionExpr) {
                    if ((exp = BgClientHelper.expand((Expression)((FunctionExpr)exp))) instanceof BinaryOperationExpr) {
                        this.handle(exp);
                    } else {
                        List ps = ((FunctionExpr)exp).parameters;
                        for (int i = 0; i < ps.size(); ++i) {
                            ps.set(i, BgClientHelper.expand((Expression)ps.get(i)));
                        }
                    }
                }
            }
        });
        return exp.toString();
    }

    private static Expression expand(Expression e) {
        try {
            if (e instanceof FunctionExpr && ("BgFormula".equalsIgnoreCase(((FunctionExpr)e).funcionName) || "BgAct".equalsIgnoreCase(((FunctionExpr)e).funcionName) || "BgBal".equalsIgnoreCase(((FunctionExpr)e).funcionName) || "BgActualS".equalsIgnoreCase(((FunctionExpr)e).funcionName) || "bgRefBgTem".equalsIgnoreCase(((FunctionExpr)e).funcionName))) {
                FunctionExpr foo = (FunctionExpr)e;
                StringBuffer sb = new StringBuffer();
                Expression p1 = (Expression)foo.parameters.get(0);
                if (p1 instanceof com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr) {
                    com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr sp = (com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr)p1;
                    String[] pp = sp.value.split(";");
                    for (int i = 0; i < pp.length; ++i) {
                        foo.parameters.set(0, new com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr(pp[i]));
                        if (sb.length() > 1) {
                            sb.append('+');
                        }
                        foo.output(sb);
                    }
                }
                return ExcelFormulaPaserHelper.parse((String)sb.toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        return e;
    }

    public static void getOtherOrg(OrgUnitInfo orgUnit, FilterInfo filter) {
        Object[] ids = null;
        try {
            IBgItemWithOrg iBgItemWithOrg = BgItemWithOrgFactory.getRemoteInstance();
            ids = (Object[])iBgItemWithOrg.getIncludeId(orgUnit.getNumber(), orgUnit.getLongNumber());
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        catch (EASBizException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        String maskString = "";
        if (ids == null) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            if (i != 0) {
                maskString = maskString + " or ";
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((HashSet)ids[i]), CompareType.INCLUDE));
            maskString = "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") ";
        }
        if (maskString.equals("")) {
            return;
        }
        if (filter.getMaskString() == null) {
            filter.setMaskString(maskString);
        } else {
            String newMask = filter.getMaskString().substring(0, filter.getMaskString().length() - 1);
            filter.setMaskString(newMask + " or (" + maskString + "))");
        }
    }

    public static void addSqlMenu(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.fm.common.client.FMIsqlUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static void getItemOrgs(CostCenterOrgUnitInfo ccoInfo, FilterInfo filter, boolean isLevel1) {
        if (ccoInfo != null && ccoInfo.getId() != null) {
            int maskSize = filter.getFilterItems().size();
            if (maskSize == 1 && StringUtils.isEmpty((String)filter.getMaskString())) {
                filter.setMaskString("#0");
            }
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ccoInfo.getId().toString()), CompareType.EQUALS));
            if (isLevel1) {
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
                filter.setMaskString("(" + filter.getMaskString() + ") and  #" + String.valueOf(maskSize) + " and #" + String.valueOf(maskSize + 1));
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") and #" + String.valueOf(maskSize));
            }
        }
    }

    public static List getSortedByNumberOrgs(Collection orgs, boolean isAsc) {
        if (orgs == null) {
            return new ArrayList();
        }
        ArrayList res = new ArrayList(orgs);
        Collections.sort(res, new SortOrgUnitByNumber(isAsc));
        return res;
    }

    public static void procesSheetPremission(Book book, String templateId, String userId) throws EASBizException {
        if (book == null || StringUtils.isEmpty((String)templateId)) {
            return;
        }
        if (StringUtils.isEmpty((String)userId)) {
            userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        boolean isAccreditUuser = false;
        if (BgSHelper.isBgTemplatePerimissionForUse()) {
            if (BgSHelper.isNeedDealBG02201(userId)) {
                isAccreditUuser = true;
            }
        } else {
            isAccreditUuser = true;
        }
        if (BgSHelper.isBgSheetPermissionUsed() && isAccreditUuser) {
            Map sheetPer = BgClientHelper.addBgSheetPermission(templateId);
            int sheetIndex = 0;
            boolean isShowSheet = false;
            Sheet sheet = null;
            int sheetSize = book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                sheet = book.getSheet(sheetIndex);
                if (!isShowSheet) {
                    isShowSheet = BgClientHelper.hideSheet(sheet, sheetPer, userId);
                    continue;
                }
                BgClientHelper.hideSheet(sheet, sheetPer, userId);
            }
            if (!isShowSheet) {
                throw new BgException(BgException.OTHERERROR, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"hasnotPermissionSheet")});
            }
        }
    }

    private static boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign((Sheet)_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null) {
                if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
            }
        }
        return isShowSheet;
    }

    private static Map addBgSheetPermission(String templateId) {
        if (StringUtils.isEmpty((String)templateId)) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(templateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(templateId) != null) {
                sheetPer = (Map)hasPer.get(templateId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    public static int calWidth(Component comp, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return 0;
        }
        FontMetrics fm = null;
        if (comp.getFont() != null) {
            fm = comp.getFontMetrics(comp.getFont());
        }
        if (fm != null) {
            return fm.stringWidth(text);
        }
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) > '\u00ff') {
                width += 12;
                continue;
            }
            width += 6;
        }
        return text.length();
    }

    public static class SortOrgUnitByNumber
    implements Comparator {
        private boolean isAsc = false;

        public SortOrgUnitByNumber(boolean asc) {
            this.isAsc = asc;
        }

        public int compare(Object o1, Object o2) {
            try {
                String l = ((OrgUnitInfo)o1).getNumber();
                String r = ((OrgUnitInfo)o2).getNumber();
                if (this.isAsc) {
                    return l.compareTo(r);
                }
                return r.compareTo(l);
            }
            catch (Exception e) {
                logger.error((Object)"SortOrgUnitByNumber:", (Throwable)e);
                return 0;
            }
        }
    }
}

