/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCollectFormFactory;
import com.kingdee.eas.ma.budget.BgCollectFormInfo;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgCollectForm;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgCollectFormListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCollectFormEditUI;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgCollectFormListUI
extends AbstractBgCollectFormListUI {
    private static final long serialVersionUID = -4411688076194619807L;
    private static final Logger logger = CoreUIObject.getLogger(BgCollectFormListUI.class);
    private static final String SOURCESTR = "com.kingdee.eas.ma.budget.client.BgCollectResource";
    protected LongTimeDialog dialog = null;
    protected IBgForm ibgForm = null;
    protected IBgExamineFacade ibgExamineFacade = null;
    protected BgCollectFormInfo bgCollectInfo = null;
    private String xNum = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setRefresh(false);
        this.tblMain.getMergeManager().setMergeMode(1);
        int schemaIndex = this.tblMain.getColumnIndex("bgScheme.name");
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (i == schemaIndex || i == 0) {
                this.tblMain.getColumn(i).setMergeable(true);
                continue;
            }
            this.tblMain.getColumn(i).setMergeable(false);
        }
        this.tblMain.setRefresh(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnViewFlow.setEnabled(true);
        this.btnViewFlow.setVisible(true);
        this.itemViewFlow.setEnabled(true);
        this.itemViewFlow.setVisible(true);
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.itemViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        if (strID != null && strID.trim().length() > 0) {
            IBgCollectForm bgCollect = BgCollectFormFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(strID);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("state"));
            BgCollectFormInfo aBgCollectFormInfo = bgCollect.getBgCollectFormInfo((IObjectPK)pk, sc);
            if (BgCollectStateEnum.SIGNED.equals((Object)aBgCollectFormInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNOCHANGE");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.SIGNED.equals((Object)aBgCollectFormInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOCHANGE"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFlow_actionPerformed(e);
        this.checkSelected();
        BgClientHelper.viewFlow((Component)((Object)this), this.getSelectedKeyValue());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        if (strID != null && strID.trim().length() > 0) {
            if (BgFormHelper.checkInProInst(strID)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOREMOVE"));
                SysUtil.abort();
            }
            IBgCollectForm bgCollect = BgCollectFormFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(strID);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("state"));
            BgCollectFormInfo aBgCollectFormInfo = bgCollect.getBgCollectFormInfo((IObjectPK)pk, sc);
            if (BgCollectStateEnum.SIGNED.equals((Object)aBgCollectFormInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNODELETE");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.AUDIT.equals((Object)aBgCollectFormInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOREMOVE"));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
        BgFormHelper.refreshBgFormList((CoreUI)this);
    }

    protected String getEditUIName() {
        return BgCollectFormEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCollectFormFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)SysContext.getSysContext().getCurrentCostUnit().getId().toString(), CompareType.EQUALS));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("BGSCHEME.PERIOD", (Object)new Integer(4), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("BGSCHEME.PERIOD", (Object)new Integer(-1), CompareType.NOTEQUALS));
        }
        filter.setMaskString("#0 and #1");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> org = new HashSet<String>();
            org.add(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermissionForDec((String)userId, org, (FilterInfo)filter);
        }
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String bgCollectId = this.getSelectedKeyValue();
        if (bgCollectId != null && bgCollectId.trim().length() > 0) {
            int re;
            if (BgFormHelper.checkInProInst(bgCollectId)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOAUDIT"));
                SysUtil.abort();
            }
            IBgCollectForm bgCollect = BgCollectFormFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(bgCollectId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("state");
            sic.add("bgForm.id");
            sic.add("refBgForms.id");
            sic.add("refBgForms.bgForm.id");
            this.bgCollectInfo = bgCollect.getBgCollectFormInfo((IObjectPK)pk, sic);
            if (BgCollectStateEnum.SIGNED.equals((Object)this.bgCollectInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNOAUDIT");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.AUDIT.equals((Object)this.bgCollectInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOAUDIT"));
                SysUtil.abort();
            }
            if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMAUDITINFO"))) == 1 || re == 2) {
                return;
            }
            if (BgParamCHelper.isCompulsionReportCheck()) {
                this.checkReport(this.bgCollectInfo);
            }
            if (this.getExamineInterface().canExamine(this.getBgExmCheckReportId(this.bgCollectInfo))) {
                this.xNum = BgNFCHelper.returnExamineX((BOSUuid[])this.getBgExmCheckReportId(this.bgCollectInfo), (Object)((Object)this));
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                this.dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
                if (this.dialog != null) {
                    this.dialog.setLongTimeTask(new ILongTimeTask(){

                        public Object exec() throws Exception {
                            Object[] result = BgCollectFormListUI.this.getExamineInterface().examines(BgCollectFormListUI.this.getBgExmCheckReportId(BgCollectFormListUI.this.bgCollectInfo), BgCollectFormListUI.this.xNum);
                            HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                            bgExamineCheckMap.put("BgExamineChecked", result[0]);
                            bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                            return bgExamineCheckMap;
                        }

                        public void afterExec(Object result) throws Exception {
                            if (result != null && result instanceof HashMap) {
                                BgCollectFormListUI.this.openBgExamineViewUI(result, null);
                                Map bgExamineCheckMap = (Map)result;
                                Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                                if (bgExCheck.booleanValue()) {
                                    BgCollectFormFactory.getRemoteInstance().audit(BgCollectFormListUI.this.bgCollectInfo.getId());
                                } else {
                                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantAudit"));
                                }
                            } else {
                                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                            }
                        }
                    });
                    this.dialog.show();
                }
            } else {
                BgCollectFormFactory.getRemoteInstance().audit(BOSUuid.read((String)this.getSelectedKeyValue()));
            }
            BgFormHelper.refreshBgFormList((CoreUI)this);
        }
    }

    protected void checkReport(BgCollectFormInfo bgCollInfo) throws Exception {
        boolean isExit = false;
        List check = this.getFormInterface().reportCheck(bgCollInfo.getId(), this.getRefBgFormIds(bgCollInfo), this.getBgExmCheckReportId(bgCollInfo), BgCollectFormInfo.class.getName());
        if (check.get(0).equals(Boolean.FALSE)) {
            isExit = true;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"String", (Object)check.get(3).toString());
            uiContext.put((Object)"id", this.getUIContext().get("ID"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiContext, null);
            uiWindow.show();
        }
        if (isExit) {
            SysUtil.abort();
        }
    }

    protected BOSUuid[] getRefBgFormIds(BgCollectFormInfo bgCollInfo) {
        BOSUuid[] refBgFormIds = null;
        refBgFormIds = new BOSUuid[1 + bgCollInfo.getRefBgForms().size()];
        refBgFormIds[0] = bgCollInfo.getId();
        int n = bgCollInfo.getRefBgForms().size();
        for (int i = 0; i < n; ++i) {
            refBgFormIds[i + 1] = bgCollInfo.getRefBgForms().get(i).getId();
        }
        return refBgFormIds;
    }

    protected BOSUuid[] getBgExmCheckReportId(BgCollectFormInfo bgCollInfo) {
        BOSUuid[] bgFormIds = null;
        RefBgFormInfo refBgFormInfo = null;
        bgFormIds = new BOSUuid[1 + bgCollInfo.getRefBgForms().size()];
        bgFormIds[0] = bgCollInfo.getBgForm().getId();
        int n = bgCollInfo.getRefBgForms().size();
        for (int i = 0; i < n; ++i) {
            refBgFormInfo = bgCollInfo.getRefBgForms().get(i);
            bgFormIds[i + 1] = refBgFormInfo.getBgForm().getId();
        }
        return bgFormIds;
    }

    protected void openBgExamineViewUI(Object obj, Boolean isModel) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openBgExamineViewType(isModel)).create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String openBgExamineViewType(Boolean isModel) {
        if (isModel != null && isModel.booleanValue()) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        if (this.getUIContext().get("Owner") != null && (this.getUIContext().get("Owner") instanceof MultiApproveUI || this.getUIContext().get("Owner") instanceof MessageCenterUI)) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected IBgForm getFormInterface() throws BOSException {
        if (this.ibgForm == null) {
            this.ibgForm = BgFormFactory.getRemoteInstance();
        }
        return this.ibgForm;
    }

    protected IBgExamineFacade getExamineInterface() throws Exception {
        if (this.ibgExamineFacade == null) {
            this.ibgExamineFacade = BgExamineFacadeFactory.getRemoteInstance();
        }
        return this.ibgExamineFacade;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String bgCollectId = this.getSelectedKeyValue();
        if (bgCollectId != null && bgCollectId.trim().length() > 0) {
            int re;
            if (BgFormHelper.checkInProInst(bgCollectId)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOSUBMIT"));
                SysUtil.abort();
            }
            IBgCollectForm bgCollect = BgCollectFormFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(bgCollectId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("state");
            sic.add("bgForm.id");
            sic.add("bgForm.number");
            sic.add("refBgForms.id");
            sic.add("refBgForms.bgForm.id");
            sic.add("refBgForms.bgForm.number");
            this.bgCollectInfo = bgCollect.getBgCollectFormInfo((IObjectPK)pk, sic);
            if (BgCollectStateEnum.SIGNED.equals((Object)this.bgCollectInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNOSUBMIT");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.AUDIT.equals((Object)this.bgCollectInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOSUBMIT"));
                SysUtil.abort();
            }
            if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMSUBMITINFO"))) == 1 || re == 2) {
                return;
            }
            if (BgParamCHelper.isCompulsionReportCheck()) {
                this.checkReport(this.bgCollectInfo);
            }
            if (this.getExamineInterface().canExamine(this.getBgExmCheckReportId(this.bgCollectInfo))) {
                this.xNum = BgNFCHelper.returnExamineX((BOSUuid[])this.getBgExmCheckReportId(this.bgCollectInfo), (Object)((Object)this));
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                this.dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
                if (this.dialog != null) {
                    this.dialog.setLongTimeTask(new ILongTimeTask(){

                        public Object exec() throws Exception {
                            Object[] result = BgCollectFormListUI.this.getExamineInterface().examines(BgCollectFormListUI.this.getBgExmCheckReportId(BgCollectFormListUI.this.bgCollectInfo), BgCollectFormListUI.this.xNum);
                            HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                            bgExamineCheckMap.put("BgExamineChecked", result[0]);
                            bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                            return bgExamineCheckMap;
                        }

                        public void afterExec(Object result) throws Exception {
                            if (result != null && result instanceof HashMap) {
                                BgCollectFormListUI.this.openBgExamineViewUI(result, null);
                                Map bgExamineCheckMap = (Map)result;
                                Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                                if (bgExCheck.booleanValue()) {
                                    BgCollectFormFactory.getRemoteInstance().auditWF(BgCollectFormListUI.this.bgCollectInfo.getId());
                                    MsgBox.showInfo((String)BgCollectFormListUI.this.getMessage("isSubmit"));
                                } else {
                                    MsgBox.showWarning((String)BgCollectFormListUI.this.getMessage("submitWorkDefeat"));
                                }
                            } else {
                                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                            }
                        }
                    });
                    this.dialog.show();
                }
            } else {
                BgCollectFormFactory.getRemoteInstance().auditWF(this.bgCollectInfo.getId());
                MsgBox.showInfo((Component)((Object)this), (String)this.getMessage("isSubmit"));
            }
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        BizEnumValueDTO dto;
        super.tblMain_tableSelectChanged(e);
        int rIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range == null) {
            return;
        }
        KDTSelectBlock select = (KDTSelectBlock)range.get(0);
        if (select == null) {
            return;
        }
        rIndex = select.getBeginRow();
        boolean isEnable = false;
        if (rIndex >= 0 && this.tblMain.getCell(rIndex, "state") != null && this.tblMain.getCell(rIndex, "state").getValue() instanceof BizEnumValueDTO && !(dto = (BizEnumValueDTO)this.tblMain.getCell(rIndex, "state").getValue()).getValue().equals("101")) {
            isEnable = true;
        }
        this.actionEdit.setEnabled(isEnable);
        this.actionRemove.setEnabled(isEnable);
        this.actionAudit.setEnabled(isEnable);
        this.actionSubmit.setEnabled(isEnable);
    }

    protected String getMessage(String key) {
        return EASResource.getString((String)SOURCESTR, (String)key);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"bgForm.number", "bgForm.name"};
        return locateNames;
    }
}

