/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AbstractBgCollectViewCompareAndAUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCollectViewCompareAndAUI
extends AbstractBgCollectViewCompareAndAUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCollectViewCompareAndAUI.class);
    private String formulaString = null;
    public static final String COLLECT_FORMULA = "com.kingdee.eas.ma.budget.client.newbg.formula";
    public static final String COLLECT_DATA_MAP = "com.kingdee.eas.ma.budget.client.newbg.datamap";
    private int decimal = 8;
    private Map dataMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.dataMap == null) {
            this.dataMap = (Map)this.getUIContext().get(COLLECT_DATA_MAP);
        }
        if (StringUtils.isEmpty((String)this.formulaString)) {
            this.formulaString = (String)this.getUIContext().get(COLLECT_FORMULA);
        }
        this.processInitSystem();
        this.processInitHeadInfo();
        this.processCollectInfo();
        this.setNumberFormat();
    }

    private void processCollectInfo() throws Exception {
        if (this.dataMap == null) {
            this.dataMap = (Map)this.getUIContext().get(COLLECT_DATA_MAP);
        }
        if (this.dataMap.isEmpty()) {
            return;
        }
        CostCenterOrgUnitInfo costCenterOrgInfo = null;
        IRow row = null;
        ICostCenterOrgUnit iCostcenterorgunit = CostCenterOrgUnitFactory.getRemoteInstance();
        Object key2 = null;
        BigDecimal value = null;
        for (Object key2 : this.dataMap.keySet()) {
            if (key2 == null || key2.toString().length() <= 0) continue;
            costCenterOrgInfo = iCostcenterorgunit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)key2));
            value = (BigDecimal)this.dataMap.get(key2);
            if (value == null) {
                value = new BigDecimal("0.00");
            }
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)costCenterOrgInfo);
            row.getCell(1).setValue((Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processInitHeadInfo() throws Exception {
        String[] parameter;
        block20: {
            block21: {
                if (StringUtils.isEmpty((String)this.formulaString)) {
                    this.formulaString = (String)this.getUIContext().get(COLLECT_FORMULA);
                }
                if ((parameter = BgFSHelper.getFormulaInfo(this.formulaString)) == null) return;
                if (parameter[0] == null || parameter[0].trim().length() <= 0) break block21;
                HashSet<String> bgItemsSet = new HashSet<String>();
                HashMap<String, String> bgItemsMap = new HashMap<String, String>();
                String bgItemsName = null;
                String[] bgItems = parameter[0].split(",");
                int n = bgItems.length;
                for (int i = 0; i < n; ++i) {
                    bgItemsSet.add(bgItems[i]);
                }
                try {
                    IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                    if (ibgItem == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    String orgUnitId = BgSHelper.getIsolateOrg(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgItemsSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgItemInfo bgItemInfo = null;
                    BgItemCollection bgItemCol = ibgItem.getBgItemCollection(view);
                    Iterator iter = bgItemCol.iterator();
                    while (iter.hasNext()) {
                        bgItemInfo = (BgItemInfo)iter.next();
                        if (bgItemsMap.containsKey(bgItemInfo.getNumber())) continue;
                        bgItemsMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
                    }
                    int n2 = bgItems.length;
                    for (int i = 0; i < n2; ++i) {
                        bgItemsName = i == 0 ? (String)bgItemsMap.get(bgItems[i]) : bgItemsName + "|" + bgItemsMap.get(bgItems[i]);
                    }
                    this.txtBgItemNumber.setText(parameter[0]);
                }
                catch (BOSException ex) {
                    throw ex;
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception e) {
                        logger.error((Object)"budget error:", (Throwable)e);
                        break block20;
                    }
                }
                this.txtBgItemName.setText(bgItemsName);
                break block20;
                finally {
                    this.txtBgItemNumber.setText(parameter[0]);
                    this.txtBgItemName.setText(bgItemsName);
                }
            }
            this.txtBgItemNumber.setText("");
            this.txtBgItemName.setText("");
        }
        if (parameter[2] != null && parameter[2].trim().length() > 0) {
            String bgElementName = null;
            try {
                IBgElement ibgElement = BgElementFactory.getRemoteInstance();
                if (ibgElement == null) {
                    throw new BgException(BgException.NOINSTANCE);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                BgElementCollection bgElementCol = ibgElement.getBgElementCollection(view);
                bgElementName = !bgElementCol.isEmpty() ? bgElementCol.get(0).getName() : "";
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (EASBizException ex3) {
                        throw ex3;
                    }
                }
                catch (Throwable throwable) {
                    this.txtBgElementName.setText(bgElementName);
                    throw throwable;
                }
            }
            this.txtBgElementName.setText(bgElementName);
        }
        if (this.getUIContext().get("data.type") != null) {
            this.txtBgDataType.setText((String)this.getUIContext().get("data.type"));
        }
        if (parameter == null) return;
        if (parameter[5] == null) return;
        CurrencyInfo currencyInfo = BgSHelper.getCurrencyInfo(null, parameter[5], null);
        if (currencyInfo == null) return;
        this.decimal = currencyInfo.getPrecision();
    }

    private void processInitSystem() {
        this.txtBgDataType.setText("");
        this.txtBgElementName.setText("");
        this.txtBgItemName.setText("");
        this.txtBgItemNumber.setText("");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.contBgItemName.setEnabled(false);
        this.contBgItemNumber.setEnabled(false);
        this.contBgElementName.setEnabled(false);
        this.contBgDataType.setEnabled(false);
    }

    private void setNumberFormat() throws BOSException {
        String currencyNumber = BgNFSHelper.parseFormulaPara((String)this.formulaString)[5];
        CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select precision where number = '" + currencyNumber + "'");
        int prec = 2;
        if (col != null && !col.isEmpty()) {
            prec = col.get(0).getPrecision();
        }
        String numberFormat = "#,###." + BgNFSHelper.getNumberFormat((String)"0", (int)prec);
        int rowCount = this.tblMain.getRowCount();
        int colCount = this.tblMain.getColumnCount();
        ICell cell = null;
        String valueStr = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                cell = this.tblMain.getCell(i, j);
                if (cell == null || cell.getValue() == null) continue;
                valueStr = cell.getValue().toString();
                valueStr = valueStr.replaceAll(",", "");
                valueStr = valueStr.replaceAll("%", "");
                try {
                    new BigDecimal(valueStr);
                    cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    cell.getStyleAttributes().setNumberFormat(numberFormat);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

