/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.IBgCollectFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgGatherFacade;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AbstractBgCollectViewUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormActualProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewActualInitProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewAddActualProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.util.StringUtils;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCollectViewUI
extends AbstractBgCollectViewUI {
    private static final long serialVersionUID = -6600658221271816922L;
    private static final Logger logger = CoreUIObject.getLogger(BgCollectViewUI.class);
    private boolean isBudget = true;
    private boolean isAdjust = false;
    private boolean isAddData = false;
    private BOSUuid bgSchemeId = null;
    private String formulaStr = null;
    private BigDecimal measure = null;
    private int decimal = 8;
    private List orgUnitList = null;
    private Map bgFormIdsMap = null;
    private boolean isEditRpt = false;

    protected IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    protected IBgCollectFacade getBgCollectInterface() throws Exception {
        return BgCollectFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        boolean isActual;
        super.onLoad();
        this.processInitSystem();
        this.processInitHeadInfo();
        if (this.getUIContext().get("DATA_SOURCE_TEMP_FUDIAN") != null) {
            this.processFodianInfo();
        } else {
            this.processCollectInfo();
        }
        this.btnEditRpt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgCollectViewUI.this.beforeActionPerformed(e);
                try {
                    BgCollectViewUI.this.btnEditRpt_actionPerformed(e);
                }
                catch (Exception exc) {
                    BgCollectViewUI.this.handUIException(exc);
                }
                finally {
                    BgCollectViewUI.this.afterActionPerformed(e);
                }
            }
        });
        if (this.getUIContext().get("isActual") instanceof Boolean && (isActual = Boolean.parseBoolean(this.getUIContext().get("isActual").toString()))) {
            this.btnEditRpt.setVisible(false);
            this.btnEditRpt.setEnabled(false);
            return;
        }
    }

    private void processInitSystem() {
        boolean isActual;
        this.txtBgDataType.setText("");
        this.txtBgElementName.setText("");
        this.txtBgItemName.setText("");
        this.txtBgItemNumber.setText("");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("money").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.contBgItemName.setEnabled(false);
        this.contBgItemNumber.setEnabled(false);
        this.contBgElementName.setEnabled(false);
        this.contBgDataType.setEnabled(false);
        if (Boolean.TRUE.equals(this.getUIContext().get("VIEWDFORM"))) {
            this.btnEditRpt.setVisible(false);
        }
        if (this.getUIContext().get("isActual") instanceof Boolean && (isActual = Boolean.parseBoolean(this.getUIContext().get("isActual").toString()))) {
            this.btnEditRpt.setVisible(false);
            this.btnEditRpt.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processInitHeadInfo() throws Exception {
        String[] parameter;
        block23: {
            block24: {
                this.measure = this.getUIContext().get("GATHER_MEASUREUNIT") != null ? (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT") : BgConstants.ONE;
                String orgUnitId2222222 = null;
                String orgUnitName = null;
                Map orgUnitMap = null;
                Map bgSchemeMap = null;
                String[] orgUnitStr = null;
                this.orgUnitList = new ArrayList();
                if (this.getUIContext().get("GATHER_ORGUNIT") == null) return;
                if (this.getUIContext().get("GATHER_SCHEME") == null) return;
                orgUnitMap = (Map)this.getUIContext().get("GATHER_ORGUNIT");
                bgSchemeMap = (Map)this.getUIContext().get("GATHER_SCHEME");
                if (this.getUIContext().get("GATHER_BGFORM") != null) {
                    this.bgFormIdsMap = (Map)this.getUIContext().get("GATHER_BGFORM");
                }
                this.isBudget = this.getUIContext().get("GATHER_DATA_TYPE") == null ? true : (Boolean)this.getUIContext().get("GATHER_DATA_TYPE");
                this.isAdjust = this.getUIContext().get("IS_GATHER_ADJUST") == null ? false : (Boolean)this.getUIContext().get("IS_GATHER_ADJUST");
                this.isAddData = this.getUIContext().get("IS_GATHER_ADD") == null ? false : (Boolean)this.getUIContext().get("IS_GATHER_ADD");
                if (orgUnitMap == null) return;
                if (orgUnitMap.isEmpty()) return;
                if (bgSchemeMap == null) return;
                if (bgSchemeMap.isEmpty()) return;
                for (String orgUnitId2222222 : orgUnitMap.keySet()) {
                    orgUnitName = (String)orgUnitMap.get(orgUnitId2222222);
                    if (!bgSchemeMap.containsKey(orgUnitId2222222)) continue;
                    orgUnitStr = new String[]{orgUnitId2222222, orgUnitName, (String)bgSchemeMap.get(orgUnitId2222222)};
                    this.orgUnitList.add(orgUnitStr);
                }
                this.bgSchemeId = (BOSUuid)this.getUIContext().get("BGSCHEME_ID");
                this.formulaStr = (String)this.getUIContext().get("GATHER_FORMULA");
                parameter = BgNFSHelper.parseFormulaPara(null, (String)this.formulaStr);
                if (parameter == null) return;
                if (parameter[0] == null || parameter[0].trim().length() <= 0) break block24;
                HashSet<String> bgItemsSet = new HashSet<String>();
                HashMap<String, String> bgItemsMap = new HashMap<String, String>();
                String bgItemsName = null;
                String[] bgItems = parameter[0].split(",");
                int n = bgItems.length;
                for (int i = 0; i < n; ++i) {
                    bgItemsSet.add(bgItems[i]);
                }
                try {
                    IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                    if (ibgItem == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    orgUnitId2222222 = BgSHelper.getIsolateOrg(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgItemsSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId2222222, CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgItemInfo bgItemInfo = null;
                    BgItemCollection bgItemCol = ibgItem.getBgItemCollection(view);
                    Iterator iter = bgItemCol.iterator();
                    while (iter.hasNext()) {
                        bgItemInfo = (BgItemInfo)iter.next();
                        if (bgItemsMap.containsKey(bgItemInfo.getNumber())) continue;
                        bgItemsMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
                    }
                    int n2 = bgItems.length;
                    for (int i = 0; i < n2; ++i) {
                        bgItemsName = i == 0 ? (String)bgItemsMap.get(bgItems[i]) : bgItemsName + "|" + bgItemsMap.get(bgItems[i]);
                    }
                    this.txtBgItemNumber.setText(parameter[0]);
                }
                catch (BOSException ex) {
                    throw ex;
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception e) {
                        logger.error((Object)"budget error:", (Throwable)e);
                        break block23;
                    }
                }
                this.txtBgItemName.setText(bgItemsName);
                break block23;
                finally {
                    this.txtBgItemNumber.setText(parameter[0]);
                    this.txtBgItemName.setText(bgItemsName);
                }
            }
            this.txtBgItemNumber.setText("");
            this.txtBgItemName.setText("");
        }
        if (parameter[2] != null && parameter[2].trim().length() > 0) {
            String bgElementName = null;
            try {
                IBgElement ibgElement = BgElementFactory.getRemoteInstance();
                if (ibgElement == null) {
                    throw new BgException(BgException.NOINSTANCE);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                BgElementCollection bgElementCol = ibgElement.getBgElementCollection(view);
                bgElementName = !bgElementCol.isEmpty() ? bgElementCol.get(0).getName() : "";
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (EASBizException ex3) {
                        throw ex3;
                    }
                }
                catch (Throwable throwable) {
                    this.txtBgElementName.setText(bgElementName);
                    throw throwable;
                }
            }
            this.txtBgElementName.setText(bgElementName);
        }
        if (parameter[3] != null && parameter[3].trim().length() > 0) {
            if (this.isBudget) {
                this.txtBgDataType.setText(BgDataTypeEnum.BgData.getAlias());
            } else {
                this.txtBgDataType.setText(BgDataTypeEnum.BgActual.getAlias());
            }
        }
        if (parameter == null) return;
        if (parameter[5] == null) return;
        CurrencyInfo currencyInfo = BgSHelper.getCurrencyInfo(null, parameter[5], null);
        if (currencyInfo == null) return;
        this.decimal = currencyInfo.getPrecision();
    }

    private void processFodianInfo() throws Exception {
        IBgGatherFacade ibgGatherFacade = BgGatherFacadeFactory.getRemoteInstance();
        if (ibgGatherFacade == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        List reInfo = ibgGatherFacade.getGatherView(this.bgFormIdsMap, this.formulaStr, this.isBudget, this.isAdjust);
        this.tblMain.getColumn("bgform.name").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("formula").getStyleAttributes().setHided(false);
        if (reInfo != null && !reInfo.isEmpty()) {
            DecimalFormat _decFormat = null;
            Object[] dataObj = null;
            IRow row = null;
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat(this.decimal);
            int in = reInfo.size();
            for (int i = 0; i < in; ++i) {
                dataObj = (Object[])reInfo.get(i);
                row = this.tblMain.addRow();
                row.getCell(0).setValue(dataObj[1]);
                row.getCell(1).setValue(dataObj[2]);
                row.getCell(2).setValue(dataObj[3]);
                row.getCell(3).setValue(dataObj[4]);
                try {
                    row.getCell(4).setValue((Object)_decFormat.format(((BigDecimal)dataObj[5]).doubleValue()));
                    continue;
                }
                catch (Exception ex) {
                    row.getCell(4).setValue((Object)BgNConstants.ZERO);
                }
            }
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    protected void btnEditRpt_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getBody().size() == 0) {
            return;
        }
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        Object billId = this.tblMain.getRow(activeRowIndex).getCell("bgform.id").getValue();
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("id");
        select.add("orgUnit.id");
        select.add("state");
        select.add("bgTemplate.formType");
        BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(billId.toString()), select);
        BOSUuid orgPk = bgForm.getOrgUnit().getId();
        BOSUuid userPK = SysContext.getSysContext().getCurrentUserInfo().getId();
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userPK), (IObjectPK)new ObjectUuidPK(orgPk), "bg_form04_update");
        int state = bgForm.getState().getValue();
        String viewState = OprtState.VIEW;
        if (state == 1 || state == 14 || state == 25) {
            viewState = OprtState.EDIT;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", billId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) ? BgReportViewProcessUI.class.getName() : BgNFormProcessUI.class.getName(), (Map)uiContext, null, viewState);
        if (uiWindow instanceof UIModelDialog) {
            ((UIModelDialog)uiWindow).setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        uiWindow.show();
        this.destroyWindow();
        this.setEditRpt(true);
    }

    private void dealActualEdit() throws BOSException, EASBizException, UIException {
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object billId = this.tblMain.getRow(activeRowIndex).getCell("bgform.id").getValue();
        String state = OprtState.VIEW;
        if (this.getUIContext().get("operState") instanceof String) {
            state = this.getUIContext().get("operState").toString();
        }
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("id");
        select.add("bgform.orgUnit.id");
        select.add("state");
        select.add("bgform.bgTemplate.formType");
        BgActualRecordInfo info = BgActualRecordFactory.getRemoteInstance().getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(billId.toString()), select);
        BOSUuid orgPk = info.getBgForm().getOrgUnit().getId();
        BOSUuid userPK = SysContext.getSysContext().getCurrentUserInfo().getId();
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userPK), (IObjectPK)new ObjectUuidPK(orgPk), "bg_form04_update");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", billId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNActualRecordProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        if (uiWindow instanceof UIModelDialog) {
            ((UIModelDialog)uiWindow).setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        uiWindow.show();
        this.setEditRpt(true);
    }

    private void processCollectInfo() throws Exception {
        List reInfo;
        String _gatherByPeriodId = null;
        boolean hasGatherByPeriod = false;
        Object _obj = this.getUIContext().get("IS_GATHER_PERIOD");
        if (_obj instanceof Boolean) {
            hasGatherByPeriod = (Boolean)_obj;
        }
        if (hasGatherByPeriod) {
            _gatherByPeriodId = (String)this.getUIContext().get("IS_GATHER_PERIOD_ID");
        }
        if ((reInfo = this.getFacadeInterface().getCollectData(this.bgSchemeId, this.formulaStr, this.orgUnitList, this.isBudget, this.isAdjust, this.isAddData, hasGatherByPeriod, _gatherByPeriodId)) != null && !reInfo.isEmpty()) {
            Object[] _objs = null;
            BigDecimal _value = null;
            DecimalFormat _decFormat = null;
            IRow row = null;
            int i = 0;
            int n = 0;
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat(this.decimal);
            n = reInfo.size();
            for (i = 0; i < n; ++i) {
                _objs = (Object[])reInfo.get(i);
                _value = (BigDecimal)_objs[1];
                row = this.tblMain.addRow();
                row.getCell(0).setValue(_objs[0]);
                try {
                    row.getCell(4).setValue((Object)_decFormat.format(_value.divide(this.measure, 8, 4).doubleValue()));
                }
                catch (Exception ex) {
                    row.getCell(4).setValue((Object)BgNConstants.ZERO);
                }
                row.getCell(1).setValue(_objs[2]);
            }
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }

    @Override
    protected void btnViewRpt_actionPerformed(ActionEvent e) throws Exception {
        this.openReport(OprtState.VIEW);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.openReport(OprtState.VIEW);
        }
    }

    protected void openReport(String reportState) throws Exception {
        Object billId;
        if (this.tblMain.getBody().size() == 0) {
            return;
        }
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        if ((billId = this.tblMain.getRow(activeRowIndex).getCell("bgform.id").getValue()) != null && !StringUtils.isEmpty((String)billId.toString())) {
            String _billId = billId.toString();
            String _bosType = BOSUuid.read((String)_billId).getType().toString();
            BgFormInfo _bgFormInfo = new BgFormInfo();
            BgActualRecordInfo _bgActualRecordInfo = new BgActualRecordInfo();
            if (_bosType.equals(_bgFormInfo.getBOSType().toString())) {
                BOSUuid bgFormIdStr = BOSUuid.read((String)_billId.toString());
                if (this.isAdjust) {
                    bgFormIdStr = this.getBgCollectInterface().getCollectFormId(BOSUuid.read((String)_billId.toString()));
                }
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)bgFormIdStr.toString());
                SelectorItemCollection itemCollection = new SelectorItemCollection();
                itemCollection.add("bgTemplate.id");
                itemCollection.add("bgTemplate.formType");
                BgFormInfo formInfo = (BgFormInfo)BgFormFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(bgFormIdStr.toString()), itemCollection);
                boolean bl = this.isBudget = this.getUIContext().get("GATHER_DATA_TYPE") == null ? true : (Boolean)this.getUIContext().get("GATHER_DATA_TYPE");
                String name = formInfo.getBgTemplate().getFormType().getValue() == 4 ? (this.isBudget ? BgReportViewProcessUI.class.getName() : BgReportViewActualInitProcessUI.class.getName()) : (!this.isBudget ? BgNFormActualProcessUI.class.getName() : BgNFormProcessUI.class.getName());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(name, (Map)uiContext, null, reportState);
                if (uiWindow instanceof UIModelDialog) {
                    ((UIModelDialog)uiWindow).setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
                }
                uiWindow.show();
            } else if (_bosType.equals(_bgActualRecordInfo.getBOSType().toString())) {
                String editUIName = "";
                SelectorItemCollection itemCollection = new SelectorItemCollection();
                itemCollection.add("bgform.id");
                itemCollection.add("bgform.bgTemplate.id");
                itemCollection.add("bgform.bgTemplate.formType");
                BgActualRecordInfo actualRecord = BgActualRecordFactory.getRemoteInstance().getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(_billId), itemCollection);
                editUIName = actualRecord.getBgForm().getBgTemplate().getFormType().getValue() == 4 ? BgReportViewAddActualProcessUI.class.getName() : BgNActualRecordProcessUI.class.getName();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)_billId);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, reportState);
                uiWindow.show();
            }
        }
    }

    public boolean isEditRpt() {
        return this.isEditRpt;
    }

    public void setEditRpt(boolean isEditRpt) {
        this.isEditRpt = isEditRpt;
    }
}

