/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisDoForBook;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgIOHelper;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.NumberExpandInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchAndDealDataAnalysisSystemFacade;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchStandardDataForBgFormulaFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.util.SysUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgComHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgComHelper");
    private static FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade = new FetchAndDealDataAnalysisSystemFacade();
    protected static final List notAllowOperation = Arrays.asList(Integer.valueOf("65536"));
    protected static final String NEW_ANALYSIS_COL_KEY = "AnalysisColKey";
    public static final String ANALYSIS_FLAG = "analysis_col";
    protected static final String ADD_ROW_FLAG = "add_row_flag";
    protected static final String COL_KEY = "bgCompareAndAnalysisColKey";
    protected static final String TITLE_FLAG = "title_col";
    protected static final BigDecimal ONE = new BigDecimal("1.00");

    public static Book getbook(NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, boolean isDisplayZero2, boolean b) {
        Book book = BgComHelper.addAndInitTable(filter1Params);
        book.setCalculate(false);
        int sheetNum = book.getSheetCount();
        for (int i = 0; i < sheetNum && b; ++i) {
            Sheet sheet = book.getSheet(i);
            int addRowIndex = BgComHelper.constructSheet(filter1Params, filter2Params.getAnalysisElement(), sheet);
            BgComHelper.rebuildFilter1Params(filter1Params, new CostCenterOrgUnitInfo[]{filter1Params.getCostCenterOrgUnitInfoAry()[0]});
            try {
                fetchAndDealDataFacade.getDataDealCenter().getFetchDataFactory().initDataFactory(filter1Params, filter2Params);
                BgComHelper.fillDataToTable(sheet, filter1Params, filter2Params, addRowIndex);
            }
            catch (EASBizException e) {
                SysUtil.abort();
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
            BgComHelper.delBgItemWithAllAnalysisDataEqualZero(isDisplayZero2, sheet, addRowIndex, filter2Params);
            BgNLockProtectHelper.setSheetLockedAndProtection((Sheet)sheet, (boolean)true, (List)notAllowOperation);
        }
        return book;
    }

    protected static void delBgItemWithAllAnalysisDataEqualZero(boolean isDelete, Sheet sheet, int addRowIndex, NewBgCompareAndAnalysisFilterParam filter2Params) {
        if (isDelete) {
            BgComHelper.delRow(sheet, addRowIndex, filter2Params);
        }
    }

    private static void delRow(Sheet sheet, int addRowIndex, NewBgCompareAndAnalysisFilterParam filter2Params) {
        List analysisColIndexList = BgComHelper.getAnalysisColIndexList(sheet);
        List analysisElementList = filter2Params.getAnalysisElement();
        for (int rowIndex = sheet.getMaxRowIndex() + 1; rowIndex > addRowIndex; --rowIndex) {
            if (!BgComHelper.isDeleteRow(sheet, rowIndex, analysisColIndexList, analysisElementList)) continue;
            BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
        }
    }

    private static boolean isDeleteRow(Sheet sheet, int rowIndex, List analysisColIndexList, List analysisElementList) {
        int colNum = analysisColIndexList.size();
        for (int k = 0; k < colNum; ++k) {
            int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
            int num = analysisElementList.size();
            for (int i = 0; i < num; ++i) {
                String variantStr;
                Variant variant;
                Cell cell = sheet.getCell(rowIndex, analysisColIndex + i, false);
                if (cell == null || (variant = cell.getValue()) == null || DataDealCenter.ZIROSTR_LIST.contains(variantStr = variant.toString().trim())) continue;
                return false;
            }
        }
        return true;
    }

    protected static final List getAnalysisColIndexList(Sheet sheet) {
        ArrayList<Integer> analysisColIndexList = new ArrayList<Integer>();
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            analysisColIndexList.add(new Integer(i));
        }
        return analysisColIndexList;
    }

    protected static Book addAndInitTable(NewBgCompareAndAnalysisFilterParam filter1Params) {
        String bgFormID = filter1Params.getBgFormID();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgFormID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("data"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        Book book = null;
        try {
            BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormCollection(viewInfo).get(0);
            if (bgFormInfo == null) {
                SysUtil.abort();
            }
            BgIOHelper bih = new BgIOHelper();
            bih.setIDoForBook(new BgCompareAndAnalysisDoForBook());
            book = bih.getBook(bgFormInfo.getData());
            book.setCalculate(false);
        }
        catch (Exception ex) {
            if (book != null) {
                book = null;
            }
            SysUtil.abort();
        }
        if (book == null || book.getSheet(0) != null) {
            // empty if block
        }
        return book;
    }

    protected static int constructSheet(NewBgCompareAndAnalysisFilterParam filter1Param, List analysisElementList, Sheet sheet) {
        Map analysisColsMap = filter1Param.getAnalysisColsMap();
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String key = sheetID + "&" + sheetName;
        List analysisColsList = (List)analysisColsMap.get(key);
        if (analysisColsList == null) {
            return 0;
        }
        Map titleColsMap = filter1Param.getTitleColsMap();
        List titleColsList = null;
        if (titleColsMap != null) {
            titleColsList = (List)titleColsMap.get(key);
        }
        if (titleColsList != null && titleColsList.size() != 0) {
            BgComHelper.removeUnRequiredCols(titleColsList, analysisColsList, sheet);
        } else {
            BgComHelper.removeUnRequiredCols(analysisColsList, sheet);
        }
        int rowIndex = BgComHelper.locateAddedNewRowIndex(sheet);
        Row addRow = BgNFSHelper.addRow((Sheet)sheet, (int)rowIndex);
        addRow.setUserObject(ADD_ROW_FLAG, (Object)"addRow");
        BgComHelper.addAnalysisCols(analysisElementList, rowIndex, sheet);
        BgComHelper.removeOldColumns(sheet);
        BgComHelper.accessorizeNewTable(analysisElementList.size(), rowIndex, sheet);
        BgComHelper.addOrgUnitByCol(filter1Param, rowIndex + 1, sheet);
        return rowIndex;
    }

    private static void removeOldColumns(Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column oldCol = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)oldCol, (String)COL_KEY);
            Row row = null;
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            int newAnalysisColIndex = i + 1;
            Column newAnalysisCol = sheet.getColumn(newAnalysisColIndex, false);
            BgNFSHelper.setColObject((Column)newAnalysisCol, (String)NEW_ANALYSIS_COL_KEY, (Object)ANALYSIS_FLAG);
            int num = sheet.getMaxRowIndex() + 1;
            for (int j = 0; j < num; ++j) {
                Cell newCell;
                Cell cell;
                row = sheet.getRow(j, false);
                if (row != null && row.getUserObjectValue(ADD_ROW_FLAG) != null && row.getUserObjectValue(ADD_ROW_FLAG).toString().equals("addRow") || (cell = sheet.getCell(j, i, false)) == null) continue;
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setFormulaOfCell((Cell)newCell, (String)bgItem, (boolean)true);
                } else if (BgNFSHelper.checkHasExpression((Cell)cell)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setExpression((Cell)newCell, (String)bgFormula);
                }
                Object txtCellObj = BgNFSHelper.getValue((Cell)cell);
                if (txtCellObj == null) continue;
                String txtCell = txtCellObj.toString();
                Cell newCell2 = sheet.getCell(j, newAnalysisColIndex, true);
                BgNFSHelper.setValue((Cell)newCell2, (Object)txtCell);
            }
            boolean isDelete = BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
            if (isDelete) continue;
            BgNFSHelper.setSheetProtection((Sheet)sheet, (boolean)false);
            BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
        }
    }

    private static void addOrgUnitByCol(NewBgCompareAndAnalysisFilterParam filter1Param, int beginRow, Sheet sheet) {
        CostCenterOrgUnitInfo[] orgInfoAry = filter1Param.getCostCenterOrgUnitInfoAry();
        int num = orgInfoAry.length;
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgInfoAry[i].getId().toString();
        }
        if (companyIds != null && companyIds.length != 0) {
            FullOrgUnitInfo baseOrgUnit = null;
            try {
                baseOrgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[0])));
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            Column column = BgNFSHelper.addColumn((Sheet)sheet, (int)0);
            int colIndex = column.getCol();
            sheet.getColRange(colIndex, colIndex).setColumnWidth(200);
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                if (!BgComHelper.checkHasBgItem(sheet, rowIndex)) continue;
                BgComHelper.addExpandInfo(sheet.getCell(rowIndex, column.getCol(), true), baseOrgUnit, companyIds.length);
            }
        }
    }

    protected static void addExpandInfo(Cell cell, FullOrgUnitInfo orgUnitInfo, int orgNum) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        if (orgNum == 1) {
            BgNFSHelper.setValue((Cell)cell, (Object)orgUnitInfo.getName());
        }
    }

    private static boolean checkHasBgItem(Sheet sheet, int rowIndex) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            return true;
        }
        return false;
    }

    private static void accessorizeNewTable(int mergeColNum, int rowIndex, Sheet sheet) {
        int num = sheet.getMaxColIndex();
        for (int i = num - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            for (int j = rowIndex - 1; j >= 0; --j) {
                Cell cell = sheet.getCell(j, i, false);
                if (cell == null || !BgNFSHelper.checkHasCurrencyInfo((Cell)cell) && !BgNFSHelper.checkHasBgElementInfo((Cell)cell) && !BgNFSHelper.checkHasBgItemInfo((Cell)cell) && !BgNFSHelper.checkHasBgPeriodInfo((Cell)cell)) continue;
                sheet.getRange(j, i, j, mergeColNum + i - 1).merge();
            }
        }
    }

    private static void addAnalysisCols(List analysisElementList, int rowIndex, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            if (!BgComHelper.isRealAnalysisCol(col, sheet)) {
                BgNFSHelper.setColObject((Column)col, (String)COL_KEY, null);
                continue;
            }
            int num = analysisElementList.size();
            for (int j = 0; j < num; ++j) {
                int colIndex = i + j + 1;
                Column column = BgNFSHelper.addColumn((Sheet)sheet, (int)colIndex);
                String proName = analysisElementList.get(j).toString();
                BgNFSHelper.setColObject((Column)column, (String)COL_KEY, (Object)proName);
                try {
                    BgNFSHelper.setValue((Cell)sheet.getCell(rowIndex, colIndex, true), (Object)AnalysisColumnTool.getProValByProName(proName, fetchAndDealDataFacade.getDataDealCenter().getFetchDataFactory().getAnalysisEleClass()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    SysUtil.abort();
                    continue;
                }
                catch (IllegalAccessException e) {
                    SysUtil.abort();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    SysUtil.abort();
                }
            }
        }
    }

    private static boolean isRealAnalysisCol(Column column, Sheet sheet) {
        int colIndex = column.getCol();
        int num = sheet.getMaxColIndex() + 11;
        for (int i = 0; i < num; ++i) {
            String tempBgItem;
            Cell cell = sheet.getCell(i, colIndex, false);
            if (cell == null) continue;
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula) || "".equals(tempBgItem = AnalysisColumnTool.changeBgFormulaToBgItem(bgFormula))) continue;
            return true;
        }
        return false;
    }

    private static int locateAddedNewRowIndex(Sheet sheet) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        boolean continueFlag = true;
        int rowIndex = 0;
        block0: for (int i = 0; i < rowCount && continueFlag; ++i) {
            for (int j = 0; j < colCount && continueFlag; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    rowIndex = cell.getRow();
                    continueFlag = false;
                    continue block0;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                rowIndex = cell.getRow();
                continueFlag = false;
                continue block0;
            }
        }
        return rowIndex;
    }

    private static void removeUnRequiredCols(List titleList, List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (titleList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)TITLE_FLAG);
                continue;
            }
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)ANALYSIS_FLAG);
                continue;
            }
            try {
                BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
                continue;
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    private static void removeUnRequiredCols(List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)TITLE_FLAG);
        }
    }

    static void rebuildFilter1Params(NewBgCompareAndAnalysisFilterParam filter1Params, Object[] ary) {
        filter1Params.setLazyLoadDataCostCenterOrgUnitInfoAry((CostCenterOrgUnitInfo[])ary);
    }

    protected static void fillDataToTable(Sheet sheet, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, int addRowIndex) throws EASBizException, BOSException {
        CostCenterOrgUnitInfo[] orgUnitAry = filter1Params.getCostCenterOrgUnitInfoAry();
        String rootOrgUnitId = orgUnitAry[0].getId().toString();
        Map amountUnitMap = filter1Params.getMeasureUnitInfoMap();
        List list = filter2Params.getAnalysisElement();
        BgComHelper.fillDataToTable(sheet, list, addRowIndex + 1, rootOrgUnitId, amountUnitMap, filter1Params, filter2Params);
    }

    protected static void fillDataToTable(Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId, Map amountUnitMap, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) throws EASBizException, BOSException {
        List analysisColIndexList = BgComHelper.getAnalysisColIndexList(sheet);
        int rowCount = sheet.getMaxRowIndex() + 1;
        BigDecimal amountUnit = ONE;
        for (int rowIndex = initRowIndex; rowIndex < rowCount; ++rowIndex) {
            int colNum = analysisColIndexList.size();
            for (int k = 0; k < colNum; ++k) {
                String[] bgFormulaAry;
                int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
                Cell cell = sheet.getCell(rowIndex, analysisColIndex, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                    amountUnit = BgComHelper.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                    int num = analysisColsList.size();
                    for (int j = 0; j < num; ++j) {
                        int addedColIndex = analysisColIndex + j;
                        Column col = sheet.getColumn(addedColIndex, false);
                        Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                        if (!(colKey instanceof String)) continue;
                        Object val = null;
                        try {
                            val = fetchAndDealDataFacade.getDataDealCenter().getDataFactory(bgItem, colKey.toString(), orgUnitId, amountUnit);
                        }
                        catch (SecurityException e) {
                            SysUtil.abort();
                        }
                        catch (IllegalArgumentException e) {
                            SysUtil.abort();
                        }
                        catch (NoSuchMethodException e) {
                        }
                        catch (IllegalAccessException e) {
                            SysUtil.abort();
                        }
                        catch (InvocationTargetException e) {
                            SysUtil.abort();
                        }
                        sheet.getCell(rowIndex, addedColIndex, true).setValue(new Variant(val));
                    }
                    continue;
                }
                if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                String currentOrgNum = BgComHelper.getOrgUnitNumber(orgUnitId);
                if (currentOrgNum.equals((bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula))[0])) {
                    BgComHelper.initBgFormulaDataFactory(bgFormulaAry, bgFormula, filter1Params, filter2Params);
                } else {
                    BgNFSHelper.setExpression((Cell)cell, (String)BgFormulaHelper.rebulidBgFormula(bgFormulaAry));
                }
                amountUnit = BgComHelper.reSetAmountUnit(bgFormulaAry[2], amountUnitMap);
                int num = analysisColsList.size();
                for (int j = 0; j < num; ++j) {
                    int addedColIndex = analysisColIndex + j;
                    Column col = sheet.getColumn(addedColIndex, false);
                    Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                    if (!(colKey instanceof String)) continue;
                    Object val = BgComHelper.getFetchStandardDataForBgFormulaFactory().getDataFactory(bgFormula, colKey.toString(), orgUnitId, amountUnit);
                    sheet.getCell(rowIndex, addedColIndex, true).setValue(new Variant(val));
                }
            }
            BgComHelper.fillDataToEntireTbl(sheet, rowIndex, orgUnitId, amountUnitMap, 0, filter1Params, filter2Params);
        }
    }

    private static FetchStandardDataForBgFormulaFactory getFetchStandardDataForBgFormulaFactory() {
        return new FetchStandardDataForBgFormulaFactory();
    }

    protected static void fillDataToEntireTbl(Sheet sheet, int rowIndex, String orgUnitId, Map amountUnitMap, int difRowNum, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) {
        int colCount = sheet.getMaxColIndex() + 1;
        BigDecimal amountUnit = ONE;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            String upBgItem;
            String colKey;
            Column col = sheet.getColumn(colIndex, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (obj instanceof String && ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                amountUnit = BgComHelper.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                Object val = null;
                try {
                    val = fetchAndDealDataFacade.getDataDealCenter().getDataFactory(bgItem, "col4", orgUnitId, amountUnit);
                }
                catch (SecurityException e) {
                    SysUtil.abort();
                }
                catch (IllegalArgumentException e) {
                    SysUtil.abort();
                }
                catch (NoSuchMethodException e) {
                    SysUtil.abort();
                }
                catch (IllegalAccessException e) {
                    SysUtil.abort();
                }
                catch (InvocationTargetException e) {
                    SysUtil.abort();
                }
                sheet.getCell(rowIndex, colIndex, false).setValue(new Variant(val));
                continue;
            }
            if (bgItem != null || (upBgItem = BgComHelper.findBgItem(sheet, rowIndex, colIndex, difRowNum)) == null || "".equals(upBgItem)) continue;
            BgNFSHelper.setFormulaOfCell((Cell)sheet.getCell(rowIndex, colIndex, true), (String)upBgItem, (boolean)true);
            String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(upBgItem);
            amountUnit = BgComHelper.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
            Object val = null;
            try {
                val = fetchAndDealDataFacade.getDataDealCenter().getDataFactory(upBgItem, "col4", orgUnitId, amountUnit);
            }
            catch (SecurityException e) {
                SysUtil.abort();
            }
            catch (IllegalArgumentException e) {
                SysUtil.abort();
            }
            catch (NoSuchMethodException e) {
                SysUtil.abort();
            }
            catch (IllegalAccessException e) {
                SysUtil.abort();
            }
            catch (InvocationTargetException e) {
                SysUtil.abort();
            }
            sheet.getCell(rowIndex, colIndex, false).setValue(new Variant(val));
        }
    }

    private static String findBgItem(Sheet sheet, int rowIndex, int colIndex, int difRowNum) {
        if (difRowNum == 0) {
            return null;
        }
        Cell cell = sheet.getCell(rowIndex - difRowNum, colIndex, false);
        String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
        if (bgItem != null && !"".equals(bgItem)) {
            return bgItem;
        }
        return null;
    }

    private static BigDecimal reSetAmountUnit(String element, Map amountUnitMap) {
        if (amountUnitMap == null || amountUnitMap.size() == 0) {
            return ONE;
        }
        for (BgElementInfo elementInfo : amountUnitMap.keySet()) {
            if (!elementInfo.getNumber().equals(element)) continue;
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)amountUnitMap.get(elementInfo);
            return measureUnitInfo.getCoefficient();
        }
        return ONE;
    }

    private static String getOrgUnitNumber(String orgUnitId) {
        FullOrgUnitInfo orgUnitInfo = null;
        try {
            orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        }
        catch (EASBizException e) {
            SysUtil.abort();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        catch (Exception e) {
            SysUtil.abort();
        }
        return orgUnitInfo.getNumber();
    }

    private static void initBgFormulaDataFactory(String[] bgFormulaAry, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) throws EASBizException, BOSException {
        BgComHelper.getFetchStandardDataForBgFormulaFactory().initDataFactory(bgFormula, filter1Params, filter2Params);
    }
}

