/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgCompareOneFilterParam;
import com.kingdee.eas.ma.budget.BgElementDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptDataInfo;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgRptFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgCompareOneMainUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCompareOneFilter2UI;
import com.kingdee.eas.ma.budget.client.BgFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgRptMainUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgCompareOneMainUI
extends AbstractBgCompareOneMainUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCompareOneMainUI.class);
    protected BgCompareOneFilter2UI filterUI;
    private BgCompareOneFilterParam filterParam;
    private Map allDataMap;
    private DecimalFormat percentFormat = new DecimalFormat("#0.00%");

    @Override
    public BgFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BgCompareOneFilter2UI(BgAnalysisTypeEnum.BGCOMPARE);
        }
        return this.filterUI;
    }

    @Override
    protected KDTable getMainTable() {
        return this.tblMain;
    }

    @Override
    protected void execQuery() throws Exception {
        super.execQuery();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.filterParam = (BgCompareOneFilterParam)this.rptFilterParam;
        this.allDataMap = null;
        if (this.filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
            this.setUITitle(EASResource.getString((String)this.resourcePath, (String)"SimpleCompareAnalyTitle"));
            if (this.filterParam.getPeriodIds() != null) {
                if (this.isSumDisp) {
                    this.processSum(this.filterParam);
                } else {
                    this.allDataMap = this.getAllDataMap(this.filterParam);
                }
            }
            this.initTableHead(this.isSumDisp);
            this.initTable(this.filterParam);
            this.fillData2Table(this.filterParam.getOrgUnitIds()[0]);
        } else if (this.filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            this.setUITitle(EASResource.getString((String)this.resourcePath, (String)"MultiCompareAnalyTitle"));
            if (this.isSumDisp) {
                this.processSumForMultiAnaly(this.filterParam);
            } else {
                this.allDataMap = this.getDataMapForMultiAnaly(this.filterParam);
            }
            this.initTableHeadForMultiAnaly(this.filterParam, this.isSumDisp);
            this.initTable(this.filterParam);
            this.fillData2TableForMultiAnaly(this.filterParam.getOrgUnitIds()[0]);
        }
        if (this.isSumDisp) {
            this.tblMain.checkParsed();
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            IColumn col = this.tblMain.getColumn("BgOrgUnit");
            if (col != null) {
                this.render = new BgRptMainUI.FlexRender(this);
                col.setRenderer((IBasicRender)this.render);
                col.getStyleAttributes().setLocked(true);
            }
            this.initListener();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell(this.tblMain.getColumnIndex("BgOrgUnit"));
                FullOrgUnitInfo companyInfo = (FullOrgUnitInfo)cell.getUserObject();
                BgRptMainUI.NumberExpandInfo expandInfo = new BgRptMainUI.NumberExpandInfo(this);
                expandInfo.setId(companyInfo.getId().toString());
                expandInfo.setNumber(companyInfo.getNumber());
                expandInfo.setName(companyInfo.getName());
                expandInfo.setLongNumber(companyInfo.getLongNumber());
                expandInfo.setLevel(0);
                expandInfo.setExpandStatus(true);
                if (this.parentCompanySet.contains(companyInfo.getId().toString())) {
                    expandInfo.setLeaf(false);
                } else {
                    expandInfo.setLeaf(true);
                }
                cell.setValue((Object)expandInfo);
            }
            IRow row = this.tblMain.getRow(0);
            if (row != null) {
                this.setTreeDisplayStyle(row, (BgRptMainUI.NumberExpandInfo)row.getCell(this.tblMain.getColumnIndex("BgOrgUnit")).getValue());
            }
        }
    }

    private void processSum(BgCompareOneFilterParam filterParam) throws Exception {
        Map preCollectMap = this.getAllDataMap(filterParam);
        Set combineSet = this.getCombineSet();
        String key = null;
        String currentKey = null;
        BigDecimal[] bigValArray = null;
        this.allDataMap = preCollectMap;
        for (int i = this.companyVec.size() - 1; i >= 0; --i) {
            String parentCompanyId;
            FullOrgUnitInfo fullOrgUnit = (FullOrgUnitInfo)this.companyVec.get(i);
            if (fullOrgUnit.getParent() == null || !this.parentCompanySet.contains(parentCompanyId = fullOrgUnit.getParent().getId().toString())) continue;
            for (String combineId : combineSet) {
                currentKey = combineId + "_" + fullOrgUnit.getId().toString();
                key = combineId + "_" + parentCompanyId;
                if (!preCollectMap.containsKey(currentKey)) continue;
                bigValArray = (BigDecimal[])preCollectMap.get(currentKey);
                if (this.allDataMap.containsKey(key)) {
                    bigValArray = (BigDecimal[])this.getAddedBigArray(this.allDataMap.get(key), bigValArray);
                }
                this.allDataMap.put(key, bigValArray);
            }
        }
    }

    private void processSumForMultiAnaly(BgCompareOneFilterParam filterParam) throws Exception {
        Map preCollectMap = this.getDataMapForMultiAnaly(filterParam);
        Set combineSet = this.getCombineSet();
        String key = null;
        String currentKey = null;
        BigDecimal[] bigValArray = null;
        this.allDataMap = preCollectMap;
        for (int i = this.companyVec.size() - 1; i >= 0; --i) {
            String parentCompanyId;
            FullOrgUnitInfo fullOrgUnit = (FullOrgUnitInfo)this.companyVec.get(i);
            if (fullOrgUnit.getParent() == null || !this.parentCompanySet.contains(parentCompanyId = fullOrgUnit.getParent().getId().toString())) continue;
            for (String combineId : combineSet) {
                currentKey = combineId + "_" + fullOrgUnit.getId().toString();
                key = combineId + "_" + parentCompanyId;
                if (!preCollectMap.containsKey(currentKey)) continue;
                bigValArray = (BigDecimal[])preCollectMap.get(currentKey);
                if (this.allDataMap.containsKey(key)) {
                    bigValArray = (BigDecimal[])this.getAddedBigArray(this.allDataMap.get(key), bigValArray);
                }
                this.allDataMap.put(key, bigValArray);
            }
        }
    }

    private void fillData2Table(String orgUnitId) {
        block25: {
            int itemColumnIndex;
            int periodColumnIndex;
            int columnCount;
            int rowCount;
            block26: {
                block24: {
                    this.tblMain.checkParsed();
                    boolean isTest = false;
                    if (!isTest) break block24;
                    int rowCount2 = this.tblMain.getRowCount();
                    int columnCount2 = this.tblMain.getColumnCount();
                    int tempIndex = this.tblMain.getColumnIndex("BgItem");
                    if (rowCount2 <= 0) break block25;
                    for (int i = 0; i < rowCount2; ++i) {
                        IRow row = this.tblMain.getRow(i);
                        String itemId = (String)row.getUserObject();
                        for (int j = tempIndex + 1; j < columnCount2; ++j) {
                            ICell cell = row.getCell(j);
                            cell.setValue((Object)new BigDecimal("0.00"));
                        }
                    }
                    break block25;
                }
                rowCount = this.tblMain.getRowCount();
                columnCount = this.tblMain.getColumnCount();
                periodColumnIndex = this.tblMain.getColumnIndex("BgPeriod");
                itemColumnIndex = this.tblMain.getColumnIndex("BgItem");
                int orgUnitColumnIndex = this.tblMain.getColumnIndex("BgOrgUnit");
                if (!this.isSumDisp || this.allDataMap == null) break block26;
                if (rowCount <= 0) break block25;
                DecimalFormat decFormat = new DecimalFormat(BgClientHelper.getNumberFormat(this.currency.getId()));
                DecimalFormat rateFormat = new DecimalFormat(BgClientHelper.getRateFormat(this.currency.getId()));
                String zero = BgClientHelper.getZeroByPrecision(this.currency.getId());
                String format = BgClientHelper.getNumberFtm(this.currency.getId());
                for (int i = 0; i < rowCount; ++i) {
                    IRow row = this.tblMain.getRow(i);
                    String itemId = (String)row.getCell(itemColumnIndex).getUserObject();
                    String periodId = (String)row.getCell(periodColumnIndex).getUserObject();
                    String companyId = ((FullOrgUnitInfo)row.getCell(orgUnitColumnIndex).getUserObject()).getId().toString();
                    for (int j = itemColumnIndex + 1; j < columnCount; ++j) {
                        IColumn column = this.tblMain.getColumn(j);
                        String totalKey = periodId + "_" + itemId + "_" + column.getKey() + "_" + companyId;
                        ICell cell = row.getCell(j);
                        if (this.allDataMap.get(totalKey) != null) {
                            BigDecimal dataVal = null;
                            String amountType = ((Object[])column.getUserObject())[0].toString();
                            BgElementDataTypeEnum dataType = (BgElementDataTypeEnum)((Object)((Object[])column.getUserObject())[1]);
                            if (amountType.equals("CurrentPeriodBg") || amountType.equals("AccumBg")) {
                                dataVal = ((BigDecimal[])this.allDataMap.get(totalKey))[0];
                            } else if (amountType.equals("CurrentPeriodActual") || amountType.equals("AccumActual")) {
                                dataVal = ((BigDecimal[])this.allDataMap.get(totalKey))[1];
                            } else if (amountType.equals("DiffValue") || amountType.equals("DiffAmount")) {
                                dataVal = ((BigDecimal[])this.allDataMap.get(totalKey))[2];
                            } else if (amountType.equals("DiffRate") || amountType.equals("AccumDiffRate")) {
                                dataVal = ((BigDecimal[])this.allDataMap.get(totalKey))[3];
                            }
                            if (amountType.equals("DiffRate") || amountType.equals("AccumDiffRate")) {
                                cell.setValue((Object)this.percentFormat.format(dataVal));
                            } else if (dataType.equals((Object)BgElementDataTypeEnum.RATE)) {
                                cell.setValue((Object)rateFormat.format(dataVal));
                            } else {
                                cell.setValue((Object)decFormat.format(dataVal));
                            }
                        }
                        cell.getFormattedStyleAttributes().setNumberFormat(format);
                    }
                }
                break block25;
            }
            if (rowCount > 0 && this.allDataMap != null) {
                String kdFormat = BgClientHelper.getNumberFtm(this.currency.getId());
                String kdRateFormat = BgClientHelper.getKDRateFormat(this.currency.getId());
                for (int i = 0; i < rowCount; ++i) {
                    IRow row = this.tblMain.getRow(i);
                    String itemId = (String)row.getCell(itemColumnIndex).getUserObject();
                    String periodId = (String)row.getCell(periodColumnIndex).getUserObject();
                    for (int j = itemColumnIndex + 1; j < columnCount; ++j) {
                        IColumn column = this.tblMain.getColumn(j);
                        String totalKey = periodId + "_" + itemId + "_" + column.getKey() + "_" + orgUnitId;
                        ICell cell = row.getCell(j);
                        if (this.allDataMap.get(totalKey) == null) continue;
                        String amountType = ((Object[])column.getUserObject())[0].toString();
                        BgElementDataTypeEnum dataType = (BgElementDataTypeEnum)((Object)((Object[])column.getUserObject())[1]);
                        if (dataType.equals((Object)BgElementDataTypeEnum.RATE)) {
                            cell.getFormattedStyleAttributes().setNumberFormat(kdRateFormat);
                        } else {
                            cell.getFormattedStyleAttributes().setNumberFormat(kdFormat);
                        }
                        if (amountType.equals("CurrentPeriodBg") || amountType.equals("AccumBg")) {
                            cell.setValue((Object)((BigDecimal[])this.allDataMap.get(totalKey))[0]);
                            continue;
                        }
                        if (amountType.equals("CurrentPeriodActual") || amountType.equals("AccumActual")) {
                            cell.setValue((Object)((BigDecimal[])this.allDataMap.get(totalKey))[1]);
                            continue;
                        }
                        if (amountType.equals("DiffValue") || amountType.equals("DiffAmount")) {
                            cell.setValue((Object)((BigDecimal[])this.allDataMap.get(totalKey))[2]);
                            continue;
                        }
                        if (!amountType.equals("DiffRate") && !amountType.equals("AccumDiffRate")) continue;
                        cell.setValue((Object)this.percentFormat.format(((BigDecimal[])this.allDataMap.get(totalKey))[3]));
                    }
                }
            }
        }
    }

    private void fillData2TableForMultiAnaly(String orgUnitId) {
        block14: {
            int itemColumnIndex;
            int periodColumnIndex;
            int columnCount;
            int rowCount;
            block15: {
                block13: {
                    this.tblMain.checkParsed();
                    boolean isTest = false;
                    if (!isTest) break block13;
                    int rowCount2 = this.tblMain.getRowCount();
                    int columnCount2 = this.tblMain.getColumnCount();
                    int tempIndex = this.tblMain.getColumnIndex("BgItem");
                    if (rowCount2 <= 0) break block14;
                    for (int i = 0; i < rowCount2; ++i) {
                        IRow row = this.tblMain.getRow(i);
                        String itemId = (String)row.getUserObject();
                        for (int j = tempIndex + 1; j < columnCount2; ++j) {
                            ICell cell = row.getCell(j);
                            cell.setValue((Object)new BigDecimal("0.00"));
                        }
                    }
                    break block14;
                }
                rowCount = this.tblMain.getRowCount();
                columnCount = this.tblMain.getColumnCount();
                periodColumnIndex = this.tblMain.getColumnIndex("BgPeriod");
                itemColumnIndex = this.tblMain.getColumnIndex("BgItem");
                int orgUnitColumnIndex = this.tblMain.getColumnIndex("BgOrgUnit");
                if (!this.isSumDisp || this.allDataMap == null) break block15;
                if (rowCount <= 0) break block14;
                String format = BgClientHelper.getNumberFtm(this.currency.getId());
                for (int i = 0; i < rowCount; ++i) {
                    IRow row = this.tblMain.getRow(i);
                    String itemId = (String)row.getCell(itemColumnIndex).getUserObject();
                    String periodId = (String)row.getCell(periodColumnIndex).getUserObject();
                    String companyId = ((FullOrgUnitInfo)row.getCell(orgUnitColumnIndex).getUserObject()).getId().toString();
                    for (int j = itemColumnIndex + 1; j < columnCount; ++j) {
                        IColumn column = this.tblMain.getColumn(j);
                        int tempIndex = j;
                        String totalKey = periodId + "_" + itemId + "_" + column.getKey() + "_" + companyId;
                        ICell cell = row.getCell(j);
                        cell.getFormattedStyleAttributes().setNumberFormat(format);
                        String amountType = ((Object[])column.getUserObject())[0].toString();
                        BgElementDataTypeEnum dataType = (BgElementDataTypeEnum)((Object)((Object[])column.getUserObject())[1]);
                        if (amountType.equals("DiffValue") || amountType.equals("DiffAmount")) {
                            cell.setValue((Object)this.getBgBalance((BigDecimal)row.getCell(tempIndex - 2).getValue(), (BigDecimal)row.getCell(tempIndex - 1).getValue()));
                            continue;
                        }
                        if (amountType.equals("DiffRate") || amountType.equals("AccumDiffRate")) {
                            cell.setValue((Object)this.percentFormat.format(this.getBgDiffRate(this.getBgBalance((BigDecimal)row.getCell(tempIndex - 3).getValue(), (BigDecimal)row.getCell(tempIndex - 2).getValue()), (BigDecimal)row.getCell(tempIndex - 3).getValue())));
                            continue;
                        }
                        if (this.allDataMap.get(totalKey) == null) continue;
                        cell.setValue((Object)((BigDecimal)this.allDataMap.get(totalKey)));
                    }
                }
                break block14;
            }
            if (rowCount > 0 && this.allDataMap != null) {
                String kdFormat = BgClientHelper.getNumberFtm(this.currency.getId());
                String kdRateFormat = BgClientHelper.getKDRateFormat(this.currency.getId());
                String firstKey = null;
                String secondKey = null;
                for (int i = 0; i < rowCount; ++i) {
                    IRow row = this.tblMain.getRow(i);
                    String itemId = (String)row.getCell(itemColumnIndex).getUserObject();
                    String periodId = (String)row.getCell(periodColumnIndex).getUserObject();
                    for (int j = itemColumnIndex + 1; j < columnCount; ++j) {
                        IColumn column = this.tblMain.getColumn(j);
                        int tempIndex = j;
                        String totalKey = periodId + "_" + itemId + "_" + column.getKey() + "_" + orgUnitId;
                        ICell cell = row.getCell(j);
                        String amountType = ((Object[])column.getUserObject())[0].toString();
                        BgElementDataTypeEnum dataType = (BgElementDataTypeEnum)((Object)((Object[])column.getUserObject())[1]);
                        if (dataType.equals((Object)BgElementDataTypeEnum.RATE)) {
                            cell.getFormattedStyleAttributes().setNumberFormat(kdRateFormat);
                        } else {
                            cell.getFormattedStyleAttributes().setNumberFormat(kdFormat);
                        }
                        if (amountType.equals("DiffValue") || amountType.equals("DiffAmount")) {
                            firstKey = periodId + "_" + itemId + "_" + this.tblMain.getColumn(itemColumnIndex + 1).getKey() + "_" + orgUnitId;
                            secondKey = periodId + "_" + itemId + "_" + this.tblMain.getColumn(itemColumnIndex + 2).getKey() + "_" + orgUnitId;
                            cell.setValue((Object)this.getBgBalance((BigDecimal)row.getCell(tempIndex - 2).getValue(), (BigDecimal)row.getCell(tempIndex - 1).getValue()));
                            continue;
                        }
                        if (amountType.equals("DiffRate") || amountType.equals("AccumDiffRate")) {
                            cell.setValue((Object)this.percentFormat.format(this.getBgDiffRate(this.getBgBalance((BigDecimal)row.getCell(tempIndex - 3).getValue(), (BigDecimal)row.getCell(tempIndex - 2).getValue()), (BigDecimal)row.getCell(tempIndex - 3).getValue())));
                            continue;
                        }
                        if (this.allDataMap.get(totalKey) == null) continue;
                        cell.setValue((Object)((BigDecimal)this.allDataMap.get(totalKey)));
                    }
                }
            }
        }
    }

    private void initTableHead(boolean isSum) {
        this.tblMain.checkParsed();
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        for (int i = 0; i < 3; ++i) {
            this.tblMain.addHeadRow();
        }
        int mergeIndex = this.tblMain.getColumnCount();
        Vector<String> dimColumnVec = new Vector<String>();
        if (isSum) {
            dimColumnVec.add("BgOrgUnit");
        }
        dimColumnVec.add("BgPeriod");
        dimColumnVec.add("BgItem");
        for (int i = 0; i < dimColumnVec.size(); ++i) {
            IColumn col = this.tblMain.addColumn();
            col.setKey((String)dimColumnVec.get(i));
            col.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(i).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)dimColumnVec.get(i))));
            this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 2, this.tblMain.getColumnCount() - 1);
            mergeIndex = this.tblMain.getColumnCount();
        }
        Vector<Object> v = new Vector<Object>();
        if (this.filterUI.prmtElement.getValue() != null) {
            v.add(this.filterUI.prmtElement.getValue());
            this.bgBaseMap.put("BGELEMENT", v);
        }
        Vector<String> analyVec = new Vector<String>();
        analyVec.add("CurrentPeriodAnaly");
        analyVec.add("AccumAnaly");
        Vector elementVec = (Vector)this.bgBaseMap.get("BGELEMENT");
        Vector<String> columnVec = null;
        Vector<String> columnOneVec = new Vector<String>();
        columnOneVec.add("CurrentPeriodBg");
        columnOneVec.add("CurrentPeriodActual");
        columnOneVec.add("DiffValue");
        columnOneVec.add("DiffRate");
        Vector<String> columnTwoVec = new Vector<String>();
        columnTwoVec.add("AccumBg");
        columnTwoVec.add("AccumActual");
        columnTwoVec.add("DiffAmount");
        columnTwoVec.add("AccumDiffRate");
        int mergeOneIndex = this.tblMain.getColumnCount();
        int mergeTwoIndex = this.tblMain.getColumnCount();
        int mergeThreeIndex = this.tblMain.getColumnCount();
        BgElementInfo elementInfo = null;
        for (int i = 0; i < analyVec.size(); ++i) {
            mergeOneIndex = this.tblMain.getColumnCount();
            if (analyVec.get(i).equals("CurrentPeriodAnaly")) {
                columnVec = columnOneVec;
            } else if (analyVec.get(i).equals("AccumAnaly")) {
                columnVec = columnTwoVec;
            }
            for (int j = 0; j < elementVec.size(); ++j) {
                elementInfo = (BgElementInfo)elementVec.get(j);
                mergeTwoIndex = this.tblMain.getColumnCount();
                if (columnVec != null) {
                    for (int k = 0; k < columnVec.size(); ++k) {
                        mergeThreeIndex = this.tblMain.getColumnCount();
                        IColumn newColumn = this.tblMain.addColumn();
                        newColumn.setKey(elementInfo.getId().toString() + "_" + (String)analyVec.get(i));
                        newColumn.setUserObject((Object)new Object[]{columnVec.get(k), elementInfo.getDataType()});
                        this.tblMain.getHeadRow(0).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)analyVec.get(i))));
                        this.tblMain.getHeadRow(1).getCell(newColumn.getColumnIndex()).setValue((Object)elementInfo.getName());
                        this.tblMain.getHeadRow(2).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)columnVec.get(k))));
                    }
                }
                this.tblMain.getHeadMergeManager().mergeBlock(1, mergeTwoIndex, 1, this.tblMain.getColumnCount() - 1);
            }
            this.tblMain.getHeadMergeManager().mergeBlock(0, mergeOneIndex, 0, this.tblMain.getColumnCount() - 1);
        }
    }

    protected void dealFilter(BgRptFilterParam filterParam) throws Exception {
        IBgRptFacade iRpt = BgRptFacadeFactory.getRemoteInstance();
        if (((BgCompareOneFilterParam)filterParam).getItemFrom() != null || ((BgCompareOneFilterParam)filterParam).getItemTo() != null) {
            Map mp = iRpt.getBgItemCombinByIds((List)this.bgBaseMap.get("dataCombIdSet"), filterParam.getOrgUnitId());
            if (((BgCompareOneFilterParam)filterParam).getItemFrom() != null && ((BgCompareOneFilterParam)filterParam).getItemTo() != null) {
                Vector st = (Vector)this.bgBaseMap.get("dataCombIdSet");
                if (st == null) {
                    return;
                }
                Iterator itor = st.iterator();
                Vector v = new Vector();
                while (itor.hasNext()) {
                    v.add(itor.next());
                }
                if (v.size() == 0) {
                    this.bgBaseMap.put("BgItemCombinId", null);
                    return;
                }
                this.bgBaseMap.put("BgItemCombinId", v);
            } else {
                this.bgBaseMap.put("BgItemCombinId", mp.get("BgItemCombinId"));
            }
            this.bgBaseMap.put("BGITEMCOMBINE", mp.get("BgItemCombineName"));
            this.bgBaseMap.put("BGITEMCOMBINENUMBER", mp.get("BgItemCombineNum"));
        }
    }

    @Override
    protected void initTable(BgRptFilterParam filterParam) throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getColumn("BgPeriod").setMergeable(true);
        this.tblMain.getColumn("BgPeriod").setGroup(true);
        boolean isSum = false;
        if (filterParam.isIsSum() && filterParam.getOrgUnitIds().length > 1) {
            isSum = true;
        }
        if (isSum) {
            if (this.tblMain.getColumn("BgOrgUnit") != null) {
                this.tblMain.getColumn("BgOrgUnit").setMergeable(true);
                this.tblMain.getColumn("BgOrgUnit").setGroup(true);
            } else {
                return;
            }
        }
        if (((BgCompareOneFilterParam)filterParam).getCurrency() != null) {
            this.txtCurrency.setText(((BgCompareOneFilterParam)filterParam).getCurrency().getName());
            this.currency = ((BgCompareOneFilterParam)filterParam).getCurrency();
        }
        if (this.periodVec == null || this.periodVec.size() == 0) {
            SysUtil.abort();
        }
        int periodColumnIndex = this.tblMain.getColumnIndex("BgPeriod");
        int itemColumnIndex = this.tblMain.getColumnIndex("BgItem");
        int orgUnitIndex = 0;
        if (isSum) {
            orgUnitIndex = this.tblMain.getColumnIndex("BgOrgUnit");
        }
        this.dealFilter(filterParam);
        Map itemMap = (Map)this.bgBaseMap.get("BGITEMCOMBINE");
        Vector itemIdVec = (Vector)this.bgBaseMap.get("BgItemCombinId");
        if (itemIdVec == null) {
            return;
        }
        int beginOneIndex = 0;
        int endOneIndex = 0;
        int beginIndex = 0;
        int endIndex = 0;
        if (isSum && !filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGTRACE)) {
            Object expandInfo = null;
            this.flexRowCount = 0;
            for (int i = 0; i < this.companyVec.size(); ++i) {
                FullOrgUnitInfo companyInfo = (FullOrgUnitInfo)this.companyVec.get(i);
                beginOneIndex = this.tblMain.getRowCount();
                for (int j = 0; j < this.periodVec.size(); ++j) {
                    beginIndex = this.tblMain.getRowCount();
                    BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.periodVec.get(j);
                    for (int k = 0; k < itemIdVec.size(); ++k) {
                        String key = (String)itemIdVec.get(k);
                        IRow row = this.tblMain.addRow();
                        ++this.flexRowCount;
                        if (this.parentCompanySet.contains(companyInfo.getId().toString())) {
                            row.getStyleAttributes().setBackground(BgClientHelper.TOTAL_COLOR);
                        }
                        row.getCell("BgOrgUnit").setValue((Object)companyInfo.getId().toString());
                        row.getCell(orgUnitIndex).setUserObject((Object)companyInfo);
                        row.getCell(periodColumnIndex).setValue((Object)bgPeriodInfo.getName());
                        row.getCell(periodColumnIndex).setUserObject((Object)bgPeriodInfo.getId().toString());
                        row.getCell(itemColumnIndex).setValue(itemMap.get(key));
                        row.getCell(itemColumnIndex).setUserObject((Object)key);
                    }
                    endIndex = this.tblMain.getRowCount();
                }
                endOneIndex = this.tblMain.getRowCount();
                this.tblMain.getMergeManager().mergeBlock(beginOneIndex, 0, endOneIndex, 0);
            }
            this.flexRowCount /= this.companyVec.size();
        } else {
            HashMap bgItemMap = new HashMap();
            for (int i = 0; i < this.periodVec.size(); ++i) {
                beginIndex = this.tblMain.getRowCount();
                bgItemMap.clear();
                for (int j = 0; j < itemIdVec.size(); ++j) {
                    String key = (String)itemIdVec.get(j);
                    if (bgItemMap.containsKey(key)) continue;
                    bgItemMap.put(key, null);
                    IRow row = this.tblMain.addRow();
                    BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.periodVec.get(i);
                    row.getCell(periodColumnIndex).setValue((Object)bgPeriodInfo.getName());
                    row.getCell(periodColumnIndex).setUserObject((Object)bgPeriodInfo.getId().toString());
                    row.getCell(itemColumnIndex).setValue(itemMap.get(key));
                    row.getCell(itemColumnIndex).setUserObject((Object)key);
                }
                endIndex = this.tblMain.getRowCount();
                this.tblMain.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
            }
        }
        this.tblMain.getGroupManager().group();
    }

    private void initTableHeadForMultiAnaly(BgCompareOneFilterParam filterParam, boolean isSum) {
        this.tblMain.checkParsed();
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        for (int i = 0; i < 3; ++i) {
            this.tblMain.addHeadRow();
        }
        int mergeIndex = this.tblMain.getColumnCount();
        Vector<String> dimColumnVec = new Vector<String>();
        if (isSum) {
            dimColumnVec.add("BgOrgUnit");
        }
        dimColumnVec.add("BgPeriod");
        dimColumnVec.add("BgItem");
        for (int i = 0; i < dimColumnVec.size(); ++i) {
            IColumn col = this.tblMain.addColumn();
            col.setKey((String)dimColumnVec.get(i));
            col.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(i).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)dimColumnVec.get(i))));
            this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 2, this.tblMain.getColumnCount() - 1);
            mergeIndex = this.tblMain.getColumnCount();
        }
        Vector<String> analyVec = new Vector<String>();
        analyVec.add("CurrentPeriodAnaly");
        analyVec.add("AccumAnaly");
        Vector elementVec = null;
        if (filterParam.objElement != null) {
            elementVec = new Vector();
            elementVec.add(filterParam.objElement);
            this.bgBaseMap.put("BGELEMENT", elementVec);
        } else {
            elementVec = (Vector)this.bgBaseMap.get("BGELEMENT");
        }
        String[] idArray = new String[2];
        boolean x = false;
        Map bgSchemeMap = filterParam.getMultiBgSchemeMap();
        for (int i = 0; i < filterParam.getMultiBgSchemeVec().size(); ++i) {
            idArray[i] = ((BgSchemeInfo)filterParam.getMultiBgSchemeVec().get(i)).getId().toString();
        }
        Vector<String> columnVec = null;
        Vector<String> columnOneVec = new Vector<String>();
        columnOneVec.add(idArray[0]);
        columnOneVec.add(idArray[1]);
        columnOneVec.add("DiffValue");
        columnOneVec.add("DiffRate");
        Vector<String> columnTwoVec = new Vector<String>();
        columnTwoVec.add(idArray[0]);
        columnTwoVec.add(idArray[1]);
        columnTwoVec.add("DiffAmount");
        columnTwoVec.add("AccumDiffRate");
        int mergeOneIndex = this.tblMain.getColumnCount();
        int mergeTwoIndex = this.tblMain.getColumnCount();
        int mergeThreeIndex = this.tblMain.getColumnCount();
        BgElementInfo elementInfo = null;
        for (int i = 0; i < analyVec.size(); ++i) {
            mergeOneIndex = this.tblMain.getColumnCount();
            if (analyVec.get(i).equals("CurrentPeriodAnaly")) {
                columnVec = columnOneVec;
            } else if (analyVec.get(i).equals("AccumAnaly")) {
                columnVec = columnTwoVec;
            }
            for (int j = 0; j < elementVec.size(); ++j) {
                elementInfo = (BgElementInfo)elementVec.get(j);
                mergeTwoIndex = this.tblMain.getColumnCount();
                if (columnVec != null) {
                    for (int k = 0; k < columnVec.size(); ++k) {
                        mergeThreeIndex = this.tblMain.getColumnCount();
                        IColumn newColumn = this.tblMain.addColumn();
                        newColumn.setKey(elementInfo.getId().toString() + "_" + (String)columnVec.get(k) + "_" + (String)analyVec.get(i));
                        newColumn.setUserObject((Object)new Object[]{columnVec.get(k), elementInfo.getDataType()});
                        this.tblMain.getHeadRow(0).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)analyVec.get(i))));
                        this.tblMain.getHeadRow(1).getCell(newColumn.getColumnIndex()).setValue((Object)elementInfo.getName());
                        if (k == 0 || k == 1) {
                            this.tblMain.getHeadRow(2).getCell(newColumn.getColumnIndex()).setValue(bgSchemeMap.get((String)columnVec.get(k)));
                            continue;
                        }
                        if (columnVec.get(k).equals("DiffValue") || columnVec.get(k).equals("DiffRate")) {
                            this.tblMain.getHeadRow(2).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)("Multi" + (String)columnVec.get(k))));
                            continue;
                        }
                        this.tblMain.getHeadRow(2).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)columnVec.get(k))));
                    }
                }
                this.tblMain.getHeadMergeManager().mergeBlock(1, mergeTwoIndex, 1, this.tblMain.getColumnCount() - 1);
            }
            this.tblMain.getHeadMergeManager().mergeBlock(0, mergeOneIndex, 0, this.tblMain.getColumnCount() - 1);
        }
    }

    private Map getDataMapForMultiAnaly(BgCompareOneFilterParam filterParam) throws Exception {
        IBgRptFacade iBgRpt = BgRptFacadeFactory.getRemoteInstance();
        List dataList = iBgRpt.getBgData(filterParam);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Vector<String> VdataCombId = new Vector<String>();
        if (dataList != null && dataList.size() > 0) {
            String key = null;
            int ct = dataList.size();
            for (int i = 0; i < ct; ++i) {
                BgRptDataInfo bgRptData = (BgRptDataInfo)dataList.get(i);
                key = bgRptData.getBgPeriodId() + "_" + bgRptData.getBgCombinId() + "_" + bgRptData.getBgElementId() + "_" + bgRptData.getBgSchemeId() + "_" + "CurrentPeriodAnaly" + "_" + bgRptData.getBgOrgUnitId();
                valueMap.put(key, bgRptData.getBgValue());
                VdataCombId.add(bgRptData.getBgCombinId());
            }
            boolean isAccumAnaly = this.isExistAccumAnaly(filterParam.getBgSchemeId(), filterParam.getBeginPeriodId(), filterParam.getEndPeriodId());
            if (isAccumAnaly) {
                Map itemMap = (Map)this.bgBaseMap.get("BGITEMCOMBINE");
                Vector elementVec = (Vector)this.bgBaseMap.get("BGELEMENT");
                String oneTotalKey = null;
                String twoTotalKey = null;
                Object objVal = null;
                String oneColKey = "CurrentPeriodAnaly";
                String twoColKey = "AccumAnaly";
                int index = 0;
                for (int i = 0; i < this.accumPeriodIdList.size(); ++i) {
                    index = i;
                    for (int j = 0; j < filterParam.getAttainOrgUnitIds().length; ++j) {
                        for (int k = 0; k < elementVec.size(); ++k) {
                            for (String itemId : itemMap.keySet()) {
                                Iterator bgSchemeIter = filterParam.getMultiBgSchemeMap().keySet().iterator();
                                while (bgSchemeIter.hasNext()) {
                                    String partKey = itemId + "_" + ((BgElementInfo)elementVec.get(k)).getId().toString() + "_" + (String)bgSchemeIter.next();
                                    twoTotalKey = (String)this.accumPeriodIdList.get(i) + "_" + partKey + "_" + twoColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                    if (index == 0) {
                                        oneTotalKey = (String)this.accumPeriodIdList.get(index) + "_" + partKey + "_" + oneColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                        valueMap.put(twoTotalKey, valueMap.get(oneTotalKey));
                                        continue;
                                    }
                                    oneTotalKey = (String)this.accumPeriodIdList.get(i) + "_" + partKey + "_" + oneColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                    objVal = valueMap.get(oneTotalKey);
                                    oneTotalKey = (String)this.accumPeriodIdList.get(index - 1) + "_" + partKey + "_" + twoColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                    valueMap.put(twoTotalKey, this.sumTwoObject(objVal, valueMap.get(oneTotalKey)));
                                }
                            }
                        }
                    }
                }
            }
        }
        this.bgBaseMap.put("dataCombIdSet", VdataCombId);
        return valueMap;
    }

    private Map getAllDataMap(BgCompareOneFilterParam filterParam) throws Exception {
        IBgRptFacade iBgRpt = BgRptFacadeFactory.getRemoteInstance();
        List dataList = iBgRpt.getBgData(filterParam);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        HashMap bgItemIdMap = new HashMap();
        Vector<String> VdataCombId = new Vector<String>();
        if (dataList != null && dataList.size() > 0) {
            String key = null;
            int ct = dataList.size();
            for (int i = 0; i < ct; ++i) {
                BgRptDataInfo bgRptData = (BgRptDataInfo)dataList.get(i);
                key = bgRptData.getBgPeriodId() + "_" + bgRptData.getBgCombinId() + "_" + bgRptData.getBgElementId() + "_" + "CurrentPeriodAnaly" + "_" + bgRptData.getBgOrgUnitId();
                BigDecimal[] valArray = new BigDecimal[4];
                valArray[0] = bgRptData.getBgValue();
                valArray[1] = bgRptData.getBizActual();
                if (!valueMap.containsKey(key)) {
                    valArray[2] = this.getBgBalance(bgRptData.getBgValue(), bgRptData.getBizActual());
                } else {
                    BigDecimal[] valArray_ = (BigDecimal[])valueMap.get(key);
                    valArray[0] = valArray[0].add(valArray_[0]);
                    valArray[1] = valArray[1].add(valArray_[1]);
                    valArray[2] = this.getBgBalance(valArray[0], valArray[1]);
                }
                valArray[3] = this.getBgDiffRate(valArray[2], valArray[0]);
                valueMap.put(key, valArray);
                if (bgItemIdMap.containsKey(bgRptData.getBgCombinId())) continue;
                bgItemIdMap.put(bgRptData.getBgCombinId(), null);
                VdataCombId.add(bgRptData.getBgCombinId());
            }
            boolean isAccumAnaly = this.isExistAccumAnaly(filterParam.getBgSchemeId(), filterParam.getBeginPeriodId(), filterParam.getEndPeriodId());
            if (isAccumAnaly) {
                Map itemMap = (Map)this.bgBaseMap.get("BGITEMCOMBINE");
                Vector elementVec = (Vector)this.bgBaseMap.get("BGELEMENT");
                String oneTotalKey = null;
                String twoTotalKey = null;
                Object objVal = null;
                String oneColKey = "CurrentPeriodAnaly";
                String twoColKey = "AccumAnaly";
                int index = 0;
                for (int i = 0; i < this.accumPeriodIdList.size(); ++i) {
                    index = i;
                    for (int j = 0; j < filterParam.getAttainOrgUnitIds().length; ++j) {
                        for (int k = 0; k < elementVec.size(); ++k) {
                            Iterator iter = itemMap.keySet().iterator();
                            while (iter.hasNext()) {
                                String partKey = (String)iter.next() + "_" + ((BgElementInfo)elementVec.get(k)).getId().toString();
                                twoTotalKey = (String)this.accumPeriodIdList.get(i) + "_" + partKey + "_" + twoColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                if (index == 0) {
                                    oneTotalKey = (String)this.accumPeriodIdList.get(index) + "_" + partKey + "_" + oneColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                    valueMap.put(twoTotalKey, valueMap.get(oneTotalKey));
                                    continue;
                                }
                                oneTotalKey = (String)this.accumPeriodIdList.get(i) + "_" + partKey + "_" + oneColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                objVal = valueMap.get(oneTotalKey);
                                oneTotalKey = (String)this.accumPeriodIdList.get(index - 1) + "_" + partKey + "_" + twoColKey + "_" + filterParam.getAttainOrgUnitIds()[j];
                                valueMap.put(twoTotalKey, this.getAddedBigArray(objVal, valueMap.get(oneTotalKey)));
                            }
                        }
                    }
                }
            }
        }
        this.bgBaseMap.put("dataCombIdSet", VdataCombId);
        return valueMap;
    }

    private Set getCombineSet() {
        HashSet<String> combineSet = new HashSet<String>();
        String keyStr = null;
        Map itemMap = (Map)this.bgBaseMap.get("BGITEMCOMBINE");
        Vector elementVec = (Vector)this.bgBaseMap.get("BGELEMENT");
        for (int i = 0; i < this.periodVec.size(); ++i) {
            for (int j = 0; j < elementVec.size(); ++j) {
                Iterator iter = itemMap.keySet().iterator();
                while (iter.hasNext()) {
                    keyStr = null;
                    keyStr = ((BgPeriodInfo)this.periodVec.get(i)).getId().toString() + "_" + (String)iter.next() + "_" + ((BgElementInfo)elementVec.get(j)).getId().toString();
                    combineSet.add(keyStr + "_" + "CurrentPeriodAnaly");
                    combineSet.add(keyStr + "_" + "AccumAnaly");
                }
            }
        }
        return combineSet;
    }

    private Object getAddedBigArray(Object oneBigArray, Object twoBigArray) {
        if (oneBigArray == null && twoBigArray != null) {
            return twoBigArray;
        }
        if (oneBigArray != null && twoBigArray == null) {
            return oneBigArray;
        }
        if (oneBigArray != null && twoBigArray != null) {
            BigDecimal[] oneBigVal = (BigDecimal[])oneBigArray;
            BigDecimal[] twoBigVal = (BigDecimal[])twoBigArray;
            BigDecimal[] retBigArray = new BigDecimal[4];
            for (int i = 0; i < 4; ++i) {
                if (i == 3) {
                    retBigArray[3] = this.getBgDiffRate(retBigArray[2], retBigArray[0]);
                    continue;
                }
                retBigArray[i] = this.sumTwoBigDecimal(oneBigVal[i], twoBigVal[i]);
            }
            return retBigArray;
        }
        return null;
    }

    private void initTableHead_bak(boolean isSum) {
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        for (int i = 0; i < 3; ++i) {
            this.tblMain.addHeadRow();
        }
        int mergeIndex = this.tblMain.getColumnCount();
        Vector<String> dimColumnVec = new Vector<String>();
        if (isSum) {
            dimColumnVec.add("BgOrgUnit");
        }
        dimColumnVec.add("BgPeriod");
        dimColumnVec.add("BgItem");
        for (int i = 0; i < dimColumnVec.size(); ++i) {
            IColumn col = this.tblMain.addColumn();
            col.setKey((String)dimColumnVec.get(i));
            col.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(i).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)dimColumnVec.get(i))));
            this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 2, this.tblMain.getColumnCount() - 1);
            mergeIndex = this.tblMain.getColumnCount();
        }
        Vector<String> analyVec = new Vector<String>();
        analyVec.add("CurrentPeriodAnaly");
        analyVec.add("AccumAnaly");
        Vector<String> elementVec = new Vector<String>();
        elementVec.add("BgValue");
        Vector<String> columnVec = null;
        Vector<String> columnOneVec = new Vector<String>();
        columnOneVec.add("CurrentPeriodBg");
        columnOneVec.add("CurrentPeriodActual");
        columnOneVec.add("DiffValue");
        columnOneVec.add("DiffRate");
        Vector<String> columnTwoVec = new Vector<String>();
        columnTwoVec.add("AccumBg");
        columnTwoVec.add("AccumActual");
        columnTwoVec.add("DiffAmount");
        columnTwoVec.add("AccumDiffRate");
        int mergeOneIndex = this.tblMain.getColumnCount();
        int mergeTwoIndex = this.tblMain.getColumnCount();
        int mergeThreeIndex = this.tblMain.getColumnCount();
        for (int i = 0; i < analyVec.size(); ++i) {
            mergeOneIndex = this.tblMain.getColumnCount();
            if (analyVec.get(i).equals("CurrentPeriodAnaly")) {
                columnVec = columnOneVec;
            } else if (analyVec.get(i).equals("AccumAnaly")) {
                columnVec = columnTwoVec;
            }
            for (int j = 0; j < elementVec.size(); ++j) {
                mergeTwoIndex = this.tblMain.getColumnCount();
                if (columnVec != null) {
                    for (int k = 0; k < columnVec.size(); ++k) {
                        mergeThreeIndex = this.tblMain.getColumnCount();
                        IColumn newColumn = this.tblMain.addColumn();
                        newColumn.setKey((String)analyVec.get(i) + "_" + (String)elementVec.get(j));
                        newColumn.setUserObject((Object)((String)columnVec.get(k)));
                        this.tblMain.getHeadRow(0).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)analyVec.get(i))));
                        this.tblMain.getHeadRow(1).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)elementVec.get(j))));
                        this.tblMain.getHeadRow(2).getCell(newColumn.getColumnIndex()).setValue((Object)EASResource.getString((String)this.resourcePath, (String)((String)columnVec.get(k))));
                    }
                }
                this.tblMain.getHeadMergeManager().mergeBlock(1, mergeTwoIndex, 1, this.tblMain.getColumnCount() - 1);
            }
            this.tblMain.getHeadMergeManager().mergeBlock(0, mergeOneIndex, 0, this.tblMain.getColumnCount() - 1);
        }
    }

    @Override
    protected void paneMain_stateChanged(ChangeEvent e) throws Exception {
        super.paneMain_stateChanged(e);
        if (this.isLoaded && this.isRemoved) {
            int index = this.paneMain.getSelectedIndex();
            this.showTable(index);
            if (this.filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
                this.initTableHead(this.isSumDisp);
                this.initTable(this.filterParam);
                this.fillData2Table(this.filterParam.getOrgUnitIds()[index]);
            } else if (this.filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
                this.initTableHeadForMultiAnaly(this.filterParam, this.isSumDisp);
                this.initTable(this.filterParam);
                this.fillData2TableForMultiAnaly(this.filterParam.getOrgUnitIds()[index]);
            }
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgClientHelper.exportTablesToExcel((Component)((Object)this), this.paneMain, false);
    }
}

