/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.eas.ma.budget.INewBgControlFacade;
import com.kingdee.eas.ma.budget.NewBgControlFacadeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BgControlUtil {
    public static Map getBgCtrlNeededFields(IObjectValue billInfo) throws BOSException, EASBizException {
        String boName = BgControlUtil.getBONameFromObjectValue(billInfo);
        return BgControlUtil.getBgCtrlNeededFields(boName);
    }

    public static Map getBgCtrlNeededFields(String boName) throws BOSException, EASBizException {
        if (boName == null || boName.length() == 0) {
            throw new IllegalArgumentException("the boName parameter is null!");
        }
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        INewBgControlFacade newBgCtrl = NewBgControlFacadeFactory.getRemoteInstance();
        BgControlRuleCollection ruleCol = newBgCtrl.getCtrlRuleColl(boName);
        if (ruleCol == null || ruleCol.size() == 0) {
            return fieldsMap;
        }
        Iterator iterator = ruleCol.iterator();
        while (iterator.hasNext()) {
            BgControlRuleInfo rule = (BgControlRuleInfo)iterator.next();
            String oqlItemCombination = rule.getOqlItemCombination();
            String aliasItemCombination = rule.getAliasItemCombination();
            String[] tempField = oqlItemCombination.split("\\@");
            String[] tempAlias = aliasItemCombination.split("\\@");
            for (int i = 0; i < tempField.length; ++i) {
                String[] _tempField = tempField[i].split("\\|");
                String[] _tempAlias = tempAlias[i].split("\\|");
                fieldsMap.put(_tempField[0], _tempAlias[0].split("\\.")[0]);
            }
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String aliasOrgUnit = rule.getAliasOrgUnit();
            fieldsMap.put(oqlOrgUnit.split("\\|")[0], aliasOrgUnit.split("\\|")[0]);
            String oqlCurrency = rule.getOqlCurrency();
            String aliasCurrency = rule.getAliasCurrency();
            fieldsMap.put(oqlCurrency, aliasCurrency);
            String oqlBizDate = rule.getOqlBizDate();
            String aliasBizDate = rule.getAliasBizDate();
            fieldsMap.put(oqlBizDate, aliasBizDate);
            String oqlRequest = rule.getOqlRequest();
            String aliasRequest = rule.getAliasRequest();
            fieldsMap.put(oqlRequest.split("\\|")[0], aliasRequest.split("\\|")[0]);
        }
        return fieldsMap;
    }

    public static boolean isBgCtrlNeededFields(IObjectValue billInfo, String fieldName) throws BOSException, EASBizException {
        String boName = BgControlUtil.getBONameFromObjectValue(billInfo);
        return BgControlUtil.isBgCtrlNeededFields(boName, fieldName);
    }

    public static boolean isBgCtrlNeededFields(String boName, String fieldName) throws EASBizException, BOSException {
        Map allNeededFields = BgControlUtil.getBgCtrlNeededFields(boName);
        if (allNeededFields == null || allNeededFields.isEmpty()) {
            return false;
        }
        return allNeededFields.containsKey(fieldName);
    }

    public static String checkBillInfo(IObjectValue billInfo) throws BOSException, EASBizException {
        BudgetCtrlCaller.checkBillInfo(null, billInfo);
        return null;
    }

    public static String getBONameFromObjectValue(IObjectValue info) throws BOSException {
        return MetaDataUtils.getBOFromCache(null, (BOSObjectType)info.getBOSType()).getFullName();
    }

    private static boolean isSpecificallyOrg(String boName, IObjectValue billInfo) throws BOSException, EASBizException {
        INewBgControlFacade newBgCtrl = NewBgControlFacadeFactory.getRemoteInstance();
        BgControlRuleCollection ruleCol = newBgCtrl.getCtrlRuleColl(boName);
        Iterator iterator = ruleCol.iterator();
        while (iterator.hasNext()) {
            BgControlRuleInfo rule = (BgControlRuleInfo)iterator.next();
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String[] oqlOrgTmp = oqlOrgUnit.split("\\|");
            if (oqlOrgTmp.length != 2) {
                return true;
            }
            String orgFiled = oqlOrgTmp[0];
            String[] SpecificallyOrgs = oqlOrgTmp[1].split("\\,");
            Vector fieldValues = BgControlUtil.getFieldValue(billInfo, orgFiled.split("\\."), true);
            for (int i = 0; i < SpecificallyOrgs.length; ++i) {
                String theSpecificallyOrg = SpecificallyOrgs[i];
                if (!theSpecificallyOrg.equals(fieldValues.get(0))) continue;
                return true;
            }
        }
        return false;
    }

    private static Vector getFieldValue(IObjectValue info, String[] orgUnitSubFields, boolean isFilterSame) {
        Vector vecOrgNumber = new Vector();
        ArrayList map = new ArrayList();
        BgControlUtil.subGetFieldValue(info, map, orgUnitSubFields, 0, isFilterSame);
        for (int i = 0; map != null && i < map.size(); ++i) {
            vecOrgNumber.add(map.get(i));
        }
        return vecOrgNumber;
    }

    private static void subGetFieldValue(IObjectValue info, List map, String[] tmp, int index, boolean isFilterSame) {
        if (BindingUtility.getBeanProperty((Object)info, (String)tmp[index]) != null) {
            if (BindingUtility.getBeanProperty((Object)info, (String)tmp[index]) instanceof IObjectCollection) {
                IObjectCollection coll = (IObjectCollection)BindingUtility.getBeanProperty((Object)info, (String)tmp[index]);
                for (int i = 0; i < coll.size(); ++i) {
                    IObjectValue tmpInfo = coll.getObject(i);
                    if (index + 1 < tmp.length) {
                        BgControlUtil.subGetFieldValue(tmpInfo, map, tmp, index + 1, isFilterSame);
                        continue;
                    }
                    if (isFilterSame) {
                        if (map.contains(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]))) continue;
                        map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                        continue;
                    }
                    map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                }
            } else if (BindingUtility.getBeanProperty((Object)info, (String)tmp[index]) instanceof IObjectValue) {
                IObjectValue tmpInfo = (IObjectValue)BindingUtility.getBeanProperty((Object)info, (String)tmp[index]);
                if (index + 1 < tmp.length) {
                    BgControlUtil.subGetFieldValue(tmpInfo, map, tmp, index + 1, isFilterSame);
                } else if (isFilterSame) {
                    if (!map.contains(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]))) {
                        map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                    }
                } else {
                    map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                }
            } else if (isFilterSame) {
                if (!map.contains(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]))) {
                    map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                }
            } else {
                map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
            }
        }
    }
}

