/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.ma.budget.AbstractBgCtrlBizBillInfo;
import com.kingdee.eas.ma.budget.BgCtrlBizBillCollection;
import com.kingdee.eas.ma.budget.BgCtrlBizBillFactory;
import com.kingdee.eas.ma.budget.BgCtrlBizBillInfo;
import com.kingdee.eas.ma.budget.BgCtrlBizParamEnum;
import com.kingdee.eas.ma.budget.BgCtrlBizParamFactory;
import com.kingdee.eas.ma.budget.client.AbstractBgCtrlBizParamListUI;
import com.kingdee.eas.ma.budget.client.BgCtrlBizParamUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class BgCtrlBizParamListUI
extends AbstractBgCtrlBizParamListUI {
    private static final long serialVersionUID = -4623940838676258289L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlBizParamListUI.class);
    private static final String RES = "com.kingdee.eas.ma.budget.BgCtrlBillParamResource";
    private static final String COL_BoName = "boName";
    private static final String COL_Value = "value";

    public void onLoad() throws Exception {
        super.onLoad();
        BgCtrlBizParamFactory.getRemoteInstance().initParam();
        this.initOrgType();
        this.initTree();
        this.initTable();
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift A"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                    UIContext uiContext = new UIContext((Object)this);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ma.nbudget.client.BgControlUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    private void initOrgType() {
        this.cbxOrgViewType.setEnabled(false);
        this.cbxOrgViewType.addItems(OrgViewType.getEnumList().toArray());
        this.cbxOrgViewType.setSelectedItem((Object)OrgViewType.COMPANY);
        NewOrgF7 f7 = new NewOrgF7((IUIObject)this);
        f7.setContainSealUp(false);
        f7.setIsCUFilter(false);
        f7.setRootUnitID(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        f7.setOrgViewTypes(new OrgViewType[]{OrgViewType.COMPANY});
        this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
        this.prmtOrgUnit.setDataNoNotify((Object)SysContext.getSysContext().getCurrentFIUnit());
    }

    private void initTable() {
        KDTMenuManager tm;
        if (this.tblMain != null && (tm = this.getMenuManager(this.tblMain)) != null && tm.getMenu() != null) {
            tm.getMenu().removeAll();
        }
    }

    protected void initTree() throws BOSException {
        MyTreeSelectModel selectModel = new MyTreeSelectModel();
        selectModel.setSelectionMode(1);
        this.treeBizSystem.setSelectionModel((TreeSelectionModel)selectModel);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)RES, (String)"bizSystem"));
        BgCtrlBizBillCollection col = BgCtrlBizBillFactory.getRemoteInstance().getBgCtrlBizBillCollection("select subSystemName, subSystemAlias, orgViewType where boName is null order by subSystemName");
        if (col != null && !col.isEmpty()) {
            HashMap<String, DefaultKingdeeTreeNode> nodes = new HashMap<String, DefaultKingdeeTreeNode>();
            for (int i = 0; i < col.size(); ++i) {
                BgCtrlBizBillInfo info = col.get(i);
                if (nodes.containsKey(info.getSubSystemName())) continue;
                DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)info);
                nodes.put(info.getSubSystemName(), child);
                child.setText(col.get(i).getSubSystemAlias());
                String parent = info.getSubSystemName().substring(0, info.getSubSystemName().lastIndexOf("."));
                if (nodes.containsKey(parent)) {
                    ((DefaultKingdeeTreeNode)nodes.get(parent)).add((MutableTreeNode)child);
                    continue;
                }
                root.add((MutableTreeNode)child);
            }
        }
        this.treeBizSystem.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.treeBizSystem.expandAllNodes(true, (TreeNode)root);
        if (col != null && !col.isEmpty()) {
            this.treeBizSystem.setSelectionRow(0);
        } else {
            this.treeBizSystem.setSelectionRow(0);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        DefaultKingdeeTreeNode node;
        viewInfo = new EntityViewInfo();
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(COL_BoName, null, CompareType.NOTEQUALS));
        AbstractBgCtrlBizBillInfo bill = null;
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
        OrgViewType orgType = (OrgViewType)this.cbxOrgViewType.getSelectedItem();
        if (this.treeBizSystem.getLastSelectedPathComponent() != null && (node = (DefaultKingdeeTreeNode)this.treeBizSystem.getLastSelectedPathComponent()).getUserObject() instanceof BgCtrlBizBillInfo) {
            bill = (BgCtrlBizBillInfo)node.getUserObject();
        }
        if (bill == null || orgUnit == null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
        } else {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("subSystemName", (Object)bill.getSubSystemName()));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void execQuery() {
        super.execQuery();
        this.selectFirstRow();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        IRow row;
        super.afterTableFillData(e);
        HashSet<String> boNames = new HashSet<String>();
        String orgUnitId = ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            row = this.tblMain.getRow(r);
            if (row == null) continue;
            boNames.add((String)row.getCell(COL_BoName).getValue());
        }
        if (boNames.isEmpty()) {
            return;
        }
        Map params = null;
        try {
            params = BgCtrlBizParamFactory.getRemoteInstance().getParam(orgUnitId, boNames);
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            row = this.tblMain.getRow(r);
            if (row == null) continue;
            String boName = (String)row.getCell(COL_BoName).getValue();
            int value = 0;
            if (params != null && params.containsKey(boName)) {
                value = (Integer)params.get(boName);
            }
            row.getCell(COL_Value).setValue((Object)BgCtrlBizParamEnum.getEnum(value));
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.execQuery();
    }

    @Override
    protected void treeBizSystem_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode node;
        super.treeBizSystem_valueChanged(e);
        DefaultKingdeeTreeNode defaultKingdeeTreeNode = node = e.getOldLeadSelectionPath() == null ? null : (DefaultKingdeeTreeNode)e.getOldLeadSelectionPath().getLastPathComponent();
        if (e.getOldLeadSelectionPath() == e.getNewLeadSelectionPath()) {
            return;
        }
        if (e.getOldLeadSelectionPath() == null || node == null || !(node.getUserObject() instanceof BgCtrlBizBillInfo)) {
            this.execQuery();
        } else {
            OrgViewType oldType;
            BgCtrlBizBillInfo info = (BgCtrlBizBillInfo)node.getUserObject();
            OrgViewType type = info.getOrgViewType();
            if (type != (oldType = (OrgViewType)this.cbxOrgViewType.getSelectedItem())) {
                OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
                OrgType orgType = NewOrgViewHelper.convert((OrgViewType)type);
                orgUnit = NewOrgViewHelper.getOrgUnitInfo(null, (String)orgUnit.getId().toString(), (OrgType)orgType);
                NewOrgF7 f7 = (NewOrgF7)this.prmtOrgUnit.getSelector();
                f7.setOrgTypes(new OrgType[]{orgType});
                if (orgUnit == null) {
                    this.prmtOrgUnit.setDataNoNotify((Object)SysContext.getSysContext().getCurrentOrgUnit(orgType));
                }
            }
            this.execQuery();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.showEditUI(e);
        uiWindow.show();
    }

    private IUIWindow showEditUI(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT, 64);
        return uiWindow;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)COL_BoName, (Object)ListUiHelper.getSelectedKeyValue((int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (KDTable)this.tblMain, (String)COL_BoName));
        uiContext.put((Object)"ORGUNIT_ID", (Object)((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString());
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCtrlBizBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgCtrlBizParamUI.class.getName();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private class MyTreeSelectModel
    extends DefaultTreeSelectionModel {
        private MyTreeSelectModel() {
        }

        @Override
        public void removeSelectionPaths(TreePath[] paths) {
        }
    }
}

