/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.budget.BgControlRuleSegmentInfo;
import com.kingdee.eas.ma.budget.BgFilterInfoProducer;
import com.kingdee.eas.ma.budget.client.AbstractBgCtrlParamSourceF7UI;
import com.kingdee.eas.ma.budget.client.BgBizItemF7Util;
import com.kingdee.eas.ma.budget.client.BgDefineCtrlFormulaDialog;
import com.kingdee.eas.ma.budget.client.BgMetaDataSelector;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCtrlParamSourceF7UI
extends AbstractBgCtrlParamSourceF7UI {
    public static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgCtrlRuleResource";
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlParamSourceF7UI.class);
    private boolean isCancel = true;
    private boolean isCanAddLine = false;
    private BgControlRuleSegmentInfo result = null;
    private String subSystem = null;
    private String billName = null;
    private String packageName = null;
    private String fromKey = null;
    private Set cuIDSet = null;
    private HashMap assActTypeGroupIdMap = new HashMap();
    private boolean isFilterOnCU = true;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.btnAddRow.setText("");
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteRow.setText("");
        this.btnDeleteRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.table.checkParsed();
        super.onLoad();
        this.cuIDSet = this.getUIContext().get("cuIDSet") == null ? null : (Set)this.getUIContext().get("cuIDSet");
        this.subSystem = this.getUIContext().get("subSystem") == null ? "" : this.getUIContext().get("subSystem").toString();
        this.billName = this.getUIContext().get("billName") == null ? "" : this.getUIContext().get("billName").toString();
        this.packageName = this.getUIContext().get("packageName") == null ? "" : this.getUIContext().get("packageName").toString();
        this.fromKey = this.getUIContext().get("fromKey") == null ? "" : this.getUIContext().get("fromKey").toString();
        this.assActTypeGroupIdMap = this.getUIContext().get("assActTypeGroupIdMap") == null ? new HashMap() : (HashMap)this.getUIContext().get("assActTypeGroupIdMap");
        this.isFilterOnCU = this.getUIContext().get("isFilterOnCU") == null ? true : (Boolean)this.getUIContext().get("isFilterOnCU");
        String title = EASResource.getString((String)RESOURCE, (String)this.fromKey);
        this.kDContainer1.setTitle(title);
        if (this.fromKey.equals("orgUnit") || this.fromKey.equals("bizProperty")) {
            this.btnAddRow.setEnabled(false);
            this.btnDeleteRow.setEnabled(false);
        } else {
            this.btnAddRow.setEnabled(true);
            this.btnDeleteRow.setEnabled(true);
        }
        this.table.getSelectManager().setSelectMode(10);
        this.putDataToKDTable();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            ICell cell = row.getCell("property");
            String property = "";
            if (cell.getValue() instanceof String) {
                property = cell.getUserObject().toString();
            } else if (cell.getValue() instanceof BgControlRuleSegmentInfo) {
                property = ((BgControlRuleSegmentInfo)cell.getValue()).getExpression();
            }
            if (this.fromKey == null || this.fromKey.trim().equals("bizProperty")) continue;
            String queryName = this.getQueryName(this.fromKey, this.subSystem, this.packageName, this.billName, property);
            if ("com.kingdee.eas.basedata.assistant.app.F7BankQuery".equals(queryName)) {
                queryName = "com.kingdee.eas.basedata.assistant.app.BankQuery";
            }
            if (queryName == null || queryName.trim().equals("")) continue;
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initOrgBox(property, queryName)));
        }
        this.colSetLocked();
        if (this.table.getRowCount() == 0) {
            this.table.addRow();
        }
    }

    private void colSetLocked() {
    }

    private KDBizPromptBox initOrgBox(String fieldName, String queryName) throws EASBizException, BOSException {
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setQueryInfo(queryName);
        prmtBox.setCommitFormat("$number$");
        prmtBox.setEditFormat("$number$");
        prmtBox.setDisplayFormat("$name$");
        prmtBox.setEnabledMultiSelection(true);
        if (!this.fromKey.equals("orgUnit")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            BgBizItemF7Util.getOrgViewInfo(view, queryName, fieldName);
            prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
            prmtBox.setEntityViewInfo(view);
        } else if ("com.kingdee.eas.basedata.org.app.AdminItemQuery".equals(queryName)) {
            boolean isAdmin = false;
            if (SysContext.getSysContext().getCurrentCostUnit() != null && SysContext.getSysContext().getCurrentCostUnit().isIsAdminOrgUnit()) {
                isAdmin = false;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (isAdmin) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysContext.getSysContext().getCurrentAdminUnit().getId()));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"###############"));
            }
            view.setFilter(filter);
            this.filterAsstActType(fieldName, queryName, view);
            prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
            prmtBox.setEntityViewInfo(view);
        }
        return prmtBox;
    }

    private void filterAsstActType(String property, String queryName, EntityViewInfo view) throws BOSException, EASBizException {
        if (queryName.equalsIgnoreCase("com.kingdee.eas.basedata.master.auxacct.app.F7GeneralAsstActTypeQuery")) {
            String[] tmps;
            if (this.assActTypeGroupIdMap == null || this.assActTypeGroupIdMap.isEmpty()) {
                this.assActTypeGroupIdMap = BgControlFacadeFactory.getRemoteInstance().getGeneralAssActTypeGroupIds();
            }
            if ((tmps = property.split("\\.")) != null && tmps.length == 5 && tmps[3] != null && tmps[3].startsWith("generalAssActType")) {
                String groupId = null;
                for (String key : this.assActTypeGroupIdMap.keySet()) {
                    if (!key.equalsIgnoreCase(tmps[3])) continue;
                    groupId = (String)this.assActTypeGroupIdMap.get(key);
                    break;
                }
                view.getFilter().getFilterItems().add(new FilterItemInfo("group.id", groupId));
            }
        }
    }

    private void putDataToKDTable() {
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        BgMetaDataSelector box = new BgMetaDataSelector((IUIObject)this);
        EntityObjectInfo entity = (EntityObjectInfo)this.getUIContext().get("entity");
        if (this.fromKey != null && this.fromKey.trim().equals("bizProperty")) {
            box.setEntityAndTargetProperty(entity, "java.lang.Number");
        } else {
            box.setEntityAndTargetProperty(entity, (String)null);
        }
        prmtBox.setSelector((KDPromptSelector)box);
        prmtBox.setEditable(false);
        this.table.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBox));
        if (this.fromKey != null && this.fromKey.trim().equals("bizProperty")) {
            this.table.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initBizBillEditor2((IUIObject)this)));
        }
        String oql = this.getUIContext().get("oql") == null ? "" : this.getUIContext().get("oql").toString();
        String alias = this.getUIContext().get("alias") == null ? "" : this.getUIContext().get("alias").toString();
        String[] aliasStrs = alias.split("@");
        String[] oqlStrs = oql.split("@");
        for (int i = 0; i < aliasStrs.length && !alias.equals(""); ++i) {
            IRow row = this.table.addRow();
            String[] aliasSubStrs = aliasStrs[i].split("\\|");
            String[] oqlSubStrs = oqlStrs[i].split("\\|");
            if (aliasSubStrs.length == 1) {
                row.getCell(0).setValue((Object)aliasSubStrs[0]);
                row.getCell(0).setUserObject((Object)oqlSubStrs[0]);
                continue;
            }
            if (aliasSubStrs.length != 2) continue;
            row.getCell(0).setValue((Object)aliasSubStrs[0]);
            row.getCell(1).setValue((Object)aliasSubStrs[1]);
            row.getCell(0).setUserObject((Object)oqlSubStrs[0]);
            row.getCell(1).setUserObject((Object)oqlSubStrs[1]);
        }
    }

    public BgControlRuleSegmentInfo getResult() {
        return this.result;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public boolean isCanAddLine() {
        return this.isCanAddLine;
    }

    public void setCanAddLine(boolean isCanAddLine) {
        this.isCanAddLine = isCanAddLine;
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddRow_actionPerformed(e);
        this.table.addRow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        if (this.table.getRowCount() > 1) {
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            this.table.removeRow(rowIndex);
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.check();
        String oqlTmp = "";
        String aliasTmp = "";
        String extendExpress = "";
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String subOql;
            BgControlRuleSegmentInfo subRule;
            String subOql2;
            String subAlias;
            ICell cell1 = this.table.getRow(i).getCell(0);
            ICell cell2 = this.table.getRow(i).getCell(1);
            if (i == 0) {
                if (cell1.getValue() instanceof String) {
                    subAlias = (String)cell1.getValue();
                    subOql2 = (String)cell1.getUserObject();
                    aliasTmp = aliasTmp + subAlias;
                    oqlTmp = oqlTmp + subOql2;
                } else if (cell1.getValue() instanceof BgControlRuleSegmentInfo) {
                    subRule = (BgControlRuleSegmentInfo)cell1.getValue();
                    String subAlias2 = subRule.getAlias();
                    subOql = subRule.getExpression();
                    aliasTmp = aliasTmp + subAlias2;
                    oqlTmp = oqlTmp + subOql;
                }
            } else if (cell1.getValue() instanceof String) {
                subAlias = (String)cell1.getValue();
                String subOql3 = (String)cell1.getUserObject();
                aliasTmp = aliasTmp + "@" + subAlias;
                oqlTmp = oqlTmp + "@" + subOql3;
            } else if (cell1.getValue() instanceof BgControlRuleSegmentInfo) {
                subRule = (BgControlRuleSegmentInfo)cell1.getValue();
                String subAlias3 = subRule.getAlias();
                subOql = subRule.getExpression();
                aliasTmp = aliasTmp + "@" + subAlias3;
                oqlTmp = oqlTmp + "@" + subOql;
            }
            if (cell2.getValue() instanceof String) {
                subAlias = (String)cell2.getValue();
                subOql2 = (String)cell2.getUserObject();
                if (subAlias != null && !subAlias.equals("")) {
                    aliasTmp = aliasTmp + "|" + subAlias;
                }
                if (subOql2 != null && !subOql2.equals("")) {
                    oqlTmp = oqlTmp + "|" + subOql2;
                    continue;
                }
                oqlTmp = aliasTmp + "|" + subAlias;
                continue;
            }
            if (cell2.getValue() instanceof Object[]) {
                Object[] subColl = (Object[])cell2.getValue();
                for (int j = 0; j < subColl.length; ++j) {
                    String subAlias4 = ((IObjectValue)subColl[j]).get("name").toString().trim();
                    String subOql4 = ((IObjectValue)subColl[j]).get("number").toString().trim();
                    if (j == 0) {
                        if (subAlias4 != null && !subAlias4.equals("")) {
                            aliasTmp = aliasTmp + "|" + subAlias4;
                        }
                        if (subOql4 == null || subOql4.equals("")) continue;
                        oqlTmp = oqlTmp + "|" + subOql4;
                        continue;
                    }
                    if (subAlias4 != null && !subAlias4.equals("")) {
                        aliasTmp = aliasTmp + "," + subAlias4;
                    }
                    if (subOql4 == null || subOql4.equals("")) continue;
                    oqlTmp = oqlTmp + "," + subOql4;
                }
                continue;
            }
            if (!(cell2.getValue() instanceof BgControlRuleSegmentInfo)) continue;
            BgControlRuleSegmentInfo ruleSegment = (BgControlRuleSegmentInfo)cell2.getValue();
            String subAlias5 = ruleSegment.getAlias() == null ? "" : ruleSegment.getAlias().trim();
            String string = subOql = ruleSegment.getExpression() == null ? "" : ruleSegment.getExpression().trim();
            if (subAlias5 != null && !subAlias5.equals("")) {
                aliasTmp = aliasTmp + "|" + subAlias5;
            }
            if (subOql != null && !subOql.equals("")) {
                oqlTmp = oqlTmp + "|" + subOql;
            }
            if (ruleSegment.getExtendExpression() == null || ruleSegment.getExtendExpression().trim().equals("")) continue;
            extendExpress = ruleSegment.getExtendExpression().trim();
        }
        this.result = new BgControlRuleSegmentInfo();
        this.result.setAlias(aliasTmp);
        this.result.setExpression(oqlTmp);
        this.result.setExtendExpression(extendExpress);
        this.setCancel(false);
        this.getUIWindow().close();
    }

    private void check() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getCell(i, 0).getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputFullDetail"));
            SysUtil.abort();
        }
    }

    @Override
    protected void table_editStarting(KDTEditEvent e) throws Exception {
        super.table_editStarting(e);
    }

    @Override
    protected void table_editStopped(KDTEditEvent e) throws Exception {
        super.table_editStopped(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.table.getColumnKey(colIndex).equals("property")) {
            ICell cell = this.table.getRow(rowIndex).getCell(colIndex);
            if (cell.getValue() == null) {
                this.table.getRow(rowIndex).getCell("propertyValue").getStyleAttributes().setLocked(true);
            } else {
                this.table.getRow(rowIndex).getCell("propertyValue").getStyleAttributes().setLocked(false);
            }
            String property = "";
            if (cell.getValue() instanceof String) {
                property = cell.getUserObject().toString();
            } else if (cell.getValue() instanceof BgControlRuleSegmentInfo) {
                property = ((BgControlRuleSegmentInfo)cell.getValue()).getExpression();
            }
            if (this.fromKey != null && this.fromKey.trim().equals("bizProperty")) {
                this.table.getRow(rowIndex).getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initBizBillEditor2((IUIObject)this)));
            } else {
                String queryName = this.getQueryName(this.fromKey, this.subSystem, this.packageName, this.billName, property);
                if (queryName != null && !queryName.trim().equals("")) {
                    this.table.getRow(rowIndex).getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initOrgBox(property, queryName)));
                } else {
                    this.table.getRow(rowIndex).getCell("propertyValue").setEditor(null);
                }
            }
        } else if (this.table.getColumnKey(colIndex).equals("propertyValue")) {
            ICell cell = this.table.getRow(rowIndex).getCell(colIndex);
            Object obj = cell.getValue();
            if (obj instanceof Object[]) {
                Object[] temp = (Object[])obj;
                String strName = "";
                String strNumber = "";
                for (int i = 0; i < temp.length; ++i) {
                    strName = strName + (((IObjectValue)temp[i]).get("name") == null ? (((IObjectValue)temp[i]).get("number") == null ? "" : ((IObjectValue)temp[i]).get("number").toString().trim()) : ((IObjectValue)temp[i]).get("name").toString().trim()) + ",";
                    strNumber = strNumber + ((IObjectValue)temp[i]).get("number").toString().trim() + ",";
                }
                strName = strName.substring(0, strName.length() - 1);
                strNumber = strNumber.substring(0, strNumber.length() - 1);
                cell.setValue((Object)strName);
                cell.setUserObject((Object)strNumber);
            } else if (obj instanceof IObjectCollection) {
                IObjectCollection temp = (IObjectCollection)obj;
                String str = "";
                for (int i = 0; i < temp.size(); ++i) {
                    str = str + temp.getObject(i).get("name") + ",";
                }
                str = str.substring(0, str.length() - 1);
                cell.setValue((Object)str);
            }
        }
    }

    private String getQueryName(String fromKey, String subSystem, String packageName, String billName, String property) {
        String result = "";
        EntityObjectInfo entity = MetaDataLoader.getEntity(null, (IMetaDataPK)new MetaDataPK(packageName + "." + billName));
        if (entity == null) {
            result = "";
        }
        String[] strs = property.split("\\.");
        for (int i = 0; i < strs.length; ++i) {
            PropertyInfo prop = entity.getPropertyByName(strs[i]);
            if (prop instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkPro = (LinkPropertyInfo)prop;
                entity = linkPro.getRelationship().getSupplierObject();
            } else {
                result = entity.getExtendedProperty("defaultF7Query");
            }
            if (i != strs.length - 1) continue;
            result = entity.getExtendedProperty("defaultF7Query");
        }
        if (result == null || result.equals("")) {
            if (fromKey.equals("orgUnit")) {
                return "com.kingdee.eas.basedata.org.app.FullOrgUnitQuery";
            }
            if (subSystem.equalsIgnoreCase("com.kingdee.eas.cp.bc")) {
                return "com.kingdee.eas.cp.bc.app.ExpenseTypeQuery";
            }
            if (subSystem.equalsIgnoreCase("com.kingdee.eas.fi.gl") && billName.equalsIgnoreCase("Voucher")) {
                if (property.equalsIgnoreCase("entries.account.number")) {
                    return "com.kingdee.eas.basedata.master.account.app.AccountViewQuery";
                }
                if (property.equalsIgnoreCase("entries.assistRecords.assGrp.customer.number")) {
                    return "com.kingdee.eas.basedata.master.cssp.app.F7CustomerWithDefaultStandardQuery";
                }
            }
            return "";
        }
        return result;
    }

    private KDPromptBox initBizBillEditor2(IUIObject owner) {
        BgDefineCtrlFormulaDialog box = new BgDefineCtrlFormulaDialog(owner);
        KDPromptBox bizPromptBoxEditor = new KDPromptBox();
        bizPromptBoxEditor.setSelector((KDPromptSelector)box);
        bizPromptBoxEditor.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                EntityObjectInfo entity = MetaDataLoader.getEntity(null, (IMetaDataPK)new MetaDataPK(BgCtrlParamSourceF7UI.this.packageName + "." + BgCtrlParamSourceF7UI.this.billName));
                if (entity != null) {
                    KDPromptBox cellEditor = (KDPromptBox)e.getSource();
                    ((BgDefineCtrlFormulaDialog)cellEditor.getSelector()).setEntity(entity);
                    ((BgDefineCtrlFormulaDialog)cellEditor.getSelector()).setDestClazz(null);
                    ICell cell = BgCtrlParamSourceF7UI.this.table.getCell(BgCtrlParamSourceF7UI.this.table.getEditManager().getEditRowIndex(), BgCtrlParamSourceF7UI.this.table.getEditManager().getEditColIndex());
                    if (cell != null && cell.getValue() != null) {
                        if (cell.getValue() instanceof String && !cell.getValue().toString().trim().equals("") && cell.getUserObject() != null && cell.getUserObject() instanceof String && !cell.getUserObject().toString().trim().equals("")) {
                            BgControlRuleSegmentInfo ruleSegmentInfo = new BgControlRuleSegmentInfo();
                            ruleSegmentInfo.setAlias(cell.getValue().toString().trim());
                            ruleSegmentInfo.setExpression(cell.getUserObject().toString().trim());
                            ruleSegmentInfo.setExtendExpression(BgCtrlParamSourceF7UI.this.getUIContext().get("extendExpression") == null ? "" : (String)BgCtrlParamSourceF7UI.this.getUIContext().get("extendExpression"));
                            ((BgDefineCtrlFormulaDialog)cellEditor.getSelector()).setRuleSegmentInfo(ruleSegmentInfo);
                        } else if (cell.getValue() instanceof BgControlRuleSegmentInfo) {
                            BgControlRuleSegmentInfo ruleSegmentInfo = (BgControlRuleSegmentInfo)cell.getValue();
                            ((BgDefineCtrlFormulaDialog)cellEditor.getSelector()).setRuleSegmentInfo(ruleSegmentInfo);
                        }
                    }
                }
            }
        });
        bizPromptBoxEditor.setEditable(false);
        return bizPromptBoxEditor;
    }

    public Set getCuIDSet() {
        return this.cuIDSet;
    }

    public void setCuIDSet(Set cuIDSet) {
        this.cuIDSet = cuIDSet;
    }
}

