/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.client.AbstractBgCurrencyF7UI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgCurrencyF7UI
extends AbstractBgCurrencyF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgCurrencyF7UI.class);
    private boolean isCancel = true;
    private boolean isMultiSelect = true;
    private CurrencyInfo result = null;
    private CurrencyCollection resultColl = new CurrencyCollection();

    public void onLoad() throws Exception {
        super.onLoad();
        this.table.checkParsed();
        if (this.isMultiSelect) {
            this.table.getSelectManager().setSelectMode(10);
        } else {
            this.table.getSelectManager().setSelectMode(2);
        }
        this.putDataToKDTable();
    }

    private void putDataToKDTable() {
        ICurrency ic = null;
        CurrencyCollection coll = null;
        try {
            ic = CurrencyFactory.getRemoteInstance();
            coll = ic.getCurrencyCollection(true);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (coll == null || coll.size() == 0) {
            return;
        }
        this.table.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            CurrencyInfo info = coll.get(i);
            IRow iRow = this.table.addRow();
            iRow.setUserObject((Object)info);
            iRow.getCell("id").setValue((Object)info.getId().toString());
            iRow.getCell("number").setValue((Object)info.getNumber());
            iRow.getCell("name").setValue((Object)info.getName());
            iRow.getCell("precision").setValue((Object)new Integer(info.getPrecision()));
            iRow.getCell("sign").setValue((Object)info.getSign());
        }
    }

    @Override
    protected void table_tableClicked(KDTMouseEvent e) throws Exception {
        super.table_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    private void onBtnConfirm() {
        if (this.isMultiSelect) {
            KDTRange range = this.table.getSelectManager().toRange();
            for (int i = 0; i < range.size(); ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                    CurrencyInfo item = (CurrencyInfo)this.table.getRow(j).getUserObject();
                    this.resultColl.add(item);
                }
            }
        } else {
            KDTSelectBlock selectBlock = this.table.getSelectManager().get();
            if (selectBlock == null) {
                return;
            }
            int currRow = this.table.getSelectManager().getActiveRowIndex();
            IRow iRow = this.table.getRow(currRow);
            this.result = (CurrencyInfo)iRow.getUserObject();
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.isMultiSelect) {
            KDTRange range = this.table.getSelectManager().toRange();
            for (int i = 0; i < range.size(); ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                    CurrencyInfo item = (CurrencyInfo)this.table.getRow(j).getUserObject();
                    this.resultColl.add(item);
                }
            }
        } else {
            int currRow = this.table.getSelectManager().getActiveRowIndex();
            if (currRow != -1) {
                IRow iRow = this.table.getRow(currRow);
                this.result = (CurrencyInfo)iRow.getUserObject();
            }
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public CurrencyInfo getResult() {
        return this.result;
    }

    public void setResult(CurrencyInfo result) {
        this.result = result;
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
    }

    public CurrencyCollection getResultColl() {
        return this.resultColl;
    }

    public void setResultColl(CurrencyCollection resultColl) {
        this.resultColl = resultColl;
    }
}

