/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgDecException;
import com.kingdee.eas.ma.budget.BgDecomposerFormFactory;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgDecomposerForm;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.RefBgDecFormCollection;
import com.kingdee.eas.ma.budget.RefBgDecFormFactory;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgDecomposerFormAddNewUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.ProgressDialogUI;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgDecomposerFormAddNewUI
extends AbstractBgDecomposerFormAddNewUI
implements AssignSolutionInterface {
    private static final long serialVersionUID = -768973810872255921L;
    private static final Logger logger = CoreUIObject.getLogger(BgDecomposerFormAddNewUI.class);
    protected boolean isCancel = true;
    protected Map orgUnitMap = new HashMap();
    protected Map orgIdsMap = new HashMap();
    protected Vector orgUnits = null;
    private boolean isSubmit = true;
    private Map returnData = null;
    private String errorStr = "";
    private BgFormInfo bgFormInfo = null;
    private boolean isOK = true;
    private TreeWillExpandListener listener = new TreeWillExpandListener(){

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
            try {
                OrgUnitUtils.addChildNode(node, BgDecomposerFormAddNewUI.this.orgUnitMap.keySet(), true);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((String)"", (Throwable)ex);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        }
    };

    protected IObjectValue createNewData() {
        BgDecomposerFormInfo bgDecFormInfo = new BgDecomposerFormInfo();
        bgDecFormInfo.setState(BgDecomposerStateEnum.DECOMPOSER);
        bgDecFormInfo.setOrgUnit(this.getCurrentFullOrgUnitInfoUsedInBg());
        return bgDecFormInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDecomposerFormFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        String rootUnitID = this.getCurrentCostCenterOrgUnitInfo().getId().toString();
        TreeModel treeModel = OrgUnitUtils.getOrgTreeModel(this.tblTree, rootUnitID, this.listener);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        root.setChecked(true);
        root.setCheckBoxEnabled(false);
        this.tblTree.setModel(treeModel);
        this.tblTree.setShowCheckBox(true);
        if (treeModel != null && this.tblTree.getRowCount() > 0) {
            this.tblTree.expandRow(0);
        }
        super.onLoad();
        this.initSystem();
        this.initBgSchema();
        if (this.getOprtState() == OprtState.VIEW) {
            this.actionConfirm.setEnabled(false);
        } else {
            this.actionConfirm.setEnabled(true);
        }
        this.prmtBgForm.setEditable(false);
    }

    private void initSystem() throws Exception {
        this.prmtBgForm.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgDecomposerFormAddNewUI.this.checkDataValid(eventObj.getNewValue(), eventObj.getOldValue());
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuBar.setVisible(false);
        this.toolBar.setVisible(false);
        this.statusBar.setVisible(false);
        this.actionQuit.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnCleanAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnCleanAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void initBgSchema() throws Exception {
        FullOrgUnitInfo ouInfo = this.getCurrentFullOrgUnitInfoUsedInBg();
        if (ouInfo == null) {
            throw new BgCollectException(BgCollectException.CURRENTHASNOCOSTCENTER);
        }
        IBgScheme bgSchema = BgSchemeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)ouInfo.getId().toString()));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFiling ", (Object)1, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(ouInfo.getId().toString());
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgSet, (FilterInfo)filter);
        }
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        BgSchemeCollection bgSchemeCols = null;
        bgSchemeCols = bgSchema.getBgSchemeCollection(view);
        if (bgSchemeCols == null || bgSchemeCols.isEmpty()) {
            EntityViewInfo viewForm = new EntityViewInfo();
            FilterInfo filterForm = new FilterInfo();
            filterForm.getFilterItems().add(new FilterItemInfo("id", (Object)"0000000000000000000000000000"));
            viewForm.setFilter(filterForm);
            this.prmtBgForm.setEntityViewInfo(viewForm);
            return;
        }
        String[] num = new String[]{"number"};
        BgHelper.sortCollection(bgSchemeCols, num);
        this.comBgScheme.addItems(bgSchemeCols.toArray());
    }

    protected void initCostCenter(BOSUuid bgFormId) throws Exception {
        HashMap getCollectInfo = null;
        try {
            getCollectInfo = this.getFormInterface().getFormDecomposerInfo(bgFormId, 1);
            if (getCollectInfo != null && !getCollectInfo.isEmpty()) {
                Object id = null;
                String orgUnitId2 = null;
                this.orgUnitMap.clear();
                for (String orgUnitId2 : getCollectInfo.keySet()) {
                    this.orgUnitMap.put(orgUnitId2, null);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected void traceNode(DefaultKingdeeTreeNode root, Map orgUnitMap) {
        if (root == null || orgUnitMap == null || orgUnitMap.isEmpty()) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!(node.getUserObject() instanceof OrgStructureInfo)) continue;
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (node.isCheckBoxVisible() && node.isCheckBoxEnabled()) {
                if (orgUnitMap.containsKey(orgUnitInfo.getId().toString())) {
                    node.setChecked(true);
                } else {
                    node.setChecked(false);
                }
            }
            this.traceNode(node, orgUnitMap);
        }
    }

    protected void traceNode(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            node.setChecked(false);
            this.traceNode(node);
        }
    }

    protected void checkTraceNode(KDTree orgTree) throws Exception {
        if (orgTree == null) {
            return;
        }
        this.checkTraceNode((DefaultKingdeeTreeNode)orgTree.getModel().getRoot());
    }

    protected void checkTraceNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        OrgStructureInfo posi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo pOrgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                if (node.isChecked()) {
                    EASBizException e;
                    if (!root.isChecked()) {
                        posi = (OrgStructureInfo)root.getUserObject();
                        pOrgUnitInfo = posi.getUnit();
                        e = new BgCollectException(BgCollectException.NOSELECTPARENTNODE, new String[]{orgUnitInfo.getName(), pOrgUnitInfo.getName()});
                        this.handleException((Exception)((Object)e));
                        SysUtil.abort();
                    }
                    if (!this.orgUnitMap.containsKey(orgUnitInfo.getId().toString())) {
                        e = new BgDecException(BgDecException.ERRORORG, new String[]{orgUnitInfo.getName()});
                        this.handleException((Exception)((Object)e));
                        SysUtil.abort();
                    }
                    this.orgIdsMap.put(orgUnitInfo.getId().toString(), orgUnitInfo.getName());
                } else {
                    this.orgIdsMap.remove(orgUnitInfo.getId().toString());
                }
            }
            this.checkTraceNode(node);
        }
    }

    protected List<String> traceNode(KDTree orgTree) {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (orgTree == null) {
            return orgUnitIds;
        }
        orgUnitIds.addAll(this.orgUnitMap.keySet());
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
        this.traceNode(root, orgUnitIds);
        return orgUnitIds;
    }

    protected void traceNode(DefaultKingdeeTreeNode root, List<String> orgUnitList) {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                orgUnitList.add(orgUnitInfo.getId().toString());
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                orgUnitList.remove(orgUnitInfo.getId().toString());
            }
            this.traceNode(node, orgUnitList);
        }
    }

    @Override
    protected void prmtBgForm_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgForm_dataChanged(e);
        if (this.prmtBgForm.getData() != null) {
            BgFormInfo bgFormInfo = (BgFormInfo)this.prmtBgForm.getData();
            this.initCostCenter(bgFormInfo.getId());
            this.traceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), this.orgUnitMap);
            this.tblTree.repaint();
        }
    }

    protected void checkDataValid(Object newValue, Object oldValue) {
        if (newValue != null) {
            BgFormInfo bgFormInfo = (BgFormInfo)newValue;
            if (oldValue != null && bgFormInfo.getId().equals((Object)((BgFormInfo)oldValue).getId())) {
                return;
            }
            try {
                IBgDecomposerForm bgDecImpl = BgDecomposerFormFactory.getRemoteInstance();
                boolean hasBgDataFormula = bgDecImpl.hasBgDataFomular(bgFormInfo.getId());
                if (!hasBgDataFormula) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGFORMSPECIFIEDHASNOBGFORMULA"));
                    this.prmtBgForm.setData(oldValue);
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void loadCostCenterStatus() {
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.editData != null && this.editData.getRefBgDecForms() != null) {
            RefBgDecFormCollection children = this.editData.getRefBgDecForms();
            HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                orgUnitMap.put(children.get(i).getBgForm().getOrgUnit().getId().toString(), null);
            }
            this.traceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), orgUnitMap);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getBgForm() != null) {
            BgSchemeInfo bgSchemaInfo = this.editData.getBgForm().getBgScheme();
            BgFormHelper.setSelectObject(this.comBgScheme, bgSchemaInfo);
            this.prmtBgForm.setData((Object)this.editData.getBgForm());
            this.loadCostCenterStatus();
        }
    }

    protected void beforeStoreFields(ActionEvent ex) {
        try {
            super.beforeStoreFields(ex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.editData.setBgForm((BgFormInfo)this.prmtBgForm.getData());
            if (this.editData.getBgForm() == null) {
                BgCollectException e = new BgCollectException(BgCollectException.HASNOBGFORMINBGCOLLECTFORM);
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            if (this.prmtBgForm.getData() != null) {
                BgFormInfo bgFormInfo = (BgFormInfo)this.prmtBgForm.getData();
                this.initCostCenter(bgFormInfo.getId());
            }
            this.checkTraceNode(this.tblTree);
            this.editData.getRefBgDecForms().clear();
            List<String> ouIdList = this.traceNode(this.tblTree);
            RefBgDecFormCollection refBgDecFormCols = RefBgDecFormFactory.getRemoteInstance().loadRefBgFormDecByBgForm(this.editData.getBgForm(), ouIdList);
            if (refBgDecFormCols != null) {
                int count = refBgDecFormCols.size();
                for (int i = 0; i < count; ++i) {
                    RefBgDecFormInfo child = refBgDecFormCols.get(i);
                    child.setBgDecomposer(this.editData);
                }
                this.editData.getRefBgDecForms().addCollection(refBgDecFormCols);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        if (this.comBgScheme.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"selectScheme"));
            SysUtil.abort();
        }
        if (this.prmtBgForm.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"selectForm"));
            SysUtil.abort();
        }
        String id = ((BgFormInfo)this.prmtBgForm.getData()).getId().toString();
        if (!this.getFormInterface().exists((IObjectPK)new ObjectUuidPK(id))) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"formIsDel"));
            SysUtil.abort();
        }
        BgClientHelper.applyMutexService((Component)((Object)this), id, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        this.isOK = true;
        this.isSubmit = true;
        this.orgIdsMap.clear();
        this.beforeStoreFields(e);
        boolean isDebug = false;
        this.setOrgs();
        try {
            this.addBgFormToChildren();
        }
        catch (Exception e1) {
            this.isSubmit = false;
            this.setErrorStr(e1.getMessage());
            SysUtil.abort();
        }
        if (!this.isSubmit || !this.isOK) {
            return;
        }
        if (isDebug) {
            super.actionSubmit_actionPerformed(e);
        } else {
            super.actionSubmit_actionPerformed(e);
            this.isCancel = false;
        }
        BgFormHelper.refreshBgFormList((CoreUI)this);
        this.returnData = new HashMap();
        this.returnData.put("getData", this.getData());
        this.returnData.put("getOrgs", this.getOrgs());
        this.returnData.put("isCancel", new Boolean(this.isCancel()));
        this.returnData.put("isSubmit", new Boolean(this.isSubmit()));
        this.returnData.put("getErrorStr", this.getErrorStr());
        this.returnData.put("setUITitle", ((BgSchemeInfo)this.comBgScheme.getSelectedItem()).getName() + " " + ((BgFormInfo)this.prmtBgForm.getData()).getName());
        this.getInterface().addNewData(this.getDecIdsMap(this.editData));
    }

    private Map getDecIdsMap(BgDecomposerFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("decId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgDecFormCollection coll = editData.getRefBgDecForms();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    protected IBgDecomposerForm getInterface() throws Exception {
        return (IBgDecomposerForm)this.getBizInterface();
    }

    public void setOrgs() {
        this.orgUnits = new Vector();
        try {
            this.orgUnits.add(((OrgStructureInfo)((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot()).getUserObject()).getUnit());
            this.orgs((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"errorData"));
            SysUtil.abort();
        }
    }

    public Vector getOrgs() {
        return this.orgUnits;
    }

    protected void orgs(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                this.orgUnits.add(orgUnitInfo);
            }
            this.orgs(node);
        }
    }

    private void addBgFormToChildren() throws Exception {
        this.bgFormInfo = null;
        if (this.prmtBgForm.getData() != null) {
            this.bgFormInfo = (BgFormInfo)this.prmtBgForm.getData();
        }
        try {
            this.bgFormInfo = this.getFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(this.bgFormInfo.getId().toString()), this.getFormSelectors());
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        UIContext map = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            List errorList;
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            this.initParameterValue(ui);
            ui.init();
            window.show();
            if (ui.isCancel()) {
                SysUtil.abort();
            }
            if ((errorList = ui.getReturnData()) != null && errorList.size() > 0) {
                StringBuffer error = new StringBuffer();
                int size = errorList.size();
                for (int i = 0; i < size; ++i) {
                    error.append(errorList.get(i) + "\r\n");
                }
                MsgBox.showError((Component)((Object)this), (String)error.toString());
                SysUtil.abort();
            }
        }
    }

    public Object invokeMethod(String orgThis, String orgThisId, boolean isTrueUpdate, String orgNext, String orgNextId, BgFormInfo bgFormInfo) throws Exception {
        Object[] obj;
        block6: {
            obj = new Object[2];
            try {
                boolean isAssignSuccess = true;
                String errorMsg = "";
                if (orgThis == null || orgThisId == null || orgNext == null || orgNextId == null) break block6;
                if (isTrueUpdate) {
                    block7: {
                        try {
                            HashMap<String, Object> orgMap = new HashMap<String, Object>();
                            orgMap.put(orgThisId, null);
                            this.getIbgDecForm().addBgFormToChildren(orgMap, bgFormInfo);
                        }
                        catch (Exception e) {
                            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"216_BgDecomposerFormAddNewUI"), (Throwable)e);
                            isAssignSuccess = false;
                            this.isOK = false;
                            if (!(e instanceof BgFormException)) break block7;
                            errorMsg = ((BgFormException)((Object)e)).getMessage();
                        }
                    }
                    obj[1] = isAssignSuccess ? MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"decSuccess"), orgThis) : (errorMsg != null && errorMsg.trim().length() > 0 ? EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"167_BgCollectFormEditUI") + orgThis + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"218_BgDecomposerFormAddNewUI") + "!BgDec!" + orgThis + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"219_BgDecomposerFormAddNewUI") + errorMsg : EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"167_BgCollectFormEditUI") + orgThis + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"218_BgDecomposerFormAddNewUI"));
                }
                obj[0] = EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"220_BgDecomposerFormAddNewUI") + orgNext + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"221_BgDecomposerFormAddNewUI");
            }
            catch (Exception exc) {
                if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"172_BgCollectFormEditUI"));
                }
                throw exc;
            }
        }
        return obj;
    }

    private IBgDecomposerForm getIbgDecForm() throws Exception {
        return BgDecomposerFormFactory.getRemoteInstance();
    }

    private void initParameterValue(ProgressDialogUI ui) {
        Class[] cla = new Class[]{String.class, String.class, Boolean.TYPE, String.class, String.class, BgFormInfo.class};
        ui.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"222_BgDecomposerFormAddNewUI"));
        ui.setInvokeClass(this.getMetaDataPK().getFullName());
        ui.setInvokeMethod("invokeMethod");
        ui.setInvokeMethodParmeterType(cla);
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        String value = null;
        String key2 = null;
        Object[] objOld = null;
        Object[] objNew = null;
        for (String key2 : this.orgIdsMap.keySet()) {
            value = (String)this.orgIdsMap.get(key2);
            if (objOld != null) {
                objNew = new Object[]{objOld[0], objOld[1], Boolean.TRUE, value, key2, this.bgFormInfo};
                objOld = new Object[]{value, key2, Boolean.FALSE};
            } else {
                objOld = new Object[]{value, key2, Boolean.FALSE};
                objNew = new Object[]{value, key2, Boolean.FALSE, value, key2, this.bgFormInfo};
            }
            vecPrameterValue.add(objNew);
        }
        if (objOld != null) {
            objNew = new Object[]{objOld[0], objOld[1], Boolean.TRUE, value, key2, this.bgFormInfo};
            vecPrameterValue.add(objNew);
        }
        int size = vecPrameterValue.size();
        if (objNew != null) {
            int objNewlength = objNew.length;
            Object[][] valueMethod = new Object[size][objNewlength];
            for (int i = 0; i < size; ++i) {
                Object[] obj = (Object[])vecPrameterValue.get(i);
                for (int j = 0; j < objNewlength; ++j) {
                    valueMethod[i][j] = obj[j];
                }
            }
            ui.setInvokeMethodParmeterValue(valueMethod);
        }
        ui.setCountSum(vecPrameterValue.size() - 1);
    }

    @Override
    protected void comBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comBgScheme.getSelectedItem() != null) {
            BgFormInfo bgFormInfo;
            BgSchemeInfo bgSchemaInfo = (BgSchemeInfo)this.comBgScheme.getSelectedItem();
            if (this.prmtBgForm.getData() != null && !(bgFormInfo = (BgFormInfo)this.prmtBgForm.getData()).getBgScheme().getId().toString().equals(bgSchemaInfo.getId().toString())) {
                this.prmtBgForm.setData(null);
            }
            HashSet<Integer> state = new HashSet<Integer>();
            state.add(new Integer(1));
            state.add(new Integer(41));
            int viewState = 4;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCurrentFullOrgUnitInfoUsedInBg().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemaInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)viewState, CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            sic.add(new SelectorItemInfo("bgPeriod.id"));
            sic.add(new SelectorItemInfo("bgPeriod.number"));
            sic.add(new SelectorItemInfo("bgPeriod.name"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("bgScheme.id"));
            sic.add(new SelectorItemInfo("bgScheme.number"));
            sic.add(new SelectorItemInfo("bgScheme.name"));
            sic.add(new SelectorItemInfo("bgTemplate.id"));
            sic.add(new SelectorItemInfo("bgTemplate.number"));
            sic.add(new SelectorItemInfo("bgTemplate.name"));
            sic.add(new SelectorItemInfo("bgTemplate.formType"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("state"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(this.getCurrentFullOrgUnitInfoUsedInBg().getId().toString());
                filter = BgPermissionHelper.addBgFormPermission((String)userId, orgSet, (FilterInfo)filter);
            }
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null, CompareType.EQUALS));
            this.addMarkStringTo(filter);
            HashSet<Integer> formType = new HashSet<Integer>();
            formType.add(new Integer(2));
            formType.add(new Integer(3));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", formType, CompareType.NOTINCLUDE));
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
            view.setFilter(filter);
            this.prmtBgForm.setEntityViewInfo(view);
            this.prmtBgForm.setRefresh(true);
            DefaultKingdeeTreeNode node = null;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                node.setChecked(false);
                this.traceNode(node);
            }
            this.tblTree.repaint();
        }
    }

    private void addMarkStringTo(FilterInfo filter) {
        FilterItemCollection fiCol = filter.getFilterItems();
        filter.setMaskString(filter.getMaskString() + " and ((#" + String.valueOf(fiCol.size() - 2) + ") or (#" + String.valueOf(fiCol.size() - 1) + "))");
    }

    protected FullOrgUnitInfo getCurrentFullOrgUnitInfoUsedInBg() {
        CostCenterOrgUnitInfo costCenterInfo = this.getCurrentCostCenterOrgUnitInfo();
        if (costCenterInfo != null) {
            FullOrgUnitInfo ouInfo = new FullOrgUnitInfo();
            ouInfo.setId(BOSUuid.read((String)costCenterInfo.getId().toString()));
            return ouInfo;
        }
        return null;
    }

    protected CostCenterOrgUnitInfo getCurrentCostCenterOrgUnitInfo() {
        return SysContext.getSysContext().getCurrentCostUnit();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("otherCont");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("bgForm.id");
        sic.add("bgForm.number");
        sic.add("bgForm.name");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.orgUnit.longnumber");
        sic.add("refBgDecForms");
        sic.add("refBgDecForms.adjustMapData");
        sic.add("refBgDecForms.bgForm");
        sic.add("refBgDecForms.bgForm.id");
        sic.add("refBgDecForms.bgForm.number");
        sic.add("refBgDecForms.bgForm.name");
        sic.add("refBgDecForms.bgForm.orgUnit.id");
        sic.add("refBgDecForms.bgForm.orgUnit.name");
        sic.add("refBgDecForms.bgForm.orgUnit.number");
        sic.add("refBgDecForms.bgForm.orgUnit.longnumber");
        sic.add("refBgDecForms.bgForm.bgScheme.id");
        sic.add("refBgDecForms.bgForm.bgScheme.name");
        sic.add("refBgDecForms.bgForm.bgScheme.number");
        return sic;
    }

    private SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public boolean isModify() {
        return false;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public BgDecomposerFormInfo getData() {
        return this.editData;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
    }

    public void verify() throws Exception {
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
    }

    @Override
    public void actionSelectAllCostCenter_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllCostCenter_actionPerformed(e);
        OrgUnitUtils.selectOrgUnitAll((Component)((Object)this), this.tblTree, true, this.chkIncludeChildren.isSelected());
    }

    @Override
    public void actionDisselectAllCostCenter_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisselectAllCostCenter_actionPerformed(e);
        OrgUnitUtils.selectOrgUnit(this.tblTree, false, this.chkIncludeChildren.isSelected());
    }

    public boolean isSubmit() {
        return this.isSubmit;
    }

    public void setSubmit(boolean isSubmit) {
        this.isSubmit = isSubmit;
    }

    public String getErrorStr() {
        return this.errorStr;
    }

    public void setErrorStr(String errorStr) {
        this.errorStr = errorStr;
    }

    @Override
    public boolean cancel() throws Exception {
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return this.returnData;
    }

    @Override
    public void clear() throws Exception {
        this.prmtBgForm.setData(null);
        this.comBgScheme.setSelectedIndex(-1);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
        this.disSelectedTree(root);
        root.setChecked(true);
        this.tblTree.repaint();
    }

    @Override
    public Object saveSolution() throws Exception {
        if (this.prmtBgForm.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"selectForm"));
            SysUtil.abort();
        }
        this.setOrgs();
        HashMap<String, Object> saveData = new HashMap<String, Object>();
        saveData.put("bgSchemeID", ((BgSchemeInfo)this.comBgScheme.getSelectedItem()).getId().toString());
        saveData.put("bgFormID", ((BgFormInfo)this.prmtBgForm.getData()).getId().toString());
        saveData.put("orgUnits", this.orgUnits);
        return saveData;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        try {
            HashMap loadData;
            if (o instanceof Map && (loadData = (HashMap)o) != null && loadData.size() > 0 && !this.loadDataToUI(loadData)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
        }
    }

    private boolean loadDataToUI(Map loadData) throws Exception {
        this.comBgScheme.setSelectedItem(null);
        this.prmtBgForm.setValue(null);
        this.inputOrgUnitTraceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), null);
        this.tblTree.requestFocus();
        if (loadData.get("bgSchemeID") == null || loadData.get("bgFormID") == null || loadData.get("orgUnits") == null || ((Vector)loadData.get("orgUnits")).size() < 2) {
            return false;
        }
        for (int i = 0; i < this.comBgScheme.getItemCount(); ++i) {
            if (!loadData.get("bgSchemeID").equals(((BgSchemeInfo)this.comBgScheme.getItemAt(i)).getId().toString())) continue;
            this.comBgScheme.setSelectedIndex(i);
        }
        if (this.comBgScheme.getSelectedItem() == null) {
            return false;
        }
        this.comBgScheme_itemStateChanged(null);
        if (!this.inputBgForm((String)loadData.get("bgFormID"))) {
            return false;
        }
        this.inputOrgUnit((Vector)loadData.get("orgUnits"));
        return true;
    }

    private void inputOrgUnit(Vector orgUnit) {
        ((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot()).setChecked(true);
        this.inputOrgUnitTraceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), orgUnit);
        this.tblTree.requestFocus();
    }

    private void disSelectedTree(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            node.setChecked(false);
            this.disSelectedTree(subNode);
        }
    }

    private void inputOrgUnitTraceNode(DefaultKingdeeTreeNode root, Vector orgUnit) {
        if (root == null || orgUnit == null || orgUnit.isEmpty()) {
            return;
        }
        HashMap orgIds = new HashMap();
        for (int i = 0; i < orgUnit.size(); ++i) {
            orgIds.put(((FullOrgUnitInfo)orgUnit.get(i)).getId().toString(), null);
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (orgUnit != null && orgIds.containsKey(orgUnitInfo.getId().toString())) {
                node.setChecked(true);
            } else {
                node.setChecked(false);
            }
            this.inputOrgUnitTraceNode(node, orgUnit);
        }
    }

    private boolean inputBgForm(String bgFormID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view = this.prmtBgForm.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter = view.getFilter();
        filter.appendFilterItem("id", (Object)bgFormID);
        String maskstring = filter.getMaskString();
        filter.setMaskString(maskstring + " and #" + (filter.getFilterItems().size() - 1));
        view.setFilter(filter);
        BgFormCollection bgFormCol = this.getFormInterface().getBgFormCollection(view);
        if (bgFormCol.size() == 1) {
            this.prmtBgForm.setValue((Object)bgFormCol.get(0));
            this.prmtBgForm_dataChanged(null);
            return true;
        }
        return false;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        ActionEvent e = new ActionEvent(this.btnConfirm, 1001, "");
        this.actionSubmit_actionPerformed(e);
        return true;
    }

    public void setConfermLabel(String confermLabel) {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        if (uicontext.get("selfPanelUiName") != null) {
            oql.append(" and uiName='" + (String)uicontext.get("selfPanelUiName") + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    private void doAllSelAndAllClr(boolean selected) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
        if (this.tblTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.tblTree.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        if (this.chkIncludeChildren.isSelected()) {
            Enumeration nodeEnum = root.breadthFirstEnumeration();
            DefaultKingdeeTreeNode node = null;
            while (nodeEnum.hasMoreElements()) {
                node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(selected);
            }
        } else {
            if (selected || root != this.tblTree.getModel().getRoot()) {
                root.setChecked(selected);
            }
            if (root.getParent() != null) {
                DefaultKingdeeTreeNode node = null;
                for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                    node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                    if (!this.canTheNodeBeSelected(node)) continue;
                    node.setChecked(selected);
                }
            }
        }
        this.tblTree.repaint();
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        return null;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }
}

