/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgDefaultCtrlSetEditUI;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class BgDefaultCtrlSetEditUI
extends AbstractBgDefaultCtrlSetEditUI {
    private static final long serialVersionUID = 3679701480930060588L;
    private static final Logger logger = CoreUIObject.getLogger(BgDefaultCtrlSetEditUI.class);
    private Boolean isFlexCtrl = Boolean.FALSE;
    private BigDecimal flexCtrlParam = null;
    private int periodCtrlPolicy = -1;
    private String RESOURCE = "com.kingdee.eas.ma.budget.client.BgCtrlSetResource";
    private Boolean isAllowAccess = Boolean.TRUE;
    private Hashtable ctrlMode = null;
    private Hashtable newCtrlMode = null;
    private Boolean isCtrl = Boolean.FALSE;
    private String bgTemplateID = null;
    private Boolean isGroupCtrl = Boolean.FALSE;
    private boolean isChanged = true;
    private boolean isChildTemplate = false;
    private boolean isCanUpdateChildCtrlModeChild = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setCanUpdateChildCtrlModeChild(BgNSHelper.isBG019_CtrlModeChildCanUpdate(null));
        this.setBgTemplateID((String)this.getUIContext().get("BGTEMPLATE_ID"));
        this.setChildTemplate();
        this.setCtrlMode(this.getBgCtrSettingFacadeInterface().getDefCtrlSetByTemplateID(this.getBgTemplateID()));
        this.setIsCtrl();
        this.setPeriodCtrlPolicy();
        this.setIsAllowAccess();
        this.setIsFlexCtrl();
        this.setFlexCtrlParam();
        this.setIsGroupCtrl();
        this.setUIButtonEnabledAndValue(this.getIsCtrl(), this.isCanUpdateChildCtrlModeChild() || !this.isChildTemplate());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.setNewCtrlMode();
        this.getBgCtrSettingFacadeInterface().saveDefCtrlSet(this.getBgTemplateID(), this.getNewCtrlMode());
        this.isChanged = false;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"225_BgDefaultCtrlSetEditUI"));
    }

    private void verify() {
        if (this.raCtrl.isSelected()) {
            if (!(this.raPeriod.isSelected() || this.raTotal.isSelected() || this.raAddUp.isSelected() || this.raYear.isSelected())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"226_BgDefaultCtrlSetEditUI"));
                SysUtil.abort();
            }
            if (this.checkFlexCtrl.isSelected()) {
                String flexParam = this.txtFlexParam.getText();
                if (StringUtils.isEmpty((String)flexParam)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"flexCtrlParamInputNumber"));
                    SysUtil.abort();
                }
                try {
                    Float.parseFloat(flexParam);
                }
                catch (Exception e) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"flexCtrlParamInputNumber"));
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    protected void raNoCtrl_actionPerformed(ActionEvent e) throws Exception {
        this.setUIButtonEnabledAndValue(!this.raNoCtrl.isSelected(), this.isCanUpdateChildCtrlModeChild() || !this.isChildTemplate());
    }

    @Override
    protected void raCtrl_actionPerformed(ActionEvent e) throws Exception {
        this.setUIButtonEnabledAndValue(this.raCtrl.isSelected(), this.isCanUpdateChildCtrlModeChild() || !this.isChildTemplate());
    }

    @Override
    protected void checkFlexCtrl_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkFlexCtrl.isSelected()) {
            this.txtFlexParam.setEnabled(true);
            this.txtFlexParam.setText(this.getFlexCtrlParam().toString());
        } else {
            this.txtFlexParam.setEnabled(false);
            this.txtFlexParam.setText("");
        }
    }

    private void setUIButtonEnabledAndValue(boolean isCtrl, boolean isCanUpdate) {
        if (!isCanUpdate) {
            this.isChanged = false;
            this.raPeriod.setEnabled(false);
            this.raTotal.setEnabled(false);
            this.raAddUp.setEnabled(false);
            this.raYear.setEnabled(false);
            this.txtFlexParam.setEnabled(false);
            this.checkFlexCtrl.setEnabled(false);
            this.checkIsAllowAccess.setEnabled(false);
            this.checkIsGroupCtrl.setEnabled(false);
            this.raCtrl.setEnabled(false);
            this.raNoCtrl.setEnabled(false);
            this.btnSave.setEnabled(false);
        } else {
            this.raPeriod.setEnabled(isCtrl);
            this.raTotal.setEnabled(isCtrl);
            this.raAddUp.setEnabled(isCtrl);
            this.raYear.setEnabled(isCtrl);
            this.txtFlexParam.setEnabled(isCtrl);
            this.checkFlexCtrl.setEnabled(isCtrl);
            this.checkIsAllowAccess.setEnabled(isCtrl);
            this.checkIsGroupCtrl.setEnabled(isCtrl);
        }
        if (isCtrl) {
            this.raCtrl.setSelected(true);
            if (this.getPeriodCtrlPolicy() == 10) {
                this.raPeriod.setSelected(true);
            } else if (this.getPeriodCtrlPolicy() == 11) {
                this.raAddUp.setSelected(true);
            } else if (this.getPeriodCtrlPolicy() == 12) {
                this.raTotal.setSelected(true);
            } else if (this.getPeriodCtrlPolicy() == 20) {
                this.raYear.setSelected(true);
            }
            this.checkIsGroupCtrl.setSelected(this.getIsGroupCtrl().booleanValue());
            this.checkFlexCtrl.setSelected(this.getIsFlexCtrl().booleanValue());
            if (this.checkFlexCtrl.isSelected()) {
                this.txtFlexParam.setText(this.getFlexCtrlParam().toString());
            } else {
                this.txtFlexParam.setEnabled(false);
            }
            this.checkIsAllowAccess.setSelected(this.getIsAllowAccess().booleanValue());
        } else {
            this.raNoCtrl.setSelected(true);
            this.raPeriod.setSelected(false);
            this.raTotal.setSelected(false);
            this.raAddUp.setSelected(false);
            this.raYear.setSelected(false);
            this.txtFlexParam.setText("");
            this.checkFlexCtrl.setSelected(false);
            this.checkIsAllowAccess.setSelected(true);
            this.checkIsGroupCtrl.setSelected(false);
        }
    }

    public Hashtable getCtrlMode() {
        if (this.ctrlMode == null) {
            this.ctrlMode = new Hashtable();
        }
        return this.ctrlMode;
    }

    protected IBgCtrSettingFacade getBgCtrSettingFacadeInterface() throws Exception {
        return BgCtrSettingFacadeFactory.getRemoteInstance();
    }

    public Boolean getIsFlexCtrl() {
        return this.isFlexCtrl;
    }

    public void setIsFlexCtrl() {
        this.isFlexCtrl = this.getCtrlMode().containsKey("isFlexCtrl") ? (Boolean)this.getCtrlMode().get("isFlexCtrl") : Boolean.FALSE;
    }

    public BigDecimal getFlexCtrlParam() {
        return this.flexCtrlParam;
    }

    public void setFlexCtrlParam() {
        this.flexCtrlParam = this.getCtrlMode().containsKey("flexCtrlParam") ? (BigDecimal)this.getCtrlMode().get("flexCtrlParam") : new BigDecimal("1");
    }

    public int getPeriodCtrlPolicy() {
        return this.periodCtrlPolicy;
    }

    public void setPeriodCtrlPolicy() {
        this.periodCtrlPolicy = this.getCtrlMode().containsKey("periodCtrlPolicy") ? (Integer)this.getCtrlMode().get("periodCtrlPolicy") : -1;
    }

    public Boolean getIsAllowAccess() {
        return this.isAllowAccess;
    }

    public void setIsAllowAccess() {
        this.isAllowAccess = this.getCtrlMode().containsKey("isAllowAccess") ? (Boolean)this.getCtrlMode().get("isAllowAccess") : Boolean.TRUE;
    }

    public Boolean getIsCtrl() {
        return this.isCtrl;
    }

    public void setIsCtrl() {
        this.isCtrl = this.getCtrlMode().containsKey("isCtrl") ? (Boolean)this.getCtrlMode().get("isCtrl") : Boolean.FALSE;
    }

    public String getBgTemplateID() {
        return this.bgTemplateID;
    }

    public void setBgTemplateID(String bgTemplateID) {
        this.bgTemplateID = bgTemplateID;
    }

    public void setCtrlMode(Hashtable ctrlMode) {
        if (ctrlMode == null || ctrlMode.isEmpty()) {
            ctrlMode = new Hashtable<String, Comparable<Boolean>>();
            ctrlMode.put("isCtrl", Boolean.FALSE);
            ctrlMode.put("periodCtrlPolicy", new Integer(-1));
            ctrlMode.put("isFlexCtrl", Boolean.FALSE);
            ctrlMode.put("flexCtrlParam", new BigDecimal("1"));
            ctrlMode.put("isGroupCtrl", Boolean.FALSE);
            ctrlMode.put("groupCtrlNo", new Integer(-1));
            ctrlMode.put("isAllowAccess", Boolean.TRUE);
            this.raNoCtrl.setSelected(true);
            this.checkIsAllowAccess.setSelected(true);
        }
        this.ctrlMode = ctrlMode;
    }

    public Hashtable getNewCtrlMode() {
        return this.newCtrlMode;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean destroyWindow() {
        this.setNewCtrlMode();
        this.isChanged();
        if (this.isChanged) {
            int confirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"227_BgDefaultCtrlSetEditUI"));
            if (0 == confirm) {
                try {
                    this.btnSave_actionPerformed(null);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                return super.destroyWindow();
            }
            if (1 == confirm) {
                return super.destroyWindow();
            }
            if (2 == confirm) {
                return false;
            }
        }
        return super.destroyWindow();
    }

    public void setNewCtrlMode() {
        if (this.newCtrlMode == null) {
            this.newCtrlMode = new Hashtable();
        }
        if (this.raCtrl.isSelected()) {
            this.newCtrlMode.put("isCtrl", Boolean.TRUE);
            int periodCtrlPolicy = -1;
            if (this.raPeriod.isSelected()) {
                periodCtrlPolicy = 10;
            } else if (this.raAddUp.isSelected()) {
                periodCtrlPolicy = 11;
            } else if (this.raTotal.isSelected()) {
                periodCtrlPolicy = 12;
            } else if (this.raYear.isSelected()) {
                periodCtrlPolicy = 20;
            }
            this.newCtrlMode.put("periodCtrlPolicy", new Integer(periodCtrlPolicy));
            this.newCtrlMode.put("isFlexCtrl", this.checkFlexCtrl.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            this.newCtrlMode.put("isGroupCtrl", this.checkIsGroupCtrl.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            this.newCtrlMode.put("isAllowAccess", this.checkIsAllowAccess.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            if (this.checkFlexCtrl.isSelected()) {
                try {
                    this.newCtrlMode.put("flexCtrlParam", new BigDecimal(this.txtFlexParam.getText().trim()));
                }
                catch (Exception e) {
                    logger.error((Object)"error_BgDefaultCtrlSetEditUI_setNewCtrlMode", (Throwable)e);
                }
            } else {
                this.newCtrlMode.put("flexCtrlParam", new BigDecimal("1"));
            }
            if (this.checkIsGroupCtrl.isSelected()) {
                this.newCtrlMode.put("groupCtrlNo", new Integer(999));
            } else {
                this.newCtrlMode.put("groupCtrlNo", new Integer(-1));
            }
        } else {
            this.newCtrlMode.put("isCtrl", Boolean.FALSE);
            this.newCtrlMode.put("periodCtrlPolicy", new Integer(-1));
            this.newCtrlMode.put("isFlexCtrl", Boolean.FALSE);
            this.newCtrlMode.put("flexCtrlParam", new BigDecimal("1"));
            this.newCtrlMode.put("isGroupCtrl", Boolean.FALSE);
            this.newCtrlMode.put("groupCtrlNo", new Integer(-1));
            this.newCtrlMode.put("isAllowAccess", Boolean.TRUE);
        }
    }

    private void isChanged() {
        if (!this.isChanged) {
            return;
        }
        if (this.getCtrlMode().isEmpty() && !this.getNewCtrlMode().isEmpty()) {
            this.isChanged = true;
            return;
        }
        Object newValue = null;
        Object oldValue = this.getCtrlMode().get("isCtrl");
        if (!oldValue.equals(newValue = this.getNewCtrlMode().get("isCtrl"))) {
            this.isChanged = true;
            return;
        }
        oldValue = this.getCtrlMode().get("periodCtrlPolicy");
        if (!oldValue.equals(newValue = this.getNewCtrlMode().get("periodCtrlPolicy"))) {
            this.isChanged = true;
            return;
        }
        oldValue = this.getCtrlMode().get("isFlexCtrl");
        if (!oldValue.equals(newValue = this.getNewCtrlMode().get("isFlexCtrl"))) {
            this.isChanged = true;
            return;
        }
        oldValue = this.getCtrlMode().get("flexCtrlParam");
        newValue = this.getNewCtrlMode().get("flexCtrlParam");
        if (!(oldValue instanceof BigDecimal) || !(newValue instanceof BigDecimal)) {
            this.isChanged = true;
            return;
        }
        if (((BigDecimal)oldValue).compareTo((BigDecimal)newValue) != 0) {
            this.isChanged = true;
            return;
        }
        oldValue = this.getCtrlMode().get("isGroupCtrl");
        if (!oldValue.equals(newValue = this.getNewCtrlMode().get("isGroupCtrl"))) {
            this.isChanged = true;
            return;
        }
        oldValue = this.getCtrlMode().get("groupCtrlNo");
        if (!oldValue.equals(newValue = this.getNewCtrlMode().get("groupCtrlNo"))) {
            this.isChanged = true;
            return;
        }
        oldValue = this.getCtrlMode().get("isAllowAccess");
        if (!oldValue.equals(newValue = this.getNewCtrlMode().get("isAllowAccess"))) {
            this.isChanged = true;
            return;
        }
        this.isChanged = false;
    }

    public Boolean getIsGroupCtrl() {
        return this.isGroupCtrl;
    }

    public void setIsGroupCtrl() {
        this.isGroupCtrl = this.getCtrlMode().containsKey("isGroupCtrl") ? (Boolean)this.getCtrlMode().get("isGroupCtrl") : Boolean.FALSE;
    }

    public boolean isChildTemplate() {
        return this.isChildTemplate;
    }

    public void setChildTemplate() {
        try {
            BgTemplateInfo bgTemplateInfo = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo("select id,rootid where id = '" + this.getBgTemplateID() + "'");
            this.isChildTemplate = !bgTemplateInfo.getId().equals((Object)bgTemplateInfo.getRootId());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean isCanUpdateChildCtrlModeChild() {
        return this.isCanUpdateChildCtrlModeChild;
    }

    public void setCanUpdateChildCtrlModeChild(boolean isCanUpdateChildCtrlModeChild) {
        this.isCanUpdateChildCtrlModeChild = isCanUpdateChildCtrlModeChild;
    }
}

