/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgDifferFilterParam;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.IBgRptFacade;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgDifferFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgRptFilter2UI;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import java.awt.event.ItemEvent;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgDifferFilterUI
extends AbstractBgDifferFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgRptFilter2UI.class);
    private BgDifferFilterParam balFilterParam;

    public BgDifferFilterUI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
        this.chkIsSum.setSelected(true);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.chkIsSum.setVisible(false);
        this.chkIsSum.setSelected(true);
        NewBgItemDialog bgItem = new NewBgItemDialog((IUIObject)this);
        this.comboBgRptType.setSelectedItem((Object)BgAnalysisTypeEnum.BGDIFFER);
        this.prmtItemFrom.setSelector((KDPromptSelector)bgItem);
        this.prmtItemFrom.setDisplayFormat("$name$");
        this.prmtItemTo.setSelector((KDPromptSelector)bgItem);
        this.prmtItemTo.setDisplayFormat("$name$");
        this.prmtElement.setSelector(null);
    }

    @Override
    public void init() throws Exception {
        BgClientHelper.setSelectObject(this.comboBgRptType, (Object)BgAnalysisTypeEnum.BGDIFFER);
        this.comboBgRptType.setEnabled(false);
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.balFilterParam == null) {
            this.balFilterParam = new BgDifferFilterParam();
        }
        return this.balFilterParam;
    }

    @Override
    protected void initScheme() {
        String orgUnitId = this.currentCompany.getId().toString();
        IBgScheme iBgScheme = null;
        try {
            iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        if (iBgScheme != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
            if (BgParamCHelper.isFodian()) {
                items.add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                items.add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString(" #0 and #1");
            view.setFilter(filter);
            BgSchemeCollection col = null;
            try {
                col = iBgScheme.getBgSchemeCollection(view);
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            BgHelper.sortCollection(col, new String[]{"number"});
            if (col != null && col.size() > 0) {
                this.comboBgScheme.removeAllItems();
                this.comboBgScheme.addItems(col.toArray());
                this.comboBgScheme.setSelectedIndex(0);
            }
        }
    }

    @Override
    public Object getParam() {
        String stritem;
        BgDifferFilterParam param = (BgDifferFilterParam)super.getParam();
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        param.objItemFrom = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemFrom(stritem);
        } else {
            param.setItemFrom(null);
        }
        vi = (VisualItemInfo)this.prmtItemTo.getValue();
        param.objItemTo = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemTo(stritem);
        } else {
            param.setItemTo(null);
        }
        Object[] beinfo = (Object[])this.prmtElement.getValue();
        if (beinfo != null && beinfo[0] != null) {
            param.arrayElement = beinfo;
            String stritems = "";
            for (int i = 0; i < beinfo.length; ++i) {
                stritems = stritems + "'" + ((BgElementInfo)beinfo[i]).getId().toString() + "' ,";
            }
            param.setElement(stritems.substring(0, stritems.length() - 1));
        } else {
            try {
                IBgRptFacade ibg = BgRptFacadeFactory.getRemoteInstance();
                Vector defaultElement = ibg.getBgElementFromSchema(param.getBgSchemeId());
                String stritems = "";
                if (defaultElement.size() > 0) {
                    Object[] are = new Object[defaultElement.size()];
                    for (int i = 0; i < defaultElement.size(); ++i) {
                        stritems = stritems + "'" + ((BgElementInfo)defaultElement.get(i)).getId().toString() + "' ,";
                        are[i] = defaultElement.get(i);
                    }
                    if (stritems.trim().length() > 0) {
                        param.setElement(stritems.substring(0, stritems.length() - 1));
                        param.arrayElement = are;
                    }
                }
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.prmtCurrency.getValue() != null) {
            param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            try {
                param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
            }
            catch (Exception e) {
                param.setCurrency(null);
            }
        }
        param.setBgRptType(BgAnalysisTypeEnum.BGDIFFER);
        return param;
    }

    @Override
    public CustomerParams getCustomerParams() {
        String stritem;
        CustomerParams cp = super.getCustomerParams();
        BgDifferFilterParam param = (BgDifferFilterParam)this.getFilterObject(cp);
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        param.objItemFrom = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemFrom(stritem);
        } else {
            param.setItemFrom(null);
        }
        vi = (VisualItemInfo)this.prmtItemTo.getValue();
        param.objItemTo = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemTo(stritem);
        } else {
            param.setItemTo(null);
        }
        Object[] beinfo = (Object[])this.prmtElement.getValue();
        if (beinfo != null && beinfo[0] != null) {
            param.arrayElement = beinfo;
            String stritems = "";
            for (int i = 0; i < beinfo.length; ++i) {
                stritems = stritems + "'" + ((BgElementInfo)beinfo[i]).getId().toString() + "' ,";
            }
            param.setElement(stritems.substring(0, stritems.length() - 1));
        } else {
            try {
                IBgRptFacade ibg = BgRptFacadeFactory.getRemoteInstance();
                Vector defaultElement = ibg.getBgElementFromSchema(param.getBgSchemeId());
                String stritems = "";
                if (defaultElement.size() > 0) {
                    Object[] are = new Object[defaultElement.size()];
                    for (int i = 0; i < defaultElement.size(); ++i) {
                        stritems = stritems + "'" + ((BgElementInfo)defaultElement.get(i)).getId().toString() + "' ,";
                        are[i] = defaultElement.get(i);
                    }
                    if (stritems.trim().length() > 0) {
                        param.setElement(stritems.substring(0, stritems.length() - 1));
                        param.arrayElement = are;
                    }
                } else {
                    param.setElement(null);
                }
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        if (this.prmtCurrency.getValue() != null) {
            param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            try {
                param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
            }
            catch (Exception e) {
                param.setCurrency(null);
            }
        }
        param.setBgRptType(BgAnalysisTypeEnum.BGDIFFER);
        this.setFilterObject(cp, param);
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        BgDifferFilterParam filterParam = (BgDifferFilterParam)this.getFilterObject(cp);
        if (filterParam != null) {
            this.prmtItemFrom.setData(filterParam.objItemFrom);
            this.prmtItemTo.setData(filterParam.objItemTo);
            this.prmtElement.setData((Object)filterParam.arrayElement);
            this.prmtCurrency.setData((Object)filterParam.getCurrency());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.prmtItemFrom.setData(null);
        this.prmtItemTo.setData(null);
        this.prmtElement.setData(null);
        this.prmtCurrency.setData(null);
    }

    @Override
    public boolean verify() {
        boolean bln = super.verify();
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        if (vi == null) {
            // empty if block
        }
        if ((vi = (VisualItemInfo)this.prmtItemTo.getValue()) == null) {
            // empty if block
        }
        return bln;
    }

    @Override
    protected void comboBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgScheme_itemStateChanged(e);
    }

    @Override
    protected void prmtBeginPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBeginPeriod_dataChanged(e);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
    }
}

