/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.client.AbstractBgDifferNotesViewUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgDifferNotesViewUI
extends AbstractBgDifferNotesViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgDifferNotesViewUI.class);
    protected DecimalFormat decFormat = new DecimalFormat(BgClientHelper.getNumberFormat(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()).getId()));
    private boolean isChanged = false;
    boolean isEdit = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.inputValueToTalbe();
        this.initTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        Object state = this.getUIContext().get("states");
        if (state != null && state instanceof Boolean) {
            this.btnSave.setEnabled(Boolean.valueOf(state.toString()).booleanValue());
        }
    }

    private void initTable() {
        this.tblMain.getColumn("auditUser").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("auditTime").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("adjustReson").getStyleAttributes().setLocked(false);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.setDefaultRowHeight(this.tblMain.getDefaultRowHeight() * 2);
    }

    private void inputValueToTalbe() {
        this.tblMain.checkParsed(true);
        Vector differNotesData = new Vector();
        differNotesData = (Vector)this.getUIContext().get("differNotesData");
        for (int i = 0; i < differNotesData.size(); ++i) {
            this.tblMain.addRow();
            Map noteData = (Map)differNotesData.get(i);
            this.tblMain.getCell(i, "bgItem").setValue(noteData.get("bgItem"));
            this.tblMain.getCell(i, "bgElement").setValue(noteData.get("bgElement"));
            this.tblMain.getCell(i, "orgUnit").setValue(noteData.get("orgUnit"));
            this.tblMain.getCell(i, "period").setValue(noteData.get("bgPeriod"));
            this.tblMain.getCell(i, "operation").setValue(noteData.get("operation"));
            this.tblMain.getCell(i, "adjustReson").setValue(noteData.get("adjustReson"));
            if (noteData.get("oldValue") != null) {
                BigDecimal oldValue = (BigDecimal)noteData.get("oldValue");
                this.tblMain.getCell(i, "oldValue").setValue((Object)this.decFormat.format(oldValue));
            }
            if (noteData.get("newValue") != null) {
                BigDecimal newValue = (BigDecimal)noteData.get("newValue");
                this.tblMain.getCell(i, "newValue").setValue((Object)this.decFormat.format(newValue));
            }
            if (noteData.get("difValue") != null) {
                BigDecimal difValue = (BigDecimal)noteData.get("difValue");
                this.tblMain.getCell(i, "difValue").setValue((Object)this.decFormat.format(difValue));
            }
            if (noteData.get("formulaString") != null) {
                this.tblMain.getCell(i, "formulaString").setValue(noteData.get("formulaString"));
                this.tblMain.getCell(i, "tmpFormId").setValue(noteData.get("tmpFormId"));
            }
            this.tblMain.getCell(i, "adjustUser").setValue(noteData.get("adjustUser"));
            this.tblMain.getCell(i, "adjustTime").setValue(noteData.get("adjustTime"));
            this.tblMain.getCell(i, "auditUser").setValue(noteData.get("auditUser"));
            this.tblMain.getCell(i, "auditTime").setValue(noteData.get("auditTime"));
        }
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void actionSaveReason_actionPerformed(ActionEvent e) throws Exception {
        Map adjustMap = null;
        if (this.getUIContext().get("adjustMap") != null) {
            adjustMap = (Map)this.getUIContext().get("adjustMap");
        }
        if (adjustMap != null) {
            BgAdjustFormDiversityData data = null;
            boolean isEntre = false;
            for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
                data = null;
                Object formulaObj = this.tblMain.getCell(i, "formulaString").getValue();
                Object adjustReason = this.tblMain.getCell(i, "adjustReson").getValue();
                Object tmpFormId = this.tblMain.getCell(i, "tmpFormId").getValue();
                data = tmpFormId != null ? (BgAdjustFormDiversityData)((Map)adjustMap.get(BOSUuid.read((String)tmpFormId.toString()))).get(formulaObj) : (BgAdjustFormDiversityData)adjustMap.get(formulaObj);
                if (data != null) {
                    if (adjustReason != null) {
                        data.setAdjustReson(adjustReason.toString());
                    } else {
                        data.setAdjustReson(null);
                    }
                }
                isEntre = true;
            }
            if (isEntre) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"successOk"));
                this.isChanged = true;
            }
            this.isEdit = false;
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        this.isEdit = true;
    }

    public boolean destroyWindow() {
        if (this.isEdit) {
            this.tblMain.getEditManager().stopEditing();
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"isSave")) == 0) {
                this.saveAdjustReson();
            }
        }
        return super.destroyWindow();
    }

    private void saveAdjustReson() {
        Map adjustMap = null;
        if (this.getUIContext().get("adjustMap") != null) {
            adjustMap = (Map)this.getUIContext().get("adjustMap");
        }
        if (adjustMap != null) {
            BgAdjustFormDiversityData data = null;
            boolean isEntre = false;
            for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
                data = null;
                Object formulaObj = this.tblMain.getCell(i, "formulaString").getValue();
                Object adjustReason = this.tblMain.getCell(i, "adjustReson").getValue();
                Object tmpFormId = this.tblMain.getCell(i, "tmpFormId").getValue();
                data = tmpFormId != null ? (BgAdjustFormDiversityData)((Map)adjustMap.get(BOSUuid.read((String)tmpFormId.toString()))).get(formulaObj) : (BgAdjustFormDiversityData)adjustMap.get(formulaObj);
                if (data != null) {
                    if (adjustReason != null) {
                        data.setAdjustReson(adjustReason.toString());
                    } else {
                        data.setAdjustReson(null);
                    }
                }
                isEntre = true;
            }
            if (isEntre) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"successOk"));
            }
            this.isEdit = false;
        }
    }
}

