/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgElementCollObject;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.client.AbstractBgElementF7UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgElementF7UI
extends AbstractBgElementF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgElementF7UI.class);
    private boolean isCancel = true;
    private BgElementInfo resultOne = null;
    private BgElementCollection result = new BgElementCollection();
    private boolean isFilterText = true;
    boolean isChooseOne = true;
    private List hadSelectedElement;
    private boolean isShowName = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.setPreferredSize(new Dimension(580, 435));
        if (this.getUIContext().get("hadSelectedElement") instanceof List) {
            this.hadSelectedElement = (List)this.getUIContext().get("hadSelectedElement");
        }
        this.btnEleSearch.setText("");
        this.btnEleSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.tblMain.checkParsed();
        this.tblMain.getColumn("isApportionable").getStyleAttributes().setLocked(true);
        super.onLoad();
        this.isFilterText = (Boolean)this.getUIContext().get("isFilterText");
        this.isChooseOne = (Boolean)this.getUIContext().get("isChooseOne");
        this.tblMain.getSelectManager().setSelectMode(2);
        this.putDataToKDTable();
        if (this.isChooseOne) {
            this.tblMain.getColumn("choose").getStyleAttributes().setHided(true);
        }
        this.colSetLocked();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor ex = super.getQueryExecutor(queryPK, viewInfo);
        boolean isCtrlRule = false;
        if (this.getUIContext().get("isCtrlRule") instanceof Boolean) {
            isCtrlRule = Boolean.parseBoolean(this.getUIContext().get("isCtrlRule").toString());
        }
        if (isCtrlRule) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("dataType", (Object)new Integer(BgElementDataTypeEnum.MONEY.getValue())));
            filter.getFilterItems().add(new FilterItemInfo("dataType", (Object)new Integer(BgElementDataTypeEnum.AMOUNT.getValue())));
            filter.setMaskString("#0 or #1");
            viewInfo.setFilter(filter);
        }
        return ex;
    }

    private void colSetLocked() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("dataType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("type").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("isReference").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("isApportionable").getStyleAttributes().setLocked(true);
    }

    private void putDataToKDTable() {
        if (this.bgElementQuery == null) {
            this.bgElementQuery = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        if (this.isFilterText) {
            if (this.txtEleSearch.getText().trim().length() > 0) {
                this.tblMain.removeRows();
                FilterItemInfo item = new FilterItemInfo("dataType", (Object)String.valueOf(5), CompareType.NOTEQUALS);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("dataType", (Object)String.valueOf(4), CompareType.NOTEQUALS);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("number", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("name", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 4) + ") and (#" + String.valueOf(filter.getFilterItems().size() - 3) + ") and ((#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
            } else {
                FilterItemInfo item = new FilterItemInfo("dataType", (Object)String.valueOf(5), CompareType.NOTEQUALS);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("dataType", (Object)String.valueOf(4), CompareType.NOTEQUALS);
                filter.getFilterItems().add(item);
                filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") and (#" + String.valueOf(filter.getFilterItems().size() - 1) + ")");
            }
        } else if (this.txtEleSearch.getText().trim().length() > 0) {
            this.tblMain.removeRows();
            FilterItemInfo item = new FilterItemInfo("number", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("name", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
        }
        this.bgElementQuery.setFilter(filter);
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.bgElementQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.bgElementQueryPK, this.bgElementQuery);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isChooseOne) {
            IRow initRow = this.tblMain.getRow(0);
            if (initRow == null) {
                return;
            }
            initRow.getCell("choose").setValue((Object)Boolean.FALSE);
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.FALSE);
                if (this.hadSelectedElement == null || this.hadSelectedElement.isEmpty() || !this.hadSelectedElement.contains(this.tblMain.getCell(i, 1).getValue().toString())) continue;
                this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    private void onBtnConfirm() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        if (!this.isChooseOne) {
            iRow.getCell("choose").setValue((Object)Boolean.TRUE);
            this.isCancel = false;
        } else {
            String id = iRow.getCell("id").getValue().toString();
            try {
                IBgElement iElement = BgElementFactory.getRemoteInstance();
                if (iElement == null) {
                    throw new BgFormException(BgFormException.NOINSTANCE);
                }
                this.resultOne = iElement.getBgElementInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.isChooseOne) {
            int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
            if (currRow != -1) {
                IRow iRow = this.tblMain.getRow(currRow);
                String id = iRow.getCell("id").getValue().toString();
                try {
                    IBgElement iElement = BgElementFactory.getRemoteInstance();
                    if (iElement == null) {
                        throw new BgFormException(BgFormException.NOINSTANCE);
                    }
                    this.resultOne = iElement.getBgElementInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                }
                catch (BOSException ex) {
                    logger.error((Object)ex.getMessage());
                    throw ex;
                }
                catch (EASBizException ex) {
                    logger.error((Object)ex.getMessage());
                    throw ex;
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgElementResource", (String)"selectBgName"));
                SysUtil.abort();
            }
        } else {
            Object info = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (!this.tblMain.getRow(i).getCell("choose").getValue().toString().equals("true")) continue;
                IRow iRow = this.tblMain.getRow(i);
                String id = iRow.getCell("id").getValue().toString();
                idSet.add(id);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.getSelector().addObjectCollection((IObjectCollection)this.bgElementQuery.getSelector());
            view.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo("number");
            sorter.add(sortInfo);
            view.setSorter(sorter);
            try {
                IBgElement ie = BgElementFactory.getRemoteInstance();
                if (ie == null) {
                    throw new BgFormException(BgFormException.NOINSTANCE);
                }
                this.result = ie.getBgElementCollection(view);
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            finally {
                if (idSet != null) {
                    idSet.clear();
                }
            }
        }
        if (this.resultOne != null || !this.result.isEmpty()) {
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgElementInfo getResultOne() {
        return this.resultOne;
    }

    public BgElementCollObject getResult() {
        return new BgElementCollObject(this.result, this.isShowName);
    }

    @Override
    protected void btnEleSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnEleSearch_actionPerformed(e);
        this.putDataToKDTable();
        if (this.tblMain.getBody().size() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    @Override
    protected void txtEleSearch_focusLost(FocusEvent e) throws Exception {
        super.txtEleSearch_focusLost(e);
        if (StringUtils.isEmpty((String)this.txtEleSearch.getText())) {
            return;
        }
        this.putDataToKDTable();
        if (this.tblMain.getBody().size() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    public void setIsShowName(boolean isShowName) {
        this.isShowName = isShowName;
    }
}

