/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.CommonEntityPanel;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFilterInfoProducer;
import com.kingdee.eas.ma.budget.client.BgBizItemF7Util;
import com.kingdee.eas.ma.budget.client.BgCommonConstant;
import com.kingdee.eas.ma.budget.client.BgEntityProcessor;
import com.kingdee.eas.ma.budget.client.BgEntityTreePromptDialog;
import com.kingdee.eas.ma.budget.client.BgEntityUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class BgEntityFilterPanel
extends KDPanel
implements IFilterPanel {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgEntityFilterPanel");
    private KDTable kdtTable;
    private KDPanel filterButtonPanel;
    private KDWorkButton addRowButton;
    private KDWorkButton delRowButton;
    private KDWorkButton clearButton;
    private FilterInfo filterInfo;
    private EntityObjectInfo entity;
    private String[] filterProperties;
    private IProcessor processor;
    private IPromptBoxFactory promptBoxFactory;
    private int width;
    private int height;
    private int defaultRows;
    private boolean extendCondition;
    private String panelName;
    private String filterInfoDesc = null;
    private int[] FILTER_COLUMN_WIDTHs;
    private static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private static final String EXTEND_CONDITION_SIGN = "%";
    private boolean isFilterOnCu = true;

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows, boolean extendCondition) throws BaseCommonQueryClientException {
        this.entity = BgEntityUtil.getEntity(entityPK);
        this.entity.setDefaultLocale(SysContext.getSysContext().getLocale());
        this.filterInfo = filterInfo == null ? null : (FilterInfo)filterInfo.clone();
        this.filterProperties = filterProperties;
        this.processor = processor;
        this.promptBoxFactory = promptBoxFactory;
        this.width = width;
        this.height = height;
        this.defaultRows = defaultRows;
        this.extendCondition = extendCondition;
        this.FILTER_COLUMN_WIDTHs = this.calculateWidths();
        if (processor != null) {
            processor.set("COMMON_ENTITY_FILTER_PANEL", (Object)this);
        }
        this.jbInit();
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, 1, false);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, 1);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, null, promptBoxFactory, width, height);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, IProcessor processor) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, processor, null, 540, 400);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, IProcessor processor, int defaultRows) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, processor, null, 540, 400, defaultRows);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, IProcessor processor, int defaultRows, boolean extendCondition) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, processor, null, 540, 400, defaultRows, extendCondition);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, promptBoxFactory, 540, 400);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory, boolean isFilterOnCu) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, promptBoxFactory, 540, 400);
        this.isFilterOnCu = isFilterOnCu;
        this.jbInit();
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, null, 540, 400);
    }

    public BgEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, null, width, height);
    }

    private int[] calculateWidths() {
        int unit = (this.width - 8 - 8) / 5;
        return new int[]{unit / 2, unit, unit, unit, unit / 2, unit - 45};
    }

    private void jbInit() throws BaseCommonQueryClientException {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"addRow"));
        this.addRowButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgEntityFilterPanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.addRowButton);
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"removeRow"));
        this.delRowButton.setBounds(this.width - 8 - 22 - 3 - 22, 3, 22, 19);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgEntityFilterPanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"clear"));
        this.clearButton.setBounds(this.width - 8 - 22, 3, 22, 19);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgEntityFilterPanel.this.clearButton_actionPerformed(e);
            }
        });
        this.add((Component)this.clearButton);
        this.kdtTable = new KDTable();
        this.initTable();
        this.kdtTable.setBounds(8, 23, this.width - 8 - 8, this.height - 19 - 1 - 3);
        this.add((Component)this.kdtTable);
    }

    private void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    BgEntityFilterPanel.this.kdtTable_editStarting(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    BgEntityFilterPanel.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgEntityFilterPanel.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void kdtTable_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(3);
                if (currentCell.getEditor() != null) {
                    Component editor = currentCell.getEditor().getComponent();
                    if (this.processor != null && !currentCell.getStyleAttributes().isLocked()) {
                        String condition = BgEntityUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
                        BgEntityProcessor BgEntityProcessor2 = (BgEntityProcessor)this.processor;
                        BgEntityProcessor2.prepareEditor(this.entity, condition, editor);
                    }
                }
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void initTable() throws BaseCommonQueryClientException {
        int columnSize = BgCommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setWidth(this.FILTER_COLUMN_WIDTHs[i]);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)commonEntityFilterRes, (String)BgCommonConstant.FILTER_COLUMN_CODEs[i]));
        }
        this.fillFilterTableBody();
        this.addTableListener();
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
    }

    private void fillLeftRows() {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.kdtTable.addRow();
            }
        }
    }

    private void fillFilterTableBody() throws BaseCommonQueryClientException {
        int filterSize;
        if (this.filterInfo != null && (filterSize = this.filterInfo.getFilterItems().size()) > 0) {
            if (!this.extendCondition) {
                this.checkFilters();
            }
            ArrayList rowInfos = BgEntityUtil.getRowInfos(this.filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowObject = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                this.kdtTable.addRow(i);
                rowObject.setLeftBracket(rowObject.getLeftBracket());
                rowObject.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null) {
                    rowObject.setCompare(filterItemInfo.getCompareType().getName());
                    EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, filterItemInfo.getPropertyName());
                    if (BgEntityUtil.isDate(targetEntity, BgEntityUtil.getPropertyName(filterItemInfo.getPropertyName()))) {
                        if (filterItemInfo.getCompareValue() instanceof Date) {
                            rowObject.setCompareValue(filterItemInfo.getCompareValue());
                        } else {
                            try {
                                rowObject.setCompareValue((Object)DateTimeUtils.parseDate((String)filterItemInfo.getCompareValue().toString()));
                            }
                            catch (ParseException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    } else {
                        rowObject.setCompareValue(filterItemInfo.getCompareValue());
                    }
                } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                    String compare = filterItemInfo.getCompareType().getName();
                    if (compare.equalsIgnoreCase("=")) {
                        compare = "IS";
                    }
                    if (compare.equalsIgnoreCase("<>")) {
                        compare = "IS NOT";
                    }
                    rowObject.setCompare(compare);
                    rowObject.setCompareValue(null);
                }
                rowObject.setRightBracket(rowObject.getRightBracket());
                rowObject.setLogic(rowObject.getLogic());
                this.loadFilter(i, rowObject);
            }
        }
    }

    private void checkFilters() {
        int filterSize = this.filterInfo.getFilterItems().size();
        if (this.filterProperties != null && this.filterProperties.length > 0) {
            for (int i = 0; i < filterSize; ++i) {
                int length = this.filterProperties.length;
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                boolean flag = true;
                for (int j = 0; j < length; ++j) {
                    if (!this.filterProperties[j].toLowerCase().equalsIgnoreCase(currentField.toLowerCase())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntityFilterRes, (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < filterSize; ++i) {
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                if (BgEntityUtil.getEntityPropertyAlias(this.entity, currentField) != null) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntityFilterRes, (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        }
    }

    private KDPromptBox getEntityTreePromptBox() {
        KDPromptBox entityTreePromptBox = new KDPromptBox();
        Window window = null;
        CommonEntityPanel commonEntityPanel = (CommonEntityPanel)BgEntityUtil.getComponent((Component)((Object)this), CommonEntityPanel.class.getName());
        if (window == null) {
            window = BgEntityUtil.getWindow((Component)this.kdtTable);
        }
        BgEntityTreePromptDialog entityTreePromptDialog = null;
        entityTreePromptDialog = window instanceof Frame ? new BgEntityTreePromptDialog((Frame)window, BgEntityUtil.getEntityAlias(this.entity), this.entity, this.filterProperties) : (window instanceof Dialog ? new BgEntityTreePromptDialog((Dialog)window, BgEntityUtil.getEntityAlias(this.entity), this.entity, this.filterProperties) : new BgEntityTreePromptDialog((Frame)null, this.entity.getAlias(), this.entity, this.filterProperties));
        if (this.extendCondition) {
            entityTreePromptBox.setEditable(true);
        }
        entityTreePromptBox.setSelector((KDPromptSelector)entityTreePromptDialog);
        return entityTreePromptBox;
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 0, LeftBracketSignEnum.class.getName(), rowObject.getLeftBracket());
    }

    private void loadCondition(int rowIndex, RowObject rowObject) {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            if (strCondition.indexOf(EXTEND_CONDITION_SIGN) != -1) {
                this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)strCondition);
            } else {
                DataObject dataObject = new DataObject();
                dataObject.setName(BgEntityUtil.getEntityPropertyAlias(this.entity, rowObject.getCondition()));
                dataObject.setValue(strCondition);
                this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)dataObject);
            }
        }
    }

    private void removeFieldCompare(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
    }

    private void loadCompareSign(int rowIndex, RowObject rowObject) {
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, rowObject.getCondition());
        String targetProperty = BgEntityUtil.getPropertyName(rowObject.getCondition());
        String compare = rowObject.getCompare();
        if (compare.equalsIgnoreCase(CompareType.NOTLIKE.toString())) {
            if (!rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "NOT LEFT LIKE";
            }
        } else if (compare.equalsIgnoreCase(CompareType.LIKE.toString())) {
            if (rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && !rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "RIGHT LIKE";
            } else if (!rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "LEFT LIKE";
            }
        }
        KDComboBox comboBox = BgEntityUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnum.class.getName(), compare);
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        this.removeFieldCompare(comboBox);
        PropertyInfo propertyInfo = BgEntityUtil.getEntityPropertyByName(targetEntity, targetProperty);
        if (propertyInfo != null && !BgEntityUtil.isString((OwnPropertyInfo)propertyInfo)) {
            comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
            comboBox.removeItem((Object)CompareSignEnum.TODAY);
            comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
            comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
            comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
            comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
            comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
            comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
            comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
            comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
            comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
            comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        }
    }

    private void loadCompareValue(int rowIndex, RowObject rowObject) {
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, rowObject.getCondition());
        String targetProperty = BgEntityUtil.getPropertyName(rowObject.getCondition());
        DataObject dataInfo = BgEntityUtil.getRefMetaData(targetEntity, targetProperty);
        this.setNullSignLocked(rowIndex);
        if (dataInfo != null) {
            if (dataInfo.getName().equalsIgnoreCase(DataType.ENUM.getName())) {
                BgEntityUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), BgEntityUtil.getValue(rowObject.getCompareValue()).toString());
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                BgEntityUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), BgEntityUtil.getValue(rowObject.getCompareValue()).toString());
            } else if (dataInfo.getName().equals(DataType.DATE.getName()) || dataInfo.getName().equals(DataType.TIMESTAMP.getName()) || dataInfo.getName().equals(DataType.TIME.getName())) {
                Date dateValue = BgEntityUtil.getDate((Date)rowObject.getCompareValue(), dataInfo.getName());
                BgEntityUtil.setDateCtrlField(this.kdtTable, rowIndex, 3, dateValue);
                this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)dateValue);
                String format = BgEntityUtil.getTimeFormatForTable(dataInfo.getName());
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setNumberFormat(format);
            } else {
                KDBizPromptBox promptBox = (KDBizPromptBox)BgEntityUtil.getF7(targetProperty, targetEntity, this.promptBoxFactory);
                if (promptBox != null) {
                    FilterInfo filter;
                    EntityViewInfo view = promptBox.getEntityViewInfo();
                    if (view == null) {
                        view = new EntityViewInfo();
                    }
                    if ((filter = view.getFilter()) == null) {
                        filter = new FilterInfo();
                    }
                    view.setFilter(filter);
                    BgBizItemF7Util.getOrgViewInfo(view, targetEntity.getFullName(), null);
                    promptBox.setEntityViewInfo(view);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    Object f7Data = rowObject.getCompareValue();
                    promptBox.setData(f7Data);
                    this.kdtTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    if (promptBox.getQueryInfo() != null && !StringUtils.isEmpty((String)promptBox.getQueryInfo())) {
                        this.kdtTable.getRow(rowIndex).getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
                    }
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(f7Data);
                } else {
                    Object compareValue = rowObject.getCompareValue();
                    Object sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
                    if (CompareSignEnum.LIKESIGN.equals(sign)) {
                        compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
                    } else if (CompareSignEnum.LEFTLIKESIGN.equals(sign)) {
                        compareValue = compareValue.toString().substring(0, compareValue.toString().length() - 1);
                    } else if (CompareSignEnum.RIGHTLIKESIGN.equals(sign)) {
                        compareValue = compareValue.toString().substring(1, compareValue.toString().length());
                    }
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(compareValue);
                }
            }
        } else {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
        if (this.isNullSign(rowObject.getCompare())) {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
    }

    private boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    private void loadRightBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 4, RightBracketSignEnum.class.getName(), rowObject.getRightBracket());
    }

    private void loadLogicSign(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 5, LogicSignEnum.class.getName(), rowObject.getLogic());
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = BgCommonConstant.FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    private void increaseRow(KDTEditEvent e) {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private boolean isBlankRow(int rowIndex) {
        int columnSize = BgCommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            if (BgEntityUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
            if (object instanceof DataObject) {
                this.processCompareSignCell(rowIndex);
                this.processCompareValueCell(rowIndex);
            } else {
                this.kdtTable.getRow(rowIndex).getCell(3).setEditor(null);
            }
        }
    }

    private void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        String targetProperty;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        String conditonValue = BgEntityUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, conditonValue);
        DataObject dataType = BgEntityUtil.getRefMetaData(targetEntity, targetProperty = BgEntityUtil.getPropertyName(conditonValue));
        if (dataType != null) {
            if (dataType.getName().equalsIgnoreCase(DataType.ENUM.getName())) {
                return;
            }
            if (dataType.getName().equalsIgnoreCase(DataType.DATE.getName()) || dataType.getName().equalsIgnoreCase(DataType.TIME.getName()) || dataType.getName().equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
                return;
            }
            if (dataType.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                return;
            }
            if (dataType.getName().equalsIgnoreCase(DataType.SHORT.getName()) || dataType.getName().equalsIgnoreCase(DataType.INTEGER.getName()) || dataType.getName().equalsIgnoreCase(DataType.LONG.getName()) || dataType.getName().equalsIgnoreCase(DataType.FLOAT.getName()) || dataType.getName().equalsIgnoreCase(DataType.DOUBLE.getName()) || dataType.getName().equalsIgnoreCase(DataType.DECIMAL.getName())) {
                String numberValue = null;
                ICellEditor editor = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
                if (editor != null) {
                    KDBizPromptBox f7PromptBox = (KDBizPromptBox)editor.getComponent();
                    Object value = f7PromptBox.getData();
                    if (value == null) {
                        return;
                    }
                    if (value instanceof String) {
                        numberValue = (String)value;
                    } else if (value instanceof DataObject) {
                        numberValue = ((DataObject)value).getValue();
                    } else if (value instanceof IObjectValue) {
                        value = BgEntityUtil.getBizData((IObjectValue)value);
                        f7PromptBox.setData(value);
                        numberValue = f7PromptBox.getEditFormatter().valueToString(value);
                    } else if (value instanceof Float) {
                        numberValue = value.toString();
                    } else if (value instanceof Integer) {
                        numberValue = value.toString();
                    }
                    if (this.checkFilterData(numberValue, dataType.getName())) {
                        MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"compareValueWarning"));
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                        return;
                    }
                    dataObject.setValue(numberValue);
                    dataObject.setName(numberValue);
                    this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)numberValue);
                }
            } else {
                ICellEditor editor = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
                if (editor != null) {
                    KDBizPromptBox promptBox = (KDBizPromptBox)this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                    Object objData = promptBox.getData();
                    if (objData == null) {
                        return;
                    }
                    if (objData instanceof String) {
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)((String)objData));
                        return;
                    }
                    if (objData instanceof DataObject) {
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                    } else if (objData instanceof IObjectValue) {
                        IObjectValue bizObject = (IObjectValue)objData;
                        bizObject = BgEntityUtil.getBizData(bizObject);
                        promptBox.setData((Object)bizObject);
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)promptBox.getEditFormatter().valueToString((Object)bizObject));
                        return;
                    }
                }
            }
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 1) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(3));
            }
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            return;
        }
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.setNullSignLocked(rowIndex);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void setNullSignLocked(int rowIndex) {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null) {
            String filter_compare_sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue().toString();
            if (filter_compare_sign.equals(CompareSignDateEnum.NULLSIGN.toString()) || filter_compare_sign.equals(CompareSignDateEnum.NOTNULLSIGN.toString())) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else {
                iCell.getStyleAttributes().setLocked(false);
            }
        }
    }

    private boolean checkFilterData(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void processCompareSignCell(int rowIndex) throws Exception {
        KDComboBox comboBox;
        String targetProperty;
        String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, value);
        if (targetEntity.getPropertyByName(targetProperty = BgEntityUtil.getPropertyName(value)) instanceof OwnPropertyInfo && !BgEntityUtil.isString((OwnPropertyInfo)targetEntity.getPropertyByName(targetProperty))) {
            if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null) {
                KDComboBox comboBox2 = (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(2).getEditor().getComponent();
                this.removeFieldCompare(comboBox2);
                if (BgEntityUtil.hasLikeCompare(comboBox2)) {
                    comboBox2.removeItem((Object)CompareSignEnum.LIKESIGN);
                    comboBox2.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
                    comboBox2.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
                    comboBox2.removeItem((Object)CompareSignEnum.YESTERDAY);
                    comboBox2.removeItem((Object)CompareSignEnum.TODAY);
                    comboBox2.removeItem((Object)CompareSignEnum.TOMORROW);
                    comboBox2.removeItem((Object)CompareSignEnum.LASTWEEK);
                    comboBox2.removeItem((Object)CompareSignEnum.THISWEEK);
                    comboBox2.removeItem((Object)CompareSignEnum.NEXTWEEK);
                    comboBox2.removeItem((Object)CompareSignEnum.LASTMONTH);
                    comboBox2.removeItem((Object)CompareSignEnum.THISMONTH);
                    comboBox2.removeItem((Object)CompareSignEnum.NEXTMONTH);
                    comboBox2.removeItem((Object)CompareSignEnum.BEFORETODAY);
                    comboBox2.removeItem((Object)CompareSignEnum.AFTERTODAY);
                    comboBox2.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
                    comboBox2.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
                    comboBox2.setSelectedIndex(0);
                    this.kdtTable.getRow(rowIndex).getCell(2).setValue(null);
                }
            } else {
                KDComboBox comboBox3 = BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, 2, BgEntityUtil.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
                comboBox3.removeItem((Object)CompareSignEnum.INCLUDESIGN);
                comboBox3.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
                comboBox3.removeItem((Object)CompareSignEnum.LIKESIGN);
                comboBox3.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
                comboBox3.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
                comboBox3.removeItem((Object)CompareSignEnum.YESTERDAY);
                comboBox3.removeItem((Object)CompareSignEnum.TODAY);
                comboBox3.removeItem((Object)CompareSignEnum.TOMORROW);
                comboBox3.removeItem((Object)CompareSignEnum.LASTWEEK);
                comboBox3.removeItem((Object)CompareSignEnum.THISWEEK);
                comboBox3.removeItem((Object)CompareSignEnum.NEXTWEEK);
                comboBox3.removeItem((Object)CompareSignEnum.LASTMONTH);
                comboBox3.removeItem((Object)CompareSignEnum.THISMONTH);
                comboBox3.removeItem((Object)CompareSignEnum.NEXTMONTH);
                comboBox3.removeItem((Object)CompareSignEnum.BEFORETODAY);
                comboBox3.removeItem((Object)CompareSignEnum.AFTERTODAY);
                comboBox3.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
                comboBox3.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
                this.removeFieldCompare(comboBox3);
            }
        } else if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null && !BgEntityUtil.hasLikeCompare(comboBox = (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(2).getEditor().getComponent())) {
            comboBox.addItem((Object)CompareSignEnum.LIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.NOTLIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.LEFTLIKESIGN);
            comboBox.addItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        }
    }

    private void processCompareValueCell(int rowIndex) {
        String targetProperty;
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        String propertyValue = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, propertyValue);
        DataObject dataObject = BgEntityUtil.getRefMetaData(targetEntity, targetProperty = BgEntityUtil.getPropertyName(propertyValue));
        if (dataObject != null) {
            String type = dataObject.getName();
            if (type.equalsIgnoreCase(DataType.ENUM.getName())) {
                String enumClassName = dataObject.getValue();
                Object[] _enum = EnumUtils.getEnumList((String)enumClassName).toArray();
                BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, 3, BgEntityUtil.addObjectToArray(_enum, null));
                iCell.setValue(null);
            } else if (type.equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                String enumClassName = dataObject.getValue();
                Object[] _enum = EnumUtils.getEnumList((String)enumClassName).toArray();
                BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, 3, BgEntityUtil.addObjectToArray(_enum, null));
                iCell.setValue(null);
            } else if (type.equalsIgnoreCase(DataType.DATE.getName()) || type.equalsIgnoreCase(DataType.TIME.getName()) || type.equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
                String format = BgEntityUtil.getTimeFormatForTable(type);
                BgEntityUtil.setDateCtrlField(this.kdtTable, rowIndex, 3, BgEntityUtil.getDate(new Date(), type));
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.setValue(null);
            } else if (propertyValue.indexOf(".") == -1) {
                this.resetCell(iCell);
            } else {
                if (propertyValue.equals("bank.number") && targetEntity.getFullName().equals("com.kingdee.eas.basedata.assistant.app.Bank")) {
                    KDBizPromptBox prmtBox = new KDBizPromptBox();
                    prmtBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.BankQuery");
                    prmtBox.setCommitFormat("$number$");
                    prmtBox.setEditFormat("$number$");
                    prmtBox.setDisplayFormat("$name$");
                    prmtBox.setEnabledMultiSelection(true);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
                    prmtBox.setEntityViewInfo(view);
                    iCell.getStyleAttributes().setNumberFormat("");
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.getStyleAttributes().setNumberFormat("");
                    return;
                }
                if (propertyValue.equals("entries.assistRecords.assGrp.adminOrg.number") && targetEntity.getFullName().equals("com.kingdee.eas.basedata.org.app.AdminOrgUnit")) {
                    KDBizPromptBox prmtBox = new KDBizPromptBox();
                    prmtBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminItemQuery");
                    prmtBox.setCommitFormat("$number$");
                    prmtBox.setEditFormat("$number$");
                    prmtBox.setDisplayFormat("$name$");
                    prmtBox.setEnabledMultiSelection(true);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    BgBizItemF7Util.getOrgViewInfo(view, "com.kingdee.eas.basedata.org.app.AdminItemQuery", "entries.assistRecords.assGrp.adminOrg.number");
                    prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
                    prmtBox.setEntityViewInfo(view);
                    iCell.getStyleAttributes().setNumberFormat("");
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.getStyleAttributes().setNumberFormat("");
                    return;
                }
                if (propertyValue.equals("entries.assistRecords.assGrp.costOrg.number") && targetEntity.getFullName().equals("com.kingdee.eas.basedata.org.app.CostCenterOrgUnit")) {
                    KDBizPromptBox prmtBox = new KDBizPromptBox();
                    prmtBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
                    prmtBox.setCommitFormat("$number$");
                    prmtBox.setEditFormat("$number$");
                    prmtBox.setDisplayFormat("$name$");
                    prmtBox.setEnabledMultiSelection(true);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    BgBizItemF7Util.getOrgViewInfo(view, "com.kingdee.eas.basedata.org.app.CostCenterItemQuery", "entries.assistRecords.assGrp.costOrg.number");
                    prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
                    prmtBox.setEntityViewInfo(view);
                    iCell.getStyleAttributes().setNumberFormat("");
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.getStyleAttributes().setNumberFormat("");
                    return;
                }
                EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(dataObject.getValue());
                KDPromptBox f7 = BgEntityUtil.getF7(BgEntityUtil.getPropertyName(propertyValue), entityObjectInfo, this.promptBoxFactory);
                if (f7 == null) {
                    this.resetCell(iCell);
                } else {
                    DataObject _value;
                    FilterInfo filter;
                    EntityViewInfo view = ((KDBizPromptBox)f7).getEntityViewInfo();
                    if (view == null) {
                        view = new EntityViewInfo();
                    }
                    if ((filter = view.getFilter()) == null) {
                        filter = new FilterInfo();
                    }
                    view.setFilter(filter);
                    BgBizItemF7Util.getOrgViewInfo(view, targetEntity.getFullName(), propertyValue);
                    ((KDBizPromptBox)f7).setEntityViewInfo(view);
                    this.resetCell(iCell);
                    if (((KDBizPromptBox)f7).getQueryInfo() == null || "".equals(((KDBizPromptBox)f7).getQueryInfo())) {
                        return;
                    }
                    this.resetCell(iCell);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    ICell _BgCell = this.kdtTable.getRow(rowIndex).getCell(1);
                    Object value = _BgCell.getValue();
                    if (value != null && value instanceof DataObject && (_value = (DataObject)value).getValue() != null && (_value.getValue().equalsIgnoreCase("entries.assistRecords.maCtrlAmount") || _value.getValue().equalsIgnoreCase("entries.assistRecords.originalAmount"))) {
                        iCell.setEditor(null);
                    }
                }
            }
        } else {
            this.resetCell(iCell);
        }
    }

    private void resetCell(ICell cell) {
        cell.setEditor(null);
        cell.setValue(null);
        if (cell.getStyleAttributes() != null) {
            cell.getStyleAttributes().setNumberFormat("");
        }
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"delWarning"));
        } else {
            this.delRow();
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    private boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = BgCommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kdtTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = BgEntityUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (compareSign.equalsIgnoreCase("YESTERDAY") || compareSign.equalsIgnoreCase("TODAY") || compareSign.equalsIgnoreCase("TOMORROW") || compareSign.equalsIgnoreCase("LASTWEEK") || compareSign.equalsIgnoreCase("THISWEEK") || compareSign.equalsIgnoreCase("NEXTWEEK") || compareSign.equalsIgnoreCase("LASTMONTH") || compareSign.equalsIgnoreCase("THISMONTH") || compareSign.equalsIgnoreCase("NEXTMONTH") || compareSign.equalsIgnoreCase("BEFORETODAY") || compareSign.equalsIgnoreCase("AFTERTODAY") || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kdtTable.getRow(rowIndex).getCell(3).getValue() != null) continue;
                    continue;
                }
                return true;
            }
            String strFilterValue = filterValue.toString();
            if (strFilterValue == null) {
                return true;
            }
            if (!strFilterValue.trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    private boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    private void addRow() {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        this.kdtTable.removeRows();
    }

    private void setLeftBracketCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BgEntityUtil.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setConditionCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox());
        this.kdtTable.getRow(rowIndex).getCell(1).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    private void setCompareSignCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
                KDComboBox comboBox = BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BgEntityUtil.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
                comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
                comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
                comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
                comboBox.removeItem((Object)CompareSignEnum.TODAY);
                comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
                comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
                comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
                comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
                comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
                comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
                comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
                comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
                comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
                this.removeFieldCompare(comboBox);
            }
        }
    }

    private void setCompareValueCell(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
            this.setNullSignLocked(rowIndex);
            if (currentCell.getEditor() != null) {
                Component editor = currentCell.getEditor().getComponent();
                if (editor instanceof KDDatePicker && currentCell.getValue() == null) {
                    currentCell.setValue((Object)new Date());
                }
                if (editor instanceof KDPromptBox) {
                    KDBizPromptBox f7Editor = (KDBizPromptBox)editor;
                    String strCompare = BgEntityUtil.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                    if (!strCompare.equalsIgnoreCase("")) {
                        CompareSignEnum signEnum = CompareSignEnum.getEnum((String)strCompare.toUpperCase());
                        if (BgEntityUtil.isIncludeCompare(signEnum)) {
                            f7Editor.setEnabledMultiSelection(true);
                        } else {
                            try {
                                f7Editor.setEnabledMultiSelection(false);
                            }
                            catch (Exception ex) {
                                logger.error((Object)"budget error:", (Throwable)ex);
                            }
                        }
                    }
                }
            }
        }
    }

    private void setRightBracketCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BgEntityUtil.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setLogicSignCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            BgEntityUtil.setComboBoxField(this.kdtTable, rowIndex, columnIndex, BgEntityUtil.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 0: {
                    this.setLeftBracketCell(e);
                    break;
                }
                case 1: {
                    this.setConditionCell(e);
                    break;
                }
                case 2: {
                    this.setCompareSignCell(e);
                    break;
                }
                case 3: {
                    this.setCompareValueCell(e);
                    break;
                }
                case 4: {
                    this.setRightBracketCell(e);
                    break;
                }
                case 5: {
                    this.setLogicSignCell(e);
                    break;
                }
            }
        }
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i) || !this.checkCurrentHasBlankCol(i)) continue;
            return true;
        }
        return false;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)commonEntityFilterRes, (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kdtTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = null;
            object = this.kdtTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kdtTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)object) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)commonEntityFilterRes, (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    private void setCurrentFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = BgEntityUtil.getValue(iRow.getCell(0).getValue()).toString();
                String condition = BgEntityUtil.getValue(iRow.getCell(1).getValue()).toString();
                String compare = BgEntityUtil.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
                Object compareValue = null;
                if (iRow.getCell(3).getEditor() != null && iRow.getCell(3).getEditor().getComponent() != null) {
                    Object f7Data;
                    KDBizPromptBox promptBox;
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (obj instanceof KDBizPromptBox) {
                        promptBox = (KDBizPromptBox)obj;
                        f7Data = promptBox.getData();
                        if (f7Data instanceof String) {
                            compareValue = (String)f7Data;
                        } else if (f7Data instanceof DataObject) {
                            compareValue = ((DataObject)f7Data).getValue();
                        } else if (f7Data instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)f7Data;
                            compareValue = BgEntityUtil.getValue(objectValue.get(BgEntityUtil.getPropertyName(condition)));
                        } else if (f7Data instanceof Object[]) {
                            compareValue = promptBox.getEditFormatter().valueToString(f7Data);
                        } else if (f7Data instanceof Float) {
                            compareValue = f7Data;
                        } else if (f7Data instanceof Integer) {
                            compareValue = f7Data;
                        }
                    } else if (obj instanceof KDComboBox) {
                        promptBox = (KDComboBox)obj;
                        f7Data = promptBox.getSelectedItem();
                        if (f7Data != null && !"".equals(f7Data.toString())) {
                            BizEnumInfo _enum = BgEntityUtil.getEnum(f7Data.getClass().getName());
                            if (_enum.getDataType().equals((Object)BizEnumValueType.STRING)) {
                                compareValue = _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue().toString();
                            } else if (_enum.getDataType().equals((Object)BizEnumValueType.INTEGER) || _enum.getDataType().equals((Object)BizEnumValueType.FLOAT) || _enum.getDataType().equals((Object)BizEnumValueType.LONG) || _enum.getDataType().equals((Object)BizEnumValueType.DOUBLE)) {
                                compareValue = _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue();
                                compareValue = compareValue.toString().indexOf(".") >= 0 ? (Number)new Float(compareValue.toString()) : (Number)new Integer(compareValue.toString());
                            }
                        }
                    } else {
                        compareValue = BgEntityUtil.getValue(iRow.getCell(3).getValue());
                        if (compareValue instanceof Date) {
                            EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, condition);
                            String targetProperty = BgEntityUtil.getPropertyName(condition);
                            String dateType = BgEntityUtil.getRefMetaData(targetEntity, targetProperty).getName();
                            compareValue = BgEntityUtil.getDate((Date)compareValue, dateType);
                        }
                    }
                } else {
                    compareValue = BgEntityUtil.getValue(iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, condition);
                        String targetProperty = BgEntityUtil.getPropertyName(condition);
                        String dateType = BgEntityUtil.getRefMetaData(targetEntity, targetProperty).getName();
                        compareValue = BgEntityUtil.getDate((Date)compareValue, dateType);
                    }
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NULLSIGN) {
                    compareValue = null;
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NOTNULLSIGN) {
                    compareValue = null;
                }
                String rightBracket = BgEntityUtil.getValue(iRow.getCell(4).getValue()).toString();
                String logic = BgEntityUtil.getValue(iRow.getCell(5).getValue()).toString().toLowerCase();
                CompareSignEnum compareSignEnum = CompareSignEnum.getEnum((String)compare.toUpperCase());
                if (BgEntityUtil.isIncludeCompare(compareSignEnum)) {
                    if (compareValue != null) {
                        FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)BgEntityUtil.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(includeFilter);
                    }
                } else if (condition != null && !"".equals(condition.trim().toString())) {
                    String targetProperty;
                    EntityObjectInfo targetEntity = BgEntityUtil.getEntity(this.entity, condition);
                    DataObject dataInfo = BgEntityUtil.getRefMetaData(targetEntity, targetProperty = BgEntityUtil.getPropertyName(condition));
                    if (dataInfo == null) {
                        String filterCond = EASResource.getString((String)commonEntityFilterRes, (String)"filterCond");
                        String notExsit = EASResource.getString((String)commonEntityFilterRes, (String)"notExsit");
                        MsgBox.showError((Component)((Object)this), (String)(filterCond + "\"" + targetProperty + "\"" + notExsit));
                        SysUtil.abort();
                    }
                    FilterItemInfo filterItemInfo = null;
                    if (dataInfo != null && (dataInfo.getName().equals(DataType.SHORT.getName()) || dataInfo.getName().equals(DataType.INTEGER.getName()) || dataInfo.getName().equals(DataType.LONG.getName()) || dataInfo.getName().equals(DataType.FLOAT.getName()) || dataInfo.getName().equals(DataType.DOUBLE.getName()) || dataInfo.getName().equals(DataType.DECIMAL.getName()))) {
                        if (compare.equalsIgnoreCase("IS")) {
                            compareValue = null;
                            compare = "=";
                        } else if (compare.equalsIgnoreCase("IS NOT")) {
                            compareValue = null;
                            compare = "<>";
                        } else if (compareValue != null && compareValue.toString().indexOf(".") >= 0) {
                            compareValue = new Float(compareValue.toString());
                        } else {
                            try {
                                if (compareValue != null) {
                                    compareValue = new Integer(compareValue.toString());
                                }
                            }
                            catch (NumberFormatException e) {
                                this.kdtTable.requestFocusInWindow();
                                throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonQueryPanel", (String)"SolutionDefineError"));
                            }
                        }
                        filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    } else {
                        if (CompareType.LIKE.toString().equalsIgnoreCase(compare) || CompareType.NOTLIKE.toString().equalsIgnoreCase(compare)) {
                            if (compareValue != null) {
                                compareValue = EXTEND_CONDITION_SIGN + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + EXTEND_CONDITION_SIGN;
                            }
                        } else if ("LEFT LIKE".equalsIgnoreCase(compare)) {
                            if (compareValue != null) {
                                compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + EXTEND_CONDITION_SIGN;
                            }
                            compare = CompareType.LIKE.toString();
                        } else if ("RIGHT LIKE".equalsIgnoreCase(compare)) {
                            if (compareValue != null) {
                                compareValue = EXTEND_CONDITION_SIGN + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "");
                            }
                            compare = CompareType.LIKE.toString();
                        } else if ("NOT LEFT LIKE".equalsIgnoreCase(compare)) {
                            if (compareValue != null) {
                                compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + EXTEND_CONDITION_SIGN;
                            }
                            compare = CompareType.NOTLIKE.toString();
                        } else if (compare.equalsIgnoreCase("IS")) {
                            compareValue = null;
                            compare = "=";
                        } else if (compare.equalsIgnoreCase("IS NOT")) {
                            compareValue = null;
                            compare = "<>";
                        }
                        filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    }
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                }
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
        this.setCurrentFilterInfoDesc();
    }

    private void setCurrentFilterInfoDesc() {
        int rowCount = this.kdtTable.getRowCount();
        StringBuffer filterDesc = new StringBuffer();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = iRow.getCell(0).getValue() != null ? iRow.getCell(0).getValue().toString() : "";
                String condition = iRow.getCell(1).getValue() != null ? iRow.getCell(1).getValue().toString() + " " : "";
                String compare = iRow.getCell(2).getValue() != null ? iRow.getCell(2).getValue().toString() + " " : "";
                String compareValue = iRow.getCell(3).getValue() != null ? iRow.getCell(3).getValue().toString() + " " : "";
                String rightBracket = iRow.getCell(4).getValue() != null ? iRow.getCell(4).getValue().toString() : "";
                String logic = iRow.getCell(5).getValue() != null ? iRow.getCell(5).getValue().toString() : "";
                filterDesc.append(leftBracket).append(condition).append(compare).append(compareValue).append(rightBracket).append(logic);
            }
        }
        this.filterInfoDesc = filterDesc.toString();
    }

    public FilterInfo getFilterInfo() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }

    public String getFilterInfoDesc() {
        return this.filterInfoDesc;
    }

    public boolean verify() {
        boolean flag = true;
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return flag;
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    public KDWorkButton getAddRowButton() {
        return this.addRowButton;
    }

    public KDWorkButton getClearButton() {
        return this.clearButton;
    }

    public KDWorkButton getDelRowButton() {
        return this.delRowButton;
    }

    public KDPanel getFilterButtonPanel() {
        return this.filterButtonPanel;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    public void clear() {
        this.clearTable();
        this.fillLeftRows();
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public FilterInfo getInnerFilterInfo() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }
}

