/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgExamineCollection;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.BgExamineGroupInfo;
import com.kingdee.eas.ma.budget.BgExamineInfo;
import com.kingdee.eas.ma.budget.BgExamineNoPassEnum;
import com.kingdee.eas.ma.budget.BgExamineTypeEnum;
import com.kingdee.eas.ma.budget.IBgExamine;
import com.kingdee.eas.ma.budget.client.AbstractBgExamineEditUI;
import com.kingdee.eas.ma.budget.client.BgExamineFormulaUI;
import com.kingdee.eas.ma.budget.client.BgExamineImportTemplateUI;
import com.kingdee.eas.ma.budget.client.BgExamineItemF7Dialog;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgExamineEditUI
extends AbstractBgExamineEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgExamineEditUI.class);
    private BgExamineGroupInfo groupInfo = null;
    private Vector exprformulas = null;
    private boolean examineFormulas = false;
    private int equalcount = 0;
    private int moreequalcount = 0;
    private int lessequalcount = 0;
    private int morecount = 0;
    private int lesscount = 0;
    private FullOrgUnitInfo orgUnitInfo = null;
    private StringBuffer oldValueS = new StringBuffer();
    private static final int PRECISION = 6;

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgUnitInfo = (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit();
        this.groupInfo = (BgExamineGroupInfo)this.getUIContext().get("groupInfo");
        if (this.groupInfo != null && this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setExamineGroup(this.groupInfo);
        }
        this.kDBRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.kDBBgItem.setIcon(EASResource.getIcon((String)"imgTbtn_importformulaguide"));
        this.KDBgItemByForm.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.KDBBgAcct.setIcon(EASResource.getIcon((String)"imgTbtn_getnumber"));
        this.kdtErrorData.setPrecision(6);
        this.btnFirst.setVisible(false);
        this.btnFirst.setEnabled(false);
        this.actionFirst.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnNext.setEnabled(false);
        this.actionNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnLast.setEnabled(false);
        this.actionLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPre.setEnabled(false);
        this.actionPre.setVisible(false);
        this.menuView.setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.kDBBgItem.setEnabled(true);
            this.KDBgItemByForm.setEnabled(true);
            this.KDBBgAcct.setEnabled(true);
            this.kDJia.setEnabled(true);
            this.kDJian.setEnabled(true);
            this.KDCheng.setEnabled(true);
            this.kDChu.setEnabled(true);
            this.kDDeng.setEnabled(true);
            this.kDBuDeng.setEnabled(true);
            this.KDDaYu.setEnabled(true);
            this.kDXiaoYu.setEnabled(true);
            this.kdtErrorData.setText("0");
            this.kdbNoPass.setEnabled(true);
            this.kdbAddExplain.setEnabled(true);
            this.kdbOnlyShowMess.setEnabled(true);
            this.txtHint.setEditable(true);
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.kDBBgItem.setEnabled(true);
            this.kDBBgItem.setVisible(true);
            this.KDBgItemByForm.setEnabled(true);
            this.KDBgItemByForm.setVisible(true);
            this.KDBBgAcct.setEnabled(true);
            this.kDJia.setEnabled(true);
            this.kDJian.setEnabled(true);
            this.KDCheng.setEnabled(true);
            this.kDChu.setEnabled(true);
            this.kDDeng.setEnabled(true);
            this.kDBuDeng.setEnabled(true);
            this.KDDaYu.setEnabled(true);
            this.kDXiaoYu.setEnabled(true);
            this.kdbNoPass.setEnabled(true);
            this.kdbAddExplain.setEnabled(true);
            this.kdbOnlyShowMess.setEnabled(true);
            this.txtHint.setEditable(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.kDBBgItem.setEnabled(false);
            this.kDBBgItem.setVisible(true);
            this.kDBRemove.setVisible(true);
            this.kDBRemove.setEnabled(false);
            this.KDBgItemByForm.setEnabled(false);
            this.KDBgItemByForm.setVisible(true);
            this.KDBBgAcct.setEnabled(false);
            this.kDJia.setEnabled(false);
            this.kDJian.setEnabled(false);
            this.KDCheng.setEnabled(false);
            this.kDChu.setEnabled(false);
            this.kDDeng.setEnabled(false);
            this.kDBuDeng.setEnabled(false);
            this.KDDaYu.setEnabled(false);
            this.kDXiaoYu.setEnabled(false);
            this.kdbNoPass.setEnabled(false);
            this.kdbAddExplain.setEnabled(false);
            this.kdbOnlyShowMess.setEnabled(false);
            this.txtHint.setEditable(false);
        }
        if (this.editData.getNoPass() != null) {
            if (this.editData.getNoPass().getValue() == BgExamineNoPassEnum.noSubmit.getValue()) {
                this.kdbNoPass.setSelected(true);
            } else if (this.editData.getNoPass().getValue() == BgExamineNoPassEnum.addPostil.getValue()) {
                this.kdbAddExplain.setSelected(true);
            } else if (this.editData.getNoPass().getValue() == BgExamineNoPassEnum.showErrorMes.getValue()) {
                this.kdbOnlyShowMess.setSelected(true);
            }
        }
    }

    public void setExamineString(Vector examFormulas) {
        int length = 0;
        for (int i = 0; i < examFormulas.size(); ++i) {
            String formula = (String)examFormulas.get(i);
            if (this.kDTFormula.getText().toString() != null && this.kDTFormula.getText().trim().toString().length() != 0) {
                this.kDTFormula.append("+");
                ++length;
            }
            this.kDTFormula.append(formula);
            if (formula == null) continue;
            length += formula.length();
        }
        if (this.kDTFormula.getText() != null) {
            this.kDTFormula.setCaretPosition(this.kDTFormula.getText().length());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFW1.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NumberNull"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText().length() > 80) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"tooLongNum"));
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() == null || this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() == 0) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NameNull"));
            SysUtil.abort();
        } else {
            String name = (String)this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData();
            if (name.length() > 254) {
                this.txtName.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"tooLongName"));
                SysUtil.abort();
            }
        }
        if (this.kDTFormula.getText() == null || this.kDTFormula.getText().trim().length() == 0) {
            this.kDTFormula.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"FormularNull"));
            SysUtil.abort();
        }
        if (this.kDTFormula.getText().length() > 2000) {
            this.kDTFormula.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"tooLongFormular"));
            SysUtil.abort();
        }
        if (this.kdtErrorData.getText() != null && this.kdtErrorData.getText().length() > 11) {
            this.kdtErrorData.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"tooLongErrorData"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        fullOrgUnit.setId(orgUnit.getId());
        BgExamineInfo bgExamineInfo = new BgExamineInfo();
        if (this.groupInfo != null) {
            bgExamineInfo.setExamineGroup(this.groupInfo);
        }
        bgExamineInfo.setOrgUnit(fullOrgUnit);
        bgExamineInfo.setId(BOSUuid.create((BOSObjectType)bgExamineInfo.getBOSType()));
        bgExamineInfo.setIsUse(true);
        bgExamineInfo.setErrorData(BgNConstants.ZERO);
        return bgExamineInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgExamineFactory.getRemoteInstance();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String creatorOrgUnit;
        String currentUserOrgUnit = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (!currentUserOrgUnit.equals(creatorOrgUnit = this.editData.getOrgUnit().getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorOrgUnitNoEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAddBgItemByForm_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBgItemByForm_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", this.getUIContext().get("ID"));
        uiContext.put((Object)"BgExamineEditUI", (Object)((BgExamineEditUI)((Object)uiContext.get((Object)"Owner"))));
        uiContext.put((Object)"EditOrg", (Object)this.orgUnitInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getImportUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private String getImportUIName() {
        return BgExamineImportTemplateUI.class.getName();
    }

    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        BgExamineItemF7Dialog itemF7 = new BgExamineItemF7Dialog();
        itemF7.show();
        String item = (String)itemF7.getData();
        String items = this.kDTFormula.getText();
        if (item != null) {
            if (items == null) {
                this.kDTFormula.setText(item);
                this.kDTFormula.setCaretPosition(item.length());
            } else {
                items = items + item;
                this.kDTFormula.setText(items);
                this.kDTFormula.setCaretPosition(items.length());
            }
        }
    }

    @Override
    public void actionRemoveFormula_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource.isRemoveAll")))) {
            this.kDTFormula.setText(null);
            this.kDTFormula.setCaretPosition(0);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BgExamineCollection col;
        String formulas = null;
        if (this.kDTFormula.getText() != null && this.kDTFormula.getText().trim().length() != 0) {
            this.examineFormulas = false;
            this.equalcount = 0;
            this.moreequalcount = 0;
            this.lessequalcount = 0;
            this.morecount = 0;
            this.lesscount = 0;
            this.verify(this.kDTFormula.getText());
            formulas = this.aliasToFormula(this.kDTFormula.getText());
            formulas = this.verifyop(formulas);
            if (this.equalcount > 1 || this.moreequalcount > 1 || this.lessequalcount > 1 || this.morecount > 1 || this.lesscount > 1) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
                SysUtil.abort();
            }
            if (formulas == null) {
                return;
            }
            formulas = formulas.replace('|', '.');
            this.verifyexaminevector(formulas);
            this.editData.setFormula(formulas);
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
            SysUtil.abort();
        }
        if (!this.examineFormulas) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
            SysUtil.abort();
        }
        if (this.kdbNoPass.isSelected()) {
            this.editData.setNoPass(BgExamineNoPassEnum.noSubmit);
        }
        if (this.kdbAddExplain.isSelected()) {
            this.editData.setNoPass(BgExamineNoPassEnum.addPostil);
        }
        if (this.kdbOnlyShowMess.isSelected()) {
            this.editData.setNoPass(BgExamineNoPassEnum.showErrorMes);
        }
        if (this.kDTFormula.getText().length() > 2000) {
            this.kDTFormula.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"tooLongFormular"));
            SysUtil.abort();
        }
        IBgExamine iBgExamine = BgExamineFactory.getRemoteInstance();
        String id = this.editData.getId().toString();
        int examlength = this.editData.getFormula().length();
        if (examlength > 2000) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"examlong"));
            SysUtil.abort();
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            col = null;
            col = iBgExamine.getBgExamineCollection("where number = '" + this.txtNumber.getText() + "'");
            if (col.size() > 0) {
                MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"num") + this.txtNumber.getText() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"havenum")));
                SysUtil.abort();
            }
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            col = null;
            col = iBgExamine.getBgExamineCollection("where number = '" + this.txtNumber.getText() + "'");
            if (!this.editData.getNumber().equals(this.txtNumber.getText()) && col.size() > 0) {
                MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"num") + this.txtNumber.getText() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"havenum")));
                SysUtil.abort();
            }
        }
        if (this.editData.getCompareValue() == null) {
            this.editData.setCompareValue(BigDecimal.ZERO);
        }
        super.actionSubmit_actionPerformed(e);
        iBgExamine.bgExamineToCitation(formulas, id);
        this.oldValueS = new StringBuffer();
        this.oldValueS.append(this.editData.getNumber());
        this.oldValueS.append(this.editData.getName());
        this.oldValueS.append(this.editData.getFormulaAlias());
        this.oldValueS.append((Object)this.editData.getNoPass());
    }

    private String verifyop(String text) {
        Expression expr = null;
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)text);
            expr = this.walkop(expression);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            return null;
        }
        return expr.toString();
    }

    private Expression walkop(Expression expr) throws Exception {
        if (!(expr instanceof FunctionExpr)) {
            if (expr instanceof BinaryOperationExpr) {
                BinaryOperationExpr bin = (BinaryOperationExpr)expr;
                if (bin.operationType == 10) {
                    ++this.equalcount;
                }
                if (bin.operationType == 111) {
                    ++this.moreequalcount;
                }
                if (bin.operationType == 120) {
                    ++this.lessequalcount;
                }
                if (bin.operationType == 12) {
                    ++this.morecount;
                }
                if (bin.operationType == 102) {
                    ++this.lesscount;
                }
                bin.left = this.walkop(bin.left);
                bin.right = this.walkop(bin.right);
            } else if (expr instanceof UnaryOperationExpr) {
                UnaryOperationExpr bin = (UnaryOperationExpr)expr;
                if (bin.operationType == 3) {
                    try {
                        double kk = Double.parseDouble("" + bin.operand);
                        Expression expression = ExcelFormulaPaserHelper.parse((String)String.valueOf(kk /= 100.0));
                        NumberExpr numexp = (NumberExpr)expression;
                        expr = numexp;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
                        SysUtil.abort();
                    }
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
                    SysUtil.abort();
                }
            }
        }
        return expr;
    }

    private boolean notIsInit(BgExamineInfo info) throws EASBizException, BOSException {
        String createrID = info.getCreator().getId().toString();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return userId.equals(createrID);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String creatorOrgUnit;
        boolean iscreator = this.notIsInit(this.editData);
        if (!iscreator) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorNoEdit"));
            return;
        }
        String currentUserOrgUnit = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (!currentUserOrgUnit.equals(creatorOrgUnit = this.editData.getOrgUnit().getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorOrgUnitNoDelete"));
            return;
        }
        try {
            super.actionRemove_actionPerformed(e);
        }
        catch (ObjectReferedException exc) {
            logger.error((Object)"actionRemove_actionPerformed", (Throwable)exc);
            StringBuffer msg = new StringBuffer();
            BizReference ref = (BizReference)exc.getReferingObject();
            if (ref != null) {
                Object[] objects = new Object[1];
                String locale = SysContext.getSysContext().getLocale().toString();
                objects[0] = ref.getRefEntityAlias(new Locale(locale));
                String template = EASResource.getString((String)"com.kingdee.eas.common.CommonResource", (String)"isReferedError");
                msg.append(MessageFormat.format(template, objects));
            } else {
                msg.append(EASResource.getString((String)"com.kingdee.eas.common.CommonResource", (String)"ReferCheckError"));
            }
            MsgBox.showError((Component)((Object)this), (String)msg.toString());
        }
    }

    private void verifyexaminevector(String text) {
        this.exprformulas = new Vector();
        boolean examinenullerror = false;
        boolean periodError = false;
        try {
            int i;
            Expression expression = ExcelFormulaPaserHelper.parse((String)text);
            this.walkexaminevector(expression);
            if (this.exprformulas.size() == 1) {
                return;
            }
            FormulaHint[] hint = new FormulaHint[this.exprformulas.size()];
            for (int i2 = 0; i2 < this.exprformulas.size(); ++i2) {
                List list = new ArrayList();
                list = TableToolkit.parseFormula((String)("=" + this.exprformulas.elementAt(i2).toString()), (boolean)false);
                hint[i2] = (FormulaHint)list.get(0);
            }
            String[][] params = new String[this.exprformulas.size()][];
            for (int i3 = 0; i3 < this.exprformulas.size(); ++i3) {
                params[i3] = hint[i3].getParams();
                if (hint[i3] == null || hint[i3].text.indexOf("BGBAL") + hint[i3].text.indexOf("BGACTUALS") != -1 || hint[i3].getParams().length != 6 || hint[i3].getParams()[5].equalsIgnoreCase("%")) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
                SysUtil.abort();
                examinenullerror = true;
            }
            periodError = this.verifyPeriod(params);
            boolean[] paramnull = new boolean[6];
            for (i = 0; i < 6; ++i) {
                paramnull[i] = false;
            }
            for (i = 0; i < this.exprformulas.size(); ++i) {
                for (int j = 2; j < 6; ++j) {
                    if (!params[i][j].equals("%")) continue;
                    paramnull[j] = true;
                }
            }
            for (int k = 0; k < 6; ++k) {
                if (!paramnull[k]) continue;
                for (int i4 = 0; i4 < this.exprformulas.size(); ++i4) {
                    if (params[i4][k].equals("%")) continue;
                    examinenullerror = true;
                }
            }
            for (i = 0; i < this.exprformulas.size(); ++i) {
                if (params[i].length != 7 || (params[i][6].equals("%") || !params[i][5].equals("%")) && (params[i][5].equals("%") || !params[i][6].equals("%"))) continue;
                examinenullerror = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        if (examinenullerror || periodError) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"examinenullerror"));
            SysUtil.abort();
        }
    }

    private boolean verifyPeriod(String[][] params) {
        int n = 0;
        int m = 8;
        for (int i = 0; i < params.length; ++i) {
            if (params[i][5].lastIndexOf("%TD") > 0) {
                if (n < 7) {
                    n = 7;
                }
            } else if (params[i][5].lastIndexOf("%MW") > 0) {
                if (n < 6) {
                    n = 6;
                }
            } else if (params[i][5].lastIndexOf("%D") > 0) {
                if (n < 5) {
                    n = 5;
                }
            } else if (params[i][5].lastIndexOf("%M") > 0) {
                if (n < 3) {
                    n = 3;
                }
            } else if (params[i][5].lastIndexOf("%W") > 0) {
                if (n < 4) {
                    n = 4;
                }
            } else if (params[i][5].lastIndexOf("%HY") > 0) {
                if (n < 2) {
                    n = 2;
                }
            } else if (params[i][5].lastIndexOf("%Y") > 0 && n < 1) {
                n = 1;
            }
            if (params[i][5].lastIndexOf("TD") > 0) {
                if (m > 7) {
                    m = 7;
                }
            } else if (params[i][5].lastIndexOf("MW") > 0) {
                if (m > 6) {
                    m = 6;
                }
            } else if (params[i][5].lastIndexOf("D") > 0) {
                if (m > 5) {
                    m = 5;
                }
            } else if (params[i][5].lastIndexOf("M") > 0) {
                if (m > 3) {
                    m = 3;
                }
            } else if (params[i][5].lastIndexOf("W") > 0) {
                if (m > 4) {
                    m = 4;
                }
            } else if (params[i][5].lastIndexOf("HY") > 0) {
                if (m > 2) {
                    m = 2;
                }
            } else if (params[i][5].lastIndexOf("Y") > 0 && m > 1) {
                m = 1;
            }
            if (n <= m) continue;
            return true;
        }
        return false;
    }

    private void walkexaminevector(Expression expr) throws Exception {
        if (expr instanceof FunctionExpr) {
            this.exprformulas.addElement(expr.toString());
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            this.walkexaminevector(bin.left);
            this.walkexaminevector(bin.right);
        } else if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr bin = (UnaryOperationExpr)expr;
            this.walkexaminevector(bin.operand);
        }
    }

    private void verify(String text) {
        boolean formularcorrect = false;
        boolean formularcorrectmoreequal = false;
        boolean formularcorrectlessequal = false;
        boolean formularcorrectmore = false;
        boolean formularcorrectless = false;
        boolean formularcorrectequal = false;
        boolean formularcorrectnotequal = false;
        if (text.indexOf(">=") > 0 && text.indexOf(">=") < text.length() - 1) {
            formularcorrectmoreequal = true;
        }
        if (text.indexOf("<=") > 0 && text.indexOf("<=") < text.length() - 1) {
            formularcorrectlessequal = true;
        }
        if (text.indexOf(">") > 0 && text.indexOf(">") < text.length() - 1) {
            formularcorrectmore = true;
        }
        if (text.indexOf("<") > 0 && text.indexOf("<") < text.length() - 1) {
            formularcorrectless = true;
        }
        if (text.indexOf("=") > 0 && text.indexOf("=") < text.length() - 1) {
            formularcorrectequal = true;
        }
        if (text.indexOf("<>") > 0 && text.indexOf("<>") < text.length() - 1) {
            formularcorrectnotequal = true;
        }
        boolean bl = formularcorrect = formularcorrectmore || formularcorrectless || formularcorrectequal || formularcorrectmoreequal || formularcorrectnotequal || formularcorrectlessequal;
        if (!formularcorrect) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"operatorerror"));
            SysUtil.abort();
            this.kDTFormula.requestFocus();
        } else if (formularcorrect) {
            return;
        }
    }

    private Expression walk(Expression expr) throws Exception {
        String[][] periodType = null;
        Vector allPeriods = new Vector();
        Vector<String> periods = new Vector<String>();
        Vector<Object> reitems = new Vector<Object>();
        if (expr instanceof FunctionExpr) {
            FunctionExpr fun = (FunctionExpr)expr;
            this.examineFormulas = true;
            if (!fun.funcionName.equalsIgnoreCase("bgitem")) {
                for (int i = 0; i < fun.parameters.size(); ++i) {
                    fun.parameters.set(i, this.walk((Expression)fun.parameters.get(i)));
                }
            }
            Expression p5 = (Expression)fun.parameters.get(5);
            String s = ((StringExpr)p5).value;
            if (p5 instanceof StringExpr) {
                StringBuffer sb = new StringBuffer();
                String param = s.toString();
                if (param != null && (param.indexOf(",") > 0 || param.indexOf(":") > 0)) {
                    int n1;
                    String[] periodCom = param.split("\\|");
                    periodType = new String[periodCom.length][];
                    for (int n = 0; n < periodCom.length; ++n) {
                        String type = null;
                        String periodToNum = periodCom[n];
                        if (periodToNum.indexOf("HY") > 0) {
                            type = "HY";
                            periodToNum = periodToNum.substring(0, periodToNum.length() - 2);
                        } else if (periodToNum.indexOf("MW") > 0) {
                            type = "MW";
                            periodToNum = periodToNum.substring(0, periodToNum.length() - 2);
                        } else if (periodToNum.indexOf("TD") > 0) {
                            type = "TD";
                            periodToNum = periodToNum.substring(0, periodToNum.length() - 2);
                        } else {
                            type = periodToNum.substring(periodToNum.length() - 1);
                            periodToNum = periodToNum.substring(0, periodToNum.length() - 1);
                        }
                        if (periodToNum.indexOf(",") > 0 || periodToNum.indexOf(":") > 0) {
                            periodType[n] = periodToNum.split(",");
                            for (int m = 0; m < periodType[n].length; ++m) {
                                if (periodType[n][m].toString().indexOf(":") > 0) {
                                    int begin = 0;
                                    int end = 0;
                                    String[] num = periodType[n][m].split(":");
                                    if (periodType[n][m].toString().indexOf("HY") > 0) {
                                        begin = Integer.valueOf(num[0]);
                                        end = Integer.valueOf(num[1]);
                                    } else {
                                        begin = Integer.valueOf(num[0]);
                                        end = Integer.valueOf(num[1]);
                                    }
                                    while (begin <= end) {
                                        periods.addElement(begin + type);
                                        ++begin;
                                    }
                                    continue;
                                }
                                periods.addElement(periodType[n][m] + type);
                            }
                        } else {
                            periods.addElement(periodCom[n]);
                        }
                        allPeriods.addElement(periods);
                        periods = new Vector();
                    }
                    Vector v1 = new Vector();
                    Vector v2 = new Vector();
                    Vector v3 = new Vector();
                    Object item = null;
                    if (allPeriods.size() == 3) {
                        v1 = (Vector)allPeriods.elementAt(0);
                        v2 = (Vector)allPeriods.elementAt(1);
                        v3 = (Vector)allPeriods.elementAt(2);
                        for (n1 = 0; n1 < v1.size(); ++n1) {
                            String k1 = (String)v1.elementAt(n1);
                            for (int n2 = 0; n2 < v2.size(); ++n2) {
                                String k2 = (String)v2.elementAt(n2);
                                for (int n3 = 0; n3 < v3.size(); ++n3) {
                                    String k3 = (String)v3.elementAt(n3);
                                    reitems.addElement(item);
                                    FunctionExpr cpFun = BgExamineEditUI.copy(fun);
                                    if (k2.length() == 2 && k2.lastIndexOf("%") < 0) {
                                        k2 = "0" + k2;
                                    }
                                    if (k3.length() == 2 && k3.lastIndexOf("%") < 0) {
                                        k3 = "0" + k3;
                                    }
                                    if (k3.length() == 3 && (k3.indexOf("MW") > 0 || k3.indexOf("TD") > 0)) {
                                        k3 = "0" + k3;
                                    }
                                    cpFun.parameters.set(5, new StringExpr(k1 + "." + k2 + "." + k3));
                                    if (sb.indexOf("B") >= 0) {
                                        sb.append('+');
                                    }
                                    cpFun.output(sb);
                                }
                            }
                        }
                    } else if (allPeriods.size() == 2) {
                        v1 = (Vector)allPeriods.elementAt(0);
                        v2 = (Vector)allPeriods.elementAt(1);
                        for (n1 = 0; n1 < v1.size(); ++n1) {
                            String k1 = (String)v1.elementAt(n1);
                            for (int n2 = 0; n2 < v2.size(); ++n2) {
                                String k2 = (String)v2.elementAt(n2);
                                reitems.addElement(item);
                                FunctionExpr cpFun = BgExamineEditUI.copy(fun);
                                if (k2.length() == 2) {
                                    k2 = "0" + k2;
                                } else if (k2.length() == 3 && k2.indexOf("HY") > 0) {
                                    k2 = "0" + k2;
                                }
                                cpFun.parameters.set(5, new StringExpr(k1 + "." + k2));
                                if (sb.indexOf("B") >= 0) {
                                    sb.append('+');
                                }
                                cpFun.output(sb);
                            }
                        }
                    } else if (allPeriods.size() == 1) {
                        v1 = (Vector)allPeriods.elementAt(0);
                        for (int a = 0; a < v1.size(); ++a) {
                            reitems.addElement(item);
                            FunctionExpr cpFun = BgExamineEditUI.copy(fun);
                            cpFun.parameters.set(5, new StringExpr((String)v1.elementAt(a)));
                            if (sb.indexOf("B") >= 0) {
                                sb.append('+');
                            }
                            cpFun.output(sb);
                        }
                    }
                } else {
                    return fun;
                }
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            bin.left = this.walk(bin.left);
            bin.right = this.walk(bin.right);
        } else if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr bin = (UnaryOperationExpr)expr;
            bin.operand = this.walk(bin.operand);
        } else if (expr instanceof ReferenceExpr) {
            SysUtil.abort();
        }
        return expr;
    }

    private static FunctionExpr copy(FunctionExpr foo) throws Exception {
        FunctionExpr cp = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)foo.toString());
        return cp;
    }

    private String aliasToFormula(String text) throws Exception {
        String formula = null;
        Expression expr2 = null;
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)text);
            expr2 = this.walk(expression);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"bgexamineerror"));
            return null;
        }
        formula = expr2.toString();
        if (text.indexOf("<>") > 0) {
            this.editData.setCompareType(BgExamineTypeEnum.NOTEQUAL);
        } else {
            if (text.indexOf("=") > 0) {
                this.editData.setCompareType(BgExamineTypeEnum.EQUAL);
            }
            if (text.indexOf(">") > 0) {
                this.editData.setCompareType(BgExamineTypeEnum.LARGER);
            }
            if (text.indexOf("<") > 0) {
                this.editData.setCompareType(BgExamineTypeEnum.LESS);
            }
            if (text.indexOf(">=") > 0) {
                this.editData.setCompareType(BgExamineTypeEnum.LARGER_EQUAL);
            }
            if (text.indexOf("<=") > 0) {
                this.editData.setCompareType(BgExamineTypeEnum.LESS_EQUAL);
            }
        }
        return formula;
    }

    @Override
    public void actionJia_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "+" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public void actionJian_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "-" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public void actionCheng_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "*" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public void actionChu_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "/" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public void actionDeng_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "=" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public void actionBuDeng_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "<>" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 2);
    }

    @Override
    public void actionDaYu_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + ">" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public void actionXiaoYu_actionPerformed(ActionEvent e) throws Exception {
        int pos = this.kDTFormula.getCaretPosition();
        String formula = this.kDTFormula.getText();
        int length = formula.length();
        String tempText = formula.substring(0, pos);
        String tempText2 = formula.substring(pos, length);
        this.kDTFormula.setText(tempText + "<" + tempText2);
        this.kDTFormula.setCaretPosition(pos + 1);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bgItemGroup.*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("specialNumber"));
        sic.add(new SelectorItemInfo("cashFlow.*"));
        sic.add(new SelectorItemInfo("cashDirection"));
        sic.add(new SelectorItemInfo("noPass"));
        sic.add(new SelectorItemInfo("formula"));
        sic.add(new SelectorItemInfo("hint"));
        sic.add(new SelectorItemInfo("errorData"));
        sic.add(new SelectorItemInfo("formulaAlias"));
        return sic;
    }

    @Override
    public void actionBgAcct_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", this.getUIContext().get("ID"));
        uiContext.put((Object)"BgExamineEditUI", (Object)((BgExamineEditUI)((Object)uiContext.get((Object)"Owner"))));
        uiContext.put((Object)"EditOrg", (Object)this.orgUnitInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExamineFormulaUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        String item = ((BgExamineFormulaUI)uiWindow.getUIObject()).getFormula();
        String items = this.kDTFormula.getText();
        if (item != null) {
            if (items == null) {
                this.kDTFormula.setText(item);
                this.kDTFormula.setCaretPosition(item.length());
            } else {
                items = items + item;
                this.kDTFormula.setText(items);
                this.kDTFormula.setCaretPosition(items.length());
            }
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.oldValueS.append(this.editData.getNumber());
        this.oldValueS.append(this.editData.getName());
        this.oldValueS.append(this.editData.getFormulaAlias());
        this.oldValueS.append((Object)this.editData.getNoPass());
    }

    public boolean isModify() {
        StringBuffer newValueS = new StringBuffer();
        newValueS.append(this.txtNumber.getText());
        if (this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() != null && this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() > 0) {
            String name = (String)this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData();
            newValueS.append(name);
        } else {
            newValueS.append("null");
        }
        newValueS.append(this.kDTFormula.getText());
        if (this.kdbNoPass.isSelected()) {
            newValueS.append((Object)BgExamineNoPassEnum.noSubmit);
        }
        if (this.kdbAddExplain.isSelected()) {
            newValueS.append((Object)BgExamineNoPassEnum.addPostil);
        }
        if (this.kdbOnlyShowMess.isSelected()) {
            newValueS.append((Object)BgExamineNoPassEnum.showErrorMes);
        }
        return this.oldValueS.toString() == null || !this.oldValueS.toString().equals(newValueS.toString()) && !this.oldValueS.toString().equals("nullnullnullnull");
    }
}

