/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgExamineFormulaEditUI;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgExamineFormulaEditUI
extends AbstractBgExamineFormulaEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgExamineFormulaEditUI.class);
    private String returnItem = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        String title = (String)this.getUIContext().get("title");
        this.setUITitle(title);
    }

    private void init() {
        BgOrgViewF7 orgF7 = new BgOrgViewF7((IUIObject)this);
        orgF7.setCurrentCUID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
        this.prmtOrgUnit.setEditable(true);
        orgF7.setMultiSelect(true);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtBgScheme.setValue(null);
        this.prmtBgScheme.setEditable(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.setMaskString("#0");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgUnitId);
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgSet, (FilterInfo)filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
        BgPeriodDialog periodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginData.setSelector((KDPromptSelector)periodDialog);
        this.prmtBeginData.setEditable(true);
        this.prmtEndData.setSelector((KDPromptSelector)periodDialog);
        this.prmtEndData.setEditable(true);
        BgElementDialog bgElement = new BgElementDialog((IUIObject)this);
        bgElement.setIsChooseOne(true);
        this.prmtBgElement.setSelector((KDPromptSelector)bgElement);
        this.prmtBgElement.setDisplayFormat("$name$");
        this.prmtBgElement.setEditable(false);
        NewBgItemDialog itemDialog = new NewBgItemDialog((IUIObject)this);
        itemDialog.setSelectCombinItem(true);
        this.prmtBgItem.setSelector((KDPromptSelector)itemDialog);
        this.prmtBgItem.setDisplayFormat("$name$");
        this.prmtBgItem.setEditable(false);
        this.prmtCurrency.setEditable(false);
    }

    private void setResultFromPrmt() {
        this.verifyX();
        StringBuffer item = new StringBuffer();
        item.append((String)this.getUIContext().get("acct"));
        item.append("(\"");
        if (this.prmtOrgUnit.getValue() != null && this.prmtOrgUnit.getValue() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])this.prmtOrgUnit.getValue();
            StringBuffer orgStr = new StringBuffer();
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (i == orgUnitInfos.length - 1) {
                    orgStr.append(orgUnitInfos[i].getNumber());
                    continue;
                }
                orgStr.append(orgUnitInfos[i].getNumber()).append(";");
            }
            item.append(orgStr.toString());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBgScheme.getValue() != null) {
            item.append(((BgSchemeInfo)this.prmtBgScheme.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBgItem.getValue() != null) {
            item.append(((VisualItemInfo)this.prmtBgItem.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBgElement.getValue() != null) {
            item.append(((BgElementInfo)this.prmtBgElement.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtCurrency.getValue() != null) {
            item.append(((CurrencyInfo)this.prmtCurrency.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBeginData.getValue() != null && this.prmtEndData.getValue() != null) {
            item.append(this.periodToFormulaeasy(this.prmtBeginData.getValue().toString()));
            item.append("\",\"");
            item.append(this.periodToFormulaeasy(this.prmtEndData.getValue().toString()));
        } else {
            item.append("%");
        }
        item.append("\")");
        this.returnItem = item.toString();
    }

    private void verifyX() {
        boolean xError = false;
        if (this.prmtBeginData.getValue() != null && this.prmtEndData.getValue() != null) {
            BigDecimal number;
            if (!(this.prmtBeginData.getValue() instanceof BgPeriodInfo)) {
                String beginData = this.prmtBeginData.getValue().toString();
                beginData = beginData.replaceAll("x", "");
                beginData = beginData.replaceAll("X", "");
                beginData = beginData.replaceAll(" ", "");
                beginData = beginData.replaceAll("\\+", "");
                if (!(beginData = beginData.replaceAll("\\-", "")).equals("")) {
                    try {
                        number = null;
                        number = new BigDecimal(beginData);
                    }
                    catch (Exception e) {
                        xError = true;
                    }
                }
            }
            if (!(this.prmtEndData.getValue() instanceof BgPeriodInfo)) {
                String endData = this.prmtEndData.getValue().toString();
                endData = endData.replaceAll("x", "");
                endData = endData.replaceAll("X", "");
                endData = endData.replaceAll(" ", "");
                endData = endData.replaceAll("\\+", "");
                if (!(endData = endData.replaceAll("\\-", "")).equals("")) {
                    try {
                        number = null;
                        number = new BigDecimal(endData);
                    }
                    catch (Exception e) {
                        xError = true;
                    }
                }
            }
        }
        if (this.prmtBeginData.getValue() == null && this.prmtEndData.getValue() != null || this.prmtBeginData.getValue() != null && this.prmtEndData.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (xError) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"xError"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAllNull()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineAllNull"));
            SysUtil.abort();
        }
        this.setResultFromPrmt();
        this.getUIWindow().close();
    }

    protected boolean isAllNull() throws Exception {
        boolean ExamineAllNull = false;
        boolean BgItemNull = false;
        boolean BgElementNull = false;
        boolean CurrencyNull = false;
        boolean PeriodNull = false;
        boolean PeriodNull2 = false;
        if (this.prmtBgItem.getText() == null || this.prmtBgItem.getText().trim().length() == 0) {
            BgItemNull = true;
        }
        if (this.prmtBgElement.getText() == null || this.prmtBgElement.getText().trim().length() == 0) {
            BgElementNull = true;
        }
        if (this.prmtCurrency.getText() == null || this.prmtCurrency.getText().trim().length() == 0) {
            CurrencyNull = true;
        }
        if (this.prmtEndData.getText() == null || this.prmtEndData.getText().trim().length() == 0) {
            PeriodNull = true;
        }
        if (this.prmtBeginData.getText() == null || this.prmtBeginData.getText().trim().length() == 0) {
            PeriodNull2 = true;
        }
        ExamineAllNull = BgItemNull && BgElementNull && CurrencyNull && PeriodNull && PeriodNull2;
        return ExamineAllNull;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public String getFormula() {
        return this.returnItem;
    }

    private String periodToFormulaeasy(String period) {
        String stryear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"stryear");
        String strfirsthalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strfirsthalfyear");
        String strlasthalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strlasthalfyear");
        String strhalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strhalfyear");
        String strquarter = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strquarter");
        String strmonth = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strmonth");
        String strweek = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strweek");
        String strday = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strday");
        if (period.indexOf(strfirsthalfyear) < 0 && period.indexOf(strlasthalfyear) < 0 && period.endsWith(stryear)) {
            period = period.replaceAll(stryear, "Y");
        } else {
            period = period.replaceFirst(stryear, "Y");
            period = period.replaceFirst("Y", "Y|");
        }
        period = period.endsWith(strmonth) ? period.replaceAll(strmonth, "M") : period.replaceAll(strmonth, "M|");
        period = period.replaceAll(strfirsthalfyear, "01HY");
        period = period.replaceAll(strlasthalfyear, "02HY");
        period = period.replaceAll(strquarter, "Q");
        period = period.replaceAll(strweek, "W");
        period = period.replaceAll(strday, "D");
        return period;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtBgScheme.setValue(null);
        HashSet<String> orgUnitSet = new HashSet<String>();
        String[] strOrgNumber = null;
        if (this.prmtOrgUnit.getValue() != null && this.prmtOrgUnit.getValue() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])this.prmtOrgUnit.getValue();
            strOrgNumber = new String[orgUnitInfos.length];
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                orgUnitSet.add(orgUnitInfos[i].getId().toString());
                strOrgNumber[i] = orgUnitInfos[i].getNumber();
            }
        } else {
            strOrgNumber = new String[1];
            CostCenterOrgUnitInfo info = SysContext.getSysContext().getCurrentCostUnit();
            orgUnitSet.add(info.getId().toString());
            strOrgNumber[0] = info.getNumber();
        }
        HashSet<String> bgSchemeIdSet = new HashSet<String>();
        try {
            IBgScheme iBgS = BgSchemeFactory.getRemoteInstance();
            BgSchemeCollection bgSchemeCol = iBgS.getSameSchemeByOrgNumbers(strOrgNumber);
            if (bgSchemeCol != null && !bgSchemeCol.isEmpty()) {
                for (int i = 0; i < bgSchemeCol.size(); ++i) {
                    bgSchemeIdSet.add(bgSchemeCol.get(i).getId().toString());
                }
            }
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bgSchemeIdSet, CompareType.INCLUDE));
        filter.setMaskString("#0");
        if (BgSHelper.isBgPermissionUsed()) {
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgUnitSet, (FilterInfo)filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    private boolean isErrorData() {
        return this.prmtOrgUnit.getValue() != null ? this.prmtBgScheme.getValue() == null : this.prmtOrgUnit.getValue() == null && this.prmtBgScheme.getValue() != null;
    }
}

