/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgExamineException;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgExamineImportTemplateUI;
import com.kingdee.eas.ma.budget.client.BgExamineTemplateProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgExamineImportTemplateUI
extends AbstractBgExamineImportTemplateUI {
    private static final long serialVersionUID = 4814762447207708944L;
    private static final Logger logger = CoreUIObject.getLogger(BgExamineImportTemplateUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDLabelTemplate.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.getColls();
    }

    private void getColls() throws Exception {
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection coll = iBgScheme.getTemplate(orgUnitID);
        this.loadTemplates(coll);
    }

    private void loadTemplates(BgTemplateCollection coll) {
        this.tblMain.removeRows();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BgTemplateInfo bgTemplateInfo = coll.get(i);
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgTemplateInfo.getName());
                iRow.getCell("creator").setValue((Object)bgTemplateInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgTemplateInfo.getCreateTime());
                iRow.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
            }
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            if (this.getDetailTable().getBody().size() == 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NoTemplateThisOrgUnit"));
                SysUtil.abort();
            }
            Vector<Integer> rows = new Vector<Integer>();
            int selectRowCount = 0;
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow iRow = this.getDetailTable().getRow(i);
                if (!iRow.getCell("select").getValue().equals(Boolean.TRUE)) continue;
                rows.add(new Integer(i));
                ++selectRowCount;
            }
            for (int n = 0; n < selectRowCount; ++n) {
                this.openBgTemplateUI((Integer)rows.get(n));
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() != 0 && e.getClickCount() == 2) {
            this.openBgTemplateUI(this.getDetailTable().getSelectManager().getActiveRowIndex());
        }
    }

    private void openBgTemplateUI(int rowIndex) throws UIException, BgExamineException {
        IRow irow = this.getDetailTable().getRow(rowIndex);
        if (irow == null) {
            return;
        }
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)irow.getUserObject();
        if (bgTemplateInfo == null) {
            throw new BgExamineException(BgExamineException.NOBGTEMPLATE);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgTemplateInfo.getId().toString());
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"BgExamineEditUI", this.getUIContext().get("BgExamineEditUI"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getReportUIName(bgTemplateInfo), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public String getReportUIName(BgTemplateInfo bgTemplateInfo) {
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgTemplateInfo.getFormType())) {
            return "com.kingdee.eas.ma.view.client.BgExamineViewTemplateProcessUI";
        }
        return BgExamineTemplateProcessUI.class.getName();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        SysUtil.abort();
    }
}

