/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgExamineCollection;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.client.AbstractBgExamineListF7UI;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgExamineListF7UI
extends AbstractBgExamineListF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgExamineListF7UI.class);
    private BgExamineCollection coll = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtConfirm.setEnabled(true);
        this.kdtConfirm.setVisible(true);
        this.kdtCancel.setEnabled(true);
        this.kdtCancel.setVisible(true);
        this.actionExamineCancel.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        BgExamineCollection bgExamineColl = new BgExamineCollection();
        bgExamineColl = this.getData();
        this.setBgExamineColl(bgExamineColl);
        this.getUIWindow().close();
    }

    @Override
    public void actionExamineCancel_actionPerformed(ActionEvent e) throws Exception {
        logger.info((Object)(" bgExamieListF7 table.rows:" + this.tblMain.getRowCount() + " "));
        this.getUIWindow().close();
    }

    public BgExamineCollection getBgExamineColl() {
        return this.coll;
    }

    public void setBgExamineColl(BgExamineCollection bgExamineColl) {
        this.coll = bgExamineColl;
    }

    public BgExamineCollection getData() throws Exception {
        return this.getBgExamineCollection();
    }

    private BgExamineCollection getBgExamineCollection() {
        BgExamineCollection coll = null;
        IRow row = null;
        KDTRange range = null;
        KDTSelectBlock block = null;
        int rangeCount = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        String bgExamineId = null;
        HashSet<String> bgExamineSet = new HashSet<String>();
        range = this.tblMain.getSelectManager().toRange();
        rangeCount = range.size();
        for (int i = 0; i < rangeCount; ++i) {
            block = (KDTSelectBlock)range.get(i);
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            for (int j = rowBegin; j <= rowEnd; ++j) {
                row = this.tblMain.getRow(j);
                if (row == null) continue;
                bgExamineId = row.getCell("id").getValue().toString();
                bgExamineSet.add(bgExamineId);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("id", bgExamineSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("examineGroup.id"));
        view.getSelector().add(new SelectorItemInfo("examineGroup.name"));
        view.getSelector().add(new SelectorItemInfo("examineGroup.number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("id"));
        try {
            coll = BgExamineFactory.getRemoteInstance().getBgExamineCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            coll = new BgExamineCollection();
        }
        return coll;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionConfirm_actionPerformed(null);
        }
    }
}

