/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.client.BgExamineEditUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class BgExamineTemplateProcessUI
extends BgNTemplateProcessUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgExamineTemplateProcessUI");
    private Vector examFormulas = new Vector();
    private BgExamineEditUI proExamineUI = null;

    public void onShow() {
        super.onShow();
        Book book = this.getBook();
        int i = 0;
        for (int n = book.getSheetCount(); n > i; --n) {
            book.getSheet(n - 1).getRange(0, 0).select();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionExamineTemSubmit.setEnabled(true);
        this.proExamineUI = (BgExamineEditUI)((Object)this.getUIContext().get("BgExamineEditUI"));
    }

    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionExamineTemSubmit.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_submit"));
        toolBarManager.addFirstGroupItem((Action)this.actionExamineTemSubmit, "common");
        super.initToolbar();
        this.actionExamineTemSubmit.putValue("ShortDescription", (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"submit"));
        this.actionExamineTemSubmit.putValue("LongDescription", (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"submit"));
    }

    public void actionExamineTemSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExamineTemSubmit_actionPerformed(e);
        this.examFormulas.clear();
        if (this.proExamineUI != null) {
            String formulaString = null;
            Sheet _sheet = null;
            Cell _cell = null;
            Range _range = null;
            CellBlock _block = null;
            for (int xx = 0; xx < this.getBook().getSheetCount(); ++xx) {
                _sheet = this.getBook().getSheet(xx);
                if (_sheet == null || (_range = _sheet.getSelectionRange()) == null) continue;
                int rowCount = _sheet.getMaxRowIndex();
                int colCount = _sheet.getMaxColIndex();
                int n = _range.size();
                for (int i = 0; i < n; ++i) {
                    _block = _range.getBlock(i);
                    int rowBegin = _block.getRow();
                    int rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                    int colBegin = _block.getCol();
                    int colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                    for (int m = rowBegin; m <= rowEnd; ++m) {
                        for (int j = colBegin; j <= colEnd; ++j) {
                            _cell = _sheet.getCell(m, j, false);
                            if (_cell == null || !BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                            formulaString = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                            this.formulaParse(formulaString);
                        }
                    }
                }
            }
            if (this.examFormulas.isEmpty()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"noBgItem"));
            } else {
                this.proExamineUI.setExamineString(this.examFormulas);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"submitSuccess"));
            }
        }
    }

    private void formulaParse(String formulas) {
        try {
            List list = new ArrayList();
            list = TableToolkit.parseFormula((String)("=" + formulas.toString()), (boolean)false);
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] newparams = new String[6];
            String[] params = hint.getParams();
            newparams[0] = "%";
            newparams[1] = "%";
            if (params[0] == null || params[0].trim().toString().length() == 0) {
                params[0] = "%";
            }
            if (params[2] == null || params[2].trim().toString().length() == 0) {
                params[2] = "%";
            }
            if (params[5] == null || params[5].trim().toString().length() == 0) {
                params[5] = "%";
            }
            if (params[1] == null || params[1].trim().toString().length() == 0) {
                params[1] = "%";
            }
            newparams[2] = "" + params[0];
            newparams[3] = "" + params[2];
            newparams[4] = "" + params[5];
            newparams[5] = "" + params[1];
            String examineFormula = "BgItem(\"" + newparams[0] + "\",\"" + newparams[1] + "\",\"" + newparams[2] + "\",\"" + newparams[3] + "\",\"" + newparams[4] + "\",\"" + newparams[5] + "\")";
            this.examFormulas.add(examineFormula);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    public BgExamineEditUI getProExamineUI() {
        return this.proExamineUI;
    }

    public void setProExamineUI(BgExamineEditUI proExamineUI) {
        this.proExamineUI = proExamineUI;
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }
}

