/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.eas.ma.budget.BgElementExtTypeEnum;
import com.kingdee.eas.ma.budget.client.BgExpFormula;
import com.kingdee.eas.ma.budget.client.BgExpPreyearActual;
import com.kingdee.eas.ma.budget.client.BgExpProjectInvest;
import com.kingdee.eas.ma.budget.client.BgExpressionBase;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgExpProcess {
    private static final Logger logger = Logger.getLogger(BgExpProcess.class);
    private static BgExpProcess instance = null;
    private Map aliasMap = new HashMap();
    private BgExpressionBase process = null;
    private Object processUI = null;

    public static synchronized BgExpProcess getInstance(Object ui) {
        if (instance == null) {
            instance = new BgExpProcess(ui);
        }
        return instance;
    }

    private BgExpProcess(Object ui) {
        this.processUI = ui;
    }

    public void process(ICell cell, boolean isExpression, int expressionValue, Object[] parameter) {
        if (this.processUI == null || cell == null) {
            return;
        }
        try {
            if (isExpression) {
                this.processExpression(cell, expressionValue, parameter);
            } else {
                this.processFormula(cell, parameter);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    private void processExpression(ICell cell, int expressionValue, Object[] parameter) throws Exception {
        switch (expressionValue) {
            case 1: {
                this.process = !this.aliasMap.containsKey(BgElementExtTypeEnum.PREYEARACTUAL.getName()) ? BgExpPreyearActual.getInstance(this.processUI) : (BgExpressionBase)this.aliasMap.get(BgElementExtTypeEnum.PREYEARACTUAL.getName());
                this.process.build(this.processUI, cell, parameter);
                this.aliasMap.put(BgElementExtTypeEnum.PREYEARACTUAL.getName(), this.process);
                break;
            }
            case 2: {
                this.process = !this.aliasMap.containsKey(BgElementExtTypeEnum.PROJECTINVEST.getName()) ? BgExpProjectInvest.getInstance(this.processUI) : (BgExpressionBase)this.aliasMap.get(BgElementExtTypeEnum.PROJECTINVEST.getName());
                this.process.build(this.processUI, cell, parameter);
                this.aliasMap.put(BgElementExtTypeEnum.PROJECTINVEST.getName(), this.process);
                break;
            }
        }
    }

    private void processFormula(ICell cell, Object[] parameter) throws Exception {
        this.process = !this.aliasMap.containsKey("BGFORMULA_FORMULA") ? BgExpFormula.getInstance(this.processUI) : (BgExpressionBase)this.aliasMap.get("BGFORMULA_FORMULA");
        if (this.process != null) {
            this.process.build(this.processUI, cell, parameter);
            this.aliasMap.put("BGFORMULA_FORMULA", this.process);
        }
    }

    public void close() {
        if (!this.aliasMap.isEmpty()) {
            this.aliasMap.clear();
        }
    }
}

