/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.RptFormulaParser;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgFCHelper;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemFormulaCHelper;
import com.kingdee.eas.ma.budget.BgMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.client.AbstractBgFormAdjustProcessUI;
import com.kingdee.eas.ma.budget.client.BgAdjustViewUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCollectViewUI;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.ErrorBudgetItemListUI;
import com.kingdee.eas.ma.budget.client.KDTAdjustTableAgent;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgFormAdjustProcessUI
extends AbstractBgFormAdjustProcessUI {
    private static final long serialVersionUID = -4497449065274636107L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormAdjustProcessUI.class);
    private boolean isBudget = true;
    private boolean isCollectShow = false;
    private UserInfo user = null;
    protected Map bgPeriodMap = null;
    protected Map changedMap = null;
    protected Map initValueMap = null;
    private String xNum = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        ((JPanel)((KDSplitPane)this.barFormula.getComponent(1)).getComponent(1)).getComponent(1).setEnabled(false);
        this.initWorkButtonStyle();
        this.loadDiversityInfo();
        this.processShowOfSheet();
        this.processDealExpression();
        this.isProcess = true;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    protected void loadBudgetFormInfo() {
        super.loadBudgetFormInfo();
        if (this.editDataUI != null) {
            this.editData = (BgFormInfo)this.editDataUI.getEditDataObject();
            this.bgFormInfo = (BgFormInfo)this.editData;
            this.bgFormInfo.setEndDate(this.bgFormInfo.getStartDate());
        }
    }

    @Override
    protected void initSystemOfOther() {
        Object obj;
        super.initSystemOfOther();
        this.user = SysContext.getSysContext().getCurrentUserInfo();
        if (this.getUIContext().get("isBizActual") != null && this.getUIContext().get("isBizActual") instanceof Boolean) {
            boolean bl = this.isBudget = (Boolean)this.getUIContext().get("isBizActual") == false;
        }
        if (this.getUIContext().get("IS_COLLECT") != null) {
            this.getModifyingManager().addModifiedCount(1L);
            this.isCollectShow = true;
        }
        if (this.getUIContext().get("OPEN_FORMULA") != null && (obj = this.getUIContext().get("Owner")) != null && obj instanceof BgExamineViewUI) {
            this.formulaStr = ((BgExamineViewUI)((Object)obj)).getSelectOfFormula();
        }
        this.measureMap = new HashMap();
        this.editorMap = new HashMap();
        if (this.bgFormInfo.getBgMeasureUnit() != null && !this.bgFormInfo.getBgMeasureUnit().isEmpty()) {
            String bgElementNumber = null;
            BgMeasureUnitInfo mcInfo = null;
            BgMeasureUnitCollection mcCol = this.bgFormInfo.getBgMeasureUnit();
            Iterator iter = mcCol.iterator();
            while (iter.hasNext()) {
                mcInfo = (BgMeasureUnitInfo)iter.next();
                bgElementNumber = mcInfo.getBgElement().getNumber();
                if (this.measureMap.containsKey(bgElementNumber)) continue;
                this.measureMap.put(bgElementNumber, mcInfo);
            }
        }
        this.before = new HashMap();
        this.after = new HashMap();
        this.alias = new HashMap();
        this.formulaMap = new HashMap();
        this.expressionMap = new HashMap();
        this.bgPeriodMap = new HashMap();
        this.changedMap = new HashMap();
        this.initValueMap = new HashMap();
        this.barFormula.setBudget(true);
        this.barFormula.setItemEnabled(false);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdjustView.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.btnAcceManager.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnAddBgItem.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnAddBgPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_checkpolicy"));
        this.btnAddBgElement.setIcon(EASResource.getIcon((String)"imgTbtn_others"));
        this.btnAddCurrency.setIcon(EASResource.getIcon((String)"imgTbtn_currency"));
        this.btnBgFormulaAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnBgFormulaRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnItemManager.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnFormCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnCollectView.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.itemBgItemAddNew.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"menuBgItemAddNew"));
        this.itemBgItemRemove.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"menuBgItemRemove"));
    }

    private void initWorkButtonStyle() {
        this.btnCalcCurrPage.setIsControlByParent(false);
        this.btnAdjustView.setIsControlByParent(false);
        this.btnAcceManager.setIsControlByParent(false);
        this.btnSubmit.setIsControlByParent(false);
        this.btnImport.setIsControlByParent(false);
        this.btnExport.setIsControlByParent(false);
        this.btnCalcCurrPage.setText(this.btnCalcCurrPage.getToolTipText());
        this.btnAdjustView.setText(this.btnAdjustView.getToolTipText());
        this.btnAcceManager.setText(this.btnAcceManager.getToolTipText());
        this.btnSubmit.setText(this.btnSubmit.getToolTipText());
        this.btnImport.setText(this.btnImport.getToolTipText());
        this.btnExport.setText(this.btnExport.getToolTipText());
        this.btnCalcCurrPage.setTextIconDisStyle((short)3);
        this.btnAdjustView.setTextIconDisStyle((short)3);
        this.btnAcceManager.setTextIconDisStyle((short)3);
        this.btnSubmit.setTextIconDisStyle((short)3);
        this.btnImport.setTextIconDisStyle((short)3);
        this.btnExport.setTextIconDisStyle((short)3);
        this.btnSelectBgItem.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnSelectContract.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    @Override
    protected void loadDiversityInfo() throws Exception {
        if (this.editData != null) {
            byte[] data = this.bgFormInfo.getAdjustMapData();
            if (data == null || data.length == 0) {
                this.adjustMap = new HashMap();
            } else {
                InputStream is = ZipUtil.unpack((byte[])data);
                ObjectInputStream ois = new ObjectInputStream(is);
                this.adjustMap = (HashMap)ois.readObject();
                is.close();
                ois.close();
                if (this.adjustMap == null) {
                    throw new BgFormException(BgFormException.LOADDIVERSITYERROR);
                }
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
    }

    protected void storeDiversityInfo() throws Exception {
        if (this.editData != null && this.adjustMap != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.adjustMap);
            ((BgFormInfo)this.editData).setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
            baos.close();
            oos.close();
        }
    }

    public void actionFileSave_actionPerformed(ActionEvent e) throws Exception {
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        BgClientHelper.dealWith(this.pnlTables.getCurrentPage(), orgUnitId, this.barFormula, null, false, true);
        if (BgNSHelper.isCalculateOfUpdate()) {
            this.isProcess = false;
            this.rptBackCalculate(null);
            this.isProcess = true;
        }
        this.beforeFileSave();
        this.processFormulaUpateOnSheets();
        this.storeDiversityInfo();
        BgFSHelper.initAliasObject(this.pnlTables.getCurrentPage());
        super.actionFileSave_actionPerformed(e);
        this.afterFileSave();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int re;
        if (BgFormHelper.checkInProInst(this.bgFormInfo.getId().toString())) {
            throw new BgAdjustException(BgAdjustException.SUBMITINWORK);
        }
        if (BgParamCHelper.isFodian()) {
            Vector result = this.getFormFacadeInterface().checkMonthBudget(false, this.bgFormInfo.getId(), null);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"monthItem", (Object)result);
            if (result != null && result.size() != 0) {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ErrorBudgetItemListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                boolean isContinue = ((ErrorBudgetItemListUI)uiWindow.getUIObject()).isContinue();
                if (!isContinue) {
                    SysUtil.abort();
                }
            }
        }
        if ((re = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormWork"))) == 1 || re == 2) {
            return;
        }
        if (this.getModifyingManager().getModifiedCount() > 0L) {
            this.actionFileSave_actionPerformed(e);
            this.getModifyingManager().setModifiedCount(0);
        }
        if (BgParamCHelper.isCompulsionReportCheck() && !this.isCheckReportPass(null, false)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cantSubmitOfCheck"));
            SysUtil.abort();
        }
        if (this.getExamineInterface().canExamine(new BOSUuid[]{this.getBgExmCheckReportId()})) {
            this.xNum = BgNFCHelper.returnExamineX((BOSUuid[])new BOSUuid[]{this.getBgExmCheckReportId()}, (Object)((Object)this));
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            this.dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
            if (this.dialog != null) {
                this.dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = BgFormAdjustProcessUI.this.getExamineInterface().examines(new BOSUuid[]{BgFormAdjustProcessUI.this.getBgExmCheckReportId()}, BgFormAdjustProcessUI.this.xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            BgFormAdjustProcessUI.this.openBgExamineViewUI(result, null);
                            Map bgExamineCheckMap = (Map)result;
                            Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                            if (bgExCheck.booleanValue()) {
                                boolean bre = false;
                                bre = BgParamCHelper.isFodian() && BgFormAdjustProcessUI.this.bgFormInfo.getBgScheme().getPeriod().getValue() == 4 ? BgFormAdjustProcessUI.this.getFormFacadeInterface().submitFPAdjustWork(BgFormAdjustProcessUI.this.bgFormInfo.getId()) : BgFormAdjustProcessUI.this.getFormFacadeInterface().submitAdjustWork(BgFormAdjustProcessUI.this.bgFormInfo.getId());
                                if (bre) {
                                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                                    BgFormHelper.refreshBgFormList((CoreUI)BgFormAdjustProcessUI.this.editDataUI);
                                    BgFormAdjustProcessUI.this.getModifyingManager().setModifiedCount(0);
                                    BgFormAdjustProcessUI.this.destroyWindow();
                                } else {
                                    MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                                }
                            } else {
                                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantsubmit"));
                            }
                        } else {
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                        }
                    }
                });
                this.dialog.show();
            }
        } else {
            boolean bre = false;
            bre = BgParamCHelper.isFodian() && this.bgFormInfo.getBgScheme().getPeriod().getValue() == 4 ? this.getFormFacadeInterface().submitFPAdjustWork(this.bgFormInfo.getId()) : this.getFormFacadeInterface().submitAdjustWork(this.bgFormInfo.getId());
            if (bre) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                BgFormHelper.refreshBgFormList((CoreUI)this.editDataUI);
                this.getModifyingManager().setModifiedCount(0);
                this.destroyWindow();
            } else {
                MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
            }
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"ReportProcessUI_Import"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            KDSSheet sheet;
            String fileName = file.getPath();
            KDSBook books = POIXlsReader.parse((String)fileName);
            if (books == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"openFileError"));
                SysUtil.abort();
            }
            if ((sheet = books.getSheet((Object)new Integer(0))) == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError"));
                SysUtil.abort();
            }
            this.alias.clear();
            this.writeToSheet(sheet, this.pnlTables.getCurrentPage());
            this.alias.clear();
            this.processUpdateFormulaValue(true);
            this.processCurrPageCalculate(null);
            this.processUpdateFormulaValue(false);
        }
    }

    private void writeToSheet(KDSSheet from, KDTable to) {
        if (from == null || to == null) {
            return;
        }
        boolean isHasFormula = false;
        ICell cellTo = null;
        KDSCell fromTo = null;
        RptCell rptCell = null;
        String[] paramter = null;
        CurrencyInfo currency = null;
        BigDecimal value = null;
        BigDecimal one = new BigDecimal("1");
        String rptValue = null;
        String formulaString = null;
        String currencyNumber = null;
        int rowCount = from.getRowCount();
        int colCount = from.getColumnCount();
        int scale = 2;
        for (int i = 0; i <= rowCount; ++i) {
            for (int j = 0; j <= colCount; ++j) {
                cellTo = to.getCell(i, j);
                fromTo = from.getCell(i, j, false);
                isHasFormula = false;
                if (cellTo == null || fromTo == null || from.getCell(i, j, false).getValue() == null || from.getCell(i, j, false).getValue().toString().equals("")) continue;
                if (cellTo.getUserObject() != null && cellTo.getUserObject() instanceof RptCell) {
                    rptCell = (RptCell)cellTo.getUserObject();
                    formulaString = rptCell.getItemFormulaLine();
                    if (formulaString != null && formulaString.trim().length() > 0) {
                        isHasFormula = true;
                        paramter = this.getFormulaInfo(this.formulaMap, formulaString);
                        currencyNumber = paramter != null ? paramter[this.paraCurrency] : this.bgFormInfo.getCurrency().getNumber();
                        if (this.currencyMap.containsKey(currencyNumber)) {
                            currency = (CurrencyInfo)this.currencyMap.get(currencyNumber);
                            scale = currency.getPrecision();
                        } else {
                            scale = 2;
                        }
                    }
                } else {
                    currency = this.bgFormInfo.getCurrency();
                    scale = currency.getPrecision();
                }
                if (cellTo.getStyleAttributes().isLocked()) continue;
                try {
                    value = new BigDecimal(from.getCell(i, j, false).getValue().toString().replaceAll(",", ""));
                    rptValue = value.subtract(GlUtils.maxBigDecimal).doubleValue() >= 0.0 ? "0" : CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value.divide(one, scale, 4));
                    cellTo.setValue((Object)rptValue);
                    continue;
                }
                catch (Exception ex) {
                    if (isHasFormula) continue;
                    cellTo.setValue((Object)from.getCell(i, j, false).getValue().toString());
                }
            }
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        this.actionFileExport_actionPerformed(e);
    }

    public void actionViewData_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewData_actionPerformed(e);
        this.actionFileSave.setEnabled(true);
        this.actionFileExport.setEnabled(true);
        this.actionFileImport.setEnabled(true);
        this.actionExport.setEnabled(true);
        this.actionImport.setEnabled(true);
    }

    public void actionViewFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFormula_actionPerformed(e);
        this.actionFileSave.setEnabled(false);
        this.actionFileExport.setEnabled(false);
        this.actionFileImport.setEnabled(false);
        this.actionExport.setEnabled(false);
        this.actionImport.setEnabled(false);
    }

    @Override
    public void actionAcceManager_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        AttachmentUIContextInfo acmInfo = new AttachmentUIContextInfo();
        acmInfo.setBoID(this.editData.getId().toString());
        if (this.getOprtState().equals(OprtState.VIEW)) {
            acmInfo.setEdit(false);
        } else {
            acmInfo.setEdit(true);
        }
        acm.showAttachmentListUIByBoID((Object)this, acmInfo);
    }

    @Override
    public void actionAdjustView_actionPerformed(ActionEvent e) throws Exception {
        String formulaString = null;
        ICell cell = this.pnlTables.getFoucusCell();
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            formulaString = rptCell.getItemFormulaLine();
        }
        UIContext uiContext = new UIContext((Object)this);
        if (this.bgFormInfo.getState().getValue() == 2 && formulaString != null && formulaString.trim().length() > 0) {
            uiContext.put((Object)"formulaRecord", (Object)formulaString);
            uiContext.put((Object)"formulaFormId", (Object)this.bgFormInfo.getId());
            uiContext.put((Object)"formulaOrgUnit", (Object)this.bgFormInfo.getOrgUnit().getId());
            uiContext.put((Object)"formulaScheme", (Object)this.bgFormInfo.getBgScheme().getId());
        } else if (this.bgFormInfo.getState().getValue() == 4) {
            uiContext.put((Object)"bgFormAdjust", (Object)this.adjustMap);
            uiContext.put((Object)"formulaRecord", (Object)formulaString);
        } else if (this.bgFormInfo.getState().getValue() == 2) {
            uiContext.put((Object)"bgFormPastRecord", (Object)this.bgFormInfo.getId().toString());
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAdjustViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionEditClearContent_actionPerformed(ActionEvent e) throws Exception {
        this.processUpdateFormulaValue(true);
        super.actionEditClearContent_actionPerformed(e);
        this.processUpdateFormulaValue(false);
    }

    protected void processShowOfSheet() {
        KDTable table = null;
        int count = this.pnlTables.getSheets().size();
        for (int index = 0; index < count; ++index) {
            table = this.pnlTables.getSheet(index).getTable();
            if (table.getStyleAttributes().isLocked()) {
                table.getStyleAttributes().setLocked(false);
            }
            this.processTableOfSheet(table);
            this.initTableKeyboardListener(table);
            table.getEditManager().setExpressAlwaysEditable(false);
        }
        this.before.putAll(this.formulaMap);
    }

    protected void processTableOfSheet(KDTable table) {
        if (table == null) {
            return;
        }
        ICell cell = null;
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                cell = table.getCell(r, c);
                this.processCellOfTable(cell);
            }
        }
    }

    protected void processCellOfTable(ICell cell) {
        if (cell == null) {
            return;
        }
        int state = this.bgFormInfo.getState().getValue();
        if (state == 15) {
            cell.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
        }
        if (cell.getStyleAttributes().isLocked()) {
            cell.getStyleAttributes().setLocked(false);
        }
        if (BgFSHelper.checkHasFormulaOfCell(cell)) {
            RptCell rptCell = null;
            String[] parameter = null;
            String formulaString = null;
            String expressionString = null;
            String valueString = null;
            String sourceString = null;
            BigDecimal value = null;
            BigDecimal initValue = null;
            BgFormDiversityData divData = null;
            rptCell = (RptCell)cell.getUserObject();
            formulaString = BgFSHelper.getFormulaOfCell(rptCell);
            parameter = this.getFormulaInfo(this.formulaMap, formulaString);
            if (rptCell.getItemFormula() != null) {
                if (this.isBudget) {
                    valueString = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                    expressionString = rptCell.getItemFormula().getExt("BG_BUDGET_EXPRESSIONS");
                } else {
                    valueString = rptCell.getItemFormula().getExt("BG_ACTUAL_VALUE");
                    expressionString = rptCell.getItemFormula().getExt("BG_ACTUAL_EXPRESSIONS");
                }
                if (valueString == null || valueString.trim().length() == 0) {
                    cell.setValue(null);
                } else {
                    cell.setValue((Object)valueString);
                }
                if (expressionString == null || expressionString.trim().length() == 0) {
                    cell.setExpressions(null);
                } else {
                    cell.setExpressions(expressionString);
                }
            }
            if (this.getOprtState().equals(OprtState.EDIT)) {
                if (parameter[this.paraPeriod] != null && !this.bgPeriodMap.containsKey(parameter[this.paraPeriod])) {
                    this.bgPeriodMap.put(parameter[this.paraPeriod], null);
                }
                if (parameter[this.paraDataType] != null && parameter[this.paraDataType].equals(BgDataTypeEnum.BgActual.getName())) {
                    cell.getStyleAttributes().setLocked(true);
                    cell.getStyleAttributes().setBackground(BgSHelper.LOCKED_COLOR);
                }
                this.processCellOfFormatInput(cell, parameter[this.paraCurrency]);
            }
            if (state == 4 && this.adjustMap.containsKey(formulaString)) {
                cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
            }
            if (this.isCollectShow && !this.adjustMap.containsKey(formulaString)) {
                valueString = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                sourceString = rptCell.getItemFormula().getExt("SIGN_DATA_SOURCE");
                if (sourceString != null && sourceString.equals("DATA_SOURCE_COLLECT") && BgFSHelper.checkCanUpdateOfCell(cell)) {
                    try {
                        value = new BigDecimal(valueString);
                    }
                    catch (Exception ex) {
                        value = BgConstants.BIGZERO;
                    }
                    divData = new BgFormDiversityData();
                    divData.setNewValue(value);
                    divData.setOldValue(BgConstants.BIGZERO);
                    divData.setFormula(formulaString);
                    divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
                    divData.setAdjustor(this.user.getId().toString());
                    this.adjustMap.put(formulaString, divData);
                    cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                }
            }
            if (this.adjustMap.containsKey(formulaString)) {
                divData = (BgFormDiversityData)this.adjustMap.get(formulaString);
                initValue = divData.getOldValue();
            } else {
                try {
                    initValue = new BigDecimal(valueString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (initValue == null) {
                initValue = BgConstants.BIGZERO;
            }
            this.initValueMap.put(formulaString, initValue);
            if (this.isBudget && this.formulaStr != null && this.formulaStr.equals(formulaString)) {
                this.xyPosition = TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex());
                this.backColor = cell.getStyleAttributes().getBackground();
                cell.getStyleAttributes().setBackground(Color.RED);
            }
        } else {
            this.processCellOfOtherInput(cell);
        }
        this.setCellStyleToText(cell, null);
    }

    protected void processCellOfPeriod() throws BOSException {
    }

    private void initTableKeyboardListener(KDTable table) {
        if (table == null) {
            return;
        }
        table.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                if (!BgFormAdjustProcessUI.this.alias.containsKey(TableToolkit.xy2range((int)e.getColIndex(), (int)e.getRowIndex()))) {
                    BgFormAdjustProcessUI.this.table_propertyChange(e);
                }
            }
        });
        table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                BgFormAdjustProcessUI.this.table_SelectChanged(e);
            }
        });
        table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                BgFormAdjustProcessUI.this.table_Clicked(e);
            }
        });
        table.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                BgFormAdjustProcessUI.this.table_EditStarting(e);
            }

            public void editStarted(KDTEditEvent e) {
                BgFormAdjustProcessUI.this.table_EditStarted(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                BgFormAdjustProcessUI.this.table_EditValueChanged(e);
            }

            public void editStopping(KDTEditEvent e) {
                BgFormAdjustProcessUI.this.table_EditStopping(e);
            }

            public void editStopped(KDTEditEvent e) {
                BgFormAdjustProcessUI.this.table_EditStopped(e);
            }

            public void editCanceled(KDTEditEvent e) {
                BgFormAdjustProcessUI.this.table_EditCanceled(e);
            }
        });
        ActionMap am = table.getActionMap();
        am.put("Paste", (Action)((Object)new KDTAdjustTableAgent(table, 1, this.pnlTables, this)));
        am.put("Cut", (Action)((Object)new KDTAdjustTableAgent(table, 3, this.pnlTables, this)));
        am.put("Delete", (Action)((Object)new KDTAdjustTableAgent(table, 2, this.pnlTables, this)));
        am.put("CancelEdit", (Action)((Object)new KDTAdjustTableAgent(table, 4, this.pnlTables, this)));
    }

    protected void table_propertyChange(KDTPropertyChangeEvent e) {
        if (!this.isProcess) {
            return;
        }
        ICell cell = null;
        String formulaString = null;
        String[] parameter = null;
        BigDecimal nValue = null;
        BigDecimal oValue = null;
        BgMeasureUnitInfo muInfo = null;
        cell = this.pnlTables.getCurrentPage().getCell(e.getRowIndex(), e.getColIndex());
        if (e.getNewValue() == null || e.getNewValue().toString().trim().length() == 0) {
            return;
        }
        if (this.itemRadMearReplace.isSelected()) {
            this.alias.put(TableToolkit.xy2range((int)e.getColIndex(), (int)e.getRowIndex()), null);
            if (BgFSHelper.checkHasFormulaOfCell(cell)) {
                formulaString = BgFSHelper.getFormulaOfCell(cell);
                parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                if (parameter != null && parameter[this.paraElement] != null && parameter[this.paraElement].trim().length() > 0) {
                    if (this.measureMap.containsKey(parameter[this.paraElement])) {
                        muInfo = (BgMeasureUnitInfo)this.measureMap.get(parameter[this.paraElement]);
                        try {
                            nValue = new BigDecimal(e.getNewValue().toString().replaceAll(",", ""));
                            nValue = nValue.multiply(muInfo.getMeasureUnit().getCoefficient()).setScale(this.decimal, 4);
                        }
                        catch (Exception ex) {
                            nValue = BgConstants.BIGZERO;
                        }
                        cell.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)nValue));
                    } else if (this.bgFormInfo.getMeasureUnit() != null && BgSHelper.isNumerical(e.getNewValue())) {
                        try {
                            nValue = new BigDecimal(e.getNewValue().toString().replaceAll(",", ""));
                            nValue = nValue.multiply(this.bgFormInfo.getMeasureUnit().getCoefficient()).setScale(this.decimal, 4);
                        }
                        catch (Exception ex) {
                            nValue = BgConstants.BIGZERO;
                        }
                        cell.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)nValue));
                    }
                }
                oValue = this.initValueMap.containsKey(formulaString) ? (BigDecimal)this.initValueMap.get(formulaString) : BgConstants.BIGZERO;
                cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                this.processUpdateFormulaValue(cell, oValue, nValue);
            } else if (this.bgFormInfo.getMeasureUnit() != null && BgSHelper.isNumerical(e.getNewValue()) && BgFCHelper.isNumericalOfCell(cell)) {
                try {
                    nValue = new BigDecimal(e.getNewValue().toString().replaceAll(",", ""));
                    nValue = nValue.multiply(this.bgFormInfo.getMeasureUnit().getCoefficient()).setScale(this.decimal, 4);
                }
                catch (Exception ex) {
                    nValue = BgConstants.BIGZERO;
                }
                cell.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)nValue));
            }
        } else if (BgFSHelper.checkHasFormulaOfCell(cell)) {
            if (e.getNewValue() != null) {
                try {
                    nValue = new BigDecimal(e.getNewValue().toString().replaceAll(",", ""));
                }
                catch (Exception ex) {
                    nValue = BgConstants.BIGZERO;
                }
            } else {
                nValue = BgConstants.BIGZERO;
            }
            oValue = this.initValueMap.containsKey(formulaString) ? (BigDecimal)this.initValueMap.get(formulaString) : BgConstants.BIGZERO;
            cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
            this.processUpdateFormulaValue(cell, oValue, nValue);
        }
        this.getModifyingManager().addModifiedCount(1L);
    }

    protected void table_SelectChanged(KDTSelectEvent e) {
        ICell cell = null;
        RptCell rptCell = null;
        cell = this.pnlTables.getFoucusCell();
        if (this.checkHasFormulaOfCell(cell)) {
            rptCell = (RptCell)cell.getUserObject();
            this.processCellOfFormatInput(cell, null);
            if (this.checkFormulaOfCellIsHasEdit(rptCell)) {
                this.btnBgFormulaAddNew.setEnabled(true);
                this.btnBgFormulaRemove.setEnabled(true);
                this.itemBgItemAddNew.setEnabled(true);
                this.itemBgItemRemove.setEnabled(true);
            } else {
                this.btnBgFormulaAddNew.setEnabled(false);
                this.btnBgFormulaRemove.setEnabled(false);
                this.itemBgItemAddNew.setEnabled(false);
                this.itemBgItemRemove.setEnabled(false);
            }
        } else {
            this.btnBgFormulaAddNew.setEnabled(true);
            this.btnBgFormulaRemove.setEnabled(true);
            this.itemBgItemAddNew.setEnabled(true);
            this.itemBgItemRemove.setEnabled(true);
            this.processCellOfOtherInput(cell);
        }
    }

    @Override
    protected void table_onCellChanged(ICell cell) {
        if (cell != null && cell.getExpressions() != null) {
            try {
                String Expressions = cell.getExpressions();
                String result = new String(Expressions);
                if (Expressions != null && !Expressions.equals("")) {
                    if (Expressions.charAt(0) == '=') {
                        Expressions = "value" + Expressions;
                    }
                    ExprStmt stmt = RptFormulaParser.parse((String)Expressions);
                    BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
                    CodeExpr codeExpr = expr.right;
                    try {
                        result = "=" + this.subDealFormula(codeExpr, this.bgFormInfo);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                cell.setExpressions(result);
                this.setCellStyleToText(cell, null);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError"));
                SysUtil.abort();
            }
        }
    }

    protected void table_Clicked(KDTMouseEvent e) {
        ICell cell;
        if (e.getClickCount() == 1 && (cell = this.pnlTables.getCurrentPage().getCell(e.getRowIndex(), e.getColIndex())).getEditor() == null && this.checkHasFormulaOfCell(cell)) {
            cell.setEditor((ICellEditor)this.defEditor);
        }
    }

    protected void table_EditStarting(KDTEditEvent e) {
    }

    protected void table_EditStarted(KDTEditEvent e) {
    }

    protected void table_EditValueChanged(KDTEditEvent e) {
    }

    protected void table_EditStopping(KDTEditEvent e) {
    }

    protected void table_EditStopped(KDTEditEvent e) {
        ICell cell = null;
        BigDecimal measure = null;
        cell = this.pnlTables.getCurrentPage().getCell(e.getRowIndex(), e.getColIndex());
        if (!this.checkHasFormulaOfCell(cell) && this.itemdata.isSelected() && this.bgFormInfo.getMeasureUnit() != null && cell.getEditor() == null && !this.checkHasFormulaOfCell(cell) && !BgFSHelper.checkIsLinkCell(cell) && BgSHelper.isNumerical(e.getValue()) && BgFCHelper.isNumericalOfCell(cell)) {
            measure = new BigDecimal(e.getValue().toString().trim().replaceAll(",", ""));
            measure = measure.multiply(this.bgFormInfo.getMeasureUnit().getCoefficient()).setScale(this.decimal, 4);
            this.processCellOfBgFormEditor(cell, "CELL_MEASUNIT", true);
            cell.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)measure));
        }
        this.getModifyingManager().addModifiedCount(1L);
        this.alias.clear();
    }

    protected void table_EditCanceled(KDTEditEvent e) {
    }

    @Override
    protected void processItemAddNew(ICell cell) throws Exception {
        if (cell == null || cell.getUserObject() == null) {
            return;
        }
        if (BgFSHelper.checkHasFormulaOfCell(cell)) {
            String[] parameter = this.checkBudgetFormula(cell, true);
            BigDecimal value = null;
            this.processCellOfFormatInput(cell, parameter[this.paraCurrency]);
            if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0) {
                try {
                    value = new BigDecimal(cell.getValue().toString().trim().replaceAll(",", ""));
                }
                catch (Exception ex) {
                    value = BgConstants.BIGZERO;
                }
                this.processUpdateFormulaValue(cell, null, value);
            } else {
                this.processUpdateFormulaValue(cell, null, null);
            }
        }
    }

    protected void processUpdateFormulaValue(ICell cell, BigDecimal oldValue, BigDecimal newValue) {
        if (cell == null) {
            return;
        }
        RptCell rptCell = null;
        rptCell = (RptCell)cell.getUserObject();
        String formulaString = rptCell.getItemFormulaLine();
        if (formulaString == null || formulaString.trim().length() == 0) {
            return;
        }
        BgFormDiversityData data = null;
        if (this.adjustMap.containsKey(formulaString)) {
            data = (BgFormDiversityData)this.adjustMap.get(formulaString);
            if (data == null) {
                data = new BgFormDiversityData();
            }
            this.adjustMap.remove(formulaString);
        } else {
            data = new BgFormDiversityData();
            data.setFormula(formulaString);
            data.setOldValue(oldValue);
        }
        data.setNewValue(newValue);
        data.setAdjustor(this.user.getId().toString());
        data.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        if (data.getOldValue() == null && data.getNewValue() == null) {
            cell.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
        } else if (data.getOldValue() != null && data.getNewValue() != null) {
            if (data.getNewValue().compareTo(data.getOldValue()) != 0) {
                this.adjustMap.put(formulaString, data);
            } else {
                cell.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
            }
        } else {
            this.adjustMap.put(formulaString, data);
        }
    }

    public void processUpdateFormulaValue(boolean mode) {
        if (mode) {
            this.changedMap.clear();
        }
        String formulaString = null;
        KDTable table = null;
        IRow row = null;
        IColumn column = null;
        ICell cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int n = this.pnlTables.getSheets().size();
        for (int i = 0; i < n; ++i) {
            table = this.pnlTables.getSheet(i).getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = table.getRow(rowIndex);
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    column = table.getColumn(colIndex);
                    cell = table.getCell(rowIndex, colIndex);
                    if (!this.checkHasFormulaOfCell(cell)) continue;
                    formulaString = this.getFormulaOfCell(cell);
                    if (mode) {
                        this.processUpdateLoadValue(row, column, cell, formulaString);
                        continue;
                    }
                    this.processUpdateChangedValue(row, column, cell, formulaString);
                }
            }
        }
    }

    protected void processUpdateLoadValue(IRow row, IColumn column, ICell cell, String formulaString) {
        if (!this.changedMap.containsKey(formulaString)) {
            if (cell.getValue() == null) {
                this.changedMap.put(formulaString, null);
            } else if (this.adjustMap.containsKey(formulaString)) {
                BgFormDiversityData data = (BgFormDiversityData)this.adjustMap.get(formulaString);
                this.changedMap.put(formulaString, data.getOldValue());
            } else {
                try {
                    this.changedMap.put(formulaString, new BigDecimal(cell.getValue().toString().trim().replaceAll(",", "")));
                }
                catch (Exception ex) {
                    cell.setValue(null);
                    this.changedMap.put(formulaString, null);
                }
            }
        }
    }

    protected void processUpdateChangedValue(IRow row, IColumn column, ICell cell, String formulaString) {
        block16: {
            BigDecimal oldValue = null;
            BigDecimal newValue = null;
            if (this.changedMap.containsKey(formulaString)) {
                oldValue = (BigDecimal)this.changedMap.get(formulaString);
                if (cell.getValue() == null) {
                    if (oldValue != null) {
                        cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                        this.processUpdateFormulaValue(cell, oldValue, null);
                    }
                } else if (oldValue == null) {
                    cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                    try {
                        newValue = new BigDecimal(cell.getValue().toString().trim().replaceAll(",", ""));
                    }
                    catch (Exception ex) {
                        newValue = BgConstants.BIGZERO;
                    }
                    this.processUpdateFormulaValue(cell, null, newValue);
                } else {
                    try {
                        newValue = new BigDecimal(cell.getValue().toString());
                        if (newValue.compareTo(oldValue) != 0) {
                            cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                            this.processUpdateFormulaValue(cell, oldValue, newValue);
                            break block16;
                        }
                        cell.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
                        this.adjustMap.remove(formulaString);
                    }
                    catch (Exception ex) {
                        cell.setValue(null);
                    }
                }
            } else if (cell.getValue() != null) {
                try {
                    newValue = new BigDecimal(cell.getValue().toString());
                }
                catch (Exception ex) {
                    cell.setValue((Object)"0");
                    newValue = BgConstants.BIGZERO;
                }
                if (newValue.compareTo(BgConstants.BIGZERO) != 0) {
                    cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                    this.processUpdateFormulaValue(cell, null, newValue);
                }
            }
        }
    }

    @Override
    protected void beforeFileSave() throws Exception {
        KDTable table = null;
        ICell cell = null;
        RptCell rptCell = null;
        RptCell nRptCell = null;
        String formulaString = null;
        String[] formulaInfo = null;
        String[] parameter = null;
        ArrayList<String[]> check = new ArrayList<String[]>();
        int rowCount = 0;
        int colCount = 0;
        boolean isHasFormula = false;
        boolean isLoad = false;
        boolean isCheck = false;
        int count = this.pnlTables.getSheets().size();
        for (int index = 0; index < count; ++index) {
            table = this.pnlTables.getSheet(index).getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    cell = table.getCell(r, c);
                    isHasFormula = false;
                    if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) != null && formulaString.trim().length() > 0) {
                        isHasFormula = true;
                        parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                        this.checkAllFormula(formulaString, r, c);
                        isLoad = false;
                        isCheck = false;
                        isCheck = this.checkFormulaOfCellIsHasEdit(rptCell);
                        try {
                            if (isCheck && parameter == null) {
                                throw new BgFormException(BgFormException.FORMULAADDERROR);
                            }
                            if (isCheck && parameter[this.paraItem] == null) {
                                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, new String[]{formulaString});
                            }
                            if (parameter[this.paraPeriod] == null || parameter[this.paraPeriod].trim().length() == 0) {
                                parameter[this.paraPeriod] = this.bgFormInfo.getBgPeriod().getNumber();
                                isLoad = true;
                            }
                            if (isCheck && (parameter[this.paraElement] == null || parameter[this.paraElement].trim().length() == 0)) {
                                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, new String[]{formulaString});
                            }
                            if (isCheck && (parameter[this.paraDataType] == null || parameter[this.paraDataType].trim().length() == 0 || parameter[this.paraDataType].equals(BgDataTypeEnum.BgActual.getName()))) {
                                parameter[this.paraDataType] = BgDataTypeEnum.BgData.getName();
                                isLoad = true;
                            }
                            if (isCheck && (parameter[this.paraCollect] == null || parameter[this.paraCollect].trim().length() == 0)) {
                                parameter[this.paraCollect] = Boolean.TRUE.toString();
                                isLoad = true;
                            }
                            if (parameter[this.paraCurrency] == null || parameter[this.paraCurrency].trim().length() == 0) {
                                parameter[this.paraCurrency] = this.bgFormInfo.getCurrency().getNumber();
                                isLoad = true;
                            }
                        }
                        catch (EASBizException ex) {
                            this.pnlTables.setSelectedIndex(index);
                            table.getSelectManager().select(r, c, r, c);
                            throw ex;
                        }
                        if (isLoad) {
                            if (this.formulaMap != null && this.formulaMap.containsKey(formulaString)) {
                                this.formulaMap.remove(formulaString);
                            }
                            formulaString = new StringBuffer("=BgItem(\"" + parameter[this.paraItem] + "\",\"" + parameter[this.paraPeriod] + "\",\"" + parameter[this.paraDataType] + "\",\"" + parameter[this.paraDataType] + "\"," + parameter[this.paraCollect] + ",\"" + parameter[this.paraCurrency] + "\")").toString();
                            this.getFormulaInfo(this.formulaMap, formulaString);
                            rptCell.setItemFormula(formulaString);
                        }
                        formulaInfo = new String[]{table.getName(), formulaString, String.valueOf(r), String.valueOf(c)};
                        check.add(formulaInfo);
                        if (this.formulaStr != null && this.formulaStr.equals(formulaString)) {
                            cell.getStyleAttributes().setBackground(this.backColor);
                        }
                    }
                    nRptCell = (RptCell)cell.getUserObject();
                    if (cell.getExpressions() == null || cell.getExpressions().trim().length() == 0) {
                        if (!isHasFormula || nRptCell.getItemFormula() == null) continue;
                        if (this.isBudget) {
                            nRptCell.getItemFormula().removeExt("BG_BUDGET_EXPRESSIONS");
                            continue;
                        }
                        nRptCell.getItemFormula().removeExt("BG_ACTUAL_EXPRESSIONS");
                        continue;
                    }
                    if (!isHasFormula) continue;
                    if (nRptCell.getItemFormula() == null) {
                        nRptCell.setItemFormula(new ItemFormula());
                    }
                    if (this.isBudget) {
                        nRptCell.getItemFormula().putExt("BG_BUDGET_EXPRESSIONS", cell.getExpressions());
                        continue;
                    }
                    nRptCell.getItemFormula().putExt("BG_ACTUAL_EXPRESSIONS", cell.getExpressions());
                }
            }
        }
        BgFormHelper.checkFormulaIsEctype(check);
    }

    protected void checkAllFormula(String formulaString, int rowIndex, int colIndex) {
    }

    @Override
    protected void afterFileSave() throws Exception {
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String formulaString2 = null;
        String[] parameter = null;
        HashMap removeMap = new HashMap();
        KDTable table = null;
        ICell cell = null;
        this.after.clear();
        int count = this.pnlTables.getSheetCount();
        for (int index = 0; index < count; ++index) {
            table = this.pnlTables.getSheet(index).getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = table.getCell(rowIndex, colIndex);
                    if (!this.checkHasFormulaOfCell(cell)) continue;
                    formulaString2 = this.getFormulaOfCell(cell);
                    this.after.put(formulaString2, null);
                }
            }
        }
        for (String formulaString2 : this.before.keySet()) {
            if (this.after.containsKey(formulaString2) || (parameter = this.getFormulaInfo(this.formulaMap, formulaString2)) == null || parameter[this.paraItem] == null) continue;
            removeMap.put(parameter[this.paraItem].replaceAll(",", "_"), null);
        }
        try {
            if (!removeMap.isEmpty()) {
                if (this.ibgTemplate == null) {
                    this.ibgTemplate = BgTemplateFactory.getRemoteInstance();
                }
                this.ibgTemplate.deleteCombinItemByKey(removeMap);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        this.before.clear();
        this.before.putAll(this.after);
        this.after.clear();
    }

    protected void processFormulaUpateOnSheets() throws Exception {
        BigDecimal value = null;
        String formulaString2 = null;
        String valueString = null;
        String[] parameter = null;
        KDTable table = null;
        ICell cell = null;
        RptCell rptCell = null;
        int rowCount = 0;
        int colCount = 0;
        int compareValue = 0;
        HashMap checkMap = new HashMap();
        int count = this.pnlTables.getSheets().size();
        for (int index = 0; index < count; ++index) {
            table = this.pnlTables.getSheet(index).getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    cell = table.getCell(r, c);
                    if (!this.checkHasFormulaOfCell(cell)) continue;
                    rptCell = (RptCell)cell.getUserObject();
                    formulaString2 = this.getFormulaOfCell(cell);
                    parameter = this.getFormulaInfo(this.formulaMap, formulaString2);
                    checkMap.put(formulaString2, null);
                    if (cell.getValue() == null || cell.getValue().toString().trim().length() == 0) {
                        rptCell.getItemFormula().putExt("BG_BUDGET_VALUE", null);
                        if (parameter[this.paraDataType] != null && parameter[this.paraDataType].equals(BgDataTypeEnum.BgActual.getName())) {
                            rptCell.getItemFormula().putExt("BG_ACTUAL_VALUE", null);
                        }
                    } else {
                        try {
                            value = new BigDecimal(cell.getValue().toString().trim().replaceAll(",", ""));
                        }
                        catch (Exception ex) {
                            value = BgConstants.BIGZERO;
                        }
                        compareValue = value.compareTo(BgConstants.BIGZERO);
                        if (compareValue > 0) {
                            if (BgFSHelper.checkHasOverstepMax(valueString)) {
                                throw new BgFormException(BgFormException.VALUEHASOVERSTEPMAX, new String[]{TableToolkit.xy2range((int)c, (int)r)});
                            }
                        } else if (compareValue < 0 && BgFSHelper.checkHasOverstepMin(valueString)) {
                            throw new BgFormException(BgFormException.VALUEHASOVERSTEPMIN, new String[]{TableToolkit.xy2range((int)c, (int)r)});
                        }
                        valueString = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value);
                        rptCell.getItemFormula().putExt("BG_BUDGET_VALUE", valueString);
                        if (parameter[this.paraDataType] != null && parameter[this.paraDataType].equals(BgDataTypeEnum.BgActual.getName())) {
                            rptCell.getItemFormula().putExt("BG_ACTUAL_VALUE", valueString);
                        }
                    }
                    if (cell.getExpressions() == null || cell.getExpressions().equals("")) {
                        rptCell.getItemFormula().putExt("BG_BUDGET_EXPRESSIONS", null);
                    } else {
                        rptCell.getItemFormula().putExt("BG_BUDGET_EXPRESSIONS", cell.getExpressions());
                    }
                    this.searchBgFormulaOfForm(cell, formulaString2);
                }
            }
        }
        ArrayList<String> removeInfo = new ArrayList<String>();
        for (String formulaString2 : this.adjustMap.keySet()) {
            if (checkMap.containsKey(formulaString2)) continue;
            removeInfo.add(formulaString2);
        }
        int n = removeInfo.size();
        for (int i = 0; i < n; ++i) {
            this.adjustMap.remove(removeInfo.get(i));
        }
    }

    public void searchBgFormulaOfForm(ICell cell, String formulaString) {
    }

    public void actionEditCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.pnlTables.getCurrentPage();
        table.getEditHelper().copy(2);
    }

    public void actionEditCut_actionPerformed(ActionEvent e) throws Exception {
        this.processUpdateFormulaValue(true);
        KDTable table = this.pnlTables.getCurrentPage();
        KDTRange rangeCut = table.getSelectManager().toRange();
        table.getEditHelper().copy();
        table.getEditHelper().delete(rangeCut.getSequenceRange(), 2);
        this.processUpdateFormulaValue(false);
    }

    public void actionEditPaste_actionPerformed(ActionEvent e) throws Exception {
        this.processUpdateFormulaValue(true);
        KDTable table = this.pnlTables.getCurrentPage();
        table.getEditHelper().paste(2);
        this.processUpdateFormulaValue(false);
    }

    @Override
    public void actionFormCollect_actionPerformed(ActionEvent e) throws Exception {
        super.actionFormCollect_actionPerformed(e);
        this.collectBgFormInfo();
    }

    @Override
    public void actionCollectView_actionPerformed(ActionEvent e) throws Exception {
        super.actionCollectView_actionPerformed(e);
        Map aliasMap = null;
        Hashtable<String, String> bgSchemeMap = null;
        ArrayList<OrgUnitInfo> orgUnitList = null;
        boolean collectType = false;
        String formulaString = this.getFormulaOfCell(null);
        if (formulaString != null && formulaString.trim().length() > 0) {
            String[] parameter;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"COLLECT_FORMULA", (Object)formulaString);
            String[] str = null;
            String[] orgStr = null;
            String[] bgSchemeStr = null;
            OrgUnitInfo orgInfo = null;
            orgUnitList = new ArrayList<OrgUnitInfo>();
            bgSchemeMap = new Hashtable<String, String>();
            KDTable table = this.pnlTables.getCurrentPage();
            if (table.getUserObject() != null && table.getUserObject() instanceof HashMap) {
                aliasMap = (Map)table.getUserObject();
                if (aliasMap.containsKey("IS_COLLECT_ADJUST")) {
                    collectType = (Boolean)aliasMap.get("IS_COLLECT_ADJUST");
                }
                if (aliasMap.containsKey("COLLECT_ORGUNIT")) {
                    str = (String[])aliasMap.get("COLLECT_ORGUNIT");
                    int in = str.length;
                    for (int i = 0; i < in; ++i) {
                        orgInfo = new OrgUnitInfo();
                        orgStr = str[i].split("_");
                        orgInfo.setId(BOSUuid.read((String)orgStr[0]));
                        orgInfo.setName(orgStr[1]);
                        orgUnitList.add(orgInfo);
                    }
                }
                if (aliasMap.containsKey("COLLECT_SCHEME")) {
                    str = (String[])aliasMap.get("COLLECT_SCHEME");
                    int jn = str.length;
                    for (int j = 0; j < jn; ++j) {
                        bgSchemeStr = str[j].split("_");
                        bgSchemeMap.put(bgSchemeStr[0], bgSchemeStr[1]);
                    }
                }
            }
            if ((parameter = this.getFormulaInfo(this.formulaMap, formulaString)) != null && parameter[this.paraElement] != null && this.measureMap.containsKey(parameter[this.paraElement])) {
                BgMeasureUnitInfo muInfo = (BgMeasureUnitInfo)this.measureMap.get(parameter[this.paraElement]);
                uiContext.put((Object)"COLLECT_MEASUREUNIT", (Object)muInfo.getMeasureUnit().getCoefficient());
            } else if (this.bgFormInfo.getMeasureUnit() != null) {
                uiContext.put((Object)"COLLECT_MEASUREUNIT", (Object)this.bgFormInfo.getMeasureUnit().getCoefficient());
            }
            uiContext.put((Object)"COLLECT_ORGUNIT", orgUnitList);
            uiContext.put((Object)"COLLECT_SCHEME", bgSchemeMap);
            uiContext.put((Object)"COLLECT_DATA_TYPE", (Object)new Boolean(this.isBudget));
            uiContext.put((Object)"IS_COLLECT_ADJUST", (Object)new Boolean(collectType));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCollectViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkFormulaNoCollectView"));
        }
    }

    @Override
    public void actionCtrlSet_actionPerformed(ActionEvent e) throws Exception {
        BgItemFormulaCHelper.ctrlSet((IUIObject)this, this.pnlTables.getCurrentPage(), this.ctrlModeMap, this.ctrlModeCellMap, true);
    }

    @Override
    public void actionSheetCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.isProcess = false;
        this.processCurrPageCalculate(e);
    }

    protected void beforeBackCalCurrPage() {
        this.btnCalcCurrPage.setEnabled(false);
        this.actionSheetCalculate.setEnabled(false);
        this.isProcess = false;
        this.processUpdateFormulaValue(true);
    }

    protected void afterBackCalCurrPage() {
        this.processUpdateFormulaValue(false);
        this.isProcess = true;
        this.actionSheetCalculate.setEnabled(true);
        this.btnCalcCurrPage.setEnabled(true);
    }

    @Override
    protected BOSUuid getBgExmCheckReportId() {
        return this.bgFormInfo.getAdjust().getId();
    }

    @Override
    protected void setFormulaValueOfSheet(Map valueMap) {
        this.processUpdateFormulaValue(true);
        super.setFormulaValueOfSheet(valueMap);
        this.processUpdateFormulaValue(false);
    }

    @Override
    protected void beforeCollect() throws Exception {
        super.beforeCollect();
        this.processUpdateFormulaValue(true);
    }

    @Override
    protected void afterCollect() throws Exception {
        super.afterCollect();
        this.processUpdateFormulaValue(false);
    }

    @Override
    public boolean destroyWindow() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return super.destroyWindow();
        }
        String state = this.getOprtState();
        this.editDataUI.setOprtState(OprtState.VIEW);
        boolean re = super.destroyWindow();
        if (!re) {
            this.editDataUI.setOprtState(state);
        }
        return re;
    }

    @Override
    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re) {
            // empty if block
        }
        return re;
    }
}

