/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgAnlysisFormCollection;
import com.kingdee.eas.ma.budget.BgAnlysisFormFactory;
import com.kingdee.eas.ma.budget.BgAnlysisFormInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.SavedAnalysisFormTypeEnum;
import com.kingdee.eas.ma.budget.client.AbstractBgFormAnalysisListUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisSavedFormMainUI;
import com.kingdee.eas.ma.budget.client.NewDirectedBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgFormAnalysisListUI
extends AbstractBgFormAnalysisListUI {
    private static final long serialVersionUID = 7246455463493783866L;
    public static final String VIEW_PERM = "_view";
    public static final String ANALYSE_PERM = "_analyse";
    public static final String LIST_PERM = "_list";
    private String permission_preix = "invoke";
    public static final String resourcePath = "com.kingdee.eas.ma.budget.client.NewAnalysisResource";
    private List analysisElementList = Collections.unmodifiableList(Arrays.asList("col4", "col0", "col30", "col1", "col2", "col3"));

    public BgFormAnalysisListUI() throws Exception {
        this.setDefaultPermission_preix();
    }

    public String getPermission_preix() {
        return this.permission_preix;
    }

    public void setPermission_preix(String permission_preix) {
        this.permission_preix = permission_preix;
    }

    @Override
    public String getPermissionNum() {
        return this.permission_preix + LIST_PERM;
    }

    public void setDefaultPermission_preix() {
    }

    public void checkPermission(String permissionType) throws BOSException, EASBizException {
        String perm_str = this.permission_preix + permissionType;
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        boolean success = false;
        success = iPermisstion.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, perm_str);
        if (!success) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"239_BgFormAnalysisListUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.checkPermission(LIST_PERM);
        super.onLoad();
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        this.btnAnalysisSetting.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnAnalysis.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.btnView.setVisible(true);
        this.btnView.setEnabled(true);
        this.menuEdit.setVisible(false);
        this.treeOrgUnit.setEnabled(true);
        this.itemViewFlow.setVisible(false);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        filter = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        FilterItemInfo item = new FilterItemInfo("state".toLowerCase(), state, CompareType.NOTINCLUDE);
        this.addFilterItem(filter, item);
        if (BgParamCHelper.isBgPermissionUsed()) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermission((String)userId, (Set)this.getPermissionOrg(), (FilterInfo)filter);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate = 4", CompareType.NOTINNER));
        if (!StringUtils.isEmpty((String)filter.getMaskString())) {
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        }
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(4), CompareType.NOTEQUALS));
        if (!StringUtils.isEmpty((String)filter.getMaskString())) {
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        }
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (!StringUtils.isEmpty((String)filter.getMaskString())) {
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        }
        viewInfo.setFilter(filter);
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        if (viewInfo.getSorter().isEmpty()) {
            viewInfo.getSorter().add(new SorterItemInfo("bgScheme.number"));
        } else if (viewInfo.getSorter().size() > 1) {
            viewInfo.getSorter().removeObject(1);
        }
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    public void actionAnalysis_actionPerformed(ActionEvent e) throws Exception {
        Object currency;
        Object bgForm;
        Object scheme;
        this.checkPermission(ANALYSE_PERM);
        this.checkSelected();
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(activeRowIndex);
        NewBgCompareAndAnalysisFilterParam filterParam = new NewBgCompareAndAnalysisFilterParam();
        Object orgUnit = row.getCell("orgUnit.id").getValue();
        if (orgUnit != null) {
            CostCenterOrgUnitInfo info = new CostCenterOrgUnitInfo();
            info.setId(BOSUuid.read((String)orgUnit.toString()));
            filterParam.setCostCenterOrgUnitInfoAry(new CostCenterOrgUnitInfo[]{info});
            filterParam.setLazyLoadDataCostCenterOrgUnitInfoAry(new CostCenterOrgUnitInfo[]{info});
        }
        if ((scheme = row.getCell("bgScheme.id").getValue()) != null) {
            BgSchemeInfo info = new BgSchemeInfo();
            info.setId(BOSUuid.read((String)scheme.toString()));
            filterParam.setBgSchemeInfo(info);
        }
        if ((bgForm = row.getCell("id").getValue()) != null) {
            filterParam.setBgFormID(bgForm.toString());
        }
        if ((currency = row.getCell("currency.id").getValue()) != null) {
            CurrencyInfo info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)currency.toString()));
            filterParam.setCurrencyInfo(info);
        }
        filterParam.setTitleColsList(new ArrayList());
        filterParam.setAnalysisElement(this.constructAnalysisElementList());
        String uiName = NewDirectedBgCompareAndAnalysisMainUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"DirectFilterParam", (Object)filterParam);
        uiContext.put((Object)"AnalysisFormType", (Object)this.getAnalysisFormType());
        NewBgCompareAndAnalysisMainUI.isNeedToDelOldWin(uiContext, uiName);
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        IUIWindow uiWindow = null;
        uiWindow = !(frame instanceof NewMainFrame) ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected SavedAnalysisFormTypeEnum getAnalysisFormType() {
        return SavedAnalysisFormTypeEnum.BaseAnalysisSavedForm;
    }

    protected List constructAnalysisElementList() {
        return this.analysisElementList;
    }

    @Override
    public void actionAnalysisSetting_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(VIEW_PERM);
        this.checkSelected();
        String uiName = NewBgCompareAndAnalysisSavedFormMainUI.class.getName();
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(activeRowIndex);
        Object bgFormID = row.getCell("id").getValue();
        if (bgFormID != null) {
            BgAnlysisFormCollection col = BgAnlysisFormFactory.getRemoteInstance().getBgAnlysisFormCollection("select id ,bgFormID, data ,analysisFormType where bgFormID = '" + bgFormID + "'");
            int size = col.size();
            if (size != 0) {
                for (int i = 0; i < size; ++i) {
                    BgAnlysisFormInfo info = col.get(i);
                    SavedAnalysisFormTypeEnum analysisFormTypeEnum = info.getAnalysisFormType();
                    if (!this.getAnalysisFormType().equals((Object)analysisFormTypeEnum)) continue;
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"BgFormInfo", (Object)info);
                    uiContext.put((Object)"DIRECT_ANALYSIS_ELEMENT", (Object)this.constructAnalysisElementList());
                    uiContext.put((Object)"AnalysisFormType", (Object)this.getAnalysisFormType());
                    NewBgCompareAndAnalysisMainUI.isNeedToDelOldWin(uiContext, uiName);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                    return;
                }
                MsgBox.showWarning((Component)((Object)this), (String)this.showMsg());
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)this.showMsg());
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)this.showMsg());
        }
    }

    private String showMsg() {
        SavedAnalysisFormTypeEnum analysisFormType = this.getAnalysisFormType();
        String title = "";
        if (SavedAnalysisFormTypeEnum.AdjustlAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)resourcePath, (String)"Form_Without_Adjust_Form");
        } else if (SavedAnalysisFormTypeEnum.BaseAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)resourcePath, (String)"Form_Without_Base_Form");
        } else if (SavedAnalysisFormTypeEnum.LYActualAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)resourcePath, (String)"Form_Without_LYBudget_Form");
        } else if (SavedAnalysisFormTypeEnum.LYBudgetAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)resourcePath, (String)"Form_Without_LYActual_Form");
        }
        return title;
    }
}

