/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.ma.budget.BgConstants;
import java.awt.Graphics;
import java.awt.Shape;
import java.math.BigDecimal;

public class BgFormCellRender
extends CellTextRender {
    protected BigDecimal measure = BgConstants.ONE;
    protected int decimal = 10;

    public BgFormCellRender(BigDecimal measure, int decimal) {
        if (measure != null && measure.compareTo(BgConstants.BIGZERO) != 0) {
            this.measure = measure;
        }
        if (decimal >= 0) {
            this.decimal = decimal;
        }
    }

    public String getText(Object object) {
        if (object == null) {
            return null;
        }
        String text = new BigDecimal(object.toString().replaceAll(",", "")).divide(this.measure, this.decimal, 4).toString();
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object == null) {
            return;
        }
        String text = null;
        try {
            text = this.getText(object);
        }
        catch (Exception ex) {
            text = null;
        }
        finally {
            super.draw(graphics, clip, (Object)text, cellStyle);
        }
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public BigDecimal getMeasure() {
        return this.measure;
    }

    public void setMeasure(BigDecimal measure) {
        this.measure = measure;
    }
}

