/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormObject;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.AbstractBgFormF7UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgFormF7UI
extends AbstractBgFormF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormF7UI.class);
    private String SchemID = null;
    private BgFormCollection colBgForm = new BgFormCollection();
    private BgFormObject result = null;
    private boolean isCancel = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.SchemID = this.getUIContext().get("schemeId").toString();
        IBgForm ibgForm = BgFormFactory.getRemoteInstance();
        BgFormCollection temColl = new BgFormCollection();
        if (this.SchemID != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.SchemID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(15), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate = 4", CompareType.NOTINNER));
            filter.getFilterItems().add(new FilterItemInfo("record", (Object)new Integer(1), CompareType.NOTEQUALS));
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getBgFormSelectors());
            temColl = ibgForm.getBgFormCollection(view);
        }
        BgHelper.sortCollection(temColl, new String[]{"number"});
        if (temColl != null && !temColl.isEmpty()) {
            this.tblMain.removeRows();
            Iterator iter = temColl.iterator();
            while (iter.hasNext()) {
                BgFormInfo info = (BgFormInfo)iter.next();
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)info);
                iRow.getCell("choose").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)info.getNumber());
                iRow.getCell("name").setValue((Object)info.getName());
                iRow.getCell("creator").setValue((Object)info.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)info.getCreateTime());
            }
        }
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnAllSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnAllSelect_actionPerformed(e);
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.colBgForm = new BgFormCollection();
        BgFormInfo info = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!((Boolean)this.tblMain.getRow(i).getCell("choose").getValue()).booleanValue()) continue;
            IRow iRow = this.tblMain.getRow(i);
            info = (BgFormInfo)iRow.getUserObject();
            this.colBgForm.add(info);
        }
        if (this.colBgForm.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"255_BgFormF7UI"));
            SysUtil.abort();
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.colBgForm = null;
        this.getUIWindow().close();
    }

    public String getSchemID() {
        if (this.SchemID == null) {
            return "schemid";
        }
        return this.SchemID;
    }

    public void setSchemID(String schemID) {
        this.SchemID = schemID;
    }

    public SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        return sic;
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public Object getData() {
        if (this.colBgForm != null && this.colBgForm.size() != 0) {
            this.result = new BgFormObject(this.colBgForm);
        }
        return this.result;
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }
}

