/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFCHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormPeriodData;
import com.kingdee.eas.ma.budget.BgFormPeriodFilterParam;
import com.kingdee.eas.ma.budget.BgFormPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgFormPeriodEditUI;
import com.kingdee.eas.ma.budget.client.BgFormFilterUI;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormAdjustListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormAdjustProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgFormPeriodEditUI
extends AbstractBgFormPeriodEditUI {
    private static final long serialVersionUID = -6144171242447909095L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormPeriodEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgFormPeriodResource";
    private OrgUnitInfo defOrgUnitInfo = null;
    private static final int bgSchemeColIndex = 0;
    private static final int bgFormColIndex = 1;
    private static final int bgPeriodColIndex = 2;
    private static final int currencyColIndex = 3;
    private static final int rateColIndex = 4;
    private static final int bgFormPeriodColIndex = 5;

    public BgFormPeriodEditUI() throws Exception {
    }

    public BgFormPeriodEditUI(Object ui, Object orgUnitInfo) throws Exception {
        this.ui = ui;
        this.defOrgUnitInfo = orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo ? (OrgUnitInfo)orgUnitInfo : SysContext.getSysContext().getCurrentCostUnit();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
        this.initSystemInfo();
        this.initUIStyle();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void restart(OrgUnitInfo orgUnitInfo) throws Exception {
        if (this.defOrgUnitInfo != null && !this.defOrgUnitInfo.getId().equals((Object)orgUnitInfo.getId())) {
            this.defOrgUnitInfo = orgUnitInfo;
            this.clear();
            this.initUISelectBgScheme();
            this.initUISelectBgForm();
            this.initUISelectBgPeriod();
            this.initUISelectCurrency();
            this.initUIInputRate();
        }
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    protected IBgPeriod getBgPeriodInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    protected ICurrency getCurrencyInterface() throws Exception {
        return CurrencyFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        this.btnSFormSelect.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
        this.btnSAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnSRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnTFormSelect.setIcon(EASResource.getIcon((String)"imgTbtn_list"));
        this.btnTAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnTRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void initSystemInfo() {
        ActionMap map = this.sTable.getActionMap();
        map.remove("Cut");
        map.remove("Delete");
        map.remove("Copy");
        map.remove("Paste");
        map = this.tTable.getActionMap();
        map.remove("Cut");
        map.remove("Delete");
        map.remove("Copy");
        map.remove("Paste");
    }

    protected void initUIStyle() throws Exception {
        this.initSheet(this.sTable, this.tTable);
        if (this.ui instanceof BgNFProcessUI) {
            this.sTable.getColumn(0).getStyleAttributes().setLocked(true);
            this.sTable.getColumn(1).getStyleAttributes().setLocked(true);
            this.tTable.getColumn(0).getStyleAttributes().setLocked(true);
            this.tTable.getColumn(1).getStyleAttributes().setLocked(true);
            this.btnSFormSelect.setEnabled(false);
            this.btnTFormSelect.setEnabled(false);
        } else {
            this.initUISelectBgScheme();
            this.initUISelectBgForm();
        }
        this.initUISelectBgPeriod();
        this.initUISelectCurrency();
        this.initUIInputRate();
    }

    protected void initSheet(KDTable sTable, KDTable tTable) throws Exception {
        if (sTable == null || tTable == null) {
            return;
        }
        sTable.checkParsed(true);
        sTable.setRefresh(false);
        IRow sRow = null;
        IRow tRow = null;
        sTable.addColumns(6);
        sRow = sTable.addHeadRow();
        sTable.getColumn(0).setWidth(200);
        sTable.getColumn(1).setWidth(250);
        sTable.getColumn(2).setWidth(100);
        sTable.getColumn(3).setWidth(75);
        sTable.getColumn(4).setWidth(85);
        sTable.getColumn(5).setWidth(100);
        sRow.getCell(0).setValue((Object)BgFormPeriodHelper.getMessage("bgScheme"));
        sRow.getCell(1).setValue((Object)BgFormPeriodHelper.getMessage("bgForm"));
        sRow.getCell(2).setValue((Object)BgFormPeriodHelper.getMessage("bgSPeriod"));
        sRow.getCell(3).setValue((Object)BgFormPeriodHelper.getMessage("currency"));
        sRow.getCell(4).setValue((Object)BgFormPeriodHelper.getMessage("rate"));
        sRow.getCell(5).setValue((Object)BgFormPeriodHelper.getMessage("bgPeriod"));
        sTable.setRefresh(true);
        tTable.checkParsed(true);
        tTable.setRefresh(false);
        tTable.addColumns(6);
        tRow = tTable.addHeadRow();
        tTable.getColumn(0).setWidth(200);
        tTable.getColumn(1).setWidth(250);
        tTable.getColumn(2).setWidth(100);
        tTable.getColumn(3).setWidth(75);
        tTable.getColumn(4).setWidth(85);
        tTable.getColumn(5).setWidth(100);
        tRow.getCell(0).setValue((Object)BgFormPeriodHelper.getMessage("bgScheme"));
        tRow.getCell(1).setValue((Object)BgFormPeriodHelper.getMessage("bgForm"));
        tRow.getCell(2).setValue((Object)BgFormPeriodHelper.getMessage("bgTPeriod"));
        tRow.getCell(3).setValue((Object)BgFormPeriodHelper.getMessage("currency"));
        tRow.getCell(4).setValue((Object)BgFormPeriodHelper.getMessage("rate"));
        tRow.getCell(5).setValue((Object)BgFormPeriodHelper.getMessage("bgPeriod"));
        tTable.setRefresh(true);
        if (this.ui != null && (this.ui instanceof BgNFormListUI || this.ui instanceof BgNFormAdjustListUI)) {
            this.Title.setText("<html><font size=3>" + BgFormPeriodHelper.getMessage("title") + "</font></html>");
        } else {
            this.Title.setText("<html><font size=3>" + BgFormPeriodHelper.getMessage("titleSheet") + "</font></html>");
        }
    }

    protected void initUISelectBgScheme() throws Exception {
        KDTDefaultCellEditor sCellEditor = null;
        KDTDefaultCellEditor tCellEditor = null;
        KDBizPromptBox prmtSSelect = null;
        KDBizPromptBox prmtTSelect = null;
        prmtSSelect = new KDBizPromptBox();
        prmtSSelect.setQueryInfo("com.kingdee.eas.ma.budget.BgSchemeF7Query");
        prmtSSelect.setDisplayFormat("$name$");
        prmtSSelect.setEditFormat("$number$");
        prmtSSelect.setCommitFormat("$number$");
        prmtTSelect = new KDBizPromptBox();
        prmtTSelect.setQueryInfo("com.kingdee.eas.ma.budget.BgSchemeF7Query");
        prmtTSelect.setDisplayFormat("$name$");
        prmtTSelect.setEditFormat("$number$");
        prmtTSelect.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.defOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        prmtSSelect.setEntityViewInfo(view);
        prmtTSelect.setEntityViewInfo(view);
        sCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtSSelect);
        tCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtTSelect);
        this.sTable.getColumn(0).setEditor((ICellEditor)sCellEditor);
        this.tTable.getColumn(0).setEditor((ICellEditor)tCellEditor);
        prmtSSelect.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgFormPeriodEditUI.this.bgScheme_willShow(e, true);
            }
        });
        prmtSSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgFormPeriodEditUI.this.bgScheme_dataChanged(eventObj, true);
            }
        });
        prmtTSelect.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgFormPeriodEditUI.this.bgScheme_willShow(e, false);
            }
        });
        prmtTSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgFormPeriodEditUI.this.bgScheme_dataChanged(eventObj, false);
            }
        });
    }

    protected void bgScheme_willShow(SelectorEvent e, boolean hasSource) {
    }

    protected void bgScheme_dataChanged(DataChangeEvent e, boolean hasSource) {
        KDTDefaultCellEditor editor = null;
        KDBizPromptBox prmtSelect = null;
        EntityViewInfo view = null;
        FilterInfo filter = null;
        boolean isClear = true;
        BgSchemeInfo bgSchemeInfo = null;
        BgSchemeInfo oldBgSchemeInfo = null;
        editor = hasSource ? (KDTDefaultCellEditor)this.sTable.getColumn(1).getEditor() : (KDTDefaultCellEditor)this.tTable.getColumn(1).getEditor();
        prmtSelect = (KDBizPromptBox)editor.getComponent();
        view = prmtSelect.getEntityViewInfo();
        filter = view.getFilter();
        if (e.getNewValue() != null && e.getNewValue() instanceof BgSchemeInfo) {
            bgSchemeInfo = (BgSchemeInfo)e.getNewValue();
            BgFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        } else {
            BgFCHelper.removeFilterItems(filter, new FilterItemInfo("bgScheme.id".toLowerCase(), null, CompareType.EQUALS));
        }
        prmtSelect.setEntityViewInfo(view);
        if (e.getNewValue() != null && e.getNewValue() instanceof BgSchemeInfo) {
            if (e.getOldValue() != null && e.getNewValue() instanceof BgSchemeInfo) {
                oldBgSchemeInfo = (BgSchemeInfo)e.getOldValue();
                if (bgSchemeInfo != null && oldBgSchemeInfo != null && oldBgSchemeInfo.getId() != null && oldBgSchemeInfo.getId().equals((Object)bgSchemeInfo.getId())) {
                    isClear = false;
                }
            } else {
                isClear = false;
            }
        }
        if (isClear) {
            int rowIndex = 0;
            IRow row = null;
            if (hasSource) {
                rowIndex = this.sTable.getSelectManager().getActiveRowIndex();
                row = this.sTable.getRow(rowIndex);
            } else {
                rowIndex = this.tTable.getSelectManager().getActiveRowIndex();
                row = this.tTable.getRow(rowIndex);
            }
            row.getCell(1).setValue(null);
        }
    }

    protected void initUISelectBgForm() throws Exception {
        KDTDefaultCellEditor sCellEditor = null;
        KDTDefaultCellEditor tCellEditor = null;
        KDBizPromptBox prmtSSelect = null;
        KDBizPromptBox prmtTSelect = null;
        prmtSSelect = new KDBizPromptBox();
        prmtSSelect.setQueryInfo("com.kingdee.eas.ma.budget.BgFormF7Query");
        prmtSSelect.setDisplayFormat("$name$");
        prmtSSelect.setEditFormat("$number$");
        prmtSSelect.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> formType = new HashSet<Integer>();
        formType.add(new Integer(2));
        formType.add(new Integer(3));
        formType.add(4);
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", formType, CompareType.NOTINCLUDE));
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate in ( 4 , 35 )", CompareType.NOTINNER));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.defOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        prmtSSelect.setEntityViewInfo(view);
        prmtTSelect = new KDBizPromptBox();
        prmtTSelect.setQueryInfo("com.kingdee.eas.ma.budget.BgFormF7Query");
        prmtTSelect.setDisplayFormat("$name$");
        prmtTSelect.setEditFormat("$number$");
        prmtTSelect.setCommitFormat("$number$");
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", formType, CompareType.NOTINCLUDE));
        state = new HashSet();
        if (this.ui != null) {
            if (this.ui instanceof BgNFormListUI || this.ui instanceof BgNFormProcessUI) {
                state.add(new Integer(1));
                state.add(new Integer(4));
            } else if (this.ui instanceof BgNFormAdjustListUI || this.ui instanceof BgNFormAdjustProcessUI) {
                state.add(new Integer(4));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.defOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        prmtTSelect.setEntityViewInfo(view);
        sCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtSSelect);
        tCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtTSelect);
        this.sTable.getColumn(1).setEditor((ICellEditor)sCellEditor);
        this.tTable.getColumn(1).setEditor((ICellEditor)tCellEditor);
        prmtSSelect.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgFormPeriodEditUI.this.bgFormInfo_willShow(e, true);
            }
        });
        prmtSSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgFormPeriodEditUI.this.bgFormInfo_dataChanged(eventObj, true);
            }
        });
        prmtTSelect.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgFormPeriodEditUI.this.bgFormInfo_willShow(e, false);
            }
        });
        prmtTSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgFormPeriodEditUI.this.bgFormInfo_dataChanged(eventObj, false);
            }
        });
    }

    protected void bgFormInfo_willShow(SelectorEvent e, boolean hasSource) {
        int rowIndex = 0;
        IRow row = null;
        KDTDefaultCellEditor editor = null;
        KDBizPromptBox prmtSelect = null;
        EntityViewInfo view = null;
        FilterInfo filter = null;
        if (hasSource) {
            rowIndex = this.sTable.getSelectManager().getActiveRowIndex();
            row = this.sTable.getRow(rowIndex);
            editor = (KDTDefaultCellEditor)this.sTable.getColumn(1).getEditor();
        } else {
            rowIndex = this.tTable.getSelectManager().getActiveRowIndex();
            row = this.tTable.getRow(rowIndex);
            editor = (KDTDefaultCellEditor)this.tTable.getColumn(1).getEditor();
        }
        prmtSelect = (KDBizPromptBox)editor.getComponent();
        view = prmtSelect.getEntityViewInfo();
        filter = view.getFilter();
        if (row.getCell(0).getValue() != null) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)row.getCell(0).getValue();
            BgFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        } else {
            BgFCHelper.removeFilterItems(filter, new FilterItemInfo("bgScheme.id".toLowerCase(), null, CompareType.EQUALS));
        }
        prmtSelect.setEntityViewInfo(view);
    }

    protected void bgFormInfo_dataChanged(DataChangeEvent e, boolean hasSource) {
        if (e.getNewValue() != null && e.getNewValue() instanceof BgFormInfo) {
            BgFormInfo bgFormInfo = (BgFormInfo)e.getNewValue();
            int rowIndex = 0;
            IRow row = null;
            if (hasSource) {
                rowIndex = this.sTable.getSelectManager().getActiveRowIndex();
                row = this.sTable.getRow(rowIndex);
            } else {
                rowIndex = this.tTable.getSelectManager().getActiveRowIndex();
                row = this.tTable.getRow(rowIndex);
            }
            if (row.getCell(0).getValue() == null && bgFormInfo.getBgScheme() != null && bgFormInfo.getBgScheme().getId() != null) {
                KDTDefaultCellEditor editor = null;
                KDBizPromptBox prmtSelect = null;
                EntityViewInfo view = null;
                FilterInfo filter = null;
                BgSchemeInfo bgSchemeInfo = null;
                try {
                    bgSchemeInfo = this.getBgSchemeInterface().getValue(bgFormInfo.getBgScheme().getId());
                    row.getCell(0).setValue((Object)bgSchemeInfo);
                    editor = hasSource ? (KDTDefaultCellEditor)this.sTable.getColumn(1).getEditor() : (KDTDefaultCellEditor)this.tTable.getColumn(1).getEditor();
                    prmtSelect = (KDBizPromptBox)editor.getComponent();
                    view = prmtSelect.getEntityViewInfo();
                    filter = view.getFilter();
                    BgFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
                    prmtSelect.setEntityViewInfo(view);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIException(ex);
                }
            }
            if (bgFormInfo.getBgPeriod() != null && bgFormInfo.getBgPeriod().getId() != null) {
                BgPeriodInfo bgPeriodInfo = null;
                try {
                    bgPeriodInfo = this.getBgPeriodInterface().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgPeriod().getId()));
                    row.getCell(5).setValue((Object)bgPeriodInfo);
                    if (row.getCell(2).getValue() == null) {
                        row.getCell(2).setValue((Object)bgPeriodInfo);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIException(ex);
                }
            }
            if (row.getCell(3).getValue() == null && bgFormInfo.getCurrency() != null && bgFormInfo.getCurrency().getId() != null) {
                try {
                    row.getCell(3).setValue((Object)this.getCurrencyInterface().getCurrencyInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getCurrency().getId())));
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
            }
        }
    }

    protected void initUISelectCurrency() throws Exception {
        KDTDefaultCellEditor cellEditor = null;
        KDComboBox comSelect = null;
        comSelect = new KDComboBox();
        BgNFCHelper.setCurrency((KDComboBox)comSelect, (BOSUuid)this.defOrgUnitInfo.getId(), (boolean)true);
        cellEditor = new KDTDefaultCellEditor((JComboBox)comSelect);
        this.sTable.getColumn(3).setEditor((ICellEditor)cellEditor);
        this.tTable.getColumn(3).setEditor((ICellEditor)cellEditor);
        comSelect.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BgFormPeriodEditUI.this.currency_propertyChange(evt);
            }
        });
    }

    protected void currency_propertyChange(PropertyChangeEvent e) {
    }

    protected void initUISelectBgPeriod() throws Exception {
        KDTDefaultCellEditor cellEditor = null;
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setSelector((KDPromptSelector)new BgPeriodDialog((CoreUIObject)this));
        cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtSelect);
        this.sTable.getColumn(2).setEditor((ICellEditor)cellEditor);
        this.tTable.getColumn(2).setEditor((ICellEditor)cellEditor);
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgFormPeriodEditUI.this.bgPeriodInfo_dataChanged(eventObj);
            }
        });
        this.sTable.getColumn(5).getStyleAttributes().setLocked(true);
        this.tTable.getColumn(5).getStyleAttributes().setLocked(true);
    }

    protected void bgPeriodInfo_dataChanged(DataChangeEvent e) {
    }

    protected void initUIInputRate() throws Exception {
        KDTDefaultCellEditor cellEditor = null;
        KDFormattedTextField formattedTextField = null;
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(2);
        formattedTextField.setMaximumValue((Comparable)BgConstants.TEN_THOUSAND);
        formattedTextField.setMinimumValue((Comparable)BgConstants.BIGZERO);
        cellEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.sTable.getColumn(4).setEditor((ICellEditor)cellEditor);
        this.tTable.getColumn(4).setEditor((ICellEditor)cellEditor);
        this.sTable.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tTable.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected void btnSFormSelect_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"SOURCEDATA", (Object)Boolean.TRUE.toString());
        uiContext.put((Object)"IS_ADJUST", (Object)this.isAdjustTrans());
        uiContext.put((Object)"ORGUNIT_ID", (Object)this.defOrgUnitInfo.getId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormFilterUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void btnTFormSelect_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"TARGETDATA", (Object)Boolean.TRUE.toString());
        uiContext.put((Object)"IS_ADJUST", (Object)this.isAdjustTrans());
        uiContext.put((Object)"ORGUNIT_ID", (Object)this.defOrgUnitInfo.getId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormFilterUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean isAdjustTrans() {
        if (this.ui != null) {
            if (this.ui instanceof BgNFormListUI || this.ui instanceof BgNFormProcessUI) {
                return false;
            }
            if (this.ui instanceof BgNFormAdjustListUI || this.ui instanceof BgNFormAdjustProcessUI) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void btnSAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnSAddNewLine_actionPerformed(e);
        IRow row = this.sTable.addRow();
        if (this.ui instanceof BgNFProcessUI) {
            BgFormInfo bgFormInfo = ((BgNFProcessUI)this.ui).getBgFormInfo();
            BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
            bgSchemeInfo.setId(bgFormInfo.getBgScheme().getId());
            bgSchemeInfo.setName(bgFormInfo.getBgScheme().getName());
            BgFormInfo tmpFormInfo = new BgFormInfo();
            tmpFormInfo.setId(bgFormInfo.getId());
            tmpFormInfo.setName(bgFormInfo.getName());
            BgPeriodInfo bgPeriodInfo = new BgPeriodInfo();
            bgPeriodInfo.setId(bgFormInfo.getBgPeriod().getId());
            bgPeriodInfo.setName(bgFormInfo.getBgPeriod().getName());
            bgPeriodInfo.setNumber(bgFormInfo.getBgPeriod().getNumber());
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(bgFormInfo.getCurrency().getId());
            currencyInfo.setName(bgFormInfo.getCurrency().getName());
            currencyInfo.setNumber(bgFormInfo.getCurrency().getNumber());
            row.getCell(0).setValue((Object)bgSchemeInfo);
            row.getCell(1).setValue((Object)tmpFormInfo);
            row.getCell(2).setValue((Object)bgPeriodInfo);
            row.getCell(3).setValue((Object)currencyInfo);
            row.getCell(5).setValue((Object)bgPeriodInfo);
        }
        row.getCell(4).setValue((Object)BgConstants.HUNDRED);
    }

    @Override
    protected void btnTAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnTAddNewLine_actionPerformed(e);
        IRow row = this.tTable.addRow();
        if (this.ui instanceof BgNFProcessUI) {
            BgFormInfo bgFormInfo = ((BgNFProcessUI)this.ui).getBgFormInfo();
            BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
            bgSchemeInfo.setId(bgFormInfo.getBgScheme().getId());
            bgSchemeInfo.setName(bgFormInfo.getBgScheme().getName());
            BgFormInfo tmpFormInfo = new BgFormInfo();
            tmpFormInfo.setId(bgFormInfo.getId());
            tmpFormInfo.setName(bgFormInfo.getName());
            BgPeriodInfo bgPeriodInfo = new BgPeriodInfo();
            bgPeriodInfo.setId(bgFormInfo.getBgPeriod().getId());
            bgPeriodInfo.setName(bgFormInfo.getBgPeriod().getName());
            bgPeriodInfo.setNumber(bgFormInfo.getBgPeriod().getNumber());
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(bgFormInfo.getCurrency().getId());
            currencyInfo.setName(bgFormInfo.getCurrency().getName());
            currencyInfo.setNumber(bgFormInfo.getCurrency().getNumber());
            row.getCell(0).setValue((Object)bgSchemeInfo);
            row.getCell(1).setValue((Object)tmpFormInfo);
            row.getCell(2).setValue((Object)bgPeriodInfo);
            row.getCell(3).setValue((Object)currencyInfo);
            row.getCell(5).setValue((Object)bgPeriodInfo);
        }
        row.getCell(4).setValue((Object)BgConstants.HUNDRED);
    }

    @Override
    protected void btnSRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int re;
        super.btnSRemoveLine_actionPerformed(e);
        KDTRange range = this.sTable.getSelectManager().toRange();
        if (range != null && range.size() > 0 && (re = MsgBox.showConfirm2((Component)((Object)this), (String)this.getMessageInfo("com.kingdee.eas.ma.budget.client.BgFormResource", "hasRemoveSelectRow"))) == 0) {
            KDTSelectBlock block = null;
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
            int in = range.size();
            for (int i = 0; i < in; ++i) {
                block = (KDTSelectBlock)range.get(i);
                if (block == null) continue;
                int jn = block.getEndRow();
                for (int j = block.getBeginRow(); j <= jn; ++j) {
                    rowIndexs.add(new Integer(j));
                }
            }
            int rowCount = rowIndexs.size();
            int rowIndex = 0;
            int[] rowInt = new int[rowCount];
            int in2 = rowCount;
            for (int i = 0; i < in2; ++i) {
                rowInt[i] = (Integer)rowIndexs.get(i);
            }
            Arrays.sort(rowInt);
            for (int x = rowInt.length - 1; x >= 0; --x) {
                rowIndex = rowInt[x];
                this.sTable.removeRow(rowIndex);
            }
        }
    }

    @Override
    protected void btnTRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int re;
        super.btnTRemoveLine_actionPerformed(e);
        KDTRange range = this.tTable.getSelectManager().toRange();
        if (range != null && range.size() > 0 && (re = MsgBox.showConfirm2((Component)((Object)this), (String)this.getMessageInfo("com.kingdee.eas.ma.budget.client.BgFormResource", "hasRemoveSelectRow"))) == 0) {
            KDTSelectBlock block = null;
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
            int in = range.size();
            for (int i = 0; i < in; ++i) {
                block = (KDTSelectBlock)range.get(i);
                if (block == null) continue;
                int jn = block.getEndRow();
                for (int j = block.getBeginRow(); j <= jn; ++j) {
                    rowIndexs.add(new Integer(j));
                }
            }
            int rowCount = rowIndexs.size();
            int rowIndex = 0;
            int[] rowInt = new int[rowCount];
            int in2 = rowCount;
            for (int i = 0; i < in2; ++i) {
                rowInt[i] = (Integer)rowIndexs.get(i);
            }
            Arrays.sort(rowInt);
            for (int x = rowInt.length - 1; x >= 0; --x) {
                rowIndex = rowInt[x];
                this.tTable.removeRow(rowIndex);
            }
        }
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            this.verifyInput();
        }
        return re;
    }

    public void verifyInput() {
        int rowIndex = 0;
        int sRowCount = this.sTable.getBody().size();
        int tRowCount = this.tTable.getBody().size();
        if (sRowCount == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("inexistenceSourceRow"));
            SysUtil.abort();
        }
        if (this.tTable.getBody().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("inexistenceTargetRow"));
            SysUtil.abort();
        }
        Object obj = null;
        IRow row = null;
        String key = null;
        String currencyNumber = null;
        HashSet<String> checkSet = new HashSet<String>();
        CurrencyInfo currencyInfo = null;
        for (rowIndex = 0; rowIndex < sRowCount; ++rowIndex) {
            row = this.sTable.getRow(rowIndex);
            obj = row.getCell(0).getValue();
            if (obj == null || !(obj instanceof BgSchemeInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectBgScheme"));
                this.sTable.getSelectManager().select(rowIndex, 0);
                SysUtil.abort();
            }
            if ((obj = row.getCell(1).getValue()) == null || !(obj instanceof BgFormInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectBgForm"));
                this.sTable.getSelectManager().select(rowIndex, 1);
                SysUtil.abort();
            }
            if ((obj = row.getCell(2).getValue()) == null || !(obj instanceof BgPeriodInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectBgPeriod"));
                this.sTable.getSelectManager().select(rowIndex, 2);
                SysUtil.abort();
            }
            if ((obj = row.getCell(3).getValue()) == null || !(obj instanceof CurrencyInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectCurrency"));
                this.sTable.getSelectManager().select(rowIndex, 3);
                SysUtil.abort();
            } else {
                currencyInfo = (CurrencyInfo)row.getCell(3).getValue();
                if (!StringUtils.isEmpty(currencyNumber)) {
                    if (currencyInfo != null && !currencyNumber.equals(currencyInfo.getNumber())) {
                        MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectCurrencyVariance"));
                        SysUtil.abort();
                    }
                } else {
                    currencyNumber = currencyInfo.getNumber();
                }
            }
            key = ((BgFormInfo)row.getCell(1).getValue()).getId().toString() + "_" + ((BgPeriodInfo)row.getCell(2).getValue()).getId().toString() + "_" + ((CurrencyInfo)row.getCell(3).getValue()).getId().toString();
            if (checkSet.contains(key)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectRepeat"));
                this.sTable.getSelectManager().select(rowIndex, 2);
                SysUtil.abort();
            } else {
                checkSet.add(key);
            }
            if (row.getCell(4).getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("inputRate"));
            this.sTable.getSelectManager().select(rowIndex, 4);
            SysUtil.abort();
        }
        for (rowIndex = 0; rowIndex < tRowCount; ++rowIndex) {
            row = this.tTable.getRow(rowIndex);
            obj = row.getCell(0).getValue();
            if (obj == null || !(obj instanceof BgSchemeInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectBgScheme"));
                this.tTable.getSelectManager().select(rowIndex, 0);
                SysUtil.abort();
            }
            if ((obj = row.getCell(1).getValue()) == null || !(obj instanceof BgFormInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectBgForm"));
                this.tTable.getSelectManager().select(rowIndex, 1);
                SysUtil.abort();
            }
            if ((obj = row.getCell(2).getValue()) == null || !(obj instanceof BgPeriodInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectBgPeriod"));
                this.tTable.getSelectManager().select(rowIndex, 2);
                SysUtil.abort();
            }
            if ((obj = row.getCell(3).getValue()) == null || !(obj instanceof CurrencyInfo)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectCurrency"));
                this.tTable.getSelectManager().select(rowIndex, 3);
                SysUtil.abort();
            } else {
                currencyInfo = (CurrencyInfo)row.getCell(3).getValue();
                if (!StringUtils.isEmpty((String)currencyNumber)) {
                    if (currencyInfo != null && !currencyNumber.equals(currencyInfo.getNumber())) {
                        MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("selectCurrencyVariance"));
                        SysUtil.abort();
                    }
                } else {
                    currencyNumber = currencyInfo.getNumber();
                }
            }
            key = ((BgFormInfo)row.getCell(1).getValue()).getId().toString() + "_" + ((BgPeriodInfo)row.getCell(2).getValue()).getId().toString() + "_" + ((CurrencyInfo)row.getCell(3).getValue()).getId().toString();
            if (checkSet.contains(key)) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("bgPeriodRepeat"));
                this.tTable.getSelectManager().select(rowIndex, 2);
                SysUtil.abort();
            } else {
                checkSet.add(key);
            }
            if (row.getCell(4).getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("inputRate"));
            this.tTable.getSelectManager().select(rowIndex, 4);
            SysUtil.abort();
        }
    }

    public Object getWeaveData() throws Exception {
        HashMap weaveMap = new HashMap();
        ArrayList<BgFormPeriodData> sourceData = new ArrayList<BgFormPeriodData>();
        ArrayList<BgFormPeriodData> targetData = new ArrayList<BgFormPeriodData>();
        IRow row = null;
        OrgUnitInfo orgUnitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgSchemeInfo tmpBgSchemeInfo = null;
        BgFormInfo bgFormInfo = null;
        BgFormInfo tmpBgFormInfo = null;
        CurrencyInfo currencyInfo = null;
        CurrencyInfo tmpCurrencyInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodInfo tmpBgPeriodInfo = null;
        BgFormPeriodData data = null;
        orgUnitInfo = new OrgUnitInfo();
        orgUnitInfo.setId(this.defOrgUnitInfo.getId());
        int in = this.sTable.getBody().size();
        for (int i = 0; i < in; ++i) {
            row = this.sTable.getRow(i);
            data = new BgFormPeriodData();
            data.setOrgUnitInfo(orgUnitInfo);
            bgSchemeInfo = (BgSchemeInfo)row.getCell(0).getValue();
            tmpBgSchemeInfo = new BgSchemeInfo();
            tmpBgSchemeInfo.setId(bgSchemeInfo.getId());
            tmpBgSchemeInfo.setName(bgSchemeInfo.getName());
            data.setBgSchemeInfo(tmpBgSchemeInfo);
            bgFormInfo = (BgFormInfo)row.getCell(1).getValue();
            tmpBgFormInfo = new BgFormInfo();
            tmpBgFormInfo.setId(bgFormInfo.getId());
            tmpBgFormInfo.setName(bgFormInfo.getName());
            data.setBgFormInfo(tmpBgFormInfo);
            bgPeriodInfo = (BgPeriodInfo)row.getCell(2).getValue();
            tmpBgPeriodInfo = new BgPeriodInfo();
            tmpBgPeriodInfo.setId(bgPeriodInfo.getId());
            tmpBgPeriodInfo.setName(bgPeriodInfo.getName());
            tmpBgPeriodInfo.setNumber(bgPeriodInfo.getNumber());
            data.setBgPeriodInfo(tmpBgPeriodInfo);
            currencyInfo = (CurrencyInfo)row.getCell(3).getValue();
            tmpCurrencyInfo = new CurrencyInfo();
            tmpCurrencyInfo.setId(currencyInfo.getId());
            tmpCurrencyInfo.setName(currencyInfo.getName());
            tmpCurrencyInfo.setNumber(currencyInfo.getNumber());
            data.setCurrencyInfo(tmpCurrencyInfo);
            sourceData.add(data);
        }
        int jn = this.tTable.getBody().size();
        for (int j = 0; j < jn; ++j) {
            row = this.tTable.getRow(j);
            data = new BgFormPeriodData();
            data.setOrgUnitInfo(orgUnitInfo);
            bgSchemeInfo = (BgSchemeInfo)row.getCell(0).getValue();
            tmpBgSchemeInfo = new BgSchemeInfo();
            tmpBgSchemeInfo.setId(bgSchemeInfo.getId());
            tmpBgSchemeInfo.setName(bgSchemeInfo.getName());
            data.setBgSchemeInfo(tmpBgSchemeInfo);
            bgFormInfo = (BgFormInfo)row.getCell(1).getValue();
            tmpBgFormInfo = new BgFormInfo();
            tmpBgFormInfo.setId(bgFormInfo.getId());
            tmpBgFormInfo.setName(bgFormInfo.getName());
            data.setBgFormInfo(tmpBgFormInfo);
            bgPeriodInfo = (BgPeriodInfo)row.getCell(2).getValue();
            tmpBgPeriodInfo = new BgPeriodInfo();
            tmpBgPeriodInfo.setId(bgPeriodInfo.getId());
            tmpBgPeriodInfo.setName(bgPeriodInfo.getName());
            tmpBgPeriodInfo.setNumber(bgPeriodInfo.getNumber());
            data.setBgPeriodInfo(tmpBgPeriodInfo);
            currencyInfo = (CurrencyInfo)row.getCell(3).getValue();
            tmpCurrencyInfo = new CurrencyInfo();
            tmpCurrencyInfo.setId(currencyInfo.getId());
            tmpCurrencyInfo.setName(currencyInfo.getName());
            tmpCurrencyInfo.setNumber(currencyInfo.getNumber());
            data.setCurrencyInfo(tmpCurrencyInfo);
            targetData.add(data);
        }
        weaveMap.put("SOURCEDATA", sourceData);
        weaveMap.put("TARGETDATA", targetData);
        return weaveMap;
    }

    protected String getMessageInfo(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)RESOURCE, (String)key) : "";
    }

    protected String getMessageInfo(String resource, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)resource, (String)key) : "";
    }

    @Override
    public void clear() {
        super.clear();
        this.sTable.removeRows();
        this.tTable.removeRows();
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgFormPeriodFilterParam();
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgFormPeriodFilterParam) {
            BgFormPeriodFilterParam _filterParam = (BgFormPeriodFilterParam)filterParam;
            IRow row = null;
            BgFormPeriodData data = null;
            ArrayList<BgFormPeriodData> _sourceList = new ArrayList<BgFormPeriodData>();
            ArrayList<BgFormPeriodData> _targetList = new ArrayList<BgFormPeriodData>();
            int rowCount = 0;
            int rowIndex = 0;
            rowCount = this.sTable.getBody().size();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.sTable.getRow(rowIndex);
                if (row.getUserObject() != null) {
                    data = (BgFormPeriodData)row.getUserObject();
                } else {
                    data = new BgFormPeriodData();
                    data.setOrgUnitInfo(this.defOrgUnitInfo);
                    data.setBgSchemeInfo((BgSchemeInfo)row.getCell(0).getValue());
                    data.setBgFormInfo((BgFormInfo)row.getCell(1).getValue());
                    data.setBgPeriodInfo((BgPeriodInfo)row.getCell(2).getValue());
                    data.setCurrencyInfo((CurrencyInfo)row.getCell(3).getValue());
                    data.setRateValue((BigDecimal)row.getCell(4).getValue());
                    if (data.getBgFormInfo() != null) {
                        data.getBgFormInfo().setBgPeriod((BgPeriodInfo)row.getCell(5).getValue());
                    }
                }
                _sourceList.add(data);
            }
            _filterParam.setSourceData(_sourceList);
            rowCount = this.tTable.getBody().size();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.tTable.getRow(rowIndex);
                if (row.getUserObject() != null) {
                    data = (BgFormPeriodData)row.getUserObject();
                } else {
                    data = new BgFormPeriodData();
                    data.setOrgUnitInfo(this.defOrgUnitInfo);
                    data.setBgSchemeInfo((BgSchemeInfo)row.getCell(0).getValue());
                    data.setBgFormInfo((BgFormInfo)row.getCell(1).getValue());
                    data.setBgPeriodInfo((BgPeriodInfo)row.getCell(2).getValue());
                    data.setCurrencyInfo((CurrencyInfo)row.getCell(3).getValue());
                    data.setRateValue((BigDecimal)row.getCell(4).getValue());
                    if (data.getBgFormInfo() != null) {
                        data.getBgFormInfo().setBgPeriod((BgPeriodInfo)row.getCell(5).getValue());
                    }
                }
                _targetList.add(data);
            }
            _filterParam.setTargetData(_targetList);
        }
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgFormPeriodFilterParam) {
            BgFormPeriodFilterParam _filterParam = (BgFormPeriodFilterParam)filterParam;
            IRow row = null;
            BgFormPeriodData data = null;
            if (_filterParam.getSourceData() != null && !_filterParam.getSourceData().isEmpty()) {
                List _sourceList = _filterParam.getSourceData();
                this.sTable.removeRows();
                int in = _sourceList.size();
                for (int i = 0; i < in; ++i) {
                    data = (BgFormPeriodData)_sourceList.get(i);
                    row = this.sTable.addRow();
                    row.getCell(0).setValue((Object)data.getBgSchemeInfo());
                    row.getCell(1).setValue((Object)data.getBgFormInfo());
                    row.getCell(2).setValue((Object)data.getBgPeriodInfo());
                    row.getCell(3).setValue((Object)data.getCurrencyInfo());
                    row.getCell(4).setValue((Object)data.getRateValue());
                    if (data.getBgFormInfo().getBgPeriod() == null) continue;
                    row.getCell(5).setValue((Object)data.getBgFormInfo().getBgPeriod());
                }
            }
            if (_filterParam.getTargetData() != null && !_filterParam.getTargetData().isEmpty()) {
                List _targetList = _filterParam.getTargetData();
                this.tTable.removeRows();
                int jn = _targetList.size();
                for (int j = 0; j < jn; ++j) {
                    data = (BgFormPeriodData)_targetList.get(j);
                    row = this.tTable.addRow();
                    row.getCell(0).setValue((Object)data.getBgSchemeInfo());
                    row.getCell(1).setValue((Object)data.getBgFormInfo());
                    row.getCell(2).setValue((Object)data.getBgPeriodInfo());
                    row.getCell(3).setValue((Object)data.getCurrencyInfo());
                    row.getCell(4).setValue((Object)data.getRateValue());
                    if (data.getBgFormInfo().getBgPeriod() == null) continue;
                    row.getCell(5).setValue((Object)data.getBgFormInfo().getBgPeriod());
                }
            }
        }
    }

    public void submit_SelectBgFormInfo(IRow row, boolean hasSource) throws Exception {
        if (row == null) {
            return;
        }
        IRow tmpRow = null;
        BgFormInfo bgFormInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        tmpRow = hasSource ? this.sTable.addRow() : this.tTable.addRow();
        bgSchemeInfo = new BgSchemeInfo();
        bgSchemeInfo.setId(BOSUuid.read((String)((String)row.getCell("bgScheme.id").getValue())));
        bgSchemeInfo.setName((String)row.getCell("bgScheme.name").getValue());
        bgFormInfo = new BgFormInfo();
        bgFormInfo.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
        bgFormInfo.setName((String)row.getCell("name").getValue());
        bgPeriodInfo = new BgPeriodInfo();
        bgPeriodInfo.setId(BOSUuid.read((String)((String)row.getCell("bgPeriod.id").getValue())));
        bgPeriodInfo.setName((String)row.getCell("bgPeriod.name").getValue());
        bgPeriodInfo.setNumber((String)row.getCell("bgPeriod.number").getValue());
        currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)((String)row.getCell("currency.id").getValue())));
        currencyInfo.setName((String)row.getCell("currency.name").getValue());
        currencyInfo.setNumber((String)row.getCell("currency.number").getValue());
        tmpRow.getCell(0).setValue((Object)bgSchemeInfo);
        tmpRow.getCell(1).setValue((Object)bgFormInfo);
        tmpRow.getCell(2).setValue((Object)bgPeriodInfo);
        tmpRow.getCell(3).setValue((Object)currencyInfo);
        tmpRow.getCell(4).setValue((Object)BgConstants.HUNDRED);
        tmpRow.getCell(5).setValue((Object)bgPeriodInfo);
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.sTable.removeRows();
            this.tTable.removeRows();
        }
        return re;
    }
}

