/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormQueryFilterParam;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.AbstractBgFormQueryUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.CompanyTreeSelectUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class BgFormQueryUI
extends AbstractBgFormQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormQueryUI.class);
    private static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgFormResource";
    protected KDDialog companySelectDlg = null;
    private BgTemplateInfo tmptInfo = null;
    private int preRowPos = -1;
    private Map map = new HashMap(32);
    private Map bgTypeNameMap = new HashMap(32);
    private BgPeriodDialog beginF7;
    private BgPeriodDialog endF7;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.bgTypeTable.checkParsed();
        this.bgTypeTable.getSelectManager().setSelectMode(2);
        this.comboBgPeriod.setEnabled(false);
    }

    protected KDDialog initDialog() throws Exception {
        if (this.companySelectDlg != null) {
            return this.companySelectDlg;
        }
        this.companySelectDlg = new KDDialog(BgNFCHelper.getFrameAncestor((Component)((Object)this)), true);
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI();
        companySelectUI.setDialog((JDialog)this.companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        this.companySelectDlg.getContentPane().setLayout(new BorderLayout());
        this.companySelectDlg.getContentPane().add((Component)((Object)companySelectUI), "Center");
        this.companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.companySelectDlg);
        this.companySelectDlg.setResizable(false);
        this.companySelectDlg.setTitle(companySelectUI.getUITitle());
        companySelectUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    // empty if block
                }
            }
        });
        return this.companySelectDlg;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void bgTypeTable_editStopped(KDTEditEvent e) throws Exception {
        super.bgTypeTable_editStopped(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String bgTypeId = this.bgTypeTable.getRow(rowIndex).getCell("id").getValue().toString();
        ICell cell = this.bgTypeTable.getRow(rowIndex).getCell(colIndex);
        if (this.bgTypeTable.getColumn(colIndex).getKey().equals("isSelect")) {
            if (this.preRowPos != -1) {
                this.putCheckedBgType();
            }
            if (((Boolean)cell.getValue()).booleanValue()) {
                this.preRowPos = rowIndex;
            } else {
                this.map.remove(bgTypeId);
                this.bgTypeNameMap.remove(bgTypeId);
            }
        }
    }

    private void putCheckedBgType() {
        ICell idCell = this.bgTypeTable.getRow(this.preRowPos).getCell("id");
        ICell nameCell = this.bgTypeTable.getRow(this.preRowPos).getCell("name");
        String bgTypeId = (String)idCell.getValue();
        String bgTypeName = (String)nameCell.getValue();
        ArrayList[] list = new ArrayList[]{new ArrayList(10), new ArrayList(10), new ArrayList(10)};
        this.map.put(bgTypeId, list);
        this.bgTypeNameMap.put(bgTypeId, bgTypeName);
    }

    @Override
    protected void bgTypeTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.bgTypeTable_tableSelectChanged(e);
    }

    @Override
    protected void comboBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgScheme_itemStateChanged(e);
        if (this.comboBgScheme.getSelectedIndex() == -1) {
            return;
        }
        this.bgTypeTable.removeRows();
        this.bgTypeTable.checkParsed();
        this.setBgTemplateSelect();
    }

    private void setBgTemplateSelect() throws EASBizException, BOSException {
        this.bgTypeTable.removeRows();
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null) {
            BgTemplateCollection bgTemplateColl = BgHelper.getBgTemplateCollByScheme(bgSchemeInfo.getId().toString());
            this.comboBgPeriod.setSelectedItem((Object)bgSchemeInfo.getPeriod());
            this.comboBgPeriod.setEnabled(false);
            if (this.beginF7 == null) {
                this.beginF7 = new BgPeriodDialog((CoreUIObject)this);
            }
            this.beginF7.setBgPeriodEnum(bgSchemeInfo.getPeriod());
            this.prmtBeginPeriod.setSelector((KDPromptSelector)this.beginF7);
            if (this.endF7 == null) {
                this.endF7 = new BgPeriodDialog((CoreUIObject)this);
            }
            this.endF7.setBgPeriodEnum(bgSchemeInfo.getPeriod());
            this.prmtEndPeriod.setSelector((KDPromptSelector)this.endF7);
            if (bgTemplateColl != null && bgTemplateColl.size() > 0) {
                int size = bgTemplateColl.size();
                for (int i = 0; i < size; ++i) {
                    BgTemplateInfo bgTemplateInfo = bgTemplateColl.get(i);
                    IRow row = this.bgTypeTable.addRow();
                    row.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
                    row.getCell("isSelect").setValue((Object)Boolean.FALSE);
                    row.getCell("name").setValue((Object)bgTemplateInfo.getName());
                    row.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
                    row.getCell("desc").setValue((Object)bgTemplateInfo.getDescription());
                }
            }
        }
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo orgInfo = null;
        orgInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.bgTypeTable.removeRows();
        if (orgInfo != null && orgInfo.getId() != null) {
            BgClientHelper.initComboBgScheme((Component)((Object)this), this.comboBgScheme, orgInfo.getId().toString());
            this.setBgTemplateSelect();
        } else {
            this.comboBgScheme.removeAllItems();
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        BgFormQueryFilterParam param = new BgFormQueryFilterParam();
        if (this.comboBgScheme.getSelectedItem() != null) {
            param.setBgSchemeId(((BgSchemeInfo)this.comboBgScheme.getSelectedItem()).getId().toString());
        }
        param.setIsSum(this.chkIsSum.isSelected());
        param.setBeginPeriod((BgPeriodInfo)this.prmtBeginPeriod.getValue());
        param.setEndPeriod((BgPeriodInfo)this.prmtEndPeriod.getValue());
        String id = null;
        String bgTypeName = null;
        this.bgTypeNameMap.clear();
        for (int i = 0; i < this.bgTypeTable.getRowCount(); ++i) {
            if (!((Boolean)this.bgTypeTable.getRow(i).getCell("isSelect").getValue()).booleanValue()) continue;
            id = (String)this.bgTypeTable.getRow(i).getCell("id").getValue();
            bgTypeName = (String)this.bgTypeTable.getRow(i).getCell("name").getValue();
            this.bgTypeNameMap.put(id, bgTypeName);
        }
        param.setBgTemplate(this.bgTypeNameMap);
        this.setFilterObject(cp, param);
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        FilterParam param = (FilterParam)this.getFilterObject(cp);
        if (param != null && param instanceof BgFormQueryFilterParam) {
            BgFormQueryFilterParam filterParam = (BgFormQueryFilterParam)param;
            this.prmtBeginPeriod.setValue((Object)filterParam.getBeginPeriod());
            this.prmtEndPeriod.setValue((Object)filterParam.getEndPeriod());
            FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
            orgUnitInfo.setId(BOSUuid.read((String)filterParam.getOrgUnitId()));
            orgUnitInfo.setName(filterParam.getOrgUnitName());
            String bgSchemeId = filterParam.getBgSchemeId();
            for (int i = 0; i < this.comboBgScheme.getItemCount(); ++i) {
                if (!bgSchemeId.equals(((BgSchemeInfo)this.comboBgScheme.getItemAt(i)).getId().toString())) continue;
                this.comboBgScheme.setSelectedIndex(i);
                break;
            }
        }
    }

    public boolean verify() {
        if (this.comboBgScheme.getItemCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            return false;
        }
        return super.verify();
    }
}

