/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemAnalyseInfo;
import com.kingdee.eas.ma.budget.BgItemAnalyseParam;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgItemAnalyseMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgItemAnalyseFilterUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgItemAnalyseMainUI
extends AbstractBgItemAnalyseMainUI {
    private static final long serialVersionUID = -5890351366476757889L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemAnalyseMainUI.class);
    private Map muMap = new HashMap();
    private BigDecimal coefficient = BgNConstants.ONE;
    private int decimal = 8;
    private String decFormat = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage("bgItemAnalyse"));
    }

    @Override
    protected String getQueryMainName() {
        return BgItemAnalyseMainUI.class.getName();
    }

    @Override
    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgItemAnalyseFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return this.defaultFilterUI;
    }

    @Override
    protected int getWidthOfDialog() {
        return 300;
    }

    @Override
    protected int getHeightOfDialog() {
        return 400;
    }

    public BigDecimal getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecFormat(String decFormat) {
        this.decFormat = decFormat;
    }

    public String getDecFormat() {
        return this.decFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeQuery() {
        FilterParam _filterParam = this.getFilterParam();
        if (_filterParam == null && !(_filterParam instanceof BgItemAnalyseParam)) {
            return;
        }
        Map dataMap = null;
        this.init(_filterParam);
        try {
            dataMap = this.getInterface().queryBgItemData(null, _filterParam);
            this.fillSheet(dataMap);
        }
        catch (Exception ex) {
            try {
                this.handUIExceptionAndAbort(ex);
                this.fillSheet(dataMap);
            }
            catch (Throwable throwable) {
                this.fillSheet(dataMap);
                throw throwable;
            }
        }
    }

    protected void init(FilterParam filterParam) {
        BgItemAnalyseParam _itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        this.setDecimal(_itemAnalyseParam.getCurrency().getPrecision());
        if (this.getDecimal() > 0) {
            this.setDecFormat("#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)this.getDecimal()));
        } else {
            this.setDecFormat("#,##0");
        }
        this.initMeasureUnitMap(filterParam);
        this.clearAnalyseSheet();
        this.initAnalyseData(filterParam);
    }

    protected void initMeasureUnitMap(FilterParam filterParam) {
        this.muMap.clear();
        BgItemAnalyseParam _itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        if (_itemAnalyseParam.getBgTemplateInfo().getDefaultMeasureUnit() != null) {
            this.setCoefficient(_itemAnalyseParam.getBgTemplateInfo().getDefaultMeasureUnit().getCoefficient());
        }
        if (_itemAnalyseParam.getMuMap() != null) {
            Map.Entry _entry2 = null;
            BgElementInfo elementInfo = null;
            MeasureUnitInfo unitInfo = null;
            for (Map.Entry _entry2 : _itemAnalyseParam.getMuMap().entrySet()) {
                elementInfo = (BgElementInfo)_entry2.getKey();
                unitInfo = (MeasureUnitInfo)_entry2.getValue();
                if (elementInfo == null || unitInfo == null) continue;
                this.muMap.put(elementInfo.getNumber(), unitInfo.getCoefficient());
            }
        }
    }

    protected void initAnalyseData(FilterParam filterParam) {
        BgItemAnalyseParam _itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        OrgUnitInfo orgUnitInfo2 = null;
        OrgUnitInfo[] orgUnitInfos = null;
        KDTable sheet = null;
        orgUnitInfos = _itemAnalyseParam.getOrgUnits();
        if (orgUnitInfos != null) {
            for (OrgUnitInfo orgUnitInfo2 : orgUnitInfos) {
                sheet = this.addAnalyseSheet(orgUnitInfo2.getId().toString(), orgUnitInfo2.getName());
                this.initHeadOfSheet(sheet);
            }
        }
    }

    protected void initHeadOfSheet(KDTable sheet) {
        if (sheet == null) {
            return;
        }
        IRow row = null;
        sheet.setRefresh(false);
        sheet.checkParsed();
        sheet.addColumns(2);
        sheet.getColumn(0).setWidth(150);
        sheet.getColumn(0).getStyleAttributes().setLocked(true);
        sheet.getColumn(0).setMergeable(true);
        sheet.getColumn(1).setWidth(250);
        sheet.getColumn(1).getStyleAttributes().setLocked(true);
        row = sheet.addHeadRow();
        row.getCell(0).setValue((Object)BgAnalyseHelper.getMessage("bgPeriod"));
        row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage("bgitem"));
        row = sheet.addHeadRow();
        sheet.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        sheet.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        sheet.reLayoutAndPaint();
        sheet.setRefresh(true);
    }

    protected void fillSheet(Map dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        String _bgPeriod = null;
        int _indexCol = 0;
        int _indexRow = 0;
        VisualItemInfo itemInfo = null;
        BgItemAnalyseInfo info = null;
        List bgItemList = null;
        List tmpList = null;
        HashMap<String, Integer> bgEleMap = new HashMap<String, Integer>();
        Map bgItemInfoMap = (Map)dataMap.get("BGITEM_INFO");
        Map bgEleInfoMap = (Map)dataMap.get("BGELEMENT_INFO");
        KDTable sheet = null;
        IRow row = null;
        int in = this.getSheetSize();
        for (int i = 0; i < in; ++i) {
            sheet = (KDTable)this.getSheet(i);
            bgEleMap.clear();
            if (sheet == null || !dataMap.containsKey(sheet.getID())) continue;
            bgItemList = (List)dataMap.get(sheet.getID());
            sheet.setRefresh(false);
            int jn = bgItemList.size();
            for (int j = 0; j < jn; ++j) {
                tmpList = (List)bgItemList.get(j);
                row = sheet.addRow();
                int xn = tmpList.size();
                for (int x = 0; x < xn; ++x) {
                    info = (BgItemAnalyseInfo)tmpList.get(x);
                    if (bgEleMap.containsKey(info.getBgElementNumber())) {
                        _indexCol = (Integer)bgEleMap.get(info.getBgElementNumber());
                    } else {
                        _indexCol = this.addColumns(sheet, info, bgEleInfoMap);
                        bgEleMap.put(info.getBgElementNumber(), new Integer(_indexCol));
                    }
                    row.getCell(0).setValue((Object)info.getBgPeriodName());
                    if (!info.getBgPeriodName().equals(_bgPeriod)) {
                        if (_bgPeriod != null) {
                            sheet.getMergeManager().mergeBlock(_indexRow, 0, row.getRowIndex() - 1, 0);
                        }
                        _bgPeriod = info.getBgPeriodName();
                        _indexRow = row.getRowIndex();
                    }
                    if ((itemInfo = BgSHelper.getBgItemCombinInfo(info.getBgItemNumber(), bgItemInfoMap)) != null) {
                        row.getCell(1).setValue((Object)itemInfo.getName());
                    }
                    row.getCell(_indexCol).setValue((Object)info.getBValue());
                    row.getCell(_indexCol + 1).setValue((Object)info.getAValue());
                    row.getCell(_indexCol + 2).setValue((Object)info.getSValue());
                    row.getCell(_indexCol).setUserObject((Object)info.getBgElementNumber());
                    row.getCell(_indexCol + 1).setUserObject((Object)info.getBgElementNumber());
                    row.getCell(_indexCol + 2).setUserObject((Object)info.getBgElementNumber());
                }
            }
            if (row != null && _indexRow != row.getRowIndex()) {
                sheet.getMergeManager().mergeBlock(_indexRow, 0, row.getRowIndex(), 0);
            }
            sheet.setRefresh(true);
        }
    }

    private int addColumns(KDTable sheet, BgItemAnalyseInfo info, Map bgEleInfoMap) {
        int _indexCol = 0;
        IColumn column = null;
        BgElementInfo elementInfo = null;
        column = sheet.addColumn();
        _indexCol = column.getColumnIndex();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        elementInfo = (BgElementInfo)bgEleInfoMap.get(info.getBgElementNumber());
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage("bValue"));
        column.setUserObject((Object)elementInfo.getNumber());
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage("aValue"));
        column.setUserObject((Object)elementInfo.getNumber());
        column.getStyleAttributes().setHided(true);
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage("sValue"));
        column.setUserObject((Object)elementInfo.getNumber());
        sheet.getHeadMergeManager().mergeBlock(0, _indexCol, 0, _indexCol + 2);
        return _indexCol;
    }

    @Override
    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (colIndex > 1 && value instanceof BigDecimal && cell != null && StringUtils.isEmpty((String)cell.getStyleAttributes().getNumberFormat())) {
            BigDecimal tmpValue = null;
            tmpValue = this.getMeasureUnit(rowIndex, colIndex, cell);
            value = ((BigDecimal)value).divide(tmpValue, 8, 4);
            cell.setValue(value);
            cell.getStyleAttributes().setNumberFormat(this.getDecFormat());
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    protected BigDecimal getMeasureUnit(int rowIndex, int colIndex, ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return this.getCoefficient();
        }
        if (this.muMap.containsKey(cell.getUserObject())) {
            return (BigDecimal)this.muMap.get(cell.getUserObject());
        }
        return this.getCoefficient();
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.muMap.clear();
        }
        return re;
    }
}

