/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.client.BgCslFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgCslTemplateProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class BgItemFormulaWizardUI
extends FormulaWizardUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgItemFormulaWizardUI");
    private KDBizPromptBox bgItemCombin;
    private KDTextField bgItemCombinTxt;
    private KDBizPromptBox bgPeriod;
    private KDTextField bgPeriodTxt;
    private KDBizPromptBox bgElement;
    private KDTextField bgElementTxt;
    private KDBizPromptBox currency;
    private KDTextField currencyTxt;

    protected void onOpen() {
        UINewFrame frame;
        this.bgItemCombin = (KDBizPromptBox)this.getParamComponent("itemCombinStr");
        this.bgItemCombinTxt = (KDTextField)this.getBaseParamComponent("itemCombinStr");
        this.bgPeriod = (KDBizPromptBox)this.getParamComponent("bgPeriod");
        this.bgPeriodTxt = (KDTextField)this.getBaseParamComponent("bgPeriod");
        this.bgElement = (KDBizPromptBox)this.getParamComponent("bgElement");
        this.bgElementTxt = (KDTextField)this.getBaseParamComponent("bgElement");
        this.currency = (KDBizPromptBox)this.getParamComponent("currencyBg");
        this.currencyTxt = (KDTextField)this.getBaseParamComponent("currencyBg");
        String orgUnitId = null;
        if (this.getUIContext().get("Owner") instanceof UINewFrame && ((frame = (UINewFrame)this.getUIContext().get("Owner")).getUIObject() instanceof BgCslTemplateProcessUI || frame.getUIObject() instanceof BgWorkTemplateProcessUI || frame.getUIObject() instanceof BgWorkPaperProcessUI || frame.getUIObject() instanceof BgCslFormProcessUI)) {
            try {
                if (BgElimContext.getInstance().getCurMappedOrgUnit() != null) {
                    orgUnitId = BgElimContext.getInstance().getCurMappedOrgUnit().getId().toString();
                }
            }
            catch (BOSException e2) {
                this.handUIException(e2);
            }
        }
        if (orgUnitId == null) {
            orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        }
        ((NewBgItemDialog)this.bgItemCombin.getSelector()).setOrgUnitId(orgUnitId);
        super.onOpen();
        this.bgElementTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e1) {
                Object obj = BgItemFormulaWizardUI.this.bgElement.getValue();
                if (obj != null && obj instanceof String && !obj.toString().equals("")) {
                    try {
                        IBgElement iEle = BgElementFactory.getRemoteInstance();
                        BgElementInfo info = iEle.getBgElementInfo("select id,name,number where number='" + obj + "'");
                        BgItemFormulaWizardUI.this.bgElement.setData((Object)info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.bgItemCombinTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e1) {
                Object obj = BgItemFormulaWizardUI.this.bgItemCombin.getData();
                if (obj != null && obj instanceof String && !obj.toString().equals("")) {
                    String name = "";
                    String[] strs = obj.toString().split(",");
                    VisualItemInfo info = new VisualItemInfo();
                    CostCenterOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentCostUnit();
                    String orgNum = orgInfo.getNumber();
                    String orgLNum = orgInfo.getLongNumber();
                    try {
                        String orgUnitId = BgSHelper.getIsolateOrg(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                        IBgItem iBg = BgItemFactory.getRemoteInstance();
                        for (int i = 0; i < strs.length; ++i) {
                            BgItemInfo item = iBg.getBgItemInfo("select id,name,number where number='" + strs[i] + "' and orgUnit.id = '" + orgUnitId + "'");
                            name = name + item.getName() + ",";
                        }
                        if (!StringUtils.isEmpty((String)name)) {
                            name = name.substring(0, name.length() - 1);
                        }
                        info.setNumber(obj.toString());
                        info.setName(name);
                        BgItemFormulaWizardUI.this.bgItemCombin.setData((Object)info);
                    }
                    catch (BOSException bOSException) {
                    }
                    catch (EASBizException eASBizException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.currencyTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Object obj = BgItemFormulaWizardUI.this.currency.getValue();
                if (obj != null && obj instanceof String && !obj.toString().equals("")) {
                    try {
                        ICurrency ic = CurrencyFactory.getRemoteInstance();
                        CurrencyInfo info = (CurrencyInfo)ic.getValue("select * where number='" + obj + "'");
                        BgItemFormulaWizardUI.this.currency.setData((Object)info);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"budget error:", (Throwable)e1);
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"budget error:", (Throwable)e1);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.bgPeriodTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.bgPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
            }
        });
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        if (e != null && e.getSource() == this.btnOk) {
            String str = this.bgPeriodTxt.getText().trim();
            boolean isRelativeBgPeriod = false;
            int relativeValue = 0;
            try {
                relativeValue = Integer.parseInt(str);
                isRelativeBgPeriod = true;
                this.bgPeriod.setData(null);
                this.bgPeriodTxt.setText(str);
            }
            catch (NumberFormatException e1) {
                isRelativeBgPeriod = false;
            }
            if (isRelativeBgPeriod && Math.abs(relativeValue) > 100) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"257_BgFormProcessUI"));
                return;
            }
            if (this.bgElementTxt.getText() != null && this.bgElementTxt.getText().length() != 0) {
                String number = null;
                if (this.bgElement.getData() == null) {
                    number = "";
                } else {
                    if (this.bgElement.getData() instanceof String) {
                        number = (String)this.bgElement.getData();
                    }
                    if (this.bgElement.getData() instanceof BgElementInfo) {
                        number = ((BgElementInfo)this.bgElement.getData()).getNumber();
                    }
                }
                try {
                    IBgElement iEle = BgElementFactory.getRemoteInstance();
                    iEle.getBgElementInfo("select id,name,number where number='" + number + "'");
                }
                catch (ObjectNotFoundException ex) {
                    this.bgElement.setData(null);
                    this.bgElementTxt.setText("");
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"noExistBgElement"), number));
                    this.bgElementTxt.requestFocus();
                    return;
                }
                catch (BOSException ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
                catch (EASBizException ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        }
        super.actionFinish_actionPerformed(e);
    }
}

