/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgItemGroupEditUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgItemGroupEditUI
extends AbstractBgItemGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemGroupEditUI.class);
    private BgItemGroupInfo parentbgItemGroupInfo = null;
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean isUseIntermitNumber = false;

    public boolean isUseIntermitNumber() {
        return this.isUseIntermitNumber;
    }

    public void setUseIntermitNumber(boolean isUseIntermitNumber) {
        this.isUseIntermitNumber = isUseIntermitNumber;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeLoad() throws EASBizException {
        FullOrgUnitInfo ccOrgUnitInfo = (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String CUID = ccOrgUnitInfo.getId().toString();
            BgItemGroupInfo bgTemplateInfo = null;
            ICodingRuleManager codingRuleManager = null;
            try {
                bgTemplateInfo = new BgItemGroupInfo();
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                this.setHasCodeNumber(BgHelper.hasNumber((CoreBaseInfo)bgTemplateInfo, CUID, codingRuleManager));
                if (this.isHasCodeNumber()) {
                    this.setHasShowCodeNumber(BgHelper.hasDisplayNumber((CoreBaseInfo)bgTemplateInfo, CUID, codingRuleManager));
                    this.setUseIntermitNumber(BgHelper.isUseIntermitNumber((CoreBaseInfo)bgTemplateInfo, CUID, codingRuleManager));
                }
                if (this.isHasCodeNumber()) {
                    this.txtNumber.setEnabled(false);
                } else {
                    this.txtNumber.setEnabled(true);
                }
            }
            catch (BOSException ex) {
                logger.error((Object)ex);
                this.handUIException(ex);
            }
            finally {
                codingRuleManager = null;
            }
        }
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        Object _obj = this.getUIContext().get("ParentNode");
        if (this.getOprtState().equals("ADDNEW")) {
            if (_obj instanceof BgItemGroupInfo) {
                this.parentbgItemGroupInfo = (BgItemGroupInfo)_obj;
                this.groupParent.setData((Object)this.parentbgItemGroupInfo);
            } else {
                this.groupParent.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"bgItem"));
            }
        } else if (_obj instanceof BgItemGroupInfo) {
            this.parentbgItemGroupInfo = (BgItemGroupInfo)_obj;
            this.groupParent.setData((Object)this.parentbgItemGroupInfo);
        } else {
            this.groupParent.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"bgItem"));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.checkCanEditTxtNumber();
    }

    private void checkCanEditTxtNumber() {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.parentbgItemGroupInfo = (BgItemGroupInfo)this.getUIContext().get("groupInfo");
            Integer rowCount = (Integer)this.getUIContext().get("tableCount");
            if (!(this.parentbgItemGroupInfo == null || this.parentbgItemGroupInfo.isIsLeaf() && this.parentbgItemGroupInfo.getCreator() != null)) {
                this.txtNumber.setEditable(false);
            } else if (rowCount != null && rowCount >= 1) {
                this.txtNumber.setEditable(false);
            } else {
                this.txtNumber.setEditable(true);
            }
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setEditable(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("displayname"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("assistant"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if ("VIEW".equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(true);
        } else if ("EDIT".equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(true);
        }
        if (this.groupParent.getData() == null) {
            this.groupParent.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"bgItem"));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.parentbgItemGroupInfo = new BgItemGroupInfo();
            this.editData.setDisplayName(this.parentbgItemGroupInfo.getDisplayName());
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.editData.setDisplayName(this.parentbgItemGroupInfo.getDisplayName());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setAssistant(this.txtAssistant.getText());
        super.actionSubmit_actionPerformed(e);
    }

    private boolean checkCanAddOrRemoveOrUpdate(BgItemGroupInfo groupInfo) {
        return groupInfo == null || !groupInfo.getLongNumber().startsWith("hbbbllx");
    }

    protected void initScrollButtons() {
        super.initScrollButtons();
        this.checkCanEditTxtNumber();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkCanAddOrRemoveOrUpdate(this.editData)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"systemImportCanNotEdit"));
            return;
        }
        boolean iscreator = BgClientHelper.isCreator(this.editData.getId().toString(), "edit");
        if (!iscreator) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"notCreatorNotEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkCanAddOrRemoveOrUpdate(this.editData.getParent())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"systemImportCanNotAdd"));
            return;
        }
        this.getUIContext().put("ParentNode", this.groupParent.getData());
        this.getUIContext().remove("groupInfo");
        this.getUIContext().remove("tableCount");
        super.actionAddNew_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String parRef;
        super.verifyInput(e);
        if (this.editData.getParent() != null && (parRef = this.editData.getParent().getRefField()) != null && (parRef.equals("F96") || parRef.equals("F97") || parRef.equals("F98"))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"notAddNewGroup"));
            SysUtil.abort();
        }
        if (this.txtNumber.isEnabled() && (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"GroupNumberNull"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText().length() > 80) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"tooLongGroupNum"));
            SysUtil.abort();
        }
        if (this.mltName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() == null || this.mltName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() == 0) {
            this.mltName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"GroupNameNull"));
            SysUtil.abort();
        } else {
            String name = (String)this.mltName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData();
            if (name.length() > 254) {
                this.mltName.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"tooLongGroupName"));
                SysUtil.abort();
            }
        }
        String description = (String)this.mltDescription.getItemBy(new LanguageInfo(new Locale("L2", ""))).getData();
        if (description != null && description.length() > 254) {
            this.mltDescription.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"tooLongDescription"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        BgItemGroupInfo bgItemGroupInfo = new BgItemGroupInfo();
        bgItemGroupInfo.setId(BOSUuid.create((BOSObjectType)bgItemGroupInfo.getBOSType()));
        bgItemGroupInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        String CUID = ((FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit()).getId().toString();
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            this.getNumberByCodingRule((IObjectValue)bgItemGroupInfo, CUID);
        } else if (this.isHasCodeNumber() && this.isUseIntermitNumber()) {
            String num = "";
            bgItemGroupInfo.setNumber(num);
            this.txtNumber.setText(num);
            this.txtNumber.setEnabled(false);
        }
        if (this.groupParent.getData() instanceof BgItemGroupInfo) {
            bgItemGroupInfo.setParent((BgItemGroupInfo)this.groupParent.getData());
        }
        return bgItemGroupInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemGroupFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }
}

