/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgLocaleHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgItemFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgItemGroupListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgElimUI;
import com.kingdee.eas.ma.budget.client.BgFpDrcMtUI;
import com.kingdee.eas.ma.budget.client.BgItemAssignUI;
import com.kingdee.eas.ma.budget.client.BgItemElimEditUI;
import com.kingdee.eas.ma.budget.client.BgItemGroupEditUI;
import com.kingdee.eas.ma.budget.client.BgItemImportByBaseUI;
import com.kingdee.eas.ma.budget.client.BgItemImportExcelUI;
import com.kingdee.eas.ma.budget.client.ExcelFile;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgDataRelationEnum;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgItemGroupListUI
extends AbstractBgItemGroupListUI {
    private static final long serialVersionUID = 1762777580452288241L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemGroupListUI.class);
    private BgItemTreeRender treeRender;
    private OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private CostCenterOrgUnitInfo ccoInfo = SysContext.getSysContext().getCurrentCostUnit();
    private FullOrgUnitInfo bgFormOrgUnit = null;
    private Set canSeeItem = null;
    private boolean isBgItemIsolate = BgSHelper.isBgItemIsolate();
    protected boolean isSelect = false;
    private IObjectPK[] arrayPK = null;
    private boolean isUpgrade = true;
    private boolean isAddNewOper = false;
    private static final String STATE = "returnState";
    private static final String STATE_OK = "ok";
    private static final String STATE_CANCEL = "cancel";
    private static final String VALUE_FPDRC = "fpDrirction";
    private static final String STATE_ELIM = "returnState";
    private static final String ELIM_OK = "ok";
    private static final String ELIM_CANCEL = "cancel";
    private static final String VALUE_ELIM = "elimtype";
    private static final String VALUE_RELA = "datarela";

    protected String getEditUIName() {
        return BgItemElimEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemFactory.getRemoteInstance();
    }

    protected IBgItem getBgItemInterface() throws Exception {
        return (IBgItem)this.getBizInterface();
    }

    protected IBgItemFacade getBgItemFacadeInterface() throws Exception {
        return BgItemFacadeFactory.getRemoteInstance();
    }

    protected ICostCenterOrgUnit getCCOInterface() throws Exception {
        return CostCenterOrgUnitFactory.getRemoteInstance();
    }

    protected BgItemTreeRender getRender() {
        return this.treeRender;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)key);
    }

    public void onLoad() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        super.onLoad();
        this.setNodeFilter(true);
        this.enableExportExcel(this.tblMain);
        this.kDBoxOrgUnit.setValue((Object)this.getCurOrgUnit());
        this.treeRender = new BgItemTreeRender();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.treeRender);
        this.assignOrgHandle();
        if (this.treeMain.getRowCount() > 0) {
            this.treeMain.setSelectionRow(0);
        }
        this.menuExport.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"exportText"));
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke(78, 640, false));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke(123, 192, false));
        this.isUpgrade = this.getBgItemFacadeInterface().checkIsUpgrade();
        AbstractAction actionDeleteRef = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int result = MsgBox.showConfirm2((Component)((Object)BgItemGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"deleteReference"));
                    if (result == 0) {
                        BgItemFacadeFactory.getRemoteInstance().deleteReference();
                        MsgBox.showInfo((Component)((Object)BgItemGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"deleRefSuccess"));
                    }
                }
                catch (Exception ex) {
                    MsgBox.showError((Component)((Object)BgItemGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"fall"));
                }
            }
        };
        String strKeyD = "CTRL_SHIFT_D";
        KeyStroke ksD = KeyStroke.getKeyStroke(68, 192, false);
        this.getActionMap().put(strKeyD, actionDeleteRef);
        this.getInputMap(2).put(ksD, strKeyD);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.handleFpFields(e);
    }

    protected void actionUpdateBosType_actionPerformed(ActionEvent e) {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    BgItemFacadeFactory.getRemoteInstance().updateBosType("all");
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }

            public void afterExec(Object result) throws Exception {
                Boolean isSuccess = (Boolean)result;
                if (isSuccess.booleanValue()) {
                    MsgBox.showInfo((Component)((Object)BgItemGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"31_BgItemGroupListUI"));
                } else {
                    MsgBox.showInfo((Component)((Object)BgItemGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"32_BgItemGroupListUI"));
                }
            }
        });
        dialog.show();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.setButtonDefaultStyl(this.removeAll);
        this.btnExpand.setVisible(false);
        this.btnConstriction.setVisible(false);
        this.btnMoveTree.setVisible(false);
        this.btnExport.setEnabled(true);
        this.btnImportExcel.setEnabled(true);
        this.removeAll.setEnabled(true);
        this.menuExport.setVisible(true);
        this.menuExport.setEnabled(true);
        this.actionExport.setEnabled(true);
        this.btnElim.setIcon(EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnImportExcel.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnCancelAssign.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.menuItemAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemCancelAssign.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.menuImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuSysImport.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.removeAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnBgItemMaintenance.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnFPDrcMt.setIcon(EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionBgItemMaintenance.setEnabled(false);
        this.actionGroupMoveTree.setEnabled(false);
        this.btnBgItemMaintenance.setVisible(false);
        this.btnGroupMoveTree.setVisible(false);
        this.menuItemMoveTree.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
        try {
            if (!this.isBgItemIsolate) {
                this.btnAssign.setVisible(false);
                this.btnCancelAssign.setVisible(false);
                this.actionAssign.setEnabled(false);
                this.actionCancelAssign.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String strKey = "CTRL_SHIFT_U";
        KeyStroke ks = KeyStroke.getKeyStroke(85, 192, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionUpgrade));
        this.getInputMap(2).put(ks, strKey);
        this.pnlTable.add((Component)this.pnlBtnGroup, (Object)"North");
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected String getSelectDetailTreeName() {
        return "MaterialGroup";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        Object obj;
        ObjectUuidPK groupPk = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && (obj = row.getCell("bgItemGroupId").getValue()) != null) {
            groupPk = new ObjectUuidPK(obj.toString());
        }
        return groupPk;
    }

    protected void enableAction(JButton button, JMenuItem menuItem, Action action) {
        this.setAction(button, menuItem, action, true);
    }

    protected void disableAction(JButton button, JMenuItem menuItem, Action action) {
        this.setAction(button, menuItem, action, false);
    }

    private void setAction(JButton button, JMenuItem menuItem, Action action, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
        if (menuItem != null) {
            menuItem.setEnabled(enabled);
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof BgItemGroupInfo) {
            BgItemGroupInfo groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
            if (groupInfo.isIsLeaf()) {
                this.enableAction((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew, (Action)this.actionAddNew);
                this.enableAction((JButton)this.btnImport, null, null);
                this.enableAction((JButton)this.btnImportExcel, null, (Action)((Object)this.actionImportExcel));
                this.enableAction(null, (JMenuItem)this.menuSysImport, null);
                this.enableAction(null, (JMenuItem)this.menuItemImportData, (Action)this.actionImportData);
                if (this.tblMain.getBody().size() > 0) {
                    this.disableAction((JButton)this.btnGroupAddNew, null, (Action)this.actionGroupAddNew);
                } else {
                    this.enableAction((JButton)this.btnGroupAddNew, null, (Action)this.actionGroupAddNew);
                }
            } else {
                this.disableAction((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew, (Action)this.actionAddNew);
                this.enableAction((JButton)this.btnGroupAddNew, null, (Action)this.actionGroupAddNew);
                this.disableAction((JButton)this.btnImport, (JMenuItem)this.menuImport, null);
                this.disableAction(null, (JMenuItem)this.menuItemImportData, (Action)this.actionImportData);
                this.disableAction(null, (JMenuItem)this.menuSysImport, null);
                this.disableAction((JButton)this.btnImportExcel, null, (Action)((Object)this.actionImportExcel));
            }
        } else {
            this.enableAction((JButton)this.btnGroupAddNew, null, (Action)this.actionGroupAddNew);
            this.disableAction((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew, (Action)this.actionAddNew);
            this.disableAction((JButton)this.btnImport, (JMenuItem)this.menuImport, null);
            this.disableAction(null, (JMenuItem)this.menuItemImportData, (Action)this.actionImportData);
            this.disableAction(null, (JMenuItem)this.menuSysImport, null);
            this.disableAction((JButton)this.btnImportExcel, null, (Action)((Object)this.actionImportExcel));
        }
    }

    protected void handleFpFields(KDTDataRequestEvent e) {
        int in = e.getLastRow();
        for (int i = e.getFirstRow(); i <= in; ++i) {
            int dataRela;
            BizEnumValueInfo dataRelaEnum;
            int elimType;
            BizEnumValueInfo elimTypeEnum;
            boolean isForFP = (Boolean)this.tblMain.getCell(i, "isForFP").getValue();
            if (!isForFP) {
                this.tblMain.getCell(i, "fpDirection").setValue(null);
            }
            if ((elimTypeEnum = (BizEnumValueInfo)this.tblMain.getCell(i, "elimType").getValue()) != null && (elimType = elimTypeEnum.getInt()) == 0) {
                this.tblMain.getCell(i, "elimType").setValue(null);
            }
            if ((dataRelaEnum = (BizEnumValueInfo)this.tblMain.getCell(i, "dataRelation").getValue()) == null || (dataRela = dataRelaEnum.getInt()) != -1) continue;
            this.tblMain.getCell(i, "dataRelation").setValue(null);
        }
    }

    @Override
    public void actionFpDrcMt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList headId = this.getSelectedIdValues();
        BgItemCollection coll = new BgItemCollection();
        HashSet set = new HashSet();
        set.addAll(headId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("level"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        coll = BgItemFactory.getRemoteInstance().getBgItemCollection(view);
        HashMap<String, BgItemInfo> rootMap = new HashMap<String, BgItemInfo>();
        BgItemInfo itemInfo = null;
        BgItemInfo rootInfo = null;
        for (int i = coll.size() - 1; i >= 0; --i) {
            itemInfo = coll.get(i);
            if (coll.get(i).getLevel() != 1) continue;
            rootMap.put(itemInfo.getId().toString(), itemInfo);
            coll.removeObject(i);
        }
        if (rootMap.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"33_BgItemGroupListUI"));
            SysUtil.abort();
        }
        String key2 = null;
        for (int i = coll.size() - 1; i >= 0; --i) {
            itemInfo = coll.get(i);
            boolean isSelectRootItem = false;
            for (String key2 : rootMap.keySet()) {
                rootInfo = (BgItemInfo)rootMap.get(key2);
                if (!itemInfo.getLongNumber().startsWith(rootInfo.getLongNumber() + "!")) continue;
                isSelectRootItem = true;
                break;
            }
            if (isSelectRootItem) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"33_BgItemGroupListUI"));
            SysUtil.abort();
        }
        this.getSelectedIdNumber();
        String uiClass = BgFpDrcMtUI.class.getName();
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        final ActionEvent e1 = e;
        final ArrayList rootId = new ArrayList();
        rootId.addAll(rootMap.keySet());
        final Map retMap = ((BgFpDrcMtUI)uiWindow.getUIObject()).getUIContext();
        if ("ok".equals(retMap.get("returnState"))) {
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    FpCashDirectionEnum fpDirection = (FpCashDirectionEnum)((Object)retMap.get(BgItemGroupListUI.VALUE_FPDRC));
                    IBgItem iInterface = BgItemGroupListUI.this.getBgItemInterface();
                    String detailMsg = iInterface.updateFpDirection(rootId, fpDirection);
                    return detailMsg;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof String) {
                        String msg = BgItemGroupListUI.this.getResource("updateFinish");
                        String refStr = BgItemGroupListUI.this.getResource("itemReferencedNew");
                        String passStr = BgItemGroupListUI.this.getResource("itemUpdatedNew");
                        String detail = "";
                        String[] tmp = ((String)result).split("!");
                        if (tmp[0] != null && tmp[0].trim().length() > 0) {
                            detail = MessageFormat.format(refStr, tmp[0]) + "\n";
                        }
                        if (tmp[1] != null && tmp[1].trim().length() > 0) {
                            detail = MessageFormat.format(passStr, tmp[1]);
                        }
                        BgItemGroupListUI.this.refresh(e1);
                        MsgBox.showDetailAndOK((Component)((Object)BgItemGroupListUI.this), (String)msg, (String)detail, (int)1);
                    } else {
                        MsgBox.showWarning((Component)((Object)BgItemGroupListUI.this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                    }
                }
            });
            dialog.show();
        }
    }

    @Override
    public void actionElim_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList headId = this.getSelectedIdValues();
        BgItemCollection coll = new BgItemCollection();
        HashSet set = new HashSet();
        set.addAll(headId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("orgUnit"));
        selector.add(new SelectorItemInfo("assignRootOrg"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        coll = BgItemFactory.getRemoteInstance().getBgItemCollection(view);
        HashMap<String, BgItemInfo> rootMap = new HashMap<String, BgItemInfo>();
        BgItemInfo itemInfo = null;
        BgItemInfo rootInfo = null;
        for (int i = coll.size() - 1; i >= 0; --i) {
            itemInfo = coll.get(i);
            if (coll.get(i).getLevel() != 1) continue;
            rootMap.put(itemInfo.getId().toString(), itemInfo);
            coll.removeObject(i);
        }
        if (rootMap.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"33_BgItemGroupListUI"));
            SysUtil.abort();
        }
        String key2 = null;
        for (int i = coll.size() - 1; i >= 0; --i) {
            itemInfo = coll.get(i);
            boolean isSelectRootItem = false;
            for (String key2 : rootMap.keySet()) {
                rootInfo = (BgItemInfo)rootMap.get(key2);
                if (!itemInfo.getLongNumber().startsWith(rootInfo.getLongNumber() + "!")) continue;
                isSelectRootItem = true;
                break;
            }
            if (isSelectRootItem) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"33_BgItemGroupListUI"));
            SysUtil.abort();
        }
        String orgId = null;
        String assignOrgId = null;
        for (String key2 : rootMap.keySet()) {
            rootInfo = (BgItemInfo)rootMap.get(key2);
            orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            if (orgId.equals(assignOrgId = rootInfo.getAssignRootOrg().getId().toString())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"34_BgItemGroupListUI"));
            SysUtil.abort();
        }
        this.getSelectedIdNumber();
        String uiClass = BgElimUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        final ActionEvent e1 = e;
        final ArrayList rootId = new ArrayList();
        rootId.addAll(rootMap.keySet());
        final Map retMap = ((BgElimUI)uiWindow.getUIObject()).getUIContext();
        if ("ok".equals(retMap.get("returnState"))) {
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    BgElimTypeEnum elimtype = (BgElimTypeEnum)retMap.get(BgItemGroupListUI.VALUE_ELIM);
                    BgDataRelationEnum datarela = (BgDataRelationEnum)retMap.get(BgItemGroupListUI.VALUE_RELA);
                    IBgItem iInterface = BgItemGroupListUI.this.getBgItemInterface();
                    String detailMsg = iInterface.updateElimType(rootId, elimtype, datarela);
                    return detailMsg;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof String) {
                        String msg = BgItemGroupListUI.this.getResource("elimFinish");
                        BgItemGroupListUI.this.refresh(e1);
                        MsgBox.showDetailAndOK((Component)((Object)BgItemGroupListUI.this), (String)msg, (String)((String)result), (int)1);
                    } else {
                        MsgBox.showWarning((Component)((Object)BgItemGroupListUI.this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                    }
                }
            });
            dialog.show();
        }
    }

    protected FilterInfo getDefaultFilterForTree() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected void execQuery() {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        super.execQuery();
        this.assignOrgHandle();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterItemInfo item;
        String orgUnitId = "";
        String longNumber = "";
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null) {
            return super.getQueryExecutor(queryPK, viewInfo);
        }
        try {
            if (this.getUIContext().get("ORGUNITID") != null) {
                orgUnitId = this.getUIContext().get("ORGUNITID").toString();
                item = new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(orgUnitId), CompareType.EQUALS);
                this.addFilterItem(filter, item);
                OrgUnitInfo ou = CostCenterOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select longnumber where id='" + orgUnitId + "'");
                longNumber = ou.getLongNumber();
            } else {
                item = null;
                if (this.ccoInfo != null) {
                    item = new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(this.ccoInfo.getId().toString()), CompareType.EQUALS);
                    longNumber = this.ccoInfo.getLongNumber();
                } else {
                    item = new FilterItemInfo("orgUnit.id", null, CompareType.EQUALS);
                }
                this.addFilterItem(filter, item);
            }
            if (!this.isBgItemIsolate) {
                filter = BgSHelper.getFilter(filter, longNumber);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        if (this.getUIContext().get("ELIMTYPE") != null) {
            item = new FilterItemInfo("elimType", (Object)("" + ((BgElimTypeEnum)this.getUIContext().get("ELIMTYPE")).getValue()), CompareType.EQUALS);
            this.addFilterItem(filter, item);
        }
        this.afterQueryExecutor(filter);
        viewInfo.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("longnumber");
        sort.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sort);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        return exec;
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemCollection items) {
        if (filter == null || items == null) {
            return;
        }
        if (!items.isEmpty()) {
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                this.replaceFilterItems(filter, (FilterItemInfo)iter.next());
            }
        }
    }

    protected FilterItemInfo getSingleNodeFilter(TreeBaseInfo treeNode) {
        if (treeNode == null) {
            return new FilterItemInfo(this.getQueryFieldName(), (Object)"000000000000000000000000000=");
        }
        return new FilterItemInfo(this.getQueryFieldName(), (Object)treeNode.getId().toString());
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    protected void addFilterItem(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            int itemsSize = fiCol.size();
            if (itemsSize < 1 || filter.getMaskString() == null) {
                filter.setMaskString("(#0)");
            }
            fiCol.add(item);
            if (itemsSize >= 1) {
                filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize) + ")");
            }
        }
    }

    protected void afterQueryExecutor(FilterInfo filter) {
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected String getGroupEditUIName() {
        return BgItemGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "bgItemGroup.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BgItemGroupFactory.getRemoteInstance();
    }

    protected String getRootName() {
        return this.getResource("bgItem");
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        BgItemGroupInfo groupInfo = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
            uiContext.put((Object)"groupInfo", (Object)this.getSelectedBgItemGroupInfo());
            if (groupInfo.isIsLeaf()) {
                uiContext.put((Object)"tableCount", (Object)new Integer(this.tblMain.getBody().size()));
            }
        }
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (!this.checkCanAddOrRemoveOrUpdate(treeNode)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"systemImportCanNotRemove"));
            return;
        }
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            String bizObjectId = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
            boolean iscreator = BgClientHelper.isCreator(bizObjectId, "remove");
            if (!iscreator) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"notCreatorNotRem"));
                return;
            }
            if (!((BgItemGroupInfo)treeNode.getUserObject()).isIsLeaf()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("notLeaf_delete"));
            } else if (this.tblMain.getBody().size() >= 1) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("hasItem_delete"));
            } else {
                super.actionGroupRemove_actionPerformed(e);
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (!this.checkCanAddOrRemoveOrUpdate(treeNode)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"systemImportCanNotAdd"));
            return;
        }
        BgItemGroupInfo groupInfo = null;
        if (treeNode != null && treeNode.getUserObject() instanceof BgItemGroupInfo) {
            groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
        }
        if (groupInfo != null && groupInfo.isIsLeaf() && this.tblMain.getBody().size() >= 1) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("hasItem_add"));
            return;
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    private boolean checkCanAddOrRemoveOrUpdate(KDTreeNode treeNode) {
        TreeBaseInfo info;
        return treeNode == null || !(treeNode.getUserObject() instanceof TreeBaseInfo) || !(info = (TreeBaseInfo)treeNode.getUserObject()).getLongNumber().startsWith("hbbbllx");
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (!this.checkCanAddOrRemoveOrUpdate(treeNode)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"systemImportCanNotEdit"));
            return;
        }
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            String bizObjectId = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
            boolean iscreator = BgClientHelper.isCreator(bizObjectId, "edit");
            if (!iscreator) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"notCreatorNotEdit"));
                return;
            }
            super.actionGroupEdit_actionPerformed(e);
        }
    }

    private String getImportUIName() {
        return BgItemImportByBaseUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"groupInfo", (Object)this.getSelectedBgItemGroupInfo());
        try {
            uiContext.put((Object)"itemInfo", (Object)this.getSelectedInfo());
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private BgItemInfo getSelectedInfo() {
        String _bgItemId = null;
        BgItemInfo _bgItemInfo = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && row.getCell("id").getValue() != null) {
            _bgItemId = row.getCell("id").getValue().toString();
            _bgItemInfo = new BgItemInfo();
            _bgItemInfo.setId(BOSUuid.read((String)_bgItemId));
            _bgItemInfo.setName(String.valueOf(row.getCell("name").getValue()));
            Object obj = row.getCell("number").getValue();
            if (obj instanceof NumberExpandInfo) {
                _bgItemInfo.setNumber(((NumberExpandInfo)obj).getNumber());
            } else {
                _bgItemInfo.setNumber(obj.toString());
            }
        }
        return _bgItemInfo;
    }

    protected BgItemGroupInfo getSelectedBgItemGroupInfo() {
        KDTreeNode treeNode = null;
        BgItemGroupInfo groupInfo = null;
        treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
        }
        return groupInfo;
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            NumberExpandInfo expandInfo;
            IRow row;
            int rowIndex = e.getRowIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && this.treeRender.inRect(expandInfo = (NumberExpandInfo)row.getCell("number").getValue(), e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo);
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    protected void afterQueryChildBgItem(FilterInfo filter) {
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgItemGroupListUI.this.setTreeDisplayStyle(start, end);
            }
        });
    }

    protected void setTreeDisplayStyle(int start, int end) {
        IRow row = null;
        IRow sRow = null;
        int level = 0;
        Object numberValue = null;
        NumberExpandInfo expandInfo = null;
        int count = end;
        for (int i = start; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (i + 1 <= count) {
                sRow = this.tblMain.getRow(i + 1);
            }
            if (row == null || row.getCell("id") == null) continue;
            String id = (String)row.getCell("id").getValue();
            numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            String number = numberValue.toString();
            String longNumber = row.getCell("longnumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            boolean isEffective = (Boolean)row.getCell("isEffective").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setEffective(isEffective);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
            if (isEffective) {
                row.getStyleAttributes().setBackground(Color.white);
                continue;
            }
            row.getStyleAttributes().setBackground(new Color(230, 230, 230));
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList idList = this.getSelectedIdValues();
            int size = idList.size();
            ObjectUuidPK[] pks = new ObjectUuidPK[size];
            for (int i = 0; i < size; ++i) {
                pks[i] = new ObjectUuidPK((String)idList.get(size - i - 1));
            }
            this.setArrayPK((IObjectPK[])pks);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    try {
                        BgItemFactory.getRemoteInstance().delete(BgItemGroupListUI.this.getArrayPK(), BgItemGroupListUI.this.getCurOrgUnitId());
                    }
                    catch (Exception ex) {
                        MsgBox.showDetailAndOK((Component)((Object)BgItemGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError"), (String)ex.getMessage(), (int)1);
                    }
                    return null;
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
            this.actionRefresh_actionPerformed(e);
        }
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = null;
        Object obj = this.treeMain.getLastSelectedPathComponent();
        if (obj == null || !(obj instanceof KDTreeNode) || ((KDTreeNode)obj).getUserObject() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"notRemoveAll"));
            return;
        }
        treeNode = (KDTreeNode)obj;
        BgItemGroupInfo groupInfo = null;
        if (!(treeNode.getUserObject() instanceof BgItemGroupInfo)) {
            return;
        }
        groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
        if (groupInfo == null || !groupInfo.isIsLeaf()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"isLeaf"));
            return;
        }
        boolean isCreator = false;
        if (isCreator) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"isCreatorGroup"));
        } else {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource.isRemoveAll")))) {
                IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                ibgItem.removeAll(groupInfo.getId(), BOSUuid.read((String)this.getCurOrgUnitId()));
            }
            this.refresh(e);
        }
    }

    private String getCurOrgUnitId() {
        String orgUnitId = null;
        if (this.getUIContext().get("ORGUNITID") != null) {
            orgUnitId = this.getUIContext().get("ORGUNITID").toString();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            orgUnitId = this.orgUnitInfo.getId().toString();
        }
        return orgUnitId;
    }

    private FullOrgUnitInfo getCurOrgUnit() {
        if (this.bgFormOrgUnit != null) {
            return this.bgFormOrgUnit;
        }
        if (this.getUIContext().get("ORGUNITID") != null && !StringUtils.isEmpty((String)this.getUIContext().get("ORGUNITID").toString())) {
            try {
                this.bgFormOrgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)this.getUIContext().get("ORGUNITID")));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return this.ccoInfo.castToFullOrgUnitInfo();
            }
            return this.bgFormOrgUnit;
        }
        if (this.ccoInfo != null) {
            return this.ccoInfo.castToFullOrgUnitInfo();
        }
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgUnitInfo != null && orgUnitInfo instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)orgUnitInfo;
        }
        return null;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"out"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.setCellValue(0, 0, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"number"));
        kdsSheet.setCellValue(0, 1, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"name"));
        kdsSheet.setCellValue(0, 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"specialNumber"));
        kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"longnumber"));
        kdsSheet.setCellValue(0, 4, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"level"));
        kdsSheet.setCellValue(0, 5, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"isSumFormula"));
        kdsSheet.setCellValue(0, 6, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"formula"));
        kdsSheet.setCellValue(0, 7, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"actRecordInit"));
        kdsSheet.setCellValue(0, 8, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"actRecordMaintain"));
        kdsSheet.setCellValue(0, 9, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"fpDirection"));
        kdsSheet.setCellValue(0, 10, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"elimType"));
        kdsSheet.setCellValue(0, 11, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"dataRela"));
        IRow row = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("number").getValue() != null && row.getCell("name").getValue() != null) {
                kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell("number").getValue().toString());
                kdsSheet.setCellValue(i + 1, 1, (Object)row.getCell("name").getValue().toString());
                if (row.getCell("specialNumber").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 2, (Object)row.getCell("specialNumber").getValue().toString());
                }
                if (row.getCell("longnumber").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 3, (Object)row.getCell("longnumber").getValue().toString());
                }
                if (row.getCell("level").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 4, (Object)row.getCell("level").getValue().toString());
                }
                if (row.getCell("isSumFormula").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 5, (Object)row.getCell("isSumFormula").getValue().toString());
                }
                if (row.getCell("formula").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 6, (Object)row.getCell("formula").getValue().toString());
                }
                if (row.getCell("actRecordInit").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 7, (Object)row.getCell("actRecordInit").getValue().toString());
                }
                if (row.getCell("actRecordMaintain").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 8, (Object)row.getCell("actRecordMaintain").getValue().toString());
                }
                if (row.getCell("fpDirection").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 9, (Object)row.getCell("fpDirection").getValue().toString());
                }
                if (row.getCell("elimType").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 10, (Object)row.getCell("elimType").getValue().toString());
                }
                if (row.getCell("dataRelation").getValue() == null) continue;
                kdsSheet.setCellValue(i + 1, 11, (Object)row.getCell("dataRelation").getValue().toString());
                continue;
            }
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"errorValue"), new Integer(i + 1)));
            return;
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"fileIsNotOpen"));
        }
    }

    @Override
    public void actionImportExcel_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        fullOrgUnit.setId(orgUnit.getId());
        BgItemGroupInfo bgItemGroupInfo = this.getSelectedBgItemGroupInfo();
        if (bgItemGroupInfo == null) {
            return;
        }
        String filePath = null;
        boolean isNull = true;
        boolean isTooLong = false;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"in"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            kdsBook = POIXlsReader.parse((String)filePath);
        }
        catch (Exception e1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"excelBad"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"notFile"));
            SysUtil.abort();
        }
        BgItemCollection collection = new BgItemCollection();
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        int rowCount = sheet.getRowCount();
        String nextNum = "0";
        String nextName = "0";
        String num = null;
        String name = null;
        String spnum = null;
        String longnumber = null;
        String level = null;
        String isSumFormula = null;
        String formula = null;
        String actRecordInit = null;
        String actRecordMaintain = null;
        String fpDirection = null;
        String elimType = null;
        String dataRela = null;
        BgItemInfo bgItemInfo = null;
        try {
            for (int i = 1; i < rowCount || !nextNum.trim().equals("") || !nextName.trim().equals(""); ++i) {
                num = sheet.getCell(i, 0, false).getValue() == null ? "" : sheet.getCell(i, 0, false).getValue().toString().trim();
                name = sheet.getCell(i, 1, false).getValue() == null ? "" : sheet.getCell(i, 1, false).getValue().toString().trim();
                spnum = sheet.getCell(i, 2, false).getValue() == null ? null : sheet.getCell(i, 2, false).getValue().toString().trim();
                longnumber = sheet.getCell(i, 3, false).getValue() == null ? null : sheet.getCell(i, 3, false).getValue().toString();
                level = sheet.getCell(i, 4, false).getValue() == null ? null : sheet.getCell(i, 4, false).getValue().toString();
                isSumFormula = sheet.getCell(i, 5, false).getValue() == null ? null : sheet.getCell(i, 5, false).getValue().toString();
                formula = sheet.getCell(i, 6, false).getValue() == null ? null : sheet.getCell(i, 6, false).getValue().toString();
                actRecordInit = sheet.getCell(i, 7, false).getValue() == null ? null : sheet.getCell(i, 7, false).getValue().toString();
                actRecordMaintain = sheet.getCell(i, 8, false).getValue() == null ? null : sheet.getCell(i, 8, false).getValue().toString();
                fpDirection = sheet.getCell(i, 9, false).getValue() == null ? null : sheet.getCell(i, 9, false).getValue().toString();
                elimType = sheet.getCell(i, 10, false).getValue() == null ? null : sheet.getCell(i, 10, false).getValue().toString();
                dataRela = sheet.getCell(i, 11, false).getValue() == null ? null : sheet.getCell(i, 11, false).getValue().toString();
                nextNum = sheet.getCell(i + 1, 0, false).getValue() == null ? "" : sheet.getCell(i + 1, 0, false).getValue().toString().trim();
                String string = nextName = sheet.getCell(i + 1, 1, false).getValue() == null ? "" : sheet.getCell(i + 1, 1, false).getValue().toString().trim();
                if (longnumber == null || "".equals(longnumber) || level == null || "".equals(level)) continue;
                if (num.trim().equals("") && name.trim().equals("")) {
                    if (i == 1) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"errorLine"), new Integer(i + 1)));
                        isNull = true;
                    }
                    break;
                }
                if (num.trim().equals("") || name.trim().equals("")) {
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"errorLine"), new Integer(i + 1)));
                    isNull = true;
                    break;
                }
                if (!(isTooLong || num.trim().length() <= 80 && name.trim().length() <= 254)) {
                    isTooLong = true;
                    continue;
                }
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                bgItemInfo.setNumber(num);
                BgLocaleHelper.setLocalesProperty((IObjectValue)bgItemInfo, "name", name, LocaleUtils.getDefaultLocale());
                bgItemInfo.setName(name);
                bgItemInfo.setLongNumber(longnumber);
                bgItemInfo.setSpecialNumber(spnum);
                bgItemInfo.setBgItemGroup(bgItemGroupInfo);
                bgItemInfo.setRefField(bgItemGroupInfo.getRefField());
                bgItemInfo.setIsEffective(true);
                bgItemInfo.setLevel(Integer.valueOf(level));
                bgItemInfo.setOrgUnit(fullOrgUnit);
                bgItemInfo.setIsSumFormula(Boolean.valueOf(isSumFormula));
                bgItemInfo.setFormula(formula);
                bgItemInfo.setAcctInit(actRecordInit);
                bgItemInfo.setAcctMaintain(actRecordMaintain);
                if ("".equals(fpDirection)) {
                    bgItemInfo.setIsForFP(false);
                } else {
                    bgItemInfo.setIsForFP(true);
                }
                if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"35_BgItemGroupListUI").equals(fpDirection)) {
                    bgItemInfo.setFpDirection(FpCashDirectionEnum.input);
                } else if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"36_BgItemGroupListUI").equals(fpDirection)) {
                    bgItemInfo.setFpDirection(FpCashDirectionEnum.output);
                } else if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"37_BgItemGroupListUI").equals(fpDirection)) {
                    bgItemInfo.setFpDirection(FpCashDirectionEnum.other);
                }
                if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"38_BgItemGroupListUI").equals(elimType) || EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"39_BgItemGroupListUI").equals(elimType)) {
                    bgItemInfo.setElimType(BgElimTypeEnum.None);
                } else if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"40_BgItemGroupListUI").equals(elimType) || EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"41_BgItemGroupListUI").equals(elimType)) {
                    bgItemInfo.setElimType(BgElimTypeEnum.ComeAndGo);
                } else if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"42_BgItemGroupListUI").equals(elimType)) {
                    bgItemInfo.setElimType(BgElimTypeEnum.InnerExchange);
                } else if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"43_BgItemGroupListUI").equals(elimType) || EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemGroupListUI").equals(elimType)) {
                    bgItemInfo.setElimType(BgElimTypeEnum.InnerInvest);
                } else if ("".equals(elimType)) {
                    bgItemInfo.setElimType(BgElimTypeEnum.None);
                } else {
                    bgItemInfo.setElimType(BgElimTypeEnum.None);
                }
                if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"45_BgItemGroupListUI").equals(dataRela)) {
                    bgItemInfo.setDataRelation(BgDataRelationEnum.DebitAdd);
                } else if (EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"46_BgItemGroupListUI").equals(dataRela) || EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"48_BgItemGroupListUI").equals(dataRela)) {
                    bgItemInfo.setDataRelation(BgDataRelationEnum.DebitMinus);
                } else if ("".equals(dataRela)) {
                    bgItemInfo.setDataRelation(BgDataRelationEnum.DebitDefault);
                } else {
                    bgItemInfo.setDataRelation(BgDataRelationEnum.DebitDefault);
                }
                collection.add(bgItemInfo);
                isNull = false;
            }
        }
        catch (Exception ee) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (isTooLong) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"tooLongNumAndName"));
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"groupInfo", (Object)bgItemGroupInfo);
        uiContext.put((Object)"collection", (Object)collection);
        uiContext.put((Object)"ORGUNITID", this.getUIContext().get("ORGUNITID"));
        if (!isNull) {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getImportExcelUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (!this.checkCanAddOrRemoveOrUpdate(treeNode)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"systemImportCanNotAddItem"));
            return;
        }
        if (treeNode == null || !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"isRootItemGroup"));
            return;
        }
        if (this.getSelectedBgItemGroupInfo() == null) {
            return;
        }
        this.isAddNewOper = true;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        BgItemGroupInfo groupInfo = this.getSelectedBgItemGroupInfo();
        if (groupInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"groupInfo", (Object)groupInfo);
        uiContext.put((Object)"ORGUNITID", this.getUIContext().get("ORGUNITID"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getImportUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    private String getImportExcelUIName() {
        return BgItemImportExcelUI.class.getName();
    }

    private String getBgItemAssignUIName() {
        return BgItemAssignUI.class.getName();
    }

    public SelectorItemCollection getListSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("itemID"));
        sic.add(new SelectorItemInfo("itemNumber"));
        sic.add(new SelectorItemInfo("itemName"));
        sic.add(new SelectorItemInfo("isEffective"));
        sic.add(new SelectorItemInfo("bgItemGroup.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("displayName"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("specialNumber"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.level"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("assignParentOrg.id"));
        sic.add(new SelectorItemInfo("assignParentOrg.name"));
        sic.add(new SelectorItemInfo("assignParentOrg.level"));
        sic.add(new SelectorItemInfo("assignParentOrg.number"));
        sic.add(new SelectorItemInfo("assignRootOrg.id"));
        sic.add(new SelectorItemInfo("assignRootOrg.name"));
        sic.add(new SelectorItemInfo("assignRootOrg.level"));
        sic.add(new SelectorItemInfo("assignRootOrg.number"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("isForFP"));
        sic.add(new SelectorItemInfo("fpDirection"));
        sic.add(new SelectorItemInfo("elimType"));
        sic.add(new SelectorItemInfo("dataRelation"));
        return sic;
    }

    public BgItemInfo getData() throws Exception {
        Object keyValue;
        BgItemInfo bgItemInfo = null;
        if (this.tblMain.getSelectManager().get() == null) {
            return null;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = row.getCell(this.getKeyFieldName());
        if (cell == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            ObjectUuidPK pk = new ObjectUuidPK(keyValue.toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            bgItemInfo = this.getBgItemInterface().getBgItemInfo((IObjectPK)pk, sic);
        }
        return bgItemInfo;
    }

    public KDTable getTable() {
        return this.tblMain;
    }

    public KDWorkButton getBtnView() {
        return this.btnView;
    }

    public KDWorkButton getBtnEdit() {
        return this.btnEdit;
    }

    public KDWorkButton getBtnGroupAddNew() {
        return this.btnGroupAddNew;
    }

    public KDWorkButton getBtnGroupEdit() {
        return this.btnGroupEdit;
    }

    public KDWorkButton getBtnGroupMoveTree() {
        return this.btnGroupMoveTree;
    }

    public KDWorkButton getBtnGroupRemove() {
        return this.btnGroupRemove;
    }

    public KDWorkButton getBtnGroupView() {
        return this.btnGroupView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveGroupTreeNode(MoveTreeEvent e) {
        BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)e.getTargetTreeBaseInfo();
        if (bgItemGroupInfo != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("bgItemGroup.id", (Object)bgItemGroupInfo.getId(), CompareType.EQUALS));
            try {
                items.add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(this.getCurOrgUnit().getId().toString()), CompareType.EQUALS));
            }
            catch (Exception exception) {
                // empty catch block
            }
            view.setFilter(filter);
            view.setTopCount(1);
            IBgItem ibgItem = null;
            BgItemCollection col = null;
            try {
                ibgItem = BgItemFactory.getRemoteInstance();
                if (ibgItem != null && (col = ibgItem.getBgItemCollection(view)).size() > 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)this.getResource("noMove"));
                    SysUtil.abort();
                }
            }
            catch (BOSException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
            finally {
                if (col != null) {
                    col.clear();
                }
                ibgItem = null;
            }
        }
        super.moveGroupTreeNode(e);
    }

    @Override
    public void actionBgItemMaintenance_actionPerformed(ActionEvent e) throws Exception {
        IBgItem ibgItem;
        super.actionBgItemMaintenance_actionPerformed(e);
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)this.getResource("isCanItemSuperiorMaintenance"));
        if (re == 0 && (ibgItem = (IBgItem)this.getBizInterface()).bgItemSupriorMaintenance()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("bgItemSuperiorSucceed"));
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList bgItemIdsList = this.getSelectedIdValues();
        if (bgItemIdsList == null || bgItemIdsList.isEmpty()) {
            return;
        }
        int option = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"47_BgItemGroupListUI"));
        if (option != 0 && option != 0) {
            return;
        }
        this.getBgItemInterface().batchSetItemInefficacy(bgItemIdsList);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList bgItemIdsList = this.getSelectedIdValues();
        this.getBgItemInterface().batchSetItemEfficacy(bgItemIdsList);
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getBgItemAssignUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionCancelAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAssign_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IS_CANCEL_ASSIGN", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getBgItemAssignUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"name", "number"};
        return locateNames;
    }

    public IObjectPK[] getArrayPK() {
        return this.arrayPK;
    }

    public void setArrayPK(IObjectPK[] arrayPK) {
        this.arrayPK = arrayPK;
    }

    public Set getCanSeeItem() {
        return this.canSeeItem;
    }

    public void setCanSeeItem(Set canSeeItem) {
        this.canSeeItem = canSeeItem;
    }

    public boolean isAddNewOper() {
        return this.isAddNewOper;
    }

    public void setAddNewOper(boolean isAddNewOper) {
        this.isAddNewOper = isAddNewOper;
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpgrade_actionPerformed(e);
        int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("upgradeWarning"));
        if (confirm == 0) {
            this.doUpgrade();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkCanEdit()) {
            super.actionEdit_actionPerformed(e);
        }
    }

    private boolean checkCanEdit() {
        this.checkSelected();
        int rowIndex = 0;
        IRow row = null;
        rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        row = this.tblMain.getRow(rowIndex);
        if (row != null && !this.isBgItemIsolate && !this.getCurOrgUnitId().equals(row.getCell("assignRootOrgId").getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"CanNotModifyItemForOrg"));
            SysUtil.abort();
        }
        return true;
    }

    protected void doUpgrade() throws Exception {
        int confirm2 = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"49_BgItemGroupListUI"));
        if (confirm2 != 0) {
            SysUtil.abort();
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog != null) {
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    BgItemGroupListUI.this.getBgItemFacadeInterface().dataMigrate();
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                    BgItemGroupListUI.this.isUpgrade = true;
                    MsgBox.showInfo((Component)((Object)BgItemGroupListUI.this), (String)BgItemGroupListUI.this.getResource("upgradeFinished"));
                    BgItemGroupListUI.this.btnAssign.setVisible(true);
                    BgItemGroupListUI.this.btnCancelAssign.setVisible(true);
                    BgItemGroupListUI.this.actionAssign.setEnabled(true);
                    BgItemGroupListUI.this.actionCancelAssign.setEnabled(true);
                    BgSHelper.setHasIsolate(0);
                }
            });
            dialog.show();
        }
    }

    @Override
    protected void CoreUI_componentShown(ComponentEvent e) throws Exception {
        super.CoreUI_componentShown(e);
        if (!this.isBgItemIsolate) {
            return;
        }
        if (!this.isUpgrade) {
            int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"50_BgItemGroupListUI"));
            if (confirm != 0) {
                SysUtil.abort();
            } else {
                this.doUpgrade();
            }
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void assignOrgHandle() {
        if (!this.isBgItemIsolate) {
            if (this.tblMain.getColumn("assignParentOrgName") != null) {
                this.tblMain.getColumn("assignParentOrgName").getStyleAttributes().setHided(true);
            }
        } else if (this.tblMain.getColumn("assignParentOrgName") != null) {
            this.tblMain.getColumn("assignParentOrgName").getStyleAttributes().setHided(false);
        }
    }

    protected class BgItemTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        protected BgItemTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        protected boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    protected class NumberExpandInfo {
        private String id = null;
        private String number = null;
        private String longNumber = null;
        private boolean isExpandStatus = false;
        private int level = 0;
        private boolean isLeaf = false;
        private boolean isEffective = true;

        protected NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isEffective() {
            return this.isEffective;
        }

        public void setEffective(boolean isEffective) {
            this.isEffective = isEffective;
        }
    }
}

