/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.budget.BgDimensionCollection;
import com.kingdee.eas.ma.budget.BgDimensionFactory;
import com.kingdee.eas.ma.budget.BgDimensionInfo;
import com.kingdee.eas.ma.budget.BgDimensionTypeEnum;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemImportFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgDimension;
import com.kingdee.eas.ma.budget.IBgItemImportFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgItemImportByBaseUI;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgDataRelationEnum;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgItemImportByBaseUI
extends AbstractBgItemImportByBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemImportByBaseUI.class);
    private static final String STRRESOURCE = "com.kingdee.eas.ma.budget.client.BgItemImportResource";
    private String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    private String bgFormOrgUnitId = null;
    private BgDimRender render = null;
    private int index = 0;
    private int count = 0;
    private BgDimensionInfo bgDimInfo = null;
    private BgItemGroupInfo bgGroupInfo = null;
    private TreeBaseCollection tableCol = null;
    private TreeBaseCollection treeCol = null;
    private TreeBaseCollection comCol = null;
    private DefaultKingdeeTreeNode root = null;
    private BgItemCollection saveItemCol = null;
    boolean toImportGroup = false;
    boolean isIntegrateWithRPT = false;
    private Locale locale = null;
    private Locale sLocale = new Locale("l2");
    private Locale tLocale = new Locale("l3");

    public IBgItemImportFacade getFacadeInterface() throws BOSException {
        return BgItemImportFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.locale = this.getCurrentLocale();
        super.onLoad();
        this.isIntegrateWithRPT = BgNSHelper.synchronizedCombinationData(null);
        this.kDLabel2.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.selectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.selectClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        BgItemGroupInDialog dialog = new BgItemGroupInDialog();
        dialog.setHideHBBBLLX(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)dialog);
        this.kDTable.getSelectManager().setSelectMode(10);
        this.bgGroupInfo = (BgItemGroupInfo)this.getUIContext().get("groupInfo");
        this.prmtOrgUnit.setData((Object)this.bgGroupInfo);
        if (this.bgGroupInfo == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)STRRESOURCE, (String)"close"));
            this.uiWindow.close();
        }
        this.selectAll.setEnabled(false);
        this.selectAll.setVisible(false);
        this.selectClear.setEnabled(false);
        this.selectClear.setVisible(false);
        this.kDComType.setEnabled(false);
        this.dealFDCIntegration();
        this.initTable();
        this.initDimension();
        if (!StringUtils.isEmpty((String)((String)this.getUIContext().get("ORGUNITID")))) {
            this.bgFormOrgUnitId = (String)this.getUIContext().get("ORGUNITID");
        }
    }

    private void dealFDCIntegration() throws Exception {
        boolean hasFDC = BgItemImportByBaseUI.hasFDCSubSystem();
        if (!hasFDC) {
            return;
        }
        BgItemImportFacadeFactory.getRemoteInstance().dealFDCCostAccount();
    }

    public static boolean hasFDCSubSystem() {
        boolean hasFDC = true;
        try {
            ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)" select fid from T_FDC_CostAccount where 1 = 2 ");
            sqlExe.executeSQL();
        }
        catch (Exception ex) {
            hasFDC = false;
        }
        return hasFDC;
    }

    private void initDimension() throws BOSException {
        IBgDimension iBgDim = BgDimensionFactory.getRemoteInstance();
        BgDimensionCollection bgDimCol = iBgDim.getBgDimensionCollection("order by seq");
        DefaultComboBoxModel<BgDimensionInfo> model = new DefaultComboBoxModel<BgDimensionInfo>();
        Iterator iter = bgDimCol.iterator();
        while (iter.hasNext()) {
            BgDimensionInfo bgInfo = (BgDimensionInfo)iter.next();
            model.addElement(bgInfo);
        }
        this.kDComDimension.setModel(model);
        if (this.kDComDimension.getItemCount() > 0) {
            this.kDComDimension.setSelectedIndex(0);
        }
        this.kDComDimension.getItemAt(1);
    }

    private void initTable() {
        int colCount = 3;
        for (int i = 0; i < colCount; ++i) {
            this.kDTable.addColumn(i);
        }
        IRow row = null;
        row = this.kDTable.addHeadRow();
        if (row != null) {
            row.getCell(0).setValue((Object)EASResource.getString((String)STRRESOURCE, (String)"select"));
            row.getCell(1).setValue((Object)EASResource.getString((String)STRRESOURCE, (String)"number"));
            row.getCell(2).setValue((Object)EASResource.getString((String)STRRESOURCE, (String)"name"));
        }
        IColumn col = null;
        col = this.kDTable.getColumn(0);
        if (col != null) {
            KDCheckBox checkbox = new KDCheckBox();
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkbox));
            col.setWidth(0);
        }
        if ((col = this.kDTable.getColumn(1)) != null) {
            this.render = new BgDimRender();
            col.setRenderer((IBasicRender)this.render);
            col.setWidth(175);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(2)) != null) {
            col.setWidth(150);
            col.getStyleAttributes().setLocked(true);
        }
    }

    private void clearAllInfo() {
        this.clearInfo();
        this.kDComType.removeAllItems();
        if (this.comCol != null) {
            this.comCol.clear();
            this.comCol = null;
        }
        if (this.bgDimInfo != null) {
            this.bgDimInfo = null;
        }
    }

    private void clearInfo() {
        this.clearTree();
        this.clearTable();
    }

    private void clearTable() {
        if (this.tableCol != null) {
            this.tableCol.clear();
            this.tableCol = null;
        }
    }

    private void clearTree() {
        if (this.treeCol != null) {
            this.treeCol.clear();
            this.treeCol = null;
        }
        if (this.root != null) {
            this.root = null;
        }
    }

    @Override
    protected void kDComDimension_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.kDComDimension.getSelectedIndex();
        if (selectIndex >= 0) {
            this.clearAllInfo();
            this.kDTable.removeRows();
            this.bgDimInfo = (BgDimensionInfo)this.kDComDimension.getModel().getElementAt(selectIndex);
            this.kDCheckBox1.setSelected(false);
            this.kDCheckBox1.setVisible(false);
            if (this.bgDimInfo != null) {
                if (this.bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.DATABASE)) {
                    this.kDComType.setEnabled(false);
                    this.kDSplitPane.setDividerLocation(0);
                    this.selectAll.setLocation(647, 0);
                    this.selectClear.setLocation(705, 0);
                    this.builderTree();
                    this.tableCol = this.getFacadeInterface().getDetailCollection(this.bgDimInfo);
                    this.builderTable(this.bgDimInfo);
                } else if (this.bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEBASE) || this.bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREEDATA)) {
                    if (this.isIntegrateWithRPT && !this.bgDimInfo.isIsOrgType()) {
                        this.kDCheckBox1.setVisible(true);
                    }
                    this.kDComType.setEnabled(false);
                    this.kDSplitPane.setDividerLocation(250);
                    this.selectAll.setLocation(398, 0);
                    this.selectClear.setLocation(456, 0);
                    this.tableCol = this.getFacadeInterface().getDetailCollection(this.bgDimInfo);
                    this.builderTable(this.bgDimInfo);
                    if (this.bgDimInfo.getSeq() != 11 && this.bgDimInfo.getSeq() != 12) {
                        this.treeCol = this.getFacadeInterface().getTreeCollection(this.bgDimInfo);
                    } else if (this.bgDimInfo.getSeq() == 11) {
                        this.treeCol = this.getFacadeInterface().getTreeCollectionForCSSP("1");
                    } else if (this.bgDimInfo.getSeq() == 12) {
                        this.treeCol = this.getFacadeInterface().getTreeCollectionForCSSP("2");
                    }
                    this.builderTree();
                } else if (this.bgDimInfo.getDimType().equals((Object)BgDimensionTypeEnum.TREETYPE)) {
                    this.kDComType.setEnabled(true);
                    this.kDSplitPane.setDividerLocation(250);
                    this.selectAll.setLocation(398, 0);
                    this.selectClear.setLocation(456, 0);
                    this.comCol = this.getFacadeInterface().getTypeCollection(this.bgDimInfo);
                    this.builderCombox();
                    if (this.kDComType.getItemCount() > 0) {
                        this.kDComType.setSelectedIndex(0);
                    }
                }
            }
        }
    }

    @Override
    protected void kDComType_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.kDComType.getSelectedIndex();
        if (selectIndex >= 0) {
            BgItemInfo bgTypeInfo = (BgItemInfo)this.kDComType.getModel().getElementAt(selectIndex);
            if (this.bgDimInfo != null && bgTypeInfo != null) {
                this.kDTable.removeRows();
                this.clearInfo();
                this.treeCol = this.getFacadeInterface().getTreeCollection(this.bgDimInfo, bgTypeInfo.getId());
                this.builderTree();
                this.tableCol = this.getFacadeInterface().getDetailCollection(this.bgDimInfo, bgTypeInfo.getId());
                this.builderTable(this.bgDimInfo);
            }
        }
    }

    private void builderTree() {
        if (this.treeCol == null) {
            return;
        }
        this.index = 0;
        this.count = this.treeCol.size();
        this.root = new DefaultKingdeeTreeNode(this.kDComDimension.getSelectedItem());
        this.loadTree(this.root, "");
        KingdeeTreeModel model = null;
        model = new KingdeeTreeModel((TreeNode)this.root);
        this.kDTree.setModel((TreeModel)model);
    }

    private void loadTree(DefaultKingdeeTreeNode node, String pLongNumber) {
        BgItemGroupInfo item = null;
        DefaultKingdeeTreeNode nodes = null;
        String longNumbr = null;
        while (this.index < this.count) {
            item = (BgItemGroupInfo)this.treeCol.getObject(this.index);
            longNumbr = item.getLongNumber();
            if (!item.getLongNumber().startsWith(pLongNumber)) break;
            nodes = new DefaultKingdeeTreeNode((Object)item);
            node.add((MutableTreeNode)nodes);
            ++this.index;
            this.loadTree(nodes, longNumbr + "!");
        }
    }

    private void builderTable(BgDimensionInfo bgDimInfo) {
        if (this.tableCol == null) {
            return;
        }
        IRow row = null;
        BgItemInfo bgItemInfo2 = null;
        for (BgItemInfo bgItemInfo2 : this.tableCol) {
            row = this.kDTable.addRow();
            this.insertExpandInfo(row, bgItemInfo2);
        }
    }

    private void builderCombox() {
        if (this.comCol == null) {
            return;
        }
        DefaultComboBoxModel<BgItemInfo> model = new DefaultComboBoxModel<BgItemInfo>();
        for (BgItemInfo bgTypeInfo : this.comCol) {
            model.addElement(bgTypeInfo);
        }
        if (model.getSize() == 0) {
            this.kDTree.setModel(null);
        }
        this.kDComType.setModel(model);
    }

    @Override
    protected void kDTree_valueChanged(TreeSelectionEvent e) throws Exception {
        block12: {
            IRow row;
            DefaultMutableTreeNode nodes;
            block11: {
                super.kDTree_valueChanged(e);
                nodes = (DefaultMutableTreeNode)this.kDTree.getLastSelectedPathComponent();
                BgDimensionInfo info = null;
                Object obj = this.kDComDimension.getSelectedItem();
                if (obj instanceof BgDimensionInfo && nodes != null) {
                    Object obj1 = nodes.getUserObject();
                    BgItemGroupInfo bgInfo = null;
                    if (obj1 != null && obj1 instanceof BgItemGroupInfo) {
                        bgInfo = (BgItemGroupInfo)nodes.getUserObject();
                        info = (BgDimensionInfo)obj;
                        if (info != null && "T_BD_Material".equals(info.getDetailTable())) {
                            this.tableCol = this.getFacadeInterface().getSpecialProcessCollection("T_BD_Material", bgInfo.getId().toString());
                        }
                        if (info != null && "T_BD_Customer".equals(info.getDetailTable())) {
                            this.tableCol = this.getFacadeInterface().getSpecialProcessCollection("T_BD_Customer", bgInfo.getId().toString());
                        }
                        if (info != null && "T_BD_Supplier".equals(info.getDetailTable())) {
                            this.tableCol = this.getFacadeInterface().getSpecialProcessCollection("T_BD_Supplier", bgInfo.getId().toString());
                        }
                    }
                }
                if (this.tableCol == null) {
                    return;
                }
                row = null;
                BgItemInfo bgItemInfo2 = null;
                this.kDTable.removeRows();
                if (nodes != this.root) break block11;
                for (BgItemInfo bgItemInfo2 : this.tableCol) {
                    row = this.kDTable.addRow();
                    this.insertExpandInfo(row, bgItemInfo2);
                }
                break block12;
            }
            if (nodes == null || !(nodes.getUserObject() instanceof TreeBaseInfo)) break block12;
            BgItemGroupInfo bgInfo = (BgItemGroupInfo)nodes.getUserObject();
            List childNodesList = null;
            if (bgInfo != null) {
                BgItemGroupInfo bgItemGroupInfo2 = null;
                Iterator ite = null;
                childNodesList = this.getChildNodes(nodes, childNodesList);
                for (BgItemInfo bgItemInfo2 : this.tableCol) {
                    if (bgItemInfo2.getLongNumber() == null) {
                        bgItemInfo2.setLongNumber(bgItemInfo2.getNumber());
                    }
                    if (bgItemInfo2.get("bgItemGroupId") == null) continue;
                    for (BgItemGroupInfo bgItemGroupInfo2 : childNodesList) {
                        if (!bgItemInfo2.get("bgItemGroupId").equals(bgItemGroupInfo2.getId())) continue;
                        row = this.kDTable.addRow();
                        this.insertExpandInfo(row, bgItemInfo2);
                    }
                }
            }
        }
    }

    private List getChildNodes(DefaultMutableTreeNode nodes, List childNodesList) {
        if (nodes == null) {
            return null;
        }
        if (childNodesList == null) {
            childNodesList = new ArrayList<BgItemGroupInfo>();
        }
        DefaultMutableTreeNode childnode = null;
        BgItemGroupInfo bgInfo = null;
        bgInfo = (BgItemGroupInfo)nodes.getUserObject();
        if (bgInfo != null) {
            childNodesList.add(bgInfo);
        }
        int childCount = nodes.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            childnode = (DefaultMutableTreeNode)nodes.getChildAt(i);
            if (childnode == null) continue;
            if (childnode.getChildCount() > 0) {
                this.getChildNodes(childnode, childNodesList);
                continue;
            }
            bgInfo = (BgItemGroupInfo)childnode.getUserObject();
            if (bgInfo == null) continue;
            childNodesList.add(bgInfo);
        }
        return childNodesList;
    }

    private void insertExpandInfo(IRow row, BgItemInfo bgItemInfo) {
        if (row == null) {
            return;
        }
        row.getCell(0).setValue((Object)new Boolean("false"));
        if (this.bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292-FDCCBKM") && bgItemInfo != null && bgItemInfo.getLongNumber() != null) {
            row.getCell(1).setValue((Object)bgItemInfo.getLongNumber().replaceAll("!", "."));
            bgItemInfo.setItemNumber(bgItemInfo.getLongNumber().replaceAll("!", "."));
            bgItemInfo.setNumber(bgItemInfo.getItemNumber());
        } else if (this.bgDimInfo.getId().toString().equals("21ee34fc-0108-1000-e000-0185c0a81292CFADEDET") && bgItemInfo != null && bgItemInfo.getLongNumber() != null) {
            row.getCell(1).setValue((Object)bgItemInfo.getLongNumber().replaceAll("!", "."));
        } else {
            row.getCell(1).setValue((Object)bgItemInfo.getNumber());
        }
        row.getCell(2).setValue((Object)bgItemInfo.getName());
        row.setUserObject((Object)bgItemInfo);
        NumberExpandInfo numberExpandInfo = null;
        if (this.bgDimInfo.isDetailTree()) {
            numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setLevel(bgItemInfo.getLevel());
            numberExpandInfo.setLeaf(bgItemInfo.isIsLeaf());
            numberExpandInfo.setNumber(bgItemInfo.getNumber());
            numberExpandInfo.setExpandStatus(true);
            row.getCell(1).setValue((Object)numberExpandInfo);
        }
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (e.getClickCount() == 1) {
            NumberExpandInfo numberExpandInfo;
            IRow row;
            if (colIndex == 1 && this.bgDimInfo.isDetailTree() && (row = this.kDTable.getRow(rowIndex)) != null && (numberExpandInfo = (NumberExpandInfo)row.getCell(1).getValue()) != null && this.render.inRect(numberExpandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, numberExpandInfo);
            }
        } else if (e.getClickCount() == 2 && rowIndex == 0 && colIndex == 0) {
            IRow row = null;
            int count = this.kDTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.kDTable.getRow(i);
                if (row == null) continue;
                row.getCell(0).setValue((Object)new Boolean((Boolean)row.getCell(0).getValue() == false));
            }
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo numberExpandInfo) {
        if (!numberExpandInfo.isLeaf) {
            this.kDTable.setRefresh(false);
            this.expandTable(row, numberExpandInfo);
            this.kDTable.setRefresh(true);
            this.kDTable.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo numberExpandInfo) {
        if (row == null || numberExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = numberExpandInfo.getNumber();
        boolean isExpandStatus = numberExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            numberExpandInfo.setExpandStatus(false);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(1).getValue()).getNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            numberExpandInfo.setExpandStatus(true);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(1).getValue()).getNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                this.expandChild(child, expandInfo);
            }
        }
    }

    private int expandChild(IRow row, NumberExpandInfo parentExpandInfo) {
        int rowIndex;
        IRow child = null;
        int endIndex = rowIndex = row.getRowIndex() + 1;
        int rowCount = this.kDTable.getRowCount();
        String number = null;
        NumberExpandInfo childExpandInfo = null;
        String parentNumber = parentExpandInfo.getNumber();
        parentExpandInfo.setExpandStatus(true);
        for (int i = rowIndex; i < rowCount; ++i) {
            child = this.kDTable.getRow(i);
            if (child != null) {
                childExpandInfo = (NumberExpandInfo)child.getCell(1).getValue();
                number = childExpandInfo.getNumber();
                if (!number.startsWith(parentNumber)) break;
                if (!childExpandInfo.isLeaf()) {
                    i = this.expandChild(child, childExpandInfo);
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    public void checkSelected() {
        if (KDTableUtil.getSelectedRowCount((KDTable)this.kDTable) < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void kDButtonImport_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block;
        BgItemCollection importGroup;
        this.checkSelected();
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        this.saveItemCol = new BgItemCollection();
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        if (!BgSHelper.isBgItemIsolate()) {
            fullOrgUnit.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        } else {
            fullOrgUnit.setId(orgUnit.getId());
        }
        boolean isSave = false;
        IRow row = null;
        BgItemInfo bgItemInfo = null;
        BgItemInfo tempInfo = null;
        String numberPerfix = "";
        if (this.KDBoxNumberPerfix.isSelected() && this.KDTxtNumberPerfix.getText() != null && !"".equals(this.KDTxtNumberPerfix.getText())) {
            numberPerfix = this.KDTxtNumberPerfix.getText();
        }
        boolean isJump = false;
        this.bgGroupInfo = (BgItemGroupInfo)this.prmtOrgUnit.getData();
        if (this.bgGroupInfo == null) {
            return;
        }
        BgItemGroupInfo groupInfo = null;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.kDTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
        }
        if (treeNode == null && this.toImportGroup) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"selectBaseDataGroup"));
            SysUtil.abort();
        }
        if (this.toImportGroup && treeNode != null && !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgImportItemResource", (String)"selectDetailGroup"));
            SysUtil.abort();
        }
        if (this.toImportGroup && (importGroup = this.importGroup(treeNode)) != null && !importGroup.isEmpty()) {
            this.saveItemCol.addCollection(importGroup);
        }
        boolean selectAll = false;
        KDTRange range = this.kDTable.getSelectManager().toRange();
        if (range.size() == 1 && (block = (KDTSelectBlock)range.get(0)).getBottom() == 0 && block.getLeft() == 0 && block.getRight() == 0 && block.getTop() == 0) {
            selectAll = true;
        }
        if (selectAll) {
            int count = this.kDTable.getRowCount();
            for (int index = 0; index < count; ++index) {
                Map extProp;
                row = this.kDTable.getRow(index);
                if (row == null) continue;
                tempInfo = (BgItemInfo)row.getUserObject();
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setName(tempInfo.getName());
                bgItemInfo.setDisplayName(tempInfo.getDisplayName());
                bgItemInfo.setItemID(tempInfo.getItemID());
                bgItemInfo.setItemNumber(tempInfo.getItemNumber());
                bgItemInfo.setItemName(tempInfo.getItemName());
                bgItemInfo.setLongNumber(tempInfo.getLongNumber());
                if (tempInfo.getItemID() != null && tempInfo.getItemID().getType() != null) {
                    bgItemInfo.setBosType(tempInfo.getItemID().getType().toString());
                }
                if (!(extProp = tempInfo.getExtendedProperties()).isEmpty()) {
                    String key2 = null;
                    for (String key2 : extProp.keySet()) {
                        bgItemInfo.setExtendedProperty(key2, (String)extProp.get(key2));
                    }
                }
                if (bgItemInfo.getItemNumber() == null || this.locale.equals(this.sLocale) && bgItemInfo.getName(this.sLocale) == null || this.locale.equals(this.tLocale) && bgItemInfo.getName(this.tLocale) == null || bgItemInfo.getName() == null) continue;
                if (this.bgDimInfo.getPrefix() != null) {
                    bgItemInfo.setNumber(this.bgDimInfo.getPrefix() + numberPerfix + tempInfo.getNumber());
                } else {
                    bgItemInfo.setNumber(numberPerfix + tempInfo.getNumber());
                }
                if (this.toImportGroup && groupInfo != null) {
                    bgItemInfo.setNumber(groupInfo.getLongNumber().replaceAll("!", ".") + "." + bgItemInfo.getItemNumber());
                    bgItemInfo.setLongNumber(groupInfo.getLongNumber() + "!" + bgItemInfo.getLongNumber());
                }
                bgItemInfo.setIsEffective(true);
                bgItemInfo.setBgItemGroup(this.bgGroupInfo);
                bgItemInfo.setRefField(this.bgGroupInfo.getRefField());
                bgItemInfo.setOrgUnit(fullOrgUnit);
                bgItemInfo.setDataRelation(BgDataRelationEnum.DebitDefault);
                if (!this.toImportGroup) {
                    this.chengeNumber(bgItemInfo);
                }
                bgItemInfo.setNumber(bgItemInfo.getNumber());
                if (this.locale.equals(this.sLocale)) {
                    bgItemInfo.setName(bgItemInfo.getName().toString(), this.sLocale);
                    bgItemInfo.setName(STConverter.sc2tc((String)bgItemInfo.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgItemInfo.setName(bgItemInfo.getName().toString(), this.tLocale);
                    bgItemInfo.setName(STConverter.tc2sc((String)bgItemInfo.getName(this.tLocale)), this.sLocale);
                } else {
                    bgItemInfo.setName(bgItemInfo.getName().toString());
                }
                if (bgItemInfo.getDescription() != null) {
                    if (this.locale.equals(this.sLocale)) {
                        bgItemInfo.setDescription(bgItemInfo.getDescription().toString(), this.sLocale);
                        bgItemInfo.setDescription(STConverter.sc2tc((String)bgItemInfo.getDescription(this.sLocale)), this.tLocale);
                    } else if (this.locale.equals(this.tLocale)) {
                        bgItemInfo.setDescription(bgItemInfo.getDescription().toString(), this.tLocale);
                        bgItemInfo.setDescription(STConverter.tc2sc((String)bgItemInfo.getDescription(this.tLocale)), this.sLocale);
                    } else {
                        bgItemInfo.setDescription(bgItemInfo.getDescription().toString());
                    }
                }
                if (bgItemInfo.getDisplayName() != null) {
                    if (this.locale.equals(this.sLocale)) {
                        bgItemInfo.setDisplayName(bgItemInfo.getDisplayName().toString(), this.sLocale);
                        bgItemInfo.setDisplayName(STConverter.sc2tc((String)bgItemInfo.getDisplayName(this.sLocale)), this.tLocale);
                    } else if (this.locale.equals(this.tLocale)) {
                        bgItemInfo.setDisplayName(bgItemInfo.getDisplayName().toString(), this.tLocale);
                        bgItemInfo.setDisplayName(STConverter.tc2sc((String)bgItemInfo.getDisplayName(this.tLocale)), this.sLocale);
                    } else {
                        bgItemInfo.setDisplayName(bgItemInfo.getDisplayName().toString());
                    }
                }
                try {
                    if (isJump) continue;
                    bgItemInfo.remove("id");
                    this.saveItemCol.add(bgItemInfo);
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
                    SysUtil.abort();
                }
            }
        } else {
            for (int i = 0; i < range.size(); ++i) {
                KDTSelectBlock block2 = (KDTSelectBlock)range.get(i);
                for (int j = block2.getBeginRow(); j <= block2.getEndRow(); ++j) {
                    Map extProp;
                    row = this.kDTable.getRow(j);
                    if (row == null) continue;
                    tempInfo = (BgItemInfo)row.getUserObject();
                    bgItemInfo = new BgItemInfo();
                    bgItemInfo.setName(tempInfo.getName());
                    bgItemInfo.setDisplayName(tempInfo.getDisplayName());
                    bgItemInfo.setItemID(tempInfo.getItemID());
                    bgItemInfo.setItemNumber(tempInfo.getItemNumber());
                    bgItemInfo.setItemName(tempInfo.getItemName());
                    bgItemInfo.setLongNumber(tempInfo.getLongNumber());
                    if (tempInfo.getItemID() != null && tempInfo.getItemID().getType() != null) {
                        bgItemInfo.setBosType(tempInfo.getItemID().getType().toString());
                    }
                    if (!(extProp = tempInfo.getExtendedProperties()).isEmpty()) {
                        String key3 = null;
                        for (String key3 : extProp.keySet()) {
                            bgItemInfo.setExtendedProperty(key3, (String)extProp.get(key3));
                        }
                    }
                    if (bgItemInfo.getItemNumber() == null || this.locale.equals(this.sLocale) && bgItemInfo.getName(this.sLocale) == null || this.locale.equals(this.tLocale) && bgItemInfo.getName(this.tLocale) == null || bgItemInfo.getName() == null) continue;
                    if (this.bgDimInfo.getPrefix() != null) {
                        bgItemInfo.setNumber(this.bgDimInfo.getPrefix() + numberPerfix + tempInfo.getNumber());
                    } else {
                        bgItemInfo.setNumber(numberPerfix + tempInfo.getNumber());
                    }
                    if (this.toImportGroup && groupInfo != null) {
                        bgItemInfo.setNumber(groupInfo.getLongNumber().replaceAll("!", ".") + "." + bgItemInfo.getNumber());
                        bgItemInfo.setLongNumber(groupInfo.getLongNumber() + "!" + bgItemInfo.getLongNumber());
                    }
                    bgItemInfo.setIsEffective(true);
                    bgItemInfo.setBgItemGroup(this.bgGroupInfo);
                    bgItemInfo.setRefField(this.bgGroupInfo.getRefField());
                    bgItemInfo.setOrgUnit(fullOrgUnit);
                    bgItemInfo.setDataRelation(BgDataRelationEnum.DebitDefault);
                    if (!this.toImportGroup) {
                        this.chengeNumber(bgItemInfo);
                    }
                    bgItemInfo.setNumber(bgItemInfo.getNumber());
                    if (this.locale.equals(this.sLocale)) {
                        bgItemInfo.setName(bgItemInfo.getName().toString(), this.sLocale);
                        bgItemInfo.setName(STConverter.sc2tc((String)bgItemInfo.getName(this.sLocale)), this.tLocale);
                    } else if (this.locale.equals(this.tLocale)) {
                        bgItemInfo.setName(bgItemInfo.getName().toString(), this.tLocale);
                        bgItemInfo.setName(STConverter.tc2sc((String)bgItemInfo.getName(this.tLocale)), this.sLocale);
                    } else {
                        bgItemInfo.setName(bgItemInfo.getName().toString());
                    }
                    if (bgItemInfo.getDescription() != null) {
                        if (this.locale.equals(this.sLocale)) {
                            bgItemInfo.setDescription(bgItemInfo.getDescription().toString(), this.sLocale);
                            bgItemInfo.setDescription(STConverter.sc2tc((String)bgItemInfo.getDescription(this.sLocale)), this.tLocale);
                        } else if (this.locale.equals(this.tLocale)) {
                            bgItemInfo.setDescription(bgItemInfo.getDescription().toString(), this.tLocale);
                            bgItemInfo.setDescription(STConverter.tc2sc((String)bgItemInfo.getDescription(this.tLocale)), this.sLocale);
                        } else {
                            bgItemInfo.setDescription(bgItemInfo.getDescription().toString());
                        }
                    }
                    if (bgItemInfo.getDisplayName() != null) {
                        if (this.locale.equals(this.sLocale)) {
                            bgItemInfo.setDisplayName(bgItemInfo.getDisplayName().toString(), this.sLocale);
                            bgItemInfo.setDisplayName(STConverter.sc2tc((String)bgItemInfo.getDisplayName(this.sLocale)), this.tLocale);
                        } else if (this.locale.equals(this.tLocale)) {
                            bgItemInfo.setDisplayName(bgItemInfo.getDisplayName().toString(), this.tLocale);
                            bgItemInfo.setDisplayName(STConverter.tc2sc((String)bgItemInfo.getDisplayName(this.tLocale)), this.sLocale);
                        } else {
                            bgItemInfo.setDisplayName(bgItemInfo.getDisplayName().toString());
                        }
                    }
                    try {
                        if (isJump) continue;
                        bgItemInfo.remove("id");
                        this.saveItemCol.add(bgItemInfo);
                        isSave = true;
                        continue;
                    }
                    catch (Exception ex) {
                        MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
                        SysUtil.abort();
                    }
                }
            }
        }
        if (this.saveItemCol != null && this.saveItemCol.size() > 0) {
            this.saveBgItem(this.saveItemCol);
        }
    }

    private void SetHRItemInfo(BgItemCollection itemCollectInfo) {
        String s_T_HR_JobGrade = "67F02330";
        String s_T_HR_JobLevel = "6830FEDD";
        String s_T_BD_HRDiploma = "9B3E5DD3";
        String s_T_HR_BDEmployeeType = "A29E85B3";
        String s_T_HR_EmployeeFenLei = "5C14FC3A";
        String s_T_HR_BDTechnicalPost = "8AD80852";
        boolean bFlag = false;
        String sPre = "";
        String sNum = "";
        String sDetailTable = this.bgDimInfo.getDetailTable();
        if ("T_HR_JobGrade".equalsIgnoreCase(sDetailTable)) {
            bFlag = true;
            sPre = s_T_HR_JobGrade;
        }
        if ("T_HR_JobLevel".equalsIgnoreCase(sDetailTable)) {
            bFlag = true;
            sPre = s_T_HR_JobLevel;
        }
        if ("T_BD_HRDiploma".equalsIgnoreCase(sDetailTable)) {
            bFlag = true;
            sPre = s_T_BD_HRDiploma;
        }
        if ("T_HR_BDEmployeeType".equalsIgnoreCase(sDetailTable)) {
            bFlag = true;
            sPre = s_T_HR_BDEmployeeType;
        }
        if ("T_HR_EmployeeFenLei".equalsIgnoreCase(sDetailTable)) {
            bFlag = true;
            sPre = s_T_HR_EmployeeFenLei;
        }
        if ("T_HR_BDTechnicalPost".equalsIgnoreCase(sDetailTable)) {
            bFlag = true;
            sPre = s_T_HR_BDTechnicalPost;
        }
        if (bFlag) {
            for (int i = 0; i < itemCollectInfo.size(); ++i) {
                sNum = itemCollectInfo.get(i).getNumber();
                itemCollectInfo.get(i).setNumber(sPre + "~" + sNum);
            }
        }
    }

    private void saveBgItem(BgItemCollection col) {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                String _orgUnitId = "";
                _orgUnitId = !StringUtils.isEmpty((String)BgItemImportByBaseUI.this.bgFormOrgUnitId) ? BgItemImportByBaseUI.this.bgFormOrgUnitId : BgItemImportByBaseUI.this.orgUnitId;
                return BgItemFactory.getRemoteInstance().importItems(BgItemImportByBaseUI.this.getSaveItemCol(), _orgUnitId, "SYS_IMPORT");
            }

            public void afterExec(Object result) throws Exception {
                Map map = (Map)result;
                if (map != null) {
                    String resultMsg = BgNFCHelper.getMessageStr((String)BgItemImportByBaseUI.STRRESOURCE, (String)((String)map.get("result")));
                    String detail = (String)map.get("detail");
                    if (!StringUtils.isEmpty((String)detail)) {
                        MsgBox.showDetailAndOK(null, (String)resultMsg, (String)detail, (int)1);
                    } else {
                        MsgBox.showInfo(null, (String)resultMsg);
                    }
                }
            }
        });
        dialog.show();
    }

    private void chengeNumber(BgItemInfo bgItemInfo) {
        String itemNum = bgItemInfo.getNumber().toString();
        if (itemNum.indexOf("_") >= 0) {
            itemNum = itemNum.replaceAll("_", "*");
        }
        if (itemNum.indexOf("|") >= 0) {
            itemNum = itemNum.replaceAll("\\|", "*");
        }
        bgItemInfo.setNumber(itemNum);
    }

    @Override
    protected void KDBoxNumberPerfix_stateChanged(ChangeEvent e) throws Exception {
        this.KDTxtNumberPerfix.setEnabled(this.KDBoxNumberPerfix.isSelected());
    }

    @Override
    protected void selectAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectTable(true);
    }

    @Override
    protected void selectClear_actionPerformed(ActionEvent e) throws Exception {
        this.selectTable(false);
    }

    private void selectTable(boolean tag) {
        int rowCount = this.kDTable.getRowCount();
        IRow row = null;
        int count = rowCount;
        for (int i = 0; i < count; ++i) {
            row = this.kDTable.getRow(i);
            if (row == null) continue;
            row.getCell(0).setValue((Object)new Boolean(tag));
        }
    }

    public boolean destroyWindow() {
        this.clearAllInfo();
        if (this.kDTree != null) {
            this.kDTree.setModel(null);
            this.kDTree = null;
        }
        return super.destroyWindow();
    }

    public BgItemCollection getSaveItemCol() {
        return this.saveItemCol;
    }

    @Override
    protected void kDCheckBox1_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckBox1_actionPerformed(e);
        if (this.kDCheckBox1.isSelected()) {
            MsgBox.showWarning((String)EASResource.getString((String)STRRESOURCE, (String)"importGroupWarning"));
            this.toImportGroup = true;
        } else {
            this.toImportGroup = false;
        }
    }

    private BgItemCollection importGroup(DefaultMutableTreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        BgItemGroupInfo groupInfo = null;
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
        }
        if (groupInfo == null) {
            return null;
        }
        BgItemGroupInfo tempGroupInfo = groupInfo;
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        try {
            if (!BgSHelper.isBgItemIsolate()) {
                fullOrgUnit.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            } else {
                fullOrgUnit.setId(orgUnit.getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        BgItemCollection bgItemCollection = new BgItemCollection();
        BgItemInfo bgItemInfo = new BgItemInfo();
        bgItemInfo.setLongNumber(tempGroupInfo.getLongNumber());
        bgItemInfo.setNumber(tempGroupInfo.getLongNumber().replaceAll("!", "."));
        bgItemInfo.setIsEffective(true);
        bgItemInfo.setBgItemGroup(this.bgGroupInfo);
        bgItemInfo.setRefField(this.bgGroupInfo.getRefField());
        bgItemInfo.setOrgUnit(fullOrgUnit);
        if (this.locale.equals(this.sLocale)) {
            bgItemInfo.setName(tempGroupInfo.getName().toString(), this.sLocale);
            bgItemInfo.setName(STConverter.sc2tc((String)tempGroupInfo.getName(this.sLocale)), this.tLocale);
        } else if (this.locale.equals(this.tLocale)) {
            bgItemInfo.setName(tempGroupInfo.getName().toString(), this.tLocale);
            bgItemInfo.setName(STConverter.tc2sc((String)tempGroupInfo.getName(this.tLocale)), this.sLocale);
        } else {
            bgItemInfo.setName(tempGroupInfo.getName().toString());
        }
        if (tempGroupInfo.getDescription() != null) {
            if (this.locale.equals(this.sLocale)) {
                bgItemInfo.setDescription(tempGroupInfo.getDescription().toString(), this.sLocale);
                bgItemInfo.setDescription(STConverter.sc2tc((String)tempGroupInfo.getDescription(this.sLocale)), this.tLocale);
            } else if (this.locale.equals(this.tLocale)) {
                bgItemInfo.setDescription(tempGroupInfo.getDescription().toString(), this.tLocale);
                bgItemInfo.setDescription(STConverter.tc2sc((String)tempGroupInfo.getDescription(this.tLocale)), this.sLocale);
            } else {
                bgItemInfo.setDescription(tempGroupInfo.getDescription().toString());
            }
        }
        bgItemCollection.add(bgItemInfo);
        DefaultMutableTreeNode tempTreeNode = treeNode;
        BgItemGroupInfo tempParentGroupInfo = null;
        while (tempTreeNode.getParent() != null && tempTreeNode.getParent() != this.root) {
            if ((tempTreeNode = (DefaultMutableTreeNode)tempTreeNode.getParent()) != null && tempTreeNode.getUserObject() instanceof TreeBaseInfo) {
                tempParentGroupInfo = (BgItemGroupInfo)tempTreeNode.getUserObject();
            }
            if (tempParentGroupInfo == null) continue;
            bgItemInfo = new BgItemInfo();
            bgItemInfo.setLongNumber(tempParentGroupInfo.getLongNumber());
            bgItemInfo.setNumber(tempParentGroupInfo.getLongNumber().replaceAll("!", "."));
            bgItemInfo.setIsEffective(true);
            bgItemInfo.setBgItemGroup(this.bgGroupInfo);
            bgItemInfo.setRefField(this.bgGroupInfo.getRefField());
            bgItemInfo.setOrgUnit(fullOrgUnit);
            if (this.locale.equals(this.sLocale)) {
                bgItemInfo.setName(tempParentGroupInfo.getName().toString(), this.sLocale);
                bgItemInfo.setName(STConverter.sc2tc((String)tempParentGroupInfo.getName(this.sLocale)), this.tLocale);
            } else if (this.locale.equals(this.tLocale)) {
                bgItemInfo.setName(tempParentGroupInfo.getName().toString(), this.tLocale);
                bgItemInfo.setName(STConverter.tc2sc((String)tempParentGroupInfo.getName(this.tLocale)), this.sLocale);
            } else {
                bgItemInfo.setName(tempParentGroupInfo.getName().toString());
            }
            if (tempParentGroupInfo.getDescription() != null) {
                if (this.locale.equals(this.sLocale)) {
                    bgItemInfo.setDescription(tempParentGroupInfo.getDescription().toString(), this.sLocale);
                    bgItemInfo.setDescription(STConverter.sc2tc((String)tempParentGroupInfo.getDescription(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgItemInfo.setDescription(tempParentGroupInfo.getDescription().toString(), this.tLocale);
                    bgItemInfo.setDescription(STConverter.tc2sc((String)tempParentGroupInfo.getDescription(this.tLocale)), this.sLocale);
                } else {
                    bgItemInfo.setDescription(tempParentGroupInfo.getDescription().toString());
                }
            }
            bgItemCollection.add(bgItemInfo);
        }
        return bgItemCollection;
    }

    private class BgDimRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        private BgDimRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class NumberExpandInfo {
        private String number;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }
    }
}

