/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemViewFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgItemViewFilterUI;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BgItemViewFilterUI
extends AbstractBgItemViewFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemViewFilterUI.class);

    public BgItemViewFilterUI() throws Exception {
    }

    public BgItemViewFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void clear() {
        this.prmtItemFrom.setValue(null);
        this.prmtItemTo.setValue(null);
        this.checkIsMultiOrg.setSelected(false);
        super.clear();
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgItemViewFilterParam();
    }

    @Override
    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _fp = super.getFilterParam(mainParam, filterParam);
        BgItemViewFilterParam _mainParam = null;
        BgItemViewFilterParam _filterParam = null;
        if (_fp != null) {
            _mainParam = (BgItemViewFilterParam)_fp;
            _filterParam = (BgItemViewFilterParam)filterParam;
            if (_filterParam.getBgItemBegin() != null) {
                _mainParam.setBgItemBegin(_filterParam.getBgItemBegin());
            } else {
                _mainParam.setBgItemBegin(null);
            }
            if (_filterParam.getBgItemEnd() != null) {
                _mainParam.setBgItemEnd(_filterParam.getBgItemEnd());
            } else {
                _mainParam.setBgItemEnd(null);
            }
            if (_filterParam.isMultOrg()) {
                _mainParam.setMultOrg(true);
            } else {
                _mainParam.setMultOrg(false);
            }
        }
        return _mainParam;
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgItemViewFilterParam) {
            BgItemViewFilterParam _filterParam = (BgItemViewFilterParam)filterParam;
            if (_filterParam.getBgItemBegin() != null) {
                this.prmtItemFrom.setData((Object)_filterParam.getBgItemBegin());
            }
            if (_filterParam.getBgItemEnd() != null) {
                this.prmtItemTo.setData((Object)_filterParam.getBgItemEnd());
            }
            if (_filterParam.isMultOrg()) {
                this.checkIsMultiOrg.setSelected(true);
            } else {
                this.checkIsMultiOrg.setSelected(false);
            }
        }
    }

    @Override
    protected void comBgScheme_actionPerformed(ActionEvent e) throws Exception {
        super.comBgScheme_actionPerformed(e);
        this.bgScheme_actionPerformed(e);
    }

    @Override
    protected void bgScheme_actionPerformed(ActionEvent e) throws Exception {
        super.bgScheme_actionPerformed(e);
        this.setBgTemplateSelect();
    }

    protected void setBgTemplateSelect() throws EASBizException, BOSException {
        if (this.comBgScheme.getSelectedItem() == null) {
            return;
        }
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.comBgScheme.getSelectedItem();
        this.comBgTemplate.removeAllItems();
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null) {
            this.prmtBgPeriodBegin.setData(null);
            this.prmtBgPeriodEnd.setValue(null);
            IBgFacade ibgFacade = BgFacadeFactory.getRemoteInstance();
            BgTemplateCollection bgTemplateCol = null;
            if (this.prmtOrgUnit.getData() != null && this.prmtOrgUnit.getData() instanceof Object[] && ((Object[])this.prmtOrgUnit.getData()).length > 1) {
                HashMap subOrgUnitMap = new HashMap();
                bgTemplateCol = ibgFacade.getCommonBgTemplateInfo(bgSchemeInfo.getRootId(), subOrgUnitMap);
                if (bgTemplateCol != null) {
                    this.comBgTemplate.addItems(bgTemplateCol.toArray());
                }
            } else {
                bgTemplateCol = ibgFacade.getCommonBgTemplateInfo(bgSchemeInfo.getId(), null);
                if (bgTemplateCol != null) {
                    this.comBgTemplate.addItems(bgTemplateCol.toArray());
                }
            }
        }
    }

    @Override
    protected void initFilter() throws Exception {
        super.initFilter();
        this.initSelectBgItem();
    }

    protected void initSelectBgItem() throws Exception {
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        this.prmtItemFrom.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtItemTo.setSelector((KDPromptSelector)bgItemSelect);
    }

    @Override
    protected boolean isMultiSelect() {
        return super.isMultiSelect();
    }

    @Override
    protected boolean isReturnSuperior() {
        return super.isReturnSuperior();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBgPeriodBegin.setRequired(true);
        this.prmtBgPeriodEnd.setRequired(true);
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgItemViewFilterParam) {
            BgItemViewFilterParam _filterParam = (BgItemViewFilterParam)filterParam;
            if (this.prmtItemFrom.getData() == null) {
                _filterParam.setBgItemBegin(null);
            }
            if (this.prmtItemTo.getData() == null) {
                _filterParam.setBgItemEnd(null);
            }
            if (this.checkIsMultiOrg.isSelected()) {
                _filterParam.setMultOrg(true);
            } else {
                _filterParam.setMultOrg(false);
            }
            Object orgObj = this.prmtOrgUnit.getData();
            if (orgObj != null) {
                if (orgObj instanceof OrgUnitInfo[]) {
                    OrgUnitInfo[] array = (OrgUnitInfo[])orgObj;
                    int length = array.length;
                    CostCenterOrgUnitInfo[] costAry = null;
                    if (length > 0) {
                        costAry = new CostCenterOrgUnitInfo[length];
                        System.arraycopy(array, 0, costAry, 0, length);
                    }
                } else if (orgObj instanceof CostCenterOrgUnitInfo) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public boolean verify() {
        boolean success = super.verify();
        if (!success) {
            return success;
        }
        if (this.prmtBgPeriodBegin.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"290_BgItemViewFilterUI"));
            this.prmtBgPeriodBegin.requestFocus();
            success = false;
            return success;
        }
        if (this.prmtBgPeriodEnd.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"290_BgItemViewFilterUI"));
            this.prmtBgPeriodBegin.requestFocus();
            success = false;
            return success;
        }
        return success;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.orgUnit_dataChanged(e);
    }
}

