/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.budget.BgEntity;
import com.kingdee.eas.ma.budget.BgMetaDataFactory;
import com.kingdee.eas.ma.budget.BgProperty;
import com.kingdee.eas.ma.budget.IBgMetaData;
import com.kingdee.eas.ma.budget.client.BgMetaDataVirtualTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgMetaDataTreeUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgMetaDataTreeUtil");
    private static final int defaultExpandLevel = 1;
    private static final int maxExpandLevel = 10;
    private static Icon icon = EASResource.getIcon((String)"imgTbtn_distributelog");
    public static final String JAVA_LANG = "java.lang.";
    private static HashMap map = new HashMap();

    private static DefaultKingdeeTreeNode buildTree(EntityObjectInfo entity, String targetClazz, int defaultLevel, int maxLevel) {
        BgEntity bgEntity = BgMetaDataFactory.createBgEntity(entity);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)bgEntity);
        BgMetaDataTreeUtil.initChildren(root, bgEntity, targetClazz, 0, defaultLevel);
        return root;
    }

    private static String getTargetClazz(IBgMetaData targetProperty) {
        if (targetProperty.getEntity() == null) {
            return targetProperty.getEntity().getBusinessAgent() + "Info";
        }
        return ((OwnPropertyInfo)targetProperty.getProperty()).getDataType().getJavaTypeName();
    }

    public static void initChildren(DefaultKingdeeTreeNode root, IBgMetaData bgEntity, String targetClazz, int level, int expandLevel) {
        if (bgEntity.getEntity() != null) {
            if (level < expandLevel) {
                List children = bgEntity.getChildren();
                if (children != null) {
                    int count = children.size();
                    for (int i = 0; i < count; ++i) {
                        IBgMetaData child = (IBgMetaData)children.get(i);
                        if (child.getEntity() == null && (child.getEntity() != null || !BgMetaDataTreeUtil.canSafeConverse(child, targetClazz))) continue;
                        DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)child);
                        if (child.getEntity() != null && targetClazz != null && BgMetaDataTreeUtil.canSafeConverse(child, targetClazz)) {
                            childNode.setCustomIcon(icon);
                        }
                        root.add((MutableTreeNode)childNode);
                        BgMetaDataTreeUtil.initChildren(childNode, child, targetClazz, level + 1, expandLevel);
                    }
                }
            } else if (level == expandLevel && bgEntity.getEntity() != null) {
                BgMetaDataVirtualTreeNode childNode = new BgMetaDataVirtualTreeNode();
                root.add((MutableTreeNode)((Object)childNode));
            }
        }
    }

    public static boolean canSafeConverse(IBgMetaData child, String targetClazz) {
        boolean result = false;
        if (targetClazz == null) {
            result = true;
        } else if (child.getEntity() != null) {
            for (EntityObjectInfo entity = child.getEntity(); entity != null; entity = entity.getBaseEntity()) {
                String entityInfo = entity.getBusinessImplName() + "Info";
                if (!entityInfo.equals(targetClazz)) continue;
                result = true;
                break;
            }
        } else {
            DataType nodeType = ((OwnPropertyInfo)child.getProperty()).getDataType();
            if (BgMetaDataTreeUtil.isEquals(nodeType.getJavaTypeName(), targetClazz)) {
                result = true;
            } else {
                try {
                    Class<?> nodeClassType = Class.forName(nodeType.getJavaTypeName());
                    for (nodeClassType = nodeClassType.getSuperclass(); nodeClassType != null; nodeClassType = nodeClassType.getSuperclass()) {
                        if (!BgMetaDataTreeUtil.isEquals(nodeClassType.getName(), targetClazz)) continue;
                        result = true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private static boolean isEquals(String sourceClass, String targetClass) {
        if (StringUtils.isEmpty((String)sourceClass) || StringUtils.isEmpty((String)targetClass)) {
            return false;
        }
        if (sourceClass.startsWith(JAVA_LANG)) {
            sourceClass = sourceClass.substring(JAVA_LANG.length());
        }
        if (targetClass.startsWith(JAVA_LANG)) {
            targetClass = targetClass.substring(JAVA_LANG.length());
        }
        return sourceClass.equals(targetClass);
    }

    public static void buildTree(KDTree tree, EntityObjectInfo entity) {
        BgMetaDataTreeUtil.buildTree(tree, entity, (String)null);
    }

    public static void buildTree(KDTree tree, EntityObjectInfo entity, IBgMetaData targetProperty) {
        BgMetaDataTreeUtil.buildTree(tree, entity, targetProperty, 1);
    }

    public static void buildTree(KDTree tree, EntityObjectInfo entity, String targetClazz) {
        BgMetaDataTreeUtil.buildTree(tree, entity, targetClazz, 1);
    }

    public static void buildTree(KDTree tree, EntityObjectInfo entity, String targetClazz, int defaultLevel) {
        BgMetaDataTreeUtil.buildTree(tree, entity, targetClazz, 1, 10);
    }

    public static void buildTree(KDTree tree, EntityObjectInfo entity, IBgMetaData targetProperty, int defaultLevel) {
        BgMetaDataTreeUtil.buildTree(tree, entity, targetProperty, defaultLevel, 10);
    }

    public static void buildTree(KDTree tree, EntityObjectInfo entity, IBgMetaData targetProperty, int defaultLevel, int maxLevel) {
        BgMetaDataTreeUtil.buildTree(tree, entity, BgMetaDataTreeUtil.getTargetClazz(targetProperty), defaultLevel, maxLevel);
    }

    private static void buildTree(KDTree tree, EntityObjectInfo entity, final String targetClazz, int defaultLevel, final int maxLevel) {
        try {
            map = BgControlFacadeFactory.getRemoteInstance().getGeneralAssActType();
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        DefaultKingdeeTreeNode root = BgMetaDataTreeUtil.buildTree(entity, targetClazz, defaultLevel, maxLevel);
        ((KingdeeTreeModel)tree.getModel()).setRoot((TreeNode)root);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                TreePath path = event.getPath();
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (path.getPathCount() >= maxLevel) {
                    tree.collapsePath(path);
                    String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"230_BgEntityTreePromptDialog"), new Integer(maxLevel));
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if (selectedNode.getChildCount() == 1 && selectedNode.getChildAt(0) instanceof BgMetaDataVirtualTreeNode) {
                    tree.removeAllChildrenFromParent((MutableTreeNode)selectedNode);
                    IBgMetaData bgMeta = (IBgMetaData)selectedNode.getUserObject();
                    BgMetaDataTreeUtil.initChildren(selectedNode, bgMeta, targetClazz, 0, 1);
                }
                if (selectedNode.getUserObject() != null && selectedNode.getUserObject() instanceof BgProperty && ((BgProperty)selectedNode.getUserObject()).getProperty() instanceof LinkPropertyInfo && ((LinkPropertyInfo)((BgProperty)selectedNode.getUserObject()).getProperty()).getRelationship().getName().equalsIgnoreCase("R_VoucherAssistRecord_AssGrp")) {
                    boolean isRepaint = false;
                    block0: for (int i = 0; i < selectedNode.getChildCount(); ++i) {
                        DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)selectedNode.getChildAt(i);
                        if (subNode.getUserObject() == null || !(subNode.getUserObject() instanceof BgProperty) || !(((BgProperty)subNode.getUserObject()).getProperty() instanceof LinkPropertyInfo) || !((LinkPropertyInfo)((BgProperty)subNode.getUserObject()).getProperty()).getRelationship().getName().startsWith("R_AssistantHG_GeneralAsstActType")) continue;
                        String name = ((LinkPropertyInfo)((BgProperty)subNode.getUserObject()).getProperty()).getRelationship().getName();
                        String[] names = name.split("_");
                        names[2] = names[2].substring(0, 10) + names[2].substring(11);
                        for (String key : map.keySet()) {
                            if (!key.equalsIgnoreCase(names[2])) continue;
                            subNode.setText((String)map.get(key));
                            ((BgProperty)subNode.getUserObject()).getProperty().getStateManager().setLocaleValue("alias", (Object)((String)map.get(key)), SysContext.getSysContext().getLocale().toString());
                            if (isRepaint) continue block0;
                            isRepaint = true;
                            continue block0;
                        }
                    }
                    if (isRepaint) {
                        tree.repaint();
                    }
                }
            }
        });
    }
}

