/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgBudgetFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgNTraceFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgTraceSelectBgFormUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.IBgFormSelectItem;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgNTraceFilterUI
extends AbstractBgNTraceFilterUI
implements IBgFormSelectItem {
    private static final long serialVersionUID = -8779052949978889279L;
    private static final Logger logger = CoreUIObject.getLogger(BgNTraceFilterUI.class);
    private static final String FILTER_UI_KEY = BgNTraceFilterUI.class.getName();
    private static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private BgTraceFilterParam filterParam;
    private boolean hasUseFund = false;
    private OrgUnitInfo curOrgUnitinfo;
    private String selectOrgId = null;
    protected boolean isUserUpdate = true;
    protected Set longNumberSet = new HashSet(32);
    protected boolean isMultiOrg = false;
    protected Map companyMap = new HashMap(32);
    protected BgSchemeCollection bgSchemeCol = null;
    private String[] companyIds = null;
    private String[] companyNames = null;
    private Vector orgUnitVec;
    protected boolean isProcessed = true;
    private String[] itemStrs = null;
    private String bgFormId = null;
    private Map bgFormMap = null;
    private static final String ORGUNIT_IDS = "ORGUNIT_IDS";
    private static final String BGSCHEME_ID = "BGSCHEME_ID";
    private static final String BGPERIOD_ID_BEGIN = "BGPERIOD_ID_BEGIN";
    private static final String BGPERIOD_ID_END = "BGPERIOD_ID_END";
    private static final String BGITEM_NUMBER = "BGITEM_NUMBER";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String BGELEMENT_ID = "BGELEMENT_ID";
    private static final String SHOWITEMNUMBER = "SHOWITEMNUMBER";
    private static final String BGFORM_ID = "BGFORM_ID";
    private static final String BGFORM_ID_MAP = "BGFORM_ID_MAP";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (BgParamCHelper.isFodian()) {
            this.initCurrency();
            this.hasUseFund = true;
        } else {
            this.hasUseFund = false;
        }
        this.init();
        this.initOrgUnit();
        this.initBgPeriod();
        this.initComboBox();
        BgElementDialog bgElement = new BgElementDialog((IUIObject)this);
        this.prmtElement.setSelector((KDPromptSelector)bgElement);
        this.prmtElement.setDisplayFormat("$name$");
        this.prmtBeginPeriod.setEditable(false);
        this.prmtEndPeriod.setEditable(false);
        this.kDLabel1.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnSelectBgForm.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnSelectBgForm.setEnabled(true);
        this.btnSelectBgForm.setVisible(true);
        this.tblMain.checkParsed();
        if (this.tblMain.getHead().getRow(0).getCell(1) != null) {
            this.tblMain.getHead().getRow(0).getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"bgitem-name"));
        }
    }

    private void initOrgUnit() throws Exception {
        BgOrgViewF7 orgF7 = new BgOrgViewF7((IUIObject)this);
        orgF7.setCuID(this.getCurrOrgUnit().getId().toString());
        orgF7.setMultiSelect(true);
        orgF7.setIsShowSub(true);
        orgF7.setTitle(EASResource.getString((String)resourcePath, (String)"SelectOrgUnit"));
        String uiClassName = null;
        uiClassName = "com.kingdee.eas.ma.budget.client.BgFormAnalyseMainUI";
        if (uiClassName != null) {
            orgF7.setUIActionPK((IMetaDataPK)new MetaDataPK(uiClassName), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
        Object obj = this.prmtOrgUnit.getValue();
        if (obj == null || ((Object[])obj)[0] == null) {
            this.curOrgUnitinfo.put("treeType", (Object)new Integer(5));
            if (this.curOrgUnitinfo != null) {
                OrgUnitInfo[] org = new OrgUnitInfo[]{this.curOrgUnitinfo};
                this.prmtOrgUnit.setValue((Object)org);
                this.selectOrgId = this.curOrgUnitinfo.getId().toString();
            }
        }
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setDisplayFormat("$name$");
    }

    public void setItemString(Vector items, Map itemNames, String orgUnitId) {
        try {
            HashMap checkMap = new HashMap();
            if (items == null || items.isEmpty()) {
                return;
            }
            this.tblMain.removeRows();
            IRow iRow = null;
            String formula = null;
            if (StringUtils.isEmpty((String)orgUnitId)) {
                orgUnitId = this.selectOrgId;
            }
            IBgBudgetFacade iBgBudget = BgBudgetFacadeFactory.getRemoteInstance();
            itemNames = iBgBudget.getSelectBgItemName(itemNames, orgUnitId);
            int size = items.size();
            this.itemStrs = new String[size];
            String itemNumbers = null;
            for (int i = 0; i < size; ++i) {
                itemNumbers = (String)items.get(i);
                if (checkMap.containsKey(itemNumbers)) continue;
                iRow = this.tblMain.addRow();
                iRow.getCell("colNumber").setValue((Object)itemNumbers);
                checkMap.put(itemNumbers, null);
                formula = this.combItem(itemNames, itemNumbers);
                iRow.getCell("colName").setValue((Object)formula);
                this.itemStrs[i] = itemNumbers + "!" + formula;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private String combItem(Map bgItems, String formula) {
        String[] items = formula.split(",");
        StringBuffer item = new StringBuffer("");
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                item.append("_");
            }
            item.append((String)bgItems.get(items[i]));
        }
        return item.toString();
    }

    private void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = null;
        bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtEndPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
    }

    @Override
    public void actionSelectBgForm_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectOrgId == null || this.bgScheme.getSelectedItem() == null || ((BgSchemeInfo)this.bgScheme.getSelectedItem()).getId() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"orgId", (Object)this.selectOrgId);
        uiContext.put((Object)"schemeId", (Object)((BgSchemeInfo)this.bgScheme.getSelectedItem()).getId().toString());
        uiContext.put((Object)"selectOwner", (Object)((BgNTraceFilterUI)((Object)uiContext.get((Object)"Owner"))));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTraceSelectBgFormUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void initComboBox() throws Exception {
        this.bgScheme.setLimitedSize(true);
    }

    private void initCurrency() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"BB01"));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        CurrencyCollection cols = CurrencyFactory.getRemoteInstance().getCurrencyCollection(viewInfo);
        if (cols.size() > 0) {
            this.prmtCurrency.setValue((Object)cols.get(0));
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object[] objs;
        if (!this.isUserUpdate) {
            return;
        }
        Object obj = null;
        obj = this.prmtOrgUnit.getValue();
        this.longNumberSet.clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[] && (objs = (Object[])obj)[0] == null) {
            return;
        }
        this.isMultiOrg = false;
        OrgUnitInfo orgInfo = null;
        CostCenterOrgUnitInfo orgUnitInfo = null;
        String[] orgUnitIds = null;
        String[] orgUnitNames = null;
        Vector<Object> companyVec = new Vector<Object>();
        if (obj instanceof CostCenterOrgUnitInfo) {
            orgInfo = (OrgUnitInfo)obj;
            this.isMultiOrg = false;
            this.setCompanyIds(new String[]{orgInfo.getId().toString()});
            this.setCompanyNames(new String[]{orgInfo.getName()});
            companyVec.add(orgInfo);
            this.selectOrgId = orgInfo.getId().toString();
        } else {
            Object[] oarr = null;
            Object[] v = oarr = (Object[])obj;
            while (v != null && !(v[0] instanceof CostCenterOrgUnitInfo)) {
                v = (Object[])v[0];
            }
            oarr = v;
            this.isMultiOrg = (oarr = this.dealSelectorOrgUnitInfo(oarr)).length > 1;
            orgUnitIds = new String[oarr.length];
            orgUnitNames = new String[oarr.length];
            for (int i = 0; i < oarr.length; ++i) {
                orgUnitInfo = (CostCenterOrgUnitInfo)oarr[i];
                this.companyMap.put(orgUnitInfo.getId().toString(), orgUnitInfo);
                this.longNumberSet.add(orgUnitInfo.getLongNumber());
                orgUnitIds[i] = orgUnitInfo.getId().toString();
                orgUnitNames[i] = orgUnitInfo.getName();
                companyVec.add(orgUnitInfo);
            }
            this.setCompanyIds(orgUnitIds);
            this.setCompanyNames(orgUnitNames);
            this.setOrgUnitVec(companyVec);
            this.selectOrgId = orgUnitIds[0];
        }
        OrgUnitInfo companyInfo = this.getCurrOrgUnit();
        this.bgScheme.removeAllItems();
        if (companyInfo != null && companyInfo.getId() != null) {
            if (this.isMultiOrg) {
                BOSUuid currOrgId = companyInfo.getId();
                String[] companyIds = this.getCompanyIds();
                if (companyIds != null && companyIds.length > 0) {
                    currOrgId = BOSUuid.read((String)companyIds[0]);
                    HashSet<BOSUuid> subOrgUnitMap = new HashSet<BOSUuid>();
                    for (int i = 1; i < companyIds.length; ++i) {
                        subOrgUnitMap.add(BOSUuid.read((String)companyIds[i]));
                    }
                    this.bgSchemeCol = this.getInterface().getCommonBgScheme(currOrgId, subOrgUnitMap, false, false, true);
                    if (!this.bgSchemeCol.isEmpty()) {
                        BgSchemeInfo bgSchemeInfo = null;
                        this.isProcessed = false;
                        Iterator iter = this.bgSchemeCol.iterator();
                        while (iter.hasNext()) {
                            bgSchemeInfo = (BgSchemeInfo)iter.next();
                            this.bgScheme.addItem((Object)bgSchemeInfo);
                        }
                        this.isProcessed = true;
                        this.bgScheme.setSelectedIndex(0);
                        this.bgScheme.setEnabled(true);
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
                    }
                }
            } else {
                BgClientHelper.initComboBgSchemeForAnalyse((Component)((Object)this), this.bgScheme, this.getCompanyIds()[0], false);
            }
        } else {
            this.bgScheme.removeAllItems();
        }
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        if (this.prmtOrgUnit.getData() != null) {
            BgOrgViewF7 orgView = (BgOrgViewF7)this.prmtOrgUnit.getSelector();
            OrgUnitInfo unitInfo2 = null;
            OrgUnitInfo[] unitInfos = null;
            Object obj = this.prmtOrgUnit.getData();
            if (obj instanceof OrgUnitInfo) {
                unitInfo2 = (OrgUnitInfo)obj;
                HashSet<String> checked = new HashSet<String>();
                checked.add(unitInfo2.getId().toString());
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else if (obj instanceof OrgUnitInfo[]) {
                unitInfos = (OrgUnitInfo[])obj;
                HashSet<String> checked = new HashSet<String>();
                for (OrgUnitInfo unitInfo2 : unitInfos) {
                    checked.add(unitInfo2.getId().toString());
                }
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else {
                orgView.setCheckedOrgIDs(null);
            }
        }
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.curOrgUnitinfo;
    }

    public void init() throws Exception {
        this.curOrgUnitinfo = SysContext.getSysContext().getCurrentCostUnit();
        this.curOrgUnitinfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.curOrgUnitinfo.getId()));
    }

    protected BgRptFilterParam getFilterParam() {
        return this.filterParam;
    }

    protected void setBgTraceFilterParam(BgTraceFilterParam filterParam) {
        this.filterParam = filterParam;
    }

    public boolean verify() {
        if (this.prmtOrgUnit.getValue() == null) {
            this.prmtOrgUnit.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectUnit"));
            return false;
        }
        if (this.bgScheme.getSelectedItem() == null) {
            this.bgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            return false;
        }
        if ("".equals(this.prmtCurrency.getText())) {
            this.prmtCurrency.setValue(null);
        }
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"291_BgNTraceFilterUI"));
            return false;
        }
        BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, this.prmtBeginPeriod, this.prmtEndPeriod);
        return true;
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam instanceof BgTraceFilterParam) {
            BgTraceFilterParam _tf = (BgTraceFilterParam)filterParam;
            this.chkIsShowItemName.setSelected(_tf.getIsShowItemNumber() == null ? false : _tf.getIsShowItemNumber());
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        Object shemeObj;
        Object orgObj;
        CustomerParams cp = super.getCustomerParams();
        this.filterParam = new BgTraceFilterParam();
        if (this.getBgFormId() != null) {
            this.filterParam.setBgFormId(this.getBgFormId());
        }
        if (this.getBgFormMap() != null) {
            this.filterParam.setBgFormMap(this.getBgFormMap());
        }
        if ((orgObj = this.prmtOrgUnit.getData()) != null) {
            if (orgObj instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] array = (OrgUnitInfo[])orgObj;
                int length = array.length;
                CostCenterOrgUnitInfo[] costAry = null;
                if (length > 0) {
                    costAry = new CostCenterOrgUnitInfo[length];
                    System.arraycopy(array, 0, costAry, 0, length);
                }
                this.filterParam.setOrgUnitInfoAry((OrgUnitInfo[])costAry);
            } else if (orgObj instanceof CostCenterOrgUnitInfo) {
                this.filterParam.setOrgUnitInfoAry(new OrgUnitInfo[]{(OrgUnitInfo)orgObj});
            }
        }
        if ((shemeObj = this.bgScheme.getSelectedItem()) != null) {
            BgSchemeInfo info = (BgSchemeInfo)shemeObj;
            this.filterParam.setBgSchemeId(info.getId().toString());
        }
        BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
        if (this.prmtBeginPeriod.getValue() != null) {
            this.filterParam.setBeginPeriod(beginPeriod);
        }
        BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
        if (this.prmtEndPeriod.getValue() != null) {
            this.filterParam.setEndPeriod(endPeriod);
        }
        if (this.itemStrs != null) {
            this.filterParam.setItems(this.itemStrs);
        } else {
            this.filterParam.setItems(null);
        }
        BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
        this.filterParam.setObjElement(beinfo);
        if (beinfo != null) {
            String stritem = beinfo.getId().toString();
            this.filterParam.setElement(stritem);
        } else {
            this.filterParam.setElement(null);
        }
        this.filterParam.setItemFrom(null);
        this.filterParam.setItemTo(null);
        if (this.prmtCurrency.getValue() != null) {
            this.filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            this.filterParam.setCurrency(null);
        }
        this.filterParam.setBgRptType(BgAnalysisTypeEnum.BGTRACE);
        this.filterParam.setIsShowItemNumber(this.chkIsShowItemName.isSelected());
        this.saveCustomerParams(cp, this.filterParam);
        return cp;
    }

    public Object getFilterObject1(CustomerParams cp, String key) throws Exception {
        if (cp == null) {
            return null;
        }
        if (this.hasNewScheme() && cp.getBoolean("NEW_SCHEME_KEY")) {
            FilterParam filterParam = this.createNewFilterParam();
            this.loadCustomerParams(cp, filterParam);
            filterParam = this.loadFilterParam(filterParam);
            return filterParam;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FILTERPARAM") : cp.getCustomerParam(key);
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        if (objByte == null || objByte.length == 0) {
            return null;
        }
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (IOException e) {
            throw new IOException();
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    throw new IOException();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new IOException();
                }
            }
        }
        return param;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        BgTraceFilterParam filterParam = new BgTraceFilterParam();
        this.loadCustomerParams(cp, filterParam);
        try {
            filterParam = (BgTraceFilterParam)this.getCPInterface().loadCustomerParams((FilterParam)filterParam);
        }
        catch (Exception ex) {
            filterParam = null;
            logger.error((Object)ex);
        }
        if (filterParam == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"UpdateSelectScheme"));
            return;
        }
        OrgUnitInfo[] ccouiAry = filterParam.getOrgUnitInfoAry();
        if (ccouiAry != null) {
            this.prmtOrgUnit.setData((Object)ccouiAry);
        }
        try {
            this.prmtOrgUnit_dataChanged(null);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String schemeId = filterParam.getBgSchemeId();
        int num = this.bgScheme.getItemCount();
        for (int i = 0; i < num; ++i) {
            String tempId = ((BgSchemeInfo)this.bgScheme.getItemAt(i)).getId().toString();
            if (!tempId.equals(schemeId)) continue;
            this.bgScheme.setSelectedIndex(i);
        }
        try {
            this.bgScheme_itemStateChanged(null);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (filterParam.getBgFormId() != null) {
            this.setBgFormId(filterParam.getBgFormId());
        }
        if (filterParam.getBgFormMap() != null) {
            this.setBgFormMap(filterParam.getBgFormMap());
        }
        if (filterParam.getItems() != null) {
            this.tblMain.removeRows();
            String[] items = filterParam.getItems();
            this.itemStrs = items;
            String[] tempStr = null;
            IRow row = null;
            int length = items.length;
            for (int i = 0; i < length; ++i) {
                tempStr = items[i].split("\\!");
                if (tempStr == null || tempStr.length != 2) continue;
                row = this.tblMain.addRow();
                row.getCell("colNumber").setValue((Object)tempStr[0]);
                row.getCell("colName").setValue((Object)tempStr[1]);
            }
        }
        this.prmtBeginPeriod.setData((Object)filterParam.getBeginPeriod());
        this.prmtEndPeriod.setData((Object)filterParam.getEndPeriod());
        this.prmtElement.setData((Object)filterParam.getObjElement());
        this.prmtCurrency.setData((Object)filterParam.getCurrency());
        this.chkIsShowItemName.setSelected(filterParam.getIsShowItemNumber().booleanValue());
    }

    @Override
    protected void prmtEndPeriod_stateChanged(ChangeEvent e) throws Exception {
        BgPeriodInfo endPeriod;
        int periodType;
        Object obj = this.prmtEndPeriod.getValue();
        if (obj != null && (periodType = (endPeriod = (BgPeriodInfo)obj).getPeriodType().getValue()) == 8) {
            this.prmtBeginPeriod.setValue((Object)endPeriod);
        }
    }

    @Override
    protected void prmtBeginPeriod_stateChanged(ChangeEvent e) throws Exception {
        Object obj = this.prmtBeginPeriod.getValue();
        if (obj != null) {
            BgPeriodInfo beginPeriod = (BgPeriodInfo)obj;
            int periodType = beginPeriod.getPeriodType().getValue();
            if (periodType == 8) {
                this.prmtEndPeriod.setValue((Object)beginPeriod);
                this.prmtEndPeriod.setEnabled(false);
            } else {
                this.prmtEndPeriod.setEnabled(true);
            }
        }
    }

    @Override
    public void clear() {
        this.prmtOrgUnit.setData((Object)this.curOrgUnitinfo);
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtElement.setData(null);
        this.prmtCurrency.setData(null);
        this.chkIsShowItemName.setSelected(false);
        this.tblMain.removeRows();
        this.setBgFormMap(null);
        this.setBgFormId(null);
    }

    @Override
    protected void bgScheme_itemStateChanged(ItemEvent e) throws Exception {
        if (this.prmtOrgUnit.getData() != null && this.bgScheme.getSelectedItem() != null) {
            this.tblMain.removeRows();
            this.setBgFormMap(null);
            this.setBgFormId(null);
            HashSet<Object> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo cOrgUnit = null;
            OrgUnitInfo currOrgUnitInfo = null;
            Object obj = this.prmtOrgUnit.getData();
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.bgScheme.getSelectedItem();
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<Object>();
            if (orgUnits != null && orgUnits.length > 1) {
                currOrgUnitInfo = this.getCurrOrgUnit();
                if (!currOrgUnitInfo.getId().equals((Object)orgUnits[0].getId())) {
                    currOrgUnitInfo = orgUnits[0];
                }
                int n = orgUnits.length;
                for (int i = 0; i < n; ++i) {
                    cOrgUnit = orgUnits[i];
                    subOrgUnits.add(cOrgUnit.getId());
                }
            }
            if (orgUnits != null && orgUnits.length == 1) {
                subOrgUnits.add(orgUnits[0].getId().toString());
            }
            BgFormCollection bgFormCol = null;
            try {
                bgFormCol = this.getInterface().getCommonBgForm(bgSchemeInfo.getId(), subOrgUnits, this.isHasUseFund(), false, true);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    public boolean isHasUseFund() {
        return this.hasUseFund;
    }

    @Override
    public String getUITitle() {
        return EASResource.getString((String)resourcePath, (String)"ntraceFilterUITitle");
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgTraceFilterParam();
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public String[] getCompanyNames() {
        return this.companyNames;
    }

    public void setCompanyNames(String[] companyNames) {
        this.companyNames = companyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] dealSelectorOrgUnitInfo(Object[] orgUnitInfo) {
        int i;
        if (orgUnitInfo == null || orgUnitInfo.length <= 1) {
            return orgUnitInfo;
        }
        String longnumber = null;
        String tmpLongnumber = null;
        String baseLongnumer = null;
        String[] numbers = null;
        String[] baseNumbers = null;
        CostCenterOrgUnitInfo[] fullOrgUnitInfos = null;
        CostCenterOrgUnitInfo fullOrgUnitInfo = null;
        CostCenterOrgUnitInfo _tmpInfo = null;
        CostCenterOrgUnitCollection fullOrgUnitColl = null;
        HashMap<String, CostCenterOrgUnitInfo> orgUnitMap = new HashMap<String, CostCenterOrgUnitInfo>();
        HashMap<String, String[]> numberMap = new HashMap<String, String[]>();
        HashSet<String> orgUnitSet = new HashSet<String>();
        int n = orgUnitInfo.length;
        for (i = 0; i < n; ++i) {
            fullOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnitInfo[i];
            longnumber = fullOrgUnitInfo.getLongNumber();
            numbers = longnumber.split("!");
            baseLongnumer = baseLongnumer == null ? longnumber : baseLongnumer;
            orgUnitMap.put(longnumber, fullOrgUnitInfo);
            numberMap.put(longnumber, numbers);
        }
        baseLongnumer = this.getCommonLongNumber(baseLongnumer, numberMap);
        baseNumbers = baseLongnumer.split("!");
        orgUnitSet.add(baseLongnumer);
        n = orgUnitInfo.length;
        for (i = 0; i < n; ++i) {
            fullOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnitInfo[i];
            longnumber = fullOrgUnitInfo.getLongNumber();
            numbers = longnumber.split("!");
            if (!longnumber.startsWith(baseLongnumer)) continue;
            if (longnumber.equals(baseLongnumer)) {
                orgUnitSet.add(longnumber);
                continue;
            }
            tmpLongnumber = baseLongnumer;
            int jn = numbers.length;
            for (int j = baseNumbers.length; j < jn; ++j) {
                tmpLongnumber = tmpLongnumber + "!" + numbers[j];
                orgUnitSet.add(tmpLongnumber);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", orgUnitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("longnumber");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        try {
            ICostCenterOrgUnit ifullOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
            fullOrgUnitColl = ifullOrgUnit.getCostCenterOrgUnitCollection(view);
            if (fullOrgUnitColl != null && !fullOrgUnitColl.isEmpty()) {
                fullOrgUnitInfos = new CostCenterOrgUnitInfo[fullOrgUnitColl.size()];
                int n2 = fullOrgUnitColl.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    fullOrgUnitInfo = fullOrgUnitColl.get(i2);
                    if (fullOrgUnitInfo.getLongNumber().equals(baseLongnumer)) {
                        _tmpInfo = new CostCenterOrgUnitInfo();
                        _tmpInfo.setId(fullOrgUnitInfo.getId());
                        _tmpInfo.setNumber(fullOrgUnitInfo.getNumber());
                        _tmpInfo.setName(fullOrgUnitInfo.getName());
                        _tmpInfo.setLongNumber(fullOrgUnitInfo.getLongNumber());
                    }
                    fullOrgUnitInfos[i2] = fullOrgUnitInfo;
                }
            }
        }
        catch (BOSException bOSException) {
        }
        if (fullOrgUnitInfos != null && fullOrgUnitInfos.length > 0) {
            this.isUserUpdate = false;
            this.prmtOrgUnit.setData((Object)fullOrgUnitInfos);
            this.isUserUpdate = true;
        }
        return fullOrgUnitInfos;
    }

    protected String getCommonLongNumber(String longnumber, Map numberMap) {
        if (longnumber == null || numberMap == null || numberMap.isEmpty()) {
            return "";
        }
        String tmpLongnumber2 = null;
        String[] numbers = null;
        StringBuffer str = new StringBuffer();
        for (String tmpLongnumber2 : numberMap.keySet()) {
            if (tmpLongnumber2.startsWith(longnumber)) continue;
            numbers = longnumber.split("!");
            int n = numbers.length - 1;
            for (int i = 0; i < n; ++i) {
                str.append(numbers[i] + "!");
            }
            longnumber = str.delete(str.length() - 1, str.length()).toString();
            longnumber = this.getCommonLongNumber(longnumber, numberMap);
        }
        return longnumber;
    }

    public Vector getOrgUnitVec() {
        return this.orgUnitVec;
    }

    public void setOrgUnitVec(Vector orgUnitVec) {
        this.orgUnitVec = orgUnitVec;
    }

    public String getBgFormId() {
        return this.bgFormId;
    }

    public void setBgFormId(String bgFormId) {
        this.bgFormId = bgFormId;
    }

    public Map getBgFormMap() {
        return this.bgFormMap;
    }

    public void setBgFormMap(Map bgFormMap) {
        this.bgFormMap = bgFormMap;
    }

    public static String getFILTER_UI_KEY() {
        return FILTER_UI_KEY;
    }

    @Override
    protected boolean hasNewScheme() {
        return true;
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgTraceFilterParam)) {
            return;
        }
        String tmpStr = null;
        String[] tmpStrs = null;
        List ids = null;
        Map tmpMap = null;
        BgTraceFilterParam _filterParam = (BgTraceFilterParam)filterParam;
        try {
            ids = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(ORGUNIT_IDS)));
            if (ids != null) {
                _filterParam.setOrgUnitInfoAry(new OrgUnitInfo[ids.size()]);
                int in = ids.size();
                for (int i = 0; i < in; ++i) {
                    tmpStr = (String)ids.get(i);
                    if (StringUtils.isEmpty((String)tmpStr)) continue;
                    _filterParam.getOrgUnitInfoAry()[i] = new CostCenterOrgUnitInfo();
                    _filterParam.getOrgUnitInfoAry()[i].setId(BOSUuid.read((String)tmpStr));
                }
            } else {
                _filterParam.setOrgUnitInfoAry(null);
            }
            tmpStr = cp.getCustomerParam(BGFORM_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgFormId(tmpStr);
            } else {
                _filterParam.setBgFormId(null);
            }
            tmpMap = (Map)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(BGFORM_ID_MAP)));
            if (tmpMap != null) {
                _filterParam.setBgFormMap(tmpMap);
            } else {
                _filterParam.setBgFormMap(null);
            }
            tmpStr = cp.getCustomerParam(BGSCHEME_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgSchemeId(tmpStr);
            } else {
                _filterParam.setBgSchemeId(null);
            }
            tmpStrs = (String[])BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(BGITEM_NUMBER)));
            if (tmpStrs != null) {
                _filterParam.setItems(tmpStrs);
            } else {
                _filterParam.setItems(null);
            }
            tmpStr = cp.getCustomerParam(BGPERIOD_ID_BEGIN);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBeginPeriod(new BgPeriodInfo());
                _filterParam.getBeginPeriod().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setBeginPeriod(null);
            }
            tmpStr = cp.getCustomerParam(BGPERIOD_ID_END);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setEndPeriod(new BgPeriodInfo());
                _filterParam.getEndPeriod().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setEndPeriod(null);
            }
            tmpStr = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setCurrency(null);
            }
            tmpStr = cp.getCustomerParam(BGELEMENT_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setObjElement(new BgElementInfo());
                _filterParam.getObjElement().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setObjElement(null);
            }
            tmpStr = cp.getCustomerParam(SHOWITEMNUMBER);
            if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
                _filterParam.setIsShowItemNumber(Boolean.TRUE);
            } else {
                _filterParam.setIsShowItemNumber(Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgTraceFilterParam)) {
            return;
        }
        BgTraceFilterParam _filterParam = (BgTraceFilterParam)filterParam;
        ArrayList<String> tmpList = null;
        OrgUnitInfo _unitInfo = null;
        if (!StringUtils.isEmpty((String)_filterParam.getBgFormId())) {
            cp.addCustomerParam(BGFORM_ID, _filterParam.getBgFormId());
        } else {
            cp.removeCustomerParam(BGFORM_ID);
        }
        if (_filterParam.getBgFormMap() != null && !_filterParam.getBgFormMap().isEmpty()) {
            cp.addCustomerParam(BGFORM_ID_MAP, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(_filterParam.getBgFormMap())));
        } else {
            cp.removeCustomerParam(BGFORM_ID_MAP);
        }
        if (_filterParam.getOrgUnitInfoAry() != null) {
            tmpList = new ArrayList<String>();
            int in = _filterParam.getOrgUnitInfoAry().length;
            for (int i = 0; i < in; ++i) {
                _unitInfo = _filterParam.getOrgUnitInfoAry()[i];
                if (_unitInfo == null) continue;
                tmpList.add(_unitInfo.getId().toString());
            }
            if (!tmpList.isEmpty()) {
                cp.addCustomerParam(ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(ORGUNIT_IDS);
            }
        } else {
            cp.removeCustomerParam(ORGUNIT_IDS);
        }
        if (_filterParam.getBgSchemeId() != null) {
            cp.addCustomerParam(BGSCHEME_ID, _filterParam.getBgSchemeId());
        } else {
            cp.removeCustomerParam(BGSCHEME_ID);
        }
        if (_filterParam.getItems() != null) {
            String[] tmpStrs = _filterParam.getItems();
            cp.addCustomerParam(BGITEM_NUMBER, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpStrs)));
        } else {
            cp.removeCustomerParam(BGITEM_NUMBER);
        }
        if (_filterParam.getBeginPeriod() != null) {
            cp.addCustomerParam(BGPERIOD_ID_BEGIN, _filterParam.getBeginPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID_BEGIN);
        }
        if (_filterParam.getEndPeriod() != null) {
            cp.addCustomerParam(BGPERIOD_ID_END, _filterParam.getEndPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID_END);
        }
        if (_filterParam.getObjElement() != null) {
            cp.addCustomerParam(BGELEMENT_ID, _filterParam.getObjElement().getId().toString());
        } else {
            cp.removeCustomerParam(BGELEMENT_ID);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(CURRENCY_ID);
        }
        if (_filterParam.getIsShowItemNumber().booleanValue()) {
            cp.addCustomerParam(SHOWITEMNUMBER, _filterParam.getIsShowItemNumber().toString());
        } else {
            cp.removeCustomerParam(SHOWITEMNUMBER);
        }
    }
}

