/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CodeNameEnum;
import com.kingdee.eas.ma.budget.CompareTyeEnum;
import com.kingdee.eas.ma.budget.client.BgPeriodListUI;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgPeriodF7ListUI
extends BgPeriodListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodF7ListUI.class);
    protected boolean isMultiSelect = false;
    protected boolean isExamine = false;
    protected boolean isInitial = false;
    private BgPeriodEnum bgPeriodEnum = null;
    private Date beginDate = null;
    private Date endDate = null;

    public BgPeriodF7ListUI() throws Exception {
    }

    public BgPeriodF7ListUI(boolean isMultiSelect) throws Exception {
        this.isMultiSelect = isMultiSelect;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initAction();
    }

    public void onLoad(boolean isInitial) throws Exception {
        this.isInitial = isInitial;
        super.onLoad();
        this.kDNameCode.removeAllItems();
        this.kDNameCode.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ma.budget.CodeNameEnum").toArray());
        this.kDCompareType.removeAllItems();
        this.kDCompareType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ma.budget.CompareTyeEnum").toArray());
        this.kDNameCode.setVisible(true);
        this.kDCompareType.setVisible(true);
        this.kDText.setVisible(true);
        this.kDQuery.setVisible(true);
        this.initAction();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void initAction() {
        AbstractAction actionShow = new AbstractAction(){
            private static final long serialVersionUID = 8707818271853932164L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgPeriodF7ListUI.this.actionShow_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgPeriodF7ListUI.this.handleException(ex);
                }
            }
        };
        AbstractAction actionHide = new AbstractAction(){
            private static final long serialVersionUID = 2750933550496592004L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgPeriodF7ListUI.this.actionHide_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgPeriodF7ListUI.this.handleException(ex);
                }
            }
        };
        this.tblMain.getActionMap().remove("SelectLeftCell");
        this.tblMain.getActionMap().remove("SelectRightCell");
        String strKey = "RIGHT";
        KeyStroke ks = KeyStroke.getKeyStroke(39, 0);
        this.tblMain.getActionMap().put(strKey, actionShow);
        this.tblMain.getInputMap(2).put(ks, strKey);
        strKey = "LEFT";
        ks = KeyStroke.getKeyStroke(37, 0);
        this.tblMain.getActionMap().put(strKey, actionHide);
        this.tblMain.getInputMap(2).put(ks, strKey);
    }

    private void actionShow_actionPerformed(ActionEvent e) {
        BgPeriodListUI.NumberExpandInfo expandInfo;
        int rowIndex;
        IRow row;
        int colIndex;
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0 && (colIndex = 2) == 2 && (row = this.tblMain.getRow(rowIndex = this.tblMain.getSelectManager().getActiveRowIndex())) != null && (expandInfo = (BgPeriodListUI.NumberExpandInfo)row.getCell("number").getValue()) != null) {
            this.setTreeDisplayStyle(row, expandInfo, true);
        }
    }

    private void actionHide_actionPerformed(ActionEvent e) {
        BgPeriodListUI.NumberExpandInfo expandInfo;
        int rowIndex;
        IRow row;
        int colIndex;
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0 && (colIndex = 2) == 2 && (row = this.tblMain.getRow(rowIndex = this.tblMain.getSelectManager().getActiveRowIndex())) != null && (expandInfo = (BgPeriodListUI.NumberExpandInfo)row.getCell("number").getValue()) != null) {
            this.setTreeDisplayStyle(row, expandInfo, false);
        }
    }

    private void setTreeDisplayStyle(IRow row, BgPeriodListUI.NumberExpandInfo expandInfo, boolean isShow) {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo, isShow);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, BgPeriodListUI.NumberExpandInfo parentExpandInfo, boolean isShow) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        BgPeriodListUI.NumberExpandInfo expandInfo = null;
        String bgLongNumber = parentExpandInfo.getLongNumber();
        int parentLevel = parentExpandInfo.getLevel();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus && !isShow) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (BgPeriodListUI.NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(bgLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else if (isShow) {
            this.expandChild(row, parentExpandInfo);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExpand.setVisible(true);
        this.btnExpand.setEnabled(true);
        this.btnConstriction.setVisible(true);
        this.btnConstriction.setEnabled(true);
    }

    protected BgPeriodEnum setBgPeriodEnum() {
        return this.bgPeriodEnum;
    }

    protected void setBgPeriodEnum(BgPeriodEnum bgPeriodEnum) {
        this.bgPeriodEnum = bgPeriodEnum;
    }

    protected void setBgPeriodDate(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        if (this.beginDate != null) {
            this.beginDate = BgHelper.getDayBegin(this.beginDate);
        }
        this.endDate = endDate;
        if (this.endDate != null) {
            this.endDate = BgHelper.getDayEnd(this.endDate);
        }
    }

    protected void bgPeriodInitial() {
        IColumn col;
        this.isInitial = true;
        if (this.bgPeriodEnum != null && (col = this.tblMain.getColumn("number")) != null) {
            col.setRenderer(null);
        }
    }

    protected boolean isPeriodInitial() {
        return this.isInitial;
    }

    public KDTable getTable() {
        return this.tblMain;
    }

    public void loadPersonalPeriod() throws BOSException {
        int i;
        if (!this.isInitial) {
            return;
        }
        BgPeriodCollection bgPeriodYearCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        SorterItemCollection sorts = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        sorts.add(sort);
        items.add(new FilterItemInfo("periodType", (Object)new Integer(8), CompareType.EQUALS));
        view.setFilter(filter);
        try {
            bgPeriodYearCol = this.getBgPeriodInterface().getBgPeriodCollection(view);
        }
        catch (Exception e) {
            bgPeriodYearCol = new BgPeriodCollection();
        }
        this.isSearch = false;
        this.kDComYear.removeAllItems();
        this.kDComYear.addItems(bgPeriodYearCol.toArray());
        int count = this.kDComYear.getItemCount();
        if (count > 0 && (i = 0) < count) {
            this.isSearch = true;
            this.kDComYear.setSelectedIndex(i);
        }
    }

    @Override
    public void loadPeriodYear(boolean isSelect, int year, int periodType) throws Exception {
        String markStr;
        if (!this.isInitial) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodYearCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        SorterItemCollection sorts = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        sorts.add(sort);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(8));
        items.add(new FilterItemInfo("periodType", (Object)new Integer(8), CompareType.EQUALS));
        items.add(new FilterItemInfo("periodType", (Object)new Integer(1), CompareType.EQUALS));
        if (periodType != 8) {
            if (this.beginDate != null && this.endDate != null) {
                items.add(new FilterItemInfo("year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                items.add(new FilterItemInfo("year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                markStr = "#0 or (#1 and #2 and #3)";
                filter.setMaskString(markStr);
            } else {
                markStr = "#0 or #1";
                filter.setMaskString(markStr);
            }
        } else {
            markStr = "#0 or #1";
            filter.setMaskString(markStr);
        }
        view.setFilter(filter);
        bgPeriodYearCol = this.getBgPeriodInterface().getBgPeriodCollection(view);
        this.isSearch = false;
        this.kDComYear.removeAllItems();
        this.kDComYear.addItems(bgPeriodYearCol.toArray());
        boolean isSelected = false;
        int count = this.kDComYear.getItemCount();
        if (isSelect && count > 0) {
            for (int i = 0; i < count; ++i) {
                bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(i);
                if (bgPeriodInfo.getYear() != year) continue;
                this.isSearch = true;
                isSelected = true;
                this.kDComYear.setSelectedIndex(i);
                break;
            }
            if (!isSelected) {
                this.isSearch = true;
                bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(0);
                this.kDComYear.setSelectedIndex(0);
            }
        } else {
            filter = new FilterInfo();
            items = filter.getFilterItems();
            items.add(new FilterItemInfo("year", (Object)new Integer(-1), CompareType.EQUALS));
            this.mainQuery.setFilter(filter);
            this.execQuery();
            if (this.tblMain.getRowCount() > 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
    }

    public void loadPeriodYearWithExamine(boolean isSelect, int year, int periodType) throws Exception {
        String markStr;
        if (!this.isInitial) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodYearCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        SorterItemCollection sorts = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        sorts.add(sort);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        items.add(new FilterItemInfo("periodType", (Object)new Integer(1), CompareType.EQUALS));
        items.add(new FilterItemInfo("periodType", set, CompareType.INCLUDE));
        if (periodType != 8) {
            if (this.beginDate != null && this.endDate != null) {
                items.add(new FilterItemInfo("year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                items.add(new FilterItemInfo("year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                markStr = "#0 or (#1 and #2 and #3)";
                filter.setMaskString(markStr);
            } else {
                markStr = "#0 or #1";
                filter.setMaskString(markStr);
            }
        } else {
            markStr = "#0 or #1";
            filter.setMaskString(markStr);
        }
        view.setFilter(filter);
        bgPeriodYearCol = this.getBgPeriodInterface().getBgPeriodCollection(view);
        this.isSearch = false;
        this.kDComYear.removeAllItems();
        this.kDComYear.addItems(bgPeriodYearCol.toArray());
        boolean isSelected = false;
        int count = this.kDComYear.getItemCount();
        if (isSelect && count > 0) {
            for (int i = 0; i < count; ++i) {
                bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(i);
                if (bgPeriodInfo.getYear() != year) continue;
                this.isSearch = true;
                isSelected = true;
                this.kDComYear.setSelectedIndex(i);
                break;
            }
            if (!isSelected) {
                this.isSearch = true;
                bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(0);
                this.kDComYear.setSelectedIndex(0);
            }
        } else {
            filter = new FilterInfo();
            items = filter.getFilterItems();
            items.add(new FilterItemInfo("year", (Object)new Integer(-1), CompareType.EQUALS));
            this.mainQuery.setFilter(filter);
            this.execQuery();
            if (this.tblMain.getRowCount() > 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgPeriodF7ListUI.this.setTableDisplayStyle(start, end);
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int start = e.getRowIndex();
                int end = e.getRowIndex();
                BgPeriodF7ListUI.this.setTableDisplayStyle(start, end);
            }
        });
    }

    private void setTableDisplayStyle(int startup, int end) {
        IRow row = null;
        int level = 0;
        Object obj = null;
        BgPeriodListUI.NumberExpandInfo expandInfo = null;
        int count = end;
        for (int i = startup; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("id").getValue();
            obj = row.getCell("number").getValue();
            if (!(obj instanceof String)) {
                return;
            }
            String number = (String)obj;
            String longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new BgPeriodListUI.NumberExpandInfo(this);
            expandInfo.setId(id);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
        }
    }

    @Override
    protected void kDComYear_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.kDComYear.getSelectedIndex();
        if (this.isSearch && selectIndex >= 0) {
            int rowNum;
            BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(selectIndex);
            this.selectYear = bgPeriodInfo.getYear();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            int periodType = bgPeriodInfo.getPeriodType().getValue();
            if (periodType == 8) {
                items.add(new FilterItemInfo("id", (Object)bgPeriodInfo.getId()));
                filter.setMaskString("#0");
            } else {
                items.add(new FilterItemInfo("year", (Object)new Integer(bgPeriodInfo.getYear()), CompareType.EQUALS));
            }
            if (this.bgPeriodEnum != null) {
                items.add(new FilterItemInfo("periodType", (Object)new Integer(this.bgPeriodEnum.getValue()), CompareType.EQUALS));
                int type = this.bgPeriodEnum.getValue();
                if (type == 2) {
                    if (this.beginDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.beginDate)) {
                        items.add(new FilterItemInfo("halfYear", (Object)new Integer(this.calendar.getCurrentlyHalfYear(this.beginDate)), CompareType.GREATER_EQUALS));
                    }
                    if (this.endDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.endDate)) {
                        items.add(new FilterItemInfo("halfYear", (Object)new Integer(this.calendar.getCurrentlyHalfYear(this.endDate)), CompareType.LESS_EQUALS));
                    }
                } else if (type == 3) {
                    if (this.beginDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.beginDate)) {
                        items.add(new FilterItemInfo("quarter", (Object)new Integer(this.calendar.getCurrentlyQuarter(this.beginDate)), CompareType.GREATER_EQUALS));
                    }
                    if (this.endDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.endDate)) {
                        items.add(new FilterItemInfo("quarter", (Object)new Integer(this.calendar.getCurrentlyQuarter(this.endDate)), CompareType.LESS_EQUALS));
                    }
                } else if (type == 4) {
                    if (this.beginDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.beginDate)) {
                        items.add(new FilterItemInfo("month", (Object)new Integer(this.calendar.getCurrentlyMonth(this.beginDate)), CompareType.GREATER_EQUALS));
                    }
                    if (this.endDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.endDate)) {
                        items.add(new FilterItemInfo("month", (Object)new Integer(this.calendar.getCurrentlyMonth(this.endDate)), CompareType.LESS_EQUALS));
                    }
                } else if (type == 5) {
                    if (this.beginDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.beginDate)) {
                        items.add(new FilterItemInfo("beginDate", (Object)this.beginDate, CompareType.GREATER_EQUALS));
                    }
                    if (this.endDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.endDate)) {
                        items.add(new FilterItemInfo("endDate", (Object)this.endDate, CompareType.LESS_EQUALS));
                    }
                } else if (type == 6) {
                    if (this.beginDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.beginDate)) {
                        items.add(new FilterItemInfo("beginDate", (Object)this.beginDate, CompareType.GREATER_EQUALS));
                    }
                    if (this.endDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.endDate)) {
                        items.add(new FilterItemInfo("endDate", (Object)this.endDate, CompareType.LESS_EQUALS));
                    }
                } else if (type == 7) {
                    if (this.beginDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.beginDate)) {
                        items.add(new FilterItemInfo("beginDate", (Object)this.beginDate, CompareType.GREATER_EQUALS));
                    }
                    if (this.endDate != null && this.selectYear == this.calendar.getCurrentlyYear(this.endDate)) {
                        items.add(new FilterItemInfo("endDate", (Object)this.endDate, CompareType.LESS_EQUALS));
                    }
                }
            }
            this.mainQuery.setFilter(filter);
            this.execQuery();
            BgPeriodListUI.NumberExpandInfo parentExpandInfo = (BgPeriodListUI.NumberExpandInfo)this.tblMain.getRow(0).getCell("number").getValue();
            parentExpandInfo.setExpandStatus(false);
            String bgLongNumber = bgPeriodInfo.getLongNumber();
            IRow child = null;
            String longNumber = null;
            BgPeriodListUI.NumberExpandInfo expandInfo = null;
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                expandInfo = (BgPeriodListUI.NumberExpandInfo)child.getCell("number").getValue();
                longNumber = expandInfo.getLongNumber();
                if (this.bgPeriodEnum != null && this.bgPeriodEnum.getValue() == 4) continue;
                if (!longNumber.startsWith(bgLongNumber + "!")) break;
                child.getStyleAttributes().setHided(true);
            }
            if ((rowNum = this.tblMain.getRowCount()) > 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
            if (periodType == 8 && rowNum > 1) {
                IColumn col = this.tblMain.getColumn("number");
                IRow row = this.tblMain.getRow(0);
                BgPeriodListUI.NumberExpandInfo info = (BgPeriodListUI.NumberExpandInfo)row.getCell("number").getValue();
                info.setLeaf(false);
                row.getCell("isLeaf").setValue((Object)false);
                if (col != null) {
                    this.render = new BgPeriodListUI.BgPeriodRender(this);
                    col.setRenderer((IBasicRender)this.render);
                    col.getStyleAttributes().setLocked(true);
                }
            }
        }
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    public void isMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        this.isMultiSelect = isMultiSelect;
    }

    public BgPeriodInfo getData() throws Exception {
        return this.getBgPeriodInfo();
    }

    public Object getSelectPeriodInfo() throws BOSException, EASBizException {
        if (this.isMultiSelect) {
            return this.getBgPeriodCollection();
        }
        return this.getBgPeriodInfo();
    }

    protected BgPeriodInfo getBgPeriodInfo() throws BOSException {
        IRow row;
        BgPeriodInfo bgPeriodInfo = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            String bgPeriodId = row.getCell("id").getValue().toString();
            try {
                bgPeriodInfo = this.getBgPeriodInterface().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bgPeriodId)));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        return bgPeriodInfo;
    }

    protected BgPeriodCollection getBgPeriodCollection() {
        IRow row = null;
        KDTRange range = null;
        KDTSelectBlock block = null;
        int rangeCount = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        String bgPeriodId = null;
        HashSet<String> bgPeriodSet = new HashSet<String>();
        range = this.tblMain.getSelectManager().toRange();
        rangeCount = range.size();
        for (int i = 0; i < rangeCount; ++i) {
            block = (KDTSelectBlock)range.get(i);
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            for (int j = rowBegin; j <= rowEnd; ++j) {
                row = this.tblMain.getRow(j);
                if (row == null || row.getStyleAttributes().isHided()) continue;
                bgPeriodId = row.getCell("id").getValue().toString();
                bgPeriodSet.add(bgPeriodId);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("id", bgPeriodSet, CompareType.INCLUDE));
        view.getSorter().add(new SorterItemInfo("longNumber"));
        view.setFilter(filter);
        BgPeriodCollection col = null;
        try {
            col = this.getBgPeriodInterface().getBgPeriodCollection(view);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            col = new BgPeriodCollection();
        }
        return col;
    }

    @Override
    protected void kDQuery_actionPerformed(ActionEvent e) throws Exception {
        String text = this.kDText.getText().trim();
        if (text == null || "".equals(text)) {
            return;
        }
        int selectIndex = this.kDComYear.getSelectedIndex();
        if (selectIndex >= 0) {
            BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(selectIndex);
            this.selectYear = bgPeriodInfo.getYear();
        }
        CodeNameEnum cn = (CodeNameEnum)((Object)this.kDNameCode.getSelectedItem());
        CompareTyeEnum ct = (CompareTyeEnum)((Object)this.kDCompareType.getSelectedItem());
        String colName = "number";
        CompareType cpType = CompareType.EQUALS;
        if (cn == CodeNameEnum.name) {
            colName = "name";
        }
        if (ct == CompareTyeEnum.include) {
            cpType = CompareType.LIKE;
            text = "%" + text + "%";
        }
        FilterInfo filter = new FilterInfo();
        int periodType = -1;
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.selectYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(colName, (Object)text, cpType));
        this.mainQuery.setFilter(filter);
        this.execQuery();
        int rowNum = this.tblMain.getRowCount();
        if (rowNum > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        if (periodType == 8 && rowNum > 1) {
            IColumn col = this.tblMain.getColumn("number");
            IRow row = this.tblMain.getRow(0);
            BgPeriodListUI.NumberExpandInfo info = (BgPeriodListUI.NumberExpandInfo)row.getCell("number").getValue();
            info.setLeaf(false);
            row.getCell("isLeaf").setValue((Object)false);
            if (col != null) {
                this.render = new BgPeriodListUI.BgPeriodRender(this);
                col.setRenderer((IBasicRender)this.render);
                col.getStyleAttributes().setLocked(true);
            }
        }
    }
}

