/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.client.AbstractBgPeriodListUI;
import com.kingdee.eas.ma.budget.client.BgPeriodEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgPeriodListUI
extends AbstractBgPeriodListUI {
    private static final long serialVersionUID = 8065696305452261391L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodListUI.class);
    protected CalendarHelper calendar = new CalendarHelper();
    protected BgPeriodRender render = null;
    protected int selectYear = 0;
    protected boolean isSearch = false;
    private int refreshType = 1;
    public static final int Year_Period_Type = 1;

    protected String getEditUIName() {
        return BgPeriodEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    protected IBgPeriod getBgPeriodInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.selectYear = this.calendar.getCurrentlyYear();
        this.loadPeriodYear(true, this.selectYear, 1);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.menuItemRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnExpand.setIcon(EASResource.getIcon((String)"imgTbtn_upenumnew"));
        this.btnConstriction.setIcon(EASResource.getIcon((String)"imgTbtn_upenumdel"));
    }

    public void setRefreshType(int refreshType) {
        this.refreshType = refreshType;
    }

    public void setSelectYear(int selectYear) {
        this.selectYear = selectYear;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ISCANCEL", (Object)this);
    }

    protected void initTable() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        IColumn col = null;
        col = this.tblMain.getColumn("number");
        if (col != null) {
            this.render = new BgPeriodRender();
            col.setRenderer((IBasicRender)this.render);
            col.getStyleAttributes().setLocked(true);
        }
    }

    public void loadPeriodYear(boolean isSelect, int year, int periodType) throws Exception {
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodYearCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        SorterItemCollection sorts = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        sorts.add(sort);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(8));
        items.add(new FilterItemInfo("periodType", set, CompareType.INCLUDE));
        view.setFilter(filter);
        bgPeriodYearCol = this.getBgPeriodInterface().getBgPeriodCollection(view);
        this.isSearch = false;
        this.kDComYear.removeAllItems();
        this.kDComYear.addItems(bgPeriodYearCol.toArray());
        boolean isSelected = false;
        int count = this.kDComYear.getItemCount();
        if (isSelect && count > 0) {
            for (int i = 0; i < count; ++i) {
                bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(i);
                if (bgPeriodInfo.getYear() != year) continue;
                this.isSearch = true;
                isSelected = true;
                this.kDComYear.setSelectedIndex(i);
                break;
            }
        }
        if (isSelect && count == 0) {
            this.isSearch = true;
        }
        if (!isSelected && count > 0) {
            this.isSearch = true;
            bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(0);
            this.kDComYear.setSelectedIndex(0);
        }
        if (count == 0) {
            this.kDComYear.setSelectedIndex(-1);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.refreshType == 0) {
            this.refreshType = 1;
        } else if (this.refreshType == 1) {
            this.loadPeriodYear(true, this.selectYear, 1);
        } else if (this.refreshType == 2) {
            this.loadPeriodYear(true, this.selectYear, 1);
            this.refreshType = 1;
        }
    }

    @Override
    protected void kDComYear_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex = this.kDComYear.getSelectedIndex();
        if (this.isSearch) {
            FilterInfo filter = new FilterInfo();
            int periodType = -1;
            if (selectIndex < 0) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"#######"));
            } else {
                BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(selectIndex);
                this.selectYear = bgPeriodInfo.getYear();
                FilterItemCollection items = filter.getFilterItems();
                periodType = bgPeriodInfo.getPeriodType().getValue();
                if (periodType == 8) {
                    items.add(new FilterItemInfo("id", (Object)bgPeriodInfo.getId()));
                    items.add(new FilterItemInfo("beginDate", (Object)this.calendar.getStartDate(bgPeriodInfo.getBeginDate()), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)this.calendar.getBeoverDate(bgPeriodInfo.getEndDate()), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("periodtype", (Object)new Integer(0)));
                    filter.setMaskString("#0 or #1 and #2 and #3");
                } else {
                    items.add(new FilterItemInfo("year", (Object)new Integer(bgPeriodInfo.getYear()), CompareType.EQUALS));
                }
            }
            this.mainQuery.setFilter(filter);
            this.execQuery();
            int rowNum = this.tblMain.getRowCount();
            if (rowNum > 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
            if (periodType == 8 && rowNum > 1) {
                IColumn col = this.tblMain.getColumn("number");
                IRow row = this.tblMain.getRow(0);
                NumberExpandInfo info = (NumberExpandInfo)row.getCell("number").getValue();
                info.setLeaf(false);
                row.getCell("isLeaf").setValue((Object)false);
                if (col != null) {
                    this.render = new BgPeriodRender();
                    col.setRenderer((IBasicRender)this.render);
                    col.getStyleAttributes().setLocked(true);
                }
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"isRemove"));
        if (re == 1 || re == 2) {
            return;
        }
        BgPeriodInfo selectPeriodInfo = (BgPeriodInfo)this.kDComYear.getSelectedItem();
        int periodType = selectPeriodInfo.getPeriodType().getValue();
        if (periodType == 8) {
            boolean isRemove = this.getBgPeriodInterface().deletePersonalPeriod(selectPeriodInfo.getId().toString());
            if (isRemove) {
                this.kDComYear.removeItem((Object)selectPeriodInfo);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"can_not_del"));
            }
        } else {
            int selectIndex = this.kDComYear.getSelectedIndex();
            if (selectIndex >= 0) {
                BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(selectIndex);
                if (bgPeriodInfo != null) {
                    this.selectYear = bgPeriodInfo.getYear();
                }
                KDTRange range = this.tblMain.getSelectManager().toRange();
                int rowEnd = 0;
                IRow row = null;
                KDTSelectBlock block = null;
                HashSet<String> idSets = new HashSet<String>();
                if (range != null) {
                    int size = range.size();
                    for (int i = 0; i < size; ++i) {
                        block = (KDTSelectBlock)range.get(i);
                        int rowBegin = block.getBeginRow();
                        rowEnd = block.getEndRow();
                        for (int j = rowBegin; j <= rowEnd; ++j) {
                            String id;
                            row = this.tblMain.getRow(j);
                            if (row == null || (id = row.getCell("id").getValue().toString()) == null) continue;
                            idSets.add(id);
                        }
                    }
                }
                if (!idSets.isEmpty()) {
                    this.getBgPeriodInterface().batchDeletePeriod(idSets);
                    this.loadPeriodYear(true, this.selectYear, bgPeriodInfo.getPeriodType().getValue());
                }
            }
        }
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        BgPeriodInfo bgPeriodInfo;
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"isRemoveAll"));
        if (re == 1 || re == 2) {
            return;
        }
        int selectIndex = this.kDComYear.getSelectedIndex();
        if (selectIndex >= 0 && (bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getItemAt(selectIndex)) != null) {
            this.getBgPeriodInterface().deletePeriodOfYear(String.valueOf(bgPeriodInfo.getYear()));
            this.loadPeriodYear(true, this.selectYear, bgPeriodInfo.getPeriodType().getValue());
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgPeriodListUI.this.setTableDisplayStyle(start, end);
            }
        });
    }

    private void setTableDisplayStyle(int startup, int end) {
        IRow row = null;
        int level = 0;
        Object obj = null;
        NumberExpandInfo expandInfo = null;
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.kDComYear.getSelectedItem();
        if (bgPeriodInfo == null) {
            return;
        }
        int periodType = bgPeriodInfo.getPeriodType().getValue();
        if (periodType == 8) {
            this.btnRemoveAll.setVisible(false);
            String parentLN = this.tblMain.getRow(0).getCell("longNumber").getValue().toString();
            int parentLevel = (Integer)this.tblMain.getRow(0).getCell("level").getValue();
            int count = end;
            for (int i = startup; i <= count; ++i) {
                row = this.tblMain.getRow(i);
                if (row == null) continue;
                String id = (String)row.getCell("id").getValue();
                obj = row.getCell("number").getValue();
                if (obj == null) {
                    return;
                }
                String number = obj.toString();
                String longNumber = row.getCell("longNumber").getValue().toString();
                level = parentLevel + 1;
                boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
                expandInfo = new NumberExpandInfo();
                expandInfo.setId(id);
                expandInfo.setNumber(number);
                if (i != 0) {
                    expandInfo.setLongNumber(parentLN + "!" + i);
                    expandInfo.setLevel(level);
                } else {
                    expandInfo.setLongNumber(longNumber);
                    expandInfo.setLevel(parentLevel);
                }
                if (i != 0) {
                    expandInfo.setLeaf(true);
                } else {
                    expandInfo.setLeaf(true);
                }
                expandInfo.setExpandStatus(true);
                row.getCell("number").setValue((Object)expandInfo);
            }
        } else {
            this.btnRemoveAll.setVisible(true);
            int count = end;
            for (int i = startup; i <= count; ++i) {
                row = this.tblMain.getRow(i);
                if (row == null) continue;
                String id = (String)row.getCell("id").getValue();
                obj = row.getCell("number").getValue();
                if (!(obj instanceof String)) {
                    return;
                }
                String number = (String)obj;
                String longNumber = row.getCell("longNumber").getValue().toString();
                level = (Integer)row.getCell("level").getValue();
                boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
                expandInfo = new NumberExpandInfo();
                expandInfo.setId(id);
                expandInfo.setNumber(number);
                expandInfo.setLongNumber(longNumber);
                expandInfo.setLevel(level);
                expandInfo.setLeaf(isLeaf);
                expandInfo.setExpandStatus(true);
                row.getCell("number").setValue((Object)expandInfo);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        NumberExpandInfo expandInfo;
        int rowIndex;
        IRow row;
        int colIndex;
        if (e.getClickCount() == 1 && (colIndex = e.getColIndex()) == 2 && (row = this.tblMain.getRow(rowIndex = e.getRowIndex())) != null && (expandInfo = (NumberExpandInfo)row.getCell("number").getValue()) != null && this.render.inRect(expandInfo, e.getX(), e.getY())) {
            this.setTreeDisplayStyle(row, expandInfo);
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = parentExpandInfo.getLongNumber();
        int parentLevel = parentExpandInfo.getLevel();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(bgLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            this.expandChild(row, parentExpandInfo);
        }
    }

    protected void expandChild(IRow row, NumberExpandInfo parentExpandInfo) {
        parentExpandInfo.setExpandStatus(true);
        String bgLongNumber = parentExpandInfo.getLongNumber();
        int parentLevel = parentExpandInfo.getLevel();
        int rowCount = this.tblMain.getRowCount();
        for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
            IRow child = this.tblMain.getRow(rowIndex);
            NumberExpandInfo expandInfo = (NumberExpandInfo)child.getCell("number").getValue();
            String longNumber = expandInfo.getLongNumber();
            int childLevel = expandInfo.getLevel();
            if (!longNumber.startsWith(bgLongNumber + "!") || childLevel != parentLevel + 1) continue;
            child.getStyleAttributes().setHided(false);
            if (!expandInfo.isExpandStatus() || expandInfo.isLeaf()) continue;
            this.expandChild(child, expandInfo);
        }
    }

    @Override
    protected void btnExpand_actionPerformed(ActionEvent e) throws Exception {
        int rowSize = this.tblMain.getBody().size();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            expandInfo.setExpandStatus(true);
            row.getStyleAttributes().setHided(false);
        }
        this.tblMain.setRowCount(rowSize);
    }

    @Override
    protected void btnConstriction_actionPerformed(ActionEvent e) throws Exception {
        int rowSize = this.tblMain.getBody().size();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            expandInfo.setExpandStatus(false);
            if (i <= 0) continue;
            row.getStyleAttributes().setHided(true);
        }
        this.tblMain.setRowCount(1);
    }

    protected class BgPeriodRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        protected BgPeriodRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    protected class NumberExpandInfo {
        private String id;
        private String number;
        private String longNumber;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        protected NumberExpandInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }
    }
}

