/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgPermissionInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTemplateObject;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgPermissionDataListUI;
import com.kingdee.eas.ma.budget.client.BgPermissionEditUI;
import com.kingdee.eas.ma.budget.client.NewBgTemplateDialog;
import com.kingdee.eas.ma.nbudget.BgFormCourseHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgPermissionDataListUI
extends AbstractBgPermissionDataListUI {
    private static final long serialVersionUID = 7440619103811843283L;
    private static final Logger logger = CoreUIObject.getLogger(BgPermissionDataListUI.class);
    private final String resource = "com.kingdee.eas.ma.budget.client.BgPermissionResource";

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEdit.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
        this.btnView.setVisible(false);
        this.btnRemoveAll.setEnabled(true);
        this.btnRemoveAll.setVisible(true);
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.menuItemRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.menuItemRemoveAll.setEnabled(true);
        this.comBgTemplate.setEditable(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (BgSHelper.isBgSheetPermissionUsed()) {
            this.tblMain.getColumn("bgSheetName").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("bgSheetName").getStyleAttributes().setHided(true);
        }
        this.prmtUser.setEnabledMultiSelection(true);
        this.prmtUser.setValue(null);
        this.comBgTemplate.setSelector((KDPromptSelector)new NewBgTemplateDialog((IUIObject)this));
        this.btnViewFlow.setVisible(false);
        this.itemViewFlow.setVisible(false);
    }

    @Override
    public String getPermissionNum() {
        return "bgPermission_listUI";
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name"};
        return locateNames;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgPermissionFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return BgPermissionEditUI.class.getName();
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (orgUnitInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            if (this.isHasFodian()) {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString("#0 and #1");
            if (BgParamCHelper.isBgPermissionUsed()) {
                String userId = this.getUserInfo().getId().toString();
                Set<String> orgSet = new HashSet<String>();
                if (this.getPermissionOrg() != null) {
                    orgSet = this.getPermissionOrg();
                } else {
                    orgSet.add(orgUnitInfo.getId().toString());
                }
                filter = BgPermissionHelper.addBgSchemePermission((String)userId, orgSet, (FilterInfo)filter);
            }
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
        this.chooseTemplate();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        String orgUnitID = orgUnitInfo == null ? null : orgUnitInfo.getId().toString();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        filter = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        this.refreshFilter(filter);
        viewInfo.setFilter(filter);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    protected void prmtUser_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.chooseTemplate();
        this.refreshTable();
    }

    @Override
    protected void prmtBgType_dataChanged(DataChangeEvent e) throws Exception {
        this.chooseTemplate();
        this.refreshTable();
    }

    @Override
    protected void comBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    private void refreshTable() {
        FilterInfo _filter = new FilterInfo();
        this.refreshFilter(_filter);
        this.mainQuery.setFilter(_filter);
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void refreshFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Object obj = this.prmtBgScheme.getData();
        if (obj != null) {
            if (obj instanceof BgSchemeInfo) {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
            } else if (obj instanceof String) {
                String _name = (String)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_name, CompareType.EQUALS));
            }
        }
        this.addBgTemplateGroupFilterItem(filter, this.prmtBgType.getValue());
        Object userValue = this.prmtUser.getValue();
        StringBuffer userNumbers = null;
        if (userValue != null) {
            Object[] users;
            if (userValue instanceof String) {
                userNumbers = new StringBuffer("");
                userNumbers.append(userValue);
            } else if (userValue instanceof Object[] && (users = (Object[])userValue) != null && users.length > 0) {
                userNumbers = new StringBuffer("");
                for (int i = 0; i < users.length; ++i) {
                    if (users[i] == null) continue;
                    userNumbers.append(((UserInfo)users[i]).getNumber().toString()).append(",");
                }
                if (!userNumbers.toString().equals("")) {
                    userNumbers.delete(userNumbers.length() - 1, userNumbers.length());
                }
            }
            if (userNumbers != null) {
                this.replaceFilterItems(filter, new FilterItemInfo("person.number", (Object)userNumbers.toString(), CompareType.INCLUDE));
            }
        }
        Object templateObj = this.comBgTemplate.getData();
        HashSet<String> templateIdSet = new HashSet<String>();
        if (templateObj != null && templateObj instanceof BgTemplateObject) {
            BgTemplateInfo[] tempArray = BgFormCourseHelper.tempObj2TempArray((BgTemplateObject)((BgTemplateObject)templateObj));
            int in = tempArray.length;
            for (int i = 0; i < in; ++i) {
                templateIdSet.add(tempArray[i].getNumber().toString());
            }
            this.replaceFilterItems(filter, new FilterItemInfo("bgTemplate.number", templateIdSet, CompareType.INCLUDE));
        }
    }

    private void chooseTemplate() throws Exception {
        Object objscheme = this.prmtBgScheme.getData();
        Object objtype = this.prmtBgType.getData();
        if (objtype instanceof BgTypeInfo && objscheme instanceof BgSchemeInfo) {
            BgTemplateObject templateObj;
            BgSchemeInfo bgscheme = (BgSchemeInfo)objscheme;
            BgTypeInfo bgTypeInfo = (BgTypeInfo)objtype;
            if (this.comBgTemplate.getData() instanceof BgTemplateObject && !(templateObj = (BgTemplateObject)this.comBgTemplate.getData()).getResult().isEmpty()) {
                BgTemplateInfo info = templateObj.getResult().get(0);
                if (info.getBgType() != null) {
                    if (!info.getBgType().getId().toString().equals(bgTypeInfo.getId().toString())) {
                        this.comBgTemplate.setData(null);
                        this.comBgTemplate.setRefresh(true);
                    }
                } else {
                    this.comBgTemplate.setData(null);
                    this.comBgTemplate.setRefresh(true);
                }
            }
            this.initTemplateFromBgType(bgscheme, bgTypeInfo);
        } else if (!(objtype instanceof BgTypeInfo) && objscheme instanceof BgSchemeInfo) {
            BgSchemeInfo bgscheme = (BgSchemeInfo)objscheme;
            this.initTemplateFromBgType(bgscheme, null);
        } else if (objtype instanceof BgTypeInfo && !(objscheme instanceof BgSchemeInfo)) {
            BgTypeInfo bgTypeInfo = (BgTypeInfo)objtype;
            this.initTemplateFromBgType(null, bgTypeInfo);
        } else {
            this.initTemplateFromBgType(null, null);
        }
    }

    protected void initTemplateFromBgType(BgSchemeInfo bgscheme, BgTypeInfo bgTypeInfo) throws Exception {
        NewBgTemplateDialog dialog = null;
        if (this.comBgTemplate.getSelector() != null) {
            dialog = (NewBgTemplateDialog)this.comBgTemplate.getSelector();
        } else {
            dialog = new NewBgTemplateDialog((IUIObject)this);
            this.comBgTemplate.setSelector((KDPromptSelector)dialog);
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (orgUnitInfo != null) {
            dialog.setOrgId(orgUnitInfo.getId().toString());
        } else {
            dialog.setOrgId(null);
        }
        if (bgTypeInfo != null) {
            dialog.setBgTypeNumber(bgTypeInfo.getNumber());
            dialog.setBgTypeId(null);
        } else {
            dialog.setBgTypeId(null);
            dialog.setBgTypeNumber(null);
        }
        if (bgscheme != null) {
            dialog.setSchemeId(bgscheme.getId().toString());
        } else {
            dialog.setSchemeId(null);
        }
    }

    protected void addBgTemplateGroupFilterItem(FilterInfo filter, Object objType) {
        if (filter == null) {
            return;
        }
        String typeNumber = null;
        if (objType instanceof BgTypeInfo) {
            BgTypeInfo bgTemGroupInfo = (BgTypeInfo)objType;
            typeNumber = bgTemGroupInfo.getNumber();
        } else if (objType instanceof String) {
            typeNumber = (String)objType;
        }
        if (filter == null || typeNumber == null || typeNumber.trim().equals("")) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            int oldSize = fiCol.size();
            fiCol.add(new FilterItemInfo("bgTemplateGroup.number", (Object)typeNumber, CompareType.EQUALS));
            fiCol.add(new FilterItemInfo("bgTemplateGroup.number", (Object)(typeNumber + ".%"), CompareType.LIKE));
            String numberMask = "((#" + oldSize + ") or (#" + (oldSize + 1) + "))";
            if (oldSize == 0) {
                filter.setMaskString(numberMask);
            } else {
                String oldMaskString = filter.getMaskString();
                if (StringUtils.isEmpty((String)oldMaskString)) {
                    StringBuffer temp = new StringBuffer();
                    for (int i = 0; i < oldSize - 1; ++i) {
                        temp.append("#").append(i).append(" and ");
                    }
                    temp.append("#").append(oldSize - 1);
                    oldMaskString = temp.toString();
                }
                filter.setMaskString("( " + oldMaskString + " ) and " + numberMask);
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionInfo info = new BgPermissionInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPermissionResource", (String)"remove"), (BOSObjectType)info.getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPermissionResource", (String)"remove"), (String)"bgPermission_remove");
        super.actionRemove_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPermissionResource", (String)"isRemoveAll1")) == 0) {
            try {
                BgPermissionInfo info = new BgPermissionInfo();
                IObjectPK pk = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPermissionResource", (String)"removeAll"), (BOSObjectType)info.getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPermissionResource", (String)"removeAll"), (String)"bgPermission_removeAll");
                BgPermissionFactory.getRemoteInstance().removeAll(null);
                LogUtil.afterLog(null, (IObjectPK)pk);
            }
            catch (BOSException ee) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPermissionResource", (String)"removeError"));
            }
        }
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("listUI", this.getUIWindow().getUIObject());
        super.actionAddNew_actionPerformed(e);
    }
}

