/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeObject;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgPermissionSchF7UI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgPermissionSchF7UI
extends AbstractBgPermissionSchF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgPermissionSchF7UI.class);
    private BgSchemeObject result = null;
    private IBgFacade iBgFacade = null;
    private IBgScheme iBgScheme = null;
    private CostCenterOrgUnitInfo companyInfo = null;
    private String[] companyIds = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtn();
        this.initTable();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.inputData();
    }

    private void initBtn() {
        this.btnCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnConfirm.setEnabled(true);
        this.btnConfirm.setVisible(true);
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.setEditable(false);
    }

    private void inputData() {
        try {
            if ((this.companyInfo == null || this.companyInfo.getId() == null) && this.companyIds.length < 1) {
                return;
            }
            BgSchemeCollection bgSchemeCol = null;
            IRow iRow = null;
            if (this.companyIds != null) {
                if (this.companyIds != null && this.companyIds.length > 1) {
                    HashMap<String, Object> subOrgUnitMap = new HashMap<String, Object>();
                    for (int i = 0; i < this.companyIds.length; ++i) {
                        subOrgUnitMap.put(this.companyIds[i], null);
                    }
                    bgSchemeCol = BgPermissionFactory.getRemoteInstance().getSameNumBgScheme(subOrgUnitMap);
                } else if (this.companyIds.length == 1) {
                    bgSchemeCol = this.getIBgScheme().getBgSchemeCollection("where orgUnit.id = '" + this.companyIds[0] + "'");
                }
                if (bgSchemeCol != null && !bgSchemeCol.isEmpty()) {
                    BgSchemeInfo bgSchemeInfo = null;
                    Iterator iter = bgSchemeCol.iterator();
                    while (iter.hasNext()) {
                        bgSchemeInfo = (BgSchemeInfo)iter.next();
                        iRow = this.tblMain.addRow();
                        iRow.getCell("number").setValue((Object)bgSchemeInfo.getNumber());
                        iRow.getCell("name").setValue((Object)bgSchemeInfo.getName());
                        iRow.getCell("id").setValue((Object)bgSchemeInfo.getId().toString());
                        iRow.setUserObject((Object)bgSchemeInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)e.toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        BgSchemeCollection coll = new BgSchemeCollection();
        if (range != null) {
            IRow row = null;
            KDTSelectBlock block = null;
            int blockIndex = 0;
            int blockSize = 0;
            int rowBegin = 0;
            int rowEnd = 0;
            int rowIndex = 0;
            blockSize = range.size();
            for (blockIndex = 0; blockIndex < blockSize; ++blockIndex) {
                block = (KDTSelectBlock)range.get(blockIndex);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    row = this.tblMain.getRow(rowIndex);
                    coll.add((BgSchemeInfo)row.getUserObject());
                }
            }
        }
        this.result = new BgSchemeObject(coll);
        if (this.result == null || this.result.getResult() == null || this.result.getResult().size() < 1) {
            this.result = null;
        }
        this.uiWindow.close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    public BgSchemeObject getResult() {
        return this.result;
    }

    public IBgFacade getIBgFacade() throws Exception {
        if (this.iBgFacade == null) {
            this.iBgFacade = BgFacadeFactory.getRemoteInstance();
        }
        return this.iBgFacade;
    }

    public IBgScheme getIBgScheme() throws Exception {
        if (this.iBgScheme == null) {
            this.iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        return this.iBgScheme;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public void setCompanyInfo(CostCenterOrgUnitInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            BgSchemeCollection coll = new BgSchemeCollection();
            IRow row = null;
            row = this.tblMain.getRow(e.getRowIndex());
            coll.add((BgSchemeInfo)row.getUserObject());
            this.result = new BgSchemeObject(coll);
            if (this.result == null || this.result.getResult() == null || this.result.getResult().size() < 1) {
                this.result = null;
            }
            this.uiWindow.close();
        }
    }
}

