/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIFrame;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.ICellChangeListener;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.util.RptFormulaParser;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFCHelper;
import com.kingdee.eas.ma.budget.BgFPeriodFacadeFactory;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormPeriodData;
import com.kingdee.eas.ma.budget.BgFormPeriodFilterParam;
import com.kingdee.eas.ma.budget.BgFormulaHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemFormulaCHelper;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgFPeriodFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.AbstractBgProcessUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgDefCellEditer;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.BgFormPeriodEditUI;
import com.kingdee.eas.ma.budget.client.BgItemGroupListF7UI;
import com.kingdee.eas.ma.budget.client.BgSelectTransCurrWayUI;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForForm;
import com.kingdee.eas.ma.budget.client.BgTemFormatImportUI;
import com.kingdee.eas.ma.budget.client.BgTransCurrencyFilter2UI;
import com.kingdee.eas.ma.budget.client.BgTransCurrencyFilterUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgProcessUI
extends AbstractBgProcessUI {
    private static final long serialVersionUID = 8174217114162296962L;
    private static final Logger logger = CoreUIObject.getLogger(BgProcessUI.class);
    protected String bgItemFoumulaString = "BgItem";
    protected int paraItem = BgSHelper.paraItem;
    protected int paraPeriod = BgSHelper.paraPeriod;
    protected int paraElement = BgSHelper.paraElement;
    protected int paraDataType = BgSHelper.paraDataType;
    protected int paraCollect = BgSHelper.paraCollect;
    protected int paraCurrency = BgSHelper.paraCurrency;
    protected int decimal = 8;
    protected KDTDefaultCellEditor defEditor = null;
    protected BgFormInfo bgFormInfo = null;
    protected IBgForm ibgForm = null;
    protected IBgFormFacade ibgFormFacade = null;
    protected IBgTemplate ibgTemplate = null;
    protected IFullOrgUnit ifullOrgUnit = null;
    private IBgExamineFacade ibgExamineFacade = null;
    private IBgFPeriodFacade ibgFPeriodFacade = null;
    protected Map before = null;
    protected Map after = null;
    protected Map adjustMap = null;
    protected Map formulaMap = null;
    protected Map currencyMap = null;
    protected Map expressionMap = null;
    protected Map measureMap = null;
    protected Map editorMap = null;
    protected Map alias = null;
    protected CalendarHelper calendarhelper = null;
    protected LongTimeDialog dialog = null;
    private boolean isGatherFormula = false;
    private boolean isGatherEnumErate = false;
    private boolean isGatherEnumErateItem = false;
    private boolean isGatherEnumErateFodian = false;
    private boolean isGatherCell = false;
    private boolean isGatherAdjust = false;
    private boolean isSelectItem = false;
    protected boolean isUpdate = true;
    protected boolean isShowMessage = true;
    protected boolean isCanSave = true;
    protected boolean isAdjustCollect = false;
    protected boolean isProcess = false;
    protected Hashtable ctrlModeMap = new Hashtable();
    protected Hashtable ctrlModeCellMap = new Hashtable();
    protected String formulaStr = null;
    protected String xyPosition = null;
    protected Color backColor = null;
    protected boolean isLockExpression = false;
    private CommonQueryDialog cqDialog = null;
    private BgFormPeriodEditUI filterUI = null;
    private IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    private Object _filterParam = null;
    private String xNum = null;

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("adjust.id"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadBudgetFormInfo();
        this.initSystemOfOther();
        this.loadAllCurrency();
        this.barFormula.setBudget(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCellComment.setIcon(EASResource.getIcon((String)"imgTbtn_monadismpostil"));
        this.btnSheetComment.setIcon(EASResource.getIcon((String)"imgTbtn_formpostil"));
        this.btnRptComment.setIcon(EASResource.getIcon((String)"imgTbtn_reportpostil"));
        this.btnCtrlSet.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnCtrlView.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnBgExamineCheck.setIcon(this.btnCheckFormula.getIcon());
        this.btnCellComment.setIsControlByParent(false);
        this.btnSheetComment.setIsControlByParent(false);
        this.btnRptComment.setIsControlByParent(false);
        this.btnCellComment.setTextIconDisStyle((short)3);
        this.btnSheetComment.setTextIconDisStyle((short)3);
        this.btnRptComment.setTextIconDisStyle((short)3);
        this.btnCellComment.setText(this.btnCellComment.getToolTipText());
        this.btnSheetComment.setText(this.btnSheetComment.getToolTipText());
        this.btnRptComment.setText(this.btnRptComment.getToolTipText());
        this.btnCheckCurrentPage.setText(this.btnCheckCurrentPage.getToolTipText());
        this.itemBudgetFormulaFill.setIcon(EASResource.getIcon((String)"imgTbtn_citecompany"));
        this.itemBgFormulaAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.itemBgFormulaAddCol.setIcon(EASResource.getIcon((String)"imgTbtn_inserttotiers"));
        this.itemBgFormulaAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.itemBgFormulaRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.itemMenuItemManager.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.menuDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.itemAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.itemAddCol.setIcon(EASResource.getIcon((String)"imgTbtn_inserttotier"));
        this.itemAddMultiCols.setIcon(EASResource.getIcon((String)"imgTbtn_inserttotiers"));
        this.menuAddComment.setIcon(EASResource.getIcon((String)"imgTbtn_postil"));
        this.itemAddCellComment.setIcon(EASResource.getIcon((String)"imgTbtn_monadismpostil"));
        this.itemAddSheetComment.setIcon(EASResource.getIcon((String)"imgTbtn_formpostil"));
        this.itemAddRptComment.setIcon(EASResource.getIcon((String)"imgTbtn_reportpostil"));
        this.itemImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.itemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemCollectForm.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemCollectView.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.itemBgExamineCheck.setIcon(this.btnCheckFormula.getIcon());
        this.menuItemBgPeriodEdit.setIcon(EASResource.getIcon((String)"imgTbtn_courseweave"));
        this.menuItemTransCurrency.setIcon(EASResource.getIcon((String)"imgTbtn_currencyconversion"));
        if (!BgParamCHelper.isFodian()) {
            this.btnSelectBgItem.setEnabled(false);
            this.btnSelectBgItem.setVisible(false);
            this.btnSelectContract.setEnabled(false);
            this.btnSelectContract.setVisible(false);
            this.itemSelectBgItem.setEnabled(false);
            this.itemSelectBgItem.setVisible(false);
            this.itemSelectContract.setEnabled(false);
            this.itemSelectContract.setVisible(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (UIFrame.class.isAssignableFrom(this.getUIWindow().getClass())) {
            KDFrame kf = (KDFrame)this.getUIWindow();
            kf.removeToolBar((JToolBar)this.kb);
        }
        if (this.getUIWindow() instanceof KDDialog) {
            ((KDDialog)this.getUIWindow()).setResizable(true);
        }
        this.pnlTables.getCurrentPage().getSelectManager().select(0, 0, 0, 0);
        this.getModifyingManager().setModifiedCount(0);
        if (this.getUIContext().get("IS_COLLECT") != null) {
            this.getModifyingManager().addModifiedCount(1L);
        }
    }

    protected void loadBudgetFormInfo() {
        if (this.editDataUI != null) {
            this.editData = (BgFormInfo)this.editDataUI.getEditDataObject();
            this.bgFormInfo = (BgFormInfo)this.editData;
        }
    }

    protected void initSystemOfOther() {
        this.btnReplaceGroup.add((AbstractButton)this.itemRadReplace);
        this.btnReplaceGroup.add((AbstractButton)this.itemRadMearReplace);
        this.itemRadMearReplace.setSelected(true);
        this.btnProcessGroup.add((AbstractButton)this.itemRadValue);
        this.btnProcessGroup.add((AbstractButton)this.itemRadExpressions);
        this.btnProcessGroup.add((AbstractButton)this.itemRadAll);
        this.itemRadValue.setSelected(true);
        this.bgSheetParamGroup.add((AbstractButton)this.itemAutoCreateFormula);
        this.bgSheetParamGroup.add((AbstractButton)this.itemManualCreateFormula);
        if (this.calendarhelper == null) {
            this.calendarhelper = new CalendarHelper();
        }
        if (this.bgFormInfo.getBgTemplate() != null && this.bgFormInfo.getBgTemplate().getCanModify() != null) {
            if (this.bgFormInfo.getBgTemplate().getCanModify().getValue() == 2) {
                this.isUpdate = false;
            }
            if (this.bgFormInfo.getBgTemplate().getCanModify().getValue() == 3) {
                this.isUpdate = false;
                this.btnFormat.setVisible(false);
                this.btnAddBgItem.setVisible(false);
                this.btnAddBgElement.setVisible(false);
                this.btnAddBgPeriod.setVisible(false);
                this.btnAddCurrency.setVisible(false);
                this.btnSelectBgItem.setVisible(false);
                this.btnSelectContract.setVisible(false);
                this.itemAddRow.setVisible(false);
                this.itemAddMultiRows.setVisible(false);
                this.itemAddCol.setVisible(false);
                this.itemAddMultiCols.setVisible(false);
                this.itemDelCell.setVisible(false);
                this.itemDelCol.setVisible(false);
                this.itemDelRow.setVisible(false);
                this.itemCut.setVisible(false);
                this.itemPaste.setVisible(false);
                this.itemSelectBgItem.setVisible(false);
                this.itemSelectContract.setVisible(false);
                this.menuBgItem.setVisible(false);
                this.menuDelete.setVisible(false);
                this.actionFormatCell.setEnabled(false);
                this.actionAddBgItem.setEnabled(false);
                this.actionAddBgElement.setEnabled(false);
                this.actionAddBgPeriod.setEnabled(false);
                this.actionAddCurrency.setEnabled(false);
                this.actionInsertRow.setEnabled(false);
                this.actionInsertCol.setEnabled(false);
                this.actionEditDeletCell.setEnabled(false);
                this.actionEditDeletCol.setEnabled(false);
                this.actionEditDeletRow.setEnabled(false);
                this.actionSelectBgItem.setEnabled(false);
                this.actionSelectContract.setEnabled(false);
                this.actionBgFormulaAddNew.setEnabled(false);
                this.actionBgFormulaRemove.setEnabled(false);
                this.actionCreateFormula.setEnabled(false);
                this.actionBgFormulaFill.setEnabled(false);
                this.itemRCCut.setVisible(false);
                this.itemRCPaste.setVisible(false);
                this.itemRCInsert.setVisible(false);
                this.itemRCDelet.setVisible(false);
                this.itemRCFormat.setVisible(false);
                this.itemBgItemAddNew.setVisible(false);
                this.itemBgItemRemove.setVisible(false);
                this.itemCreateFormula.setVisible(false);
            }
        }
        this.isLockExpression = BgParamCHelper.isLockedOfOpen();
    }

    private void loadAllCurrency() throws Exception {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            if (this.currencyMap == null) {
                this.currencyMap = new HashMap();
            }
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
    }

    protected IBgForm getFormInterface() throws Exception {
        if (this.ibgForm == null) {
            this.ibgForm = BgFormFactory.getRemoteInstance();
        }
        return this.ibgForm;
    }

    protected IBgFormFacade getFormFacadeInterface() throws Exception {
        if (this.ibgFormFacade == null) {
            this.ibgFormFacade = BgFormFacadeFactory.getRemoteInstance();
        }
        return this.ibgFormFacade;
    }

    protected IBgExamineFacade getExamineInterface() throws Exception {
        if (this.ibgExamineFacade == null) {
            this.ibgExamineFacade = BgExamineFacadeFactory.getRemoteInstance();
        }
        return this.ibgExamineFacade;
    }

    protected IBgFPeriodFacade getBgFPEInterface() throws Exception {
        if (this.ibgFPeriodFacade == null) {
            this.ibgFPeriodFacade = BgFPeriodFacadeFactory.getRemoteInstance();
        }
        return this.ibgFPeriodFacade;
    }

    protected void loadDiversityInfo() throws Exception {
    }

    public void actionInsertItem_actionPerformed(ActionEvent e) throws Exception {
        this.barFormula.pickItemFormula(this.bgItemFoumulaString, (CoreUIObject)this);
        this.processItemAddNew(this.pnlTables.getFoucusCell());
    }

    public void actionFormatSheetName_actionPerformed(ActionEvent e) throws Exception {
        int index = this.pnlTables.getSelectedSheetIndex();
        if (index == -1) {
            return;
        }
        String oldName = this.pnlTables.getSheetTitleAt(index);
        String newName = this.pnlTables.renamePage(index, null, (Object)this);
        this.getSchemaComp().notifyRenameSheet(oldName, newName);
        this.getModifyingManager().incModifiedCount();
    }

    public void actionEditDeletRow_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        ICell cell = null;
        RptCell rptCell = null;
        KDTSelectBlock block = null;
        KDTable table = this.pnlTables.getCurrentPage();
        KDTRange range = table.getSelectManager().toRange();
        int colCount = table.getExpandedColumnCount();
        if (range == null) {
            throw new BgAdjustException(BgAdjustException.SELECTDELETEROW);
        }
        int rangeSize = range.size();
        int rowIndex = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (int i = 0; i < rangeSize; ++i) {
            block = (KDTSelectBlock)range.get(i);
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                row = table.getRow(rowIndex);
                rowIndexs.add(new Integer(rowIndex));
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = row.getCell(colIndex);
                    if (!this.checkHasFormulaOfCell(cell) || this.checkFormulaOfCellIsHasEdit(rptCell = (RptCell)cell.getUserObject())) continue;
                    throw new BgAdjustException(BgAdjustException.DELETEROWERROR);
                }
            }
        }
        int rowCount = rowIndexs.size();
        int[] rowInt = new int[rowCount];
        int in = rowCount;
        for (int i = 0; i < in; ++i) {
            rowInt[i] = (Integer)rowIndexs.get(i);
        }
        Arrays.sort(rowInt);
        for (int j = rowInt.length - 1; j >= 0; --j) {
            rowIndex = rowInt[j];
            table.removeRow(rowIndex);
        }
        table.getSelectManager().select(rowIndex, 0, rowIndex, 0);
        this.getModifyingManager().addModifiedCount(1L);
    }

    public void actionEditDeletCol_actionPerformed(ActionEvent e) throws Exception {
        ICell cell = null;
        RptCell rptCell = null;
        KDTSelectBlock block = null;
        KDTable table = this.pnlTables.getCurrentPage();
        KDTRange range = table.getSelectManager().toRange();
        int rowCount = table.getExpandedRowCount();
        if (range == null) {
            throw new BgAdjustException(BgAdjustException.SELECTDELETEROW);
        }
        int rangeSize = range.size();
        int colIndex = 0;
        int colBegin = 0;
        int colEnd = 0;
        ArrayList<Integer> colIndexs = new ArrayList<Integer>();
        for (int i = 0; i < rangeSize; ++i) {
            block = (KDTSelectBlock)range.get(i);
            colBegin = block.getBeginCol();
            colEnd = block.getEndCol();
            for (colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                colIndexs.add(new Integer(colIndex));
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    cell = table.getCell(rowIndex, colIndex);
                    if (!this.checkHasFormulaOfCell(cell) || this.checkFormulaOfCellIsHasEdit(rptCell = (RptCell)cell.getUserObject())) continue;
                    throw new BgAdjustException(BgAdjustException.DELETEROWERROR);
                }
            }
        }
        int colCount = colIndexs.size();
        int[] colInt = new int[colCount];
        int in = colCount;
        for (int i = 0; i < in; ++i) {
            colInt[i] = (Integer)colIndexs.get(i);
        }
        Arrays.sort(colInt);
        for (int j = colInt.length - 1; j >= 0; --j) {
            colIndex = colInt[j];
            table.removeColumn(colIndex);
        }
        table.getSelectManager().select(0, colIndex, 0, colIndex);
        this.getModifyingManager().addModifiedCount(1L);
    }

    protected void processDealExpression() {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.pnlTables.addCellChangeListener(new ICellChangeListener(){

                public void onCellChanged(ICell cell) {
                    BgProcessUI.this.table_onCellChanged(cell);
                }
            });
        }
    }

    protected void table_onCellChanged(ICell cell) {
    }

    protected String[] getFormulaInfo(Map map, String formulaString) {
        if (map == null || formulaString == null) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        if (map != null && map.containsKey(formulaString)) {
            parameter = (String[])map.get(formulaString);
        } else {
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                map.put(formulaString, parameter);
                formulaHint.clear();
            }
        }
        return parameter;
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object svalue) {
        if (svalue == null) {
            return super.formatCellDisplay(rowIndex, colIndex, cell, svalue);
        }
        DecimalFormat decFormat = null;
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            String formulaString = rptCell.getItemFormulaLine();
            if ((formulaString == null || formulaString.trim().length() == 0) && rptCell.getItemFormula() != null) {
                formulaString = rptCell.getItemFormula().getExt("COLLECT_FORMULA");
            }
            if (formulaString != null && formulaString.trim().length() > 0) {
                int precision = 0;
                BigDecimal measure = BgConstants.ONE;
                BigDecimal value = null;
                String currencyNumber = null;
                CurrencyInfo currencyInfo = null;
                String[] parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                if (parameter != null && parameter[this.paraElement] != null && parameter[this.paraElement].trim().length() > 0) {
                    if (this.measureMap.containsKey(parameter[this.paraElement])) {
                        BgMeasureUnitInfo muInfo = (BgMeasureUnitInfo)this.measureMap.get(parameter[this.paraElement]);
                        measure = muInfo.getMeasureUnit().getCoefficient();
                    } else if (this.bgFormInfo.getMeasureUnit() != null) {
                        measure = this.bgFormInfo.getMeasureUnit().getCoefficient();
                    }
                }
                if (this.currencyMap.containsKey(currencyNumber = parameter != null && parameter[this.paraCurrency] != null && parameter[this.paraCurrency].trim().length() > 0 ? parameter[this.paraCurrency] : this.bgFormInfo.getCurrency().getNumber())) {
                    currencyInfo = (CurrencyInfo)this.currencyMap.get(currencyNumber);
                    precision = currencyInfo.getPrecision();
                } else {
                    precision = this.decimal;
                }
                String text = null;
                decFormat = null;
                try {
                    value = new BigDecimal(svalue.toString().replaceAll(",", "")).divide(measure, 8, 4);
                    precision = BgFCHelper.getDigitOfNumber(cell, value, precision);
                    decFormat = precision != 0 ? new DecimalFormat("#,##0." + BgFormHelper.getNumberFormat("0", precision)) : new DecimalFormat("#,##0");
                    text = decFormat.format(value.doubleValue());
                }
                catch (Exception ex) {
                    text = svalue.toString();
                }
                return super.formatCellDisplay(rowIndex, colIndex, cell, (Object)text);
            }
        }
        if (BgSHelper.isNumerical(cell.getValue()) && this.bgFormInfo.getMeasureUnit() != null) {
            String text = null;
            BigDecimal value = null;
            if (BgFCHelper.isNumericalOfCell(cell)) {
                int precision = this.bgFormInfo.getCurrency().getPrecision();
                BigDecimal measure = this.bgFormInfo.getMeasureUnit().getCoefficient();
                try {
                    value = new BigDecimal(svalue.toString().replaceAll(",", "")).divide(measure, 8, 4);
                    precision = BgFCHelper.getDigitOfNumber(cell, value, precision);
                    decFormat = precision != 0 ? new DecimalFormat("#,##0." + BgFormHelper.getNumberFormat("0", precision)) : new DecimalFormat("#,##0");
                    text = decFormat.format(value.doubleValue());
                }
                catch (Exception ex) {
                    text = svalue.toString();
                }
            } else {
                if (Pattern.matches("[\\-]{0,1}[0-9]+\\.[0]*", svalue.toString())) {
                    text = svalue.toString().substring(0, svalue.toString().indexOf("."));
                } else if (Pattern.matches("[\\-]{0,1}[0-9]+\\.[0]*[0-9]+[0]*", svalue.toString())) {
                    text = svalue.toString();
                    int index = text.length();
                    int i = text.length() - 1;
                    while (i >= 0 && text.substring(i, i + 1).equals("0")) {
                        index = i--;
                    }
                    text = text.substring(0, index);
                } else {
                    text = svalue.toString();
                }
                cell.setEditor(null);
                if (this.alias != null) {
                    this.alias.remove(TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex()));
                }
            }
            return super.formatCellDisplay(rowIndex, colIndex, cell, (Object)text);
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, svalue);
    }

    public void processCellOfFormatInput(ICell cell, String currencyNumber) {
        if (cell == null) {
            return;
        }
        String formulaString = null;
        String[] parameter = null;
        formulaString = BgFSHelper.getFormulaOfCell(cell);
        parameter = this.getFormulaInfo(this.formulaMap, formulaString);
        if (parameter[this.paraElement] != null && parameter[this.paraElement].trim().length() > 0) {
            if (this.measureMap.containsKey(parameter[this.paraElement])) {
                this.processCellOfBgFormEditor(cell, parameter[this.paraElement], false);
            } else {
                this.processCellOfBgFormEditor(cell, parameter[this.paraElement], true);
            }
        } else {
            this.processCellOfDefEditor(cell);
        }
    }

    public void processCellOfOtherInput(ICell cell) {
        RptCell rptCell;
        if (cell == null) {
            return;
        }
        boolean isProcess = true;
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && (rptCell = (RptCell)cell.getUserObject()).getItemFormula() != null) {
            String formulaString = rptCell.getItemFormula().getExt("COLLECT_FORMULA");
            if (formulaString != null && formulaString.trim().length() > 0) {
                String[] parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                if (parameter[this.paraElement] != null && parameter[this.paraElement].trim().length() > 0) {
                    if (this.measureMap.containsKey(parameter[this.paraElement])) {
                        this.processCellOfBgFormEditor(cell, parameter[this.paraElement], false);
                    } else {
                        this.processCellOfBgFormEditor(cell, parameter[this.paraElement], true);
                    }
                } else {
                    this.processCellOfDefEditor(cell);
                }
                isProcess = false;
            } else {
                String linkForm = rptCell.getItemFormula().getExt("BG_BUDGET_Form");
                if (linkForm != null && linkForm.length() > 0) {
                    isProcess = false;
                }
            }
        }
        if (isProcess) {
            String cellEle = "CELL_MEASUNIT";
            if (BgSHelper.isNumerical(cell.getValue())) {
                if (BgFCHelper.isNumericalOfCell(cell)) {
                    this.processCellOfBgFormEditor(cell, cellEle, true);
                } else {
                    cell.setEditor(null);
                    String text = cell.getValue().toString();
                    if (Pattern.matches("[\\-]{0,1}[0-9]+\\.[0]*", text.toString())) {
                        text = text.substring(0, text.indexOf("."));
                    } else if (Pattern.matches("[\\-]{0,1}[0-9]+\\.[0]*[0-9]+[0]*", text)) {
                        int index = text.length();
                        int i = text.length() - 1;
                        while (i >= 0 && text.substring(i, i + 1).equals("0")) {
                            index = i--;
                        }
                        text = text.substring(0, index);
                    }
                    cell.setValue((Object)text);
                }
            } else {
                cell.setEditor(null);
            }
        }
    }

    public void processCellOfDefEditor(ICell cell) {
        if (this.defEditor == null) {
            KDFormattedTextField formattedTextField = new KDFormattedTextField();
            formattedTextField.setDataType(1);
            formattedTextField.setPrecision(this.decimal);
            formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
            this.defEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        }
        cell.setEditor((ICellEditor)this.defEditor);
    }

    public void processCellOfBgFormEditor(ICell cell, String bgElementNumber, boolean isCell) {
        int precision = this.decimal;
        BgMeasureUnitInfo muInfo = (BgMeasureUnitInfo)this.measureMap.get(bgElementNumber);
        if (this.editorMap.containsKey(bgElementNumber)) {
            cell.setEditor((ICellEditor)this.editorMap.get(bgElementNumber));
        } else {
            KDFormattedTextField formattedTextField = new KDFormattedTextField();
            formattedTextField.setDataType(1);
            formattedTextField.setPrecision(this.decimal);
            formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
            BgDefCellEditer bgCellEditor = null;
            if (isCell) {
                if (this.bgFormInfo.getMeasureUnit() != null) {
                    bgCellEditor = new BgDefCellEditer((JFormattedTextField)formattedTextField, this.bgFormInfo.getMeasureUnit().getCoefficient(), precision);
                }
            } else {
                bgCellEditor = new BgDefCellEditer((JFormattedTextField)formattedTextField, muInfo.getMeasureUnit().getCoefficient(), precision);
            }
            cell.setEditor(bgCellEditor);
            this.editorMap.put(bgElementNumber, bgCellEditor);
        }
    }

    public boolean checkFormulaOfCellIsHasEdit(RptCell rptCell) {
        if (rptCell == null) {
            return true;
        }
        boolean re = true;
        if (rptCell.getItemFormula().getExt("BGITEM_CANUPDATE") == null) {
            rptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "true");
            return true;
        }
        if (rptCell.getItemFormula().getExt("BGITEM_CANUPDATE").equals("false")) {
            re = false;
        } else if (rptCell.getItemFormula().getExt("BGITEM_CANUPDATE").equals("true")) {
            re = true;
        }
        return re;
    }

    public void setFormulaOfCellCantEdit(ICell cell, boolean isUpdate) {
        RptCell rptCell;
        if (this.checkHasFormulaOfCell(cell) && (rptCell = (RptCell)cell.getUserObject()).getItemFormula() != null) {
            if (isUpdate) {
                rptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "true");
            } else {
                rptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "false");
            }
        }
    }

    public String getFormulaOfCell(ICell curCell) {
        ICell cell = null;
        cell = curCell == null ? this.pnlTables.getFoucusCell() : curCell;
        if (cell != null && cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            String formulaString = rptCell.getItemFormulaLine();
            if (formulaString != null && formulaString.trim().length() > 0) {
                return formulaString;
            }
            return null;
        }
        return null;
    }

    public boolean checkHasFormulaOfCell(ICell curCell) {
        String formulaString = this.getFormulaOfCell(curCell);
        return formulaString != null;
    }

    public String subDealFormula(CodeExpr codeExpr, BgFormInfo bgFormInfo) {
        String bgPeriodNumber = null;
        if (bgFormInfo != null) {
            bgPeriodNumber = bgFormInfo.getBgPeriod().getNumber();
        }
        if (codeExpr instanceof BinaryOpExpr) {
            BinaryOpExpr bo = (BinaryOpExpr)codeExpr;
            this.subDealFormula(bo.left, bgFormInfo);
            this.subDealFormula(bo.right, bgFormInfo);
        } else if (codeExpr instanceof MethodInvokeExpr) {
            String funcName = ((MethodInvokeExpr)codeExpr).methodName;
            List params = ((MethodInvokeExpr)codeExpr).paramList;
            boolean isContinue = true;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) == null) continue;
                if (params.get(i) instanceof BinaryOpExpr) {
                    isContinue = false;
                    BinaryOpExpr bo = (BinaryOpExpr)params.get(i);
                    this.subDealFormula(bo.left, bgFormInfo);
                    this.subDealFormula(bo.right, bgFormInfo);
                    continue;
                }
                if (!(params.get(i) instanceof MethodInvokeExpr)) continue;
                isContinue = false;
                MethodInvokeExpr method = (MethodInvokeExpr)params.get(i);
                String funcName1 = method.methodName;
                List params1 = method.paramList;
                this.subDealParam(params1, funcName1, bgPeriodNumber, codeExpr);
            }
            if (isContinue) {
                this.subDealParam(params, funcName, bgPeriodNumber, codeExpr);
            }
        }
        return codeExpr.toString();
    }

    public void subDealParam(List params, String funcName, String bgPeriodNumber, CodeExpr codeExpr) {
        CodeExpr param1;
        String result;
        boolean isContinue = true;
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i) == null) continue;
            if (params.get(i) instanceof BinaryOpExpr) {
                isContinue = false;
                BinaryOpExpr bo = (BinaryOpExpr)params.get(i);
                this.subDealFormula(bo.left, this.bgFormInfo);
                this.subDealFormula(bo.right, this.bgFormInfo);
                continue;
            }
            if (!(params.get(i) instanceof MethodInvokeExpr)) continue;
            isContinue = false;
            MethodInvokeExpr method = (MethodInvokeExpr)params.get(i);
            String funcName1 = method.methodName;
            List params1 = method.paramList;
            this.subDealParam(params1, funcName1, bgPeriodNumber, codeExpr);
        }
        if (!isContinue) {
            return;
        }
        if (params != null && params.size() == 6 && funcName != null && funcName.equalsIgnoreCase("BgActual")) {
            String endPeriod;
            String beginPeriod;
            String currency;
            String org;
            CodeExpr param0 = (CodeExpr)params.get(0);
            CodeExpr param3 = (CodeExpr)params.get(3);
            CodeExpr param4 = (CodeExpr)params.get(4);
            CodeExpr param5 = (CodeExpr)params.get(5);
            if (param0 instanceof StringExpr && ((org = ((StringExpr)param0).text) == null || org.equals(""))) {
                ((StringExpr)param0).text = this.bgFormInfo.getOrgUnit().getNumber();
            }
            if (param3 instanceof StringExpr && ((currency = ((StringExpr)param3).text) == null || currency.equals(""))) {
                ((StringExpr)param3).text = this.bgFormInfo.getCurrency().getNumber();
            }
            if (param4 instanceof StringExpr && ((beginPeriod = ((StringExpr)param4).text) == null || beginPeriod.equals(""))) {
                ((StringExpr)param4).text = bgPeriodNumber;
            }
            if (param5 instanceof StringExpr && ((endPeriod = ((StringExpr)param5).text) == null || endPeriod.equals(""))) {
                ((StringExpr)param5).text = bgPeriodNumber;
            }
        } else if (params != null && params.size() == 7 && funcName != null && (funcName.equalsIgnoreCase("BgFormula") || funcName.equalsIgnoreCase("BgAct") || funcName.equalsIgnoreCase("BgBal") || funcName.equalsIgnoreCase("BgActualS"))) {
            String endPeriod;
            String beginPeriod;
            String currency;
            String scheme;
            String org;
            CodeExpr param0 = (CodeExpr)params.get(0);
            result = BgClientHelper.rebuildExpressionForm(param0.toString(), (MethodInvokeExpr)codeExpr, this.bgFormInfo);
            if (!result.equals("")) {
                // empty if block
            }
            param1 = (CodeExpr)params.get(1);
            CodeExpr param4 = (CodeExpr)params.get(4);
            CodeExpr param5 = (CodeExpr)params.get(5);
            CodeExpr param6 = (CodeExpr)params.get(6);
            if (param0 instanceof StringExpr && ((org = ((StringExpr)param0).text) == null || org.equals(""))) {
                ((StringExpr)param0).text = this.bgFormInfo.getOrgUnit().getNumber();
            }
            if (param1 instanceof StringExpr && ((scheme = ((StringExpr)param1).text) == null || scheme.equals(""))) {
                ((StringExpr)param1).text = this.bgFormInfo.getBgScheme().getNumber();
            }
            if (param4 instanceof StringExpr && ((currency = ((StringExpr)param4).text) == null || currency.equals(""))) {
                ((StringExpr)param4).text = this.bgFormInfo.getCurrency().getNumber();
            }
            if (param5 instanceof StringExpr && ((beginPeriod = ((StringExpr)param5).text) == null || beginPeriod.equals(""))) {
                ((StringExpr)param5).text = bgPeriodNumber;
            }
            if (param6 instanceof StringExpr && ((endPeriod = ((StringExpr)param6).text) == null || endPeriod.equals(""))) {
                ((StringExpr)param6).text = bgPeriodNumber;
            }
        } else if (params != null && params.size() == 8 && funcName != null && funcName.equalsIgnoreCase("Acct")) {
            String endPeriod;
            String beginPeriod;
            CodeExpr param3 = (CodeExpr)params.get(3);
            CodeExpr param4 = (CodeExpr)params.get(4);
            CodeExpr param5 = (CodeExpr)params.get(5);
            CodeExpr param6 = (CodeExpr)params.get(6);
            String currYear = null;
            String currBMonth = null;
            String currEMonth = null;
            if (this.bgFormInfo != null && this.bgFormInfo.getBgPeriod() != null) {
                BgPeriodInfo bgPeriodInfo = this.bgFormInfo.getBgPeriod();
                if (this.calendarhelper == null) {
                    this.calendarhelper = new CalendarHelper();
                }
                currYear = String.valueOf(this.bgFormInfo.getBgPeriod().getYear());
                currBMonth = String.valueOf(this.calendarhelper.getCurrentlyMonth(bgPeriodInfo.getBeginDate()));
                currEMonth = String.valueOf(this.calendarhelper.getCurrentlyMonth(bgPeriodInfo.getEndDate()));
            }
            if (param3 instanceof IntExpr && ((beginPeriod = ((IntExpr)param3).text) == null || beginPeriod.trim().length() == 0 || beginPeriod.trim().equals("0"))) {
                String string = ((IntExpr)param3).text = currYear == null ? "0" : currYear;
            }
            if (param4 instanceof IntExpr && ((beginPeriod = ((IntExpr)param4).text) == null || beginPeriod.trim().length() == 0 || beginPeriod.trim().equals("0"))) {
                String string = ((IntExpr)param4).text = currBMonth == null ? "0" : currBMonth;
            }
            if (param5 instanceof IntExpr && ((endPeriod = ((IntExpr)param5).text) == null || endPeriod.trim().length() == 0 || endPeriod.trim().equals("0"))) {
                String string = ((IntExpr)param5).text = currYear == null ? "0" : currYear;
            }
            if (param6 instanceof IntExpr && ((endPeriod = ((IntExpr)param6).text) == null || endPeriod.trim().length() == 0 || endPeriod.trim().equals("0"))) {
                ((IntExpr)param6).text = currEMonth == null ? "0" : currEMonth;
            }
        } else if (params != null && params.size() == 6 && funcName != null && funcName.equalsIgnoreCase("bgRefBgTem")) {
            String period;
            String scheme;
            String org;
            CodeExpr param0 = (CodeExpr)params.get(0);
            result = BgClientHelper.rebuildExpressionForm1(param0.toString(), (MethodInvokeExpr)codeExpr, this.bgFormInfo);
            if (!result.equals("")) {
                // empty if block
            }
            param1 = (CodeExpr)params.get(1);
            CodeExpr param3 = (CodeExpr)params.get(3);
            String periodNumber = "";
            String schemeNumber = "";
            String orgNumber = "";
            if (this.bgFormInfo != null && this.bgFormInfo.getBgPeriod() != null) {
                periodNumber = this.bgFormInfo.getBgPeriod().getNumber();
                schemeNumber = this.bgFormInfo.getBgScheme().getNumber();
                orgNumber = this.bgFormInfo.getOrgUnit().getNumber();
            }
            if (param0 instanceof StringExpr && ((org = ((StringExpr)param0).text) == null || org.trim().length() == 0)) {
                ((StringExpr)param0).text = orgNumber;
            }
            if (param1 instanceof StringExpr && ((scheme = ((StringExpr)param1).text) == null || scheme.trim().length() == 0)) {
                ((StringExpr)param1).text = schemeNumber;
            }
            if (param3 instanceof StringExpr && ((period = ((StringExpr)param3).text) == null || period.trim().length() == 0)) {
                ((StringExpr)param3).text = periodNumber;
            }
        }
    }

    public void aliasCellOfFormula(Map aliasMap) {
        if (aliasMap == null) {
            aliasMap = new HashMap();
        }
        ICell cell = null;
        RptCell rptCell = null;
        String formulaString = null;
        KDTable table = this.pnlTables.getCurrentPage();
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                cell = table.getCell(rowIndex, colIndex);
                if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                rptCell = (RptCell)cell.getUserObject();
                formulaString = rptCell.getItemFormulaLine();
                if (rptCell.getItemFormula() != null && (rptCell.getItemFormula().getExt("BG_BUDGET_Form") != null || rptCell.getItemFormula().getExt("BG_LINK_Template_Id") != null)) {
                    cell.getStyleAttributes().setFontColor(Color.blue);
                    cell.getStyleAttributes().setUnderline(true);
                }
                if (StringUtils.isEmpty((String)formulaString) || aliasMap.containsKey(formulaString)) continue;
                aliasMap.put(rowIndex + "_" + colIndex, null);
            }
        }
    }

    @Override
    public void actionBgItemManager_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgItemManager_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgItemGroupListF7UI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionBudgetFormulaFill_actionPerformed(ActionEvent e) throws Exception {
        super.actionBudgetFormulaFill_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormatImportUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionBgFormulaAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgFormulaAddRow_actionPerformed(e);
        BgFormulaHelper.processAddItemRowFormula((Object)this, this.pnlTables.getCurrentPage(), this.bgFormInfo);
        this.getModifyingManager().addModifiedCount(1L);
    }

    @Override
    public void actionBgFormulaAddCol_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgFormulaAddCol_actionPerformed(e);
        BgFormulaHelper.processAddItemColFormula((Object)this, this.pnlTables.getCurrentPage(), this.bgFormInfo);
        this.getModifyingManager().addModifiedCount(1L);
    }

    @Override
    public void actionBgFormulaAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgFormulaAddNew_actionPerformed(e);
        this.actionInsertItem_actionPerformed(e);
        this.getModifyingManager().addModifiedCount(1L);
    }

    @Override
    public void actionBgFormulaRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgFormulaRemove_actionPerformed(e);
        int re = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"isRemoveFormula"));
        if (re == 1 || re == 2) {
            return;
        }
        AdvMsgBox msgBox = AdvMsgBox.createAdvMsgBox((Component)((Object)this), (String)EASResource.getString((String)"promotInfoBox"), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"isRemoveValue"), null, (int)3, (int)8189);
        msgBox.show();
        int delValue = msgBox.getResult();
        int i = 0;
        int n = 0;
        int r = 0;
        int c = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        KDTable table = null;
        ICell cell = null;
        RptCell rptCell = null;
        KDTSelectBlock block = null;
        String formulaString = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        table = this.pnlTables.getCurrentPage();
        KDTRange range = table.getSelectManager().toRange();
        n = range.size();
        for (i = 0; i < n; ++i) {
            block = (KDTSelectBlock)range.get(i);
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            colBegin = block.getBeginCol();
            colEnd = block.getEndCol();
            for (r = rowBegin; r <= rowEnd; ++r) {
                for (c = colBegin; c <= colEnd; ++c) {
                    cell = table.getCell(r, c);
                    if (!this.checkHasFormulaOfCell(cell)) continue;
                    rptCell = (RptCell)cell.getUserObject();
                    formulaString = this.getFormulaOfCell(cell);
                    formulaList.add(formulaString);
                    if (this.checkFormulaOfCellIsHasEdit(rptCell)) continue;
                    table.getSelectManager().select(r, c, r, c);
                    throw new BgFormException(BgFormException.ISREMOVEOLDFORMULA);
                }
            }
        }
        n = range.size();
        for (i = 0; i < n; ++i) {
            block = (KDTSelectBlock)range.get(i);
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            colBegin = block.getBeginCol();
            colEnd = block.getEndCol();
            for (r = rowBegin; r <= rowEnd; ++r) {
                for (c = colBegin; c <= colEnd; ++c) {
                    cell = table.getCell(r, c);
                    if (BgFSHelper.checkHasFormulaOfCell(cell)) {
                        this.beforeFormulaRemove(cell, formulaString);
                        if (delValue == 0) {
                            cell.setValue(null);
                        }
                        cell.setUserObject(null);
                        cell.setEditor(null);
                        cell.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
                        this.afterFormulaRemove(cell, formulaString);
                        continue;
                    }
                    if (delValue == 0) {
                        cell.setValue(null);
                    }
                    cell.setUserObject(null);
                    cell.setEditor(null);
                }
            }
        }
        n = formulaList.size();
        for (i = 0; i < n; ++i) {
            formulaString = (String)formulaList.get(i);
            if (this.adjustMap == null || !this.adjustMap.containsKey(formulaString)) continue;
            this.adjustMap.remove(formulaString);
        }
        this.getModifyingManager().addModifiedCount(1L);
    }

    protected void beforeFormulaRemove(ICell cell, String formulaString) {
    }

    protected void afterFormulaRemove(ICell cell, String formulaString) {
    }

    protected void processItemAddNew(ICell cell) throws Exception {
        RptCell rptCell;
        String formulaString;
        this.checkBudgetFormula(cell, true);
        if (cell.getUserObject() instanceof RptCell && (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) != null && formulaString.trim().length() > 0) {
            rptCell.getItemFormula().putExt("Bg_ItemFormula_From_BgForm", "true");
        }
    }

    protected String[] checkBudgetFormula(ICell cell, boolean isFillUpdate) throws Exception {
        String[] parameter = null;
        if (cell == null || cell.getUserObject() == null) {
            return parameter;
        }
        if (cell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            String formulaString = rptCell.getItemFormulaLine();
            if (formulaString == null || formulaString.trim().length() == 0) {
                return parameter;
            }
            this.processCellOfFormatInput(cell, null);
            parameter = this.getFormulaInfo(this.formulaMap, formulaString);
            boolean isLoad = false;
            if (parameter == null) {
                throw new BgFormException(BgFormException.FORMULAADDERROR);
            }
            if (parameter[this.paraItem] == null) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, new String[]{formulaString});
            }
            boolean isRelativeBgPeriod = false;
            int relativeValue = 0;
            try {
                relativeValue = Integer.parseInt(parameter[this.paraPeriod]);
                isRelativeBgPeriod = true;
            }
            catch (NumberFormatException e) {
                isRelativeBgPeriod = false;
            }
            if (isRelativeBgPeriod && Math.abs(relativeValue) > 100) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"257_BgFormProcessUI"));
                SysUtil.abort();
            }
            if (isRelativeBgPeriod && isFillUpdate) {
                try {
                    parameter[this.paraPeriod] = BgHelper.getRelativeBgPeriod(null, this.bgFormInfo.getBgPeriod().getNumber(), relativeValue);
                    isLoad = true;
                }
                catch (BgPeriodException e) {
                    isLoad = false;
                    rptCell.setItemFormula((String)null);
                    this.barFormula.setItemLine(null);
                    if (e.getSubCode().equals(BgPeriodException.CURRENTPERIODERROR.getCode())) {
                        throw new BgPeriodException(BgPeriodException.CURRENTPERIODERROR);
                    }
                    throw new BgPeriodException(BgPeriodException.RELATIVEPERIODERROR);
                }
            }
            if (parameter[this.paraPeriod] == null || parameter[this.paraPeriod].trim().length() == 0) {
                if (isFillUpdate) {
                    parameter[this.paraPeriod] = this.bgFormInfo.getBgPeriod().getNumber();
                    isLoad = true;
                } else {
                    throw new BgFormException(BgFormException.ERRORPARAMETERNOPERIOD, new String[]{formulaString});
                }
            }
            if (parameter[this.paraElement] == null || parameter[this.paraElement].trim().length() == 0) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, new String[]{formulaString});
            }
            if (parameter[this.paraDataType] == null || parameter[this.paraDataType].trim().length() == 0) {
                if (isFillUpdate) {
                    parameter[this.paraDataType] = BgDataTypeEnum.BgData.getName();
                    isLoad = true;
                } else {
                    throw new BgFormException(BgFormException.ERRORPARAMETERNODATATYPE, new String[]{formulaString});
                }
            }
            if (parameter[this.paraCollect] == null || parameter[this.paraCollect].trim().length() == 0) {
                if (isFillUpdate) {
                    parameter[this.paraCollect] = Boolean.TRUE.toString();
                    isLoad = true;
                } else {
                    throw new BgFormException(BgFormException.ERRORPARAMETERNOCOLLECT, new String[]{formulaString});
                }
            }
            if (parameter[this.paraCurrency] == null || parameter[this.paraCurrency].trim().length() == 0) {
                parameter[this.paraCurrency] = this.bgFormInfo.getCurrency().getNumber();
                isLoad = true;
            }
            if (isLoad) {
                if (this.formulaMap != null && this.formulaMap.containsKey(formulaString)) {
                    this.formulaMap.remove(formulaString);
                }
                formulaString = new StringBuffer("=BgItem(\"" + parameter[this.paraItem] + "\",\"" + parameter[this.paraPeriod] + "\",\"" + parameter[this.paraElement] + "\",\"" + parameter[this.paraDataType] + "\"," + parameter[this.paraCollect] + ",\"" + parameter[this.paraCurrency] + "\")").toString();
                parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                rptCell.setItemFormula(formulaString);
            }
        }
        return parameter;
    }

    protected String[] checkBudgetFormulaSP(ICell cell, boolean isFillUpdate) throws Exception {
        int x = cell.getRowIndex();
        int y = cell.getColumnIndex();
        String[] parameter = null;
        if (cell == null || cell.getUserObject() == null) {
            return parameter;
        }
        if (cell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            String formulaString = rptCell.getItemFormulaLine();
            if (formulaString == null || formulaString.trim().length() == 0) {
                return parameter;
            }
            this.processCellOfFormatInput(cell, null);
            parameter = this.getFormulaInfo(this.formulaMap, formulaString);
            boolean isLoad = false;
            if (parameter == null) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"300_BgProcessUI") + (x + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"301_BgProcessUI") + (y + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"302_BgProcessUI") + new BgFormException(BgFormException.FORMULAADDERROR).getMessage()));
                SysUtil.abort();
            }
            if (parameter[this.paraItem] == null) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"300_BgProcessUI") + (x + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"301_BgProcessUI") + (y + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"302_BgProcessUI") + new BgFormException(BgFormException.ERRORPARAMETERNOITEM, new String[]{formulaString}).getMessage()));
                SysUtil.abort();
            }
            if (parameter[this.paraPeriod] == null || parameter[this.paraPeriod].trim().length() == 0) {
                if (isFillUpdate) {
                    parameter[this.paraPeriod] = this.bgFormInfo.getBgPeriod().getNumber();
                    isLoad = true;
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"300_BgProcessUI") + (x + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"301_BgProcessUI") + (y + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"302_BgProcessUI") + new BgFormException(BgFormException.ERRORPARAMETERNOPERIOD, new String[]{formulaString}).getMessage()));
                    SysUtil.abort();
                }
            }
            if (parameter[this.paraElement] == null || parameter[this.paraElement].trim().length() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"300_BgProcessUI") + (x + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"301_BgProcessUI") + (y + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"302_BgProcessUI") + new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, new String[]{formulaString}).getMessage()));
                SysUtil.abort();
            }
            if (parameter[this.paraDataType] == null || parameter[this.paraDataType].trim().length() == 0) {
                if (isFillUpdate) {
                    parameter[this.paraDataType] = BgDataTypeEnum.BgData.getName();
                    isLoad = true;
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"300_BgProcessUI") + (x + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"301_BgProcessUI") + (y + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"302_BgProcessUI") + new BgFormException(BgFormException.ERRORPARAMETERNODATATYPE, new String[]{formulaString}).getMessage()));
                    SysUtil.abort();
                }
            }
            if (parameter[this.paraCollect] == null || parameter[this.paraCollect].trim().length() == 0) {
                if (isFillUpdate) {
                    parameter[this.paraCollect] = Boolean.TRUE.toString();
                    isLoad = true;
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"300_BgProcessUI") + (x + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"301_BgProcessUI") + (y + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"302_BgProcessUI") + new BgFormException(BgFormException.ERRORPARAMETERNOCOLLECT, new String[]{formulaString}).toString()));
                    SysUtil.abort();
                }
            }
            if (parameter[this.paraCurrency] == null || parameter[this.paraCurrency].trim().length() == 0) {
                parameter[this.paraCurrency] = this.bgFormInfo.getCurrency().getNumber();
                isLoad = true;
            }
            if (isLoad) {
                if (this.formulaMap != null && this.formulaMap.containsKey(formulaString)) {
                    this.formulaMap.remove(formulaString);
                }
                formulaString = new StringBuffer("=BgItem(\"" + parameter[this.paraItem] + "\",\"" + parameter[this.paraPeriod] + "\",\"" + parameter[this.paraElement] + "\",\"" + parameter[this.paraDataType] + "\"," + parameter[this.paraCollect] + ",\"" + parameter[this.paraCurrency] + "\")").toString();
                parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                rptCell.setItemFormula(formulaString);
            }
        }
        return parameter;
    }

    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBgItem_actionPerformed(e);
        String bgPeriodNumber = this.bgFormInfo.getBgPeriod().getNumber();
        String currencyNumber = this.bgFormInfo.getCurrency().getNumber();
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (this.itemAutoCreateFormula.isSelected()) {
            BgFillHelper.showBgItem((IUIObject)this, this.pnlTables.getCurrentPage(), orgUnitId, true, bgPeriodNumber, currencyNumber, null);
        } else {
            BgFillHelper.showBgItem((IUIObject)this, this.pnlTables.getCurrentPage(), orgUnitId, false, bgPeriodNumber, currencyNumber, null);
        }
    }

    @Override
    public void actionAddBgPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBgPeriod_actionPerformed(e);
        BgFillHelper.showBgPeriod((IUIObject)this, this.pnlTables.getCurrentPage());
    }

    @Override
    public void actionAddBgElement_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBgElement_actionPerformed(e);
        BgFillHelper.showElement((IUIObject)this, this.pnlTables.getCurrentPage());
    }

    @Override
    public void actionAddCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddCurrency_actionPerformed(e);
        BgFillHelper.showCurrency((IUIObject)this, this.pnlTables.getCurrentPage());
    }

    @Override
    public void actionCreateFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFormula_actionPerformed(e);
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        BgFillHelper.createItemFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.bgFormInfo, null, false);
        KDTable table = this.pnlTables.getCurrentPage();
        KDTRange range = table.getSelectManager().toRange();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                for (int k = block.getBeginCol(); k <= block.getEndCol(); ++k) {
                    ICell cell = table.getCell(j, k);
                    if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || ((RptCell)cell.getUserObject()).getItemFormula() == null || ((RptCell)cell.getUserObject()).getItemFormulaLine() == null) continue;
                    this.checkBudgetFormulaSP(cell, true);
                }
            }
        }
    }

    public boolean isSelectItem() {
        return this.isSelectItem;
    }

    public void setSelectItem(boolean isSelectItem) {
        this.isSelectItem = isSelectItem;
    }

    public void isGatherFormula(boolean isGatherFormula) {
        this.isGatherFormula = isGatherFormula;
    }

    public boolean isGatherFormula() {
        return this.isGatherFormula;
    }

    public void isGatherEnumErate(boolean isGatherEnumErate) {
        this.isGatherEnumErate = isGatherEnumErate;
    }

    public boolean isGatherEnumErate() {
        return this.isGatherEnumErate;
    }

    public void isGatherEnumErateItem(boolean isGatherEnumErateItem) {
        this.isGatherEnumErateItem = isGatherEnumErateItem;
    }

    public boolean isGatherEnumErateItem() {
        return this.isGatherEnumErateItem;
    }

    public void isGatherEnumErateFudian(boolean isGatherEnumErateFodian) {
        this.isGatherEnumErateFodian = isGatherEnumErateFodian;
    }

    public boolean isGatherEnumErateFodian() {
        return this.isGatherEnumErateFodian;
    }

    public void isGatherCell(boolean isGatherCell) {
        this.isGatherCell = isGatherCell;
    }

    public boolean isGatherCell() {
        return this.isGatherCell;
    }

    public boolean isGatherAdjust() {
        return this.isGatherAdjust;
    }

    public void isGatherAdjust(boolean isGatherAdjust) {
        this.isGatherAdjust = isGatherAdjust;
    }

    @Override
    public void actionSelectBgItem_actionPerformed(ActionEvent e) throws Exception {
        String bgPeriodNumber = this.bgFormInfo.getBgPeriod().getNumber();
        String currencyNumber = this.bgFormInfo.getCurrency().getNumber();
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (this.itemAutoCreateFormula.isSelected()) {
            BgFillHelper.showBgItem((IUIObject)this, this.pnlTables.getCurrentPage(), orgUnitId, true, bgPeriodNumber, currencyNumber, null);
        } else {
            BgFillHelper.showBgItem((IUIObject)this, this.pnlTables.getCurrentPage(), orgUnitId, false, bgPeriodNumber, currencyNumber, null);
        }
    }

    @Override
    public void actionCtrlSet_actionPerformed(ActionEvent e) throws Exception {
        BgItemFormulaCHelper.ctrlSet((IUIObject)this, this.pnlTables.getCurrentPage(), this.ctrlModeMap, this.ctrlModeCellMap, true);
    }

    @Override
    public void actionCtrlView_actionPerformed(ActionEvent e) throws Exception {
        BgItemFormulaCHelper.ctrlView((IUIObject)this, this.pnlTables.getCurrentPage(), this.ctrlModeMap, this.ctrlModeCellMap);
    }

    protected void beforeFileSave() throws Exception {
    }

    protected void afterFileSave() throws Exception {
    }

    protected ReportBaseInfo getCalculateObject() throws BOSException {
        ArrayList sheets = this.getAllKDTable();
        ArrayList<Object> sheetKeys = new ArrayList<Object>(sheets.size());
        RptSheetParamCollection sheetParams = new RptSheetParamCollection();
        if (sheets != null && sheets.size() > 0) {
            int count = sheets.size();
            for (int i = 0; i < count; ++i) {
                RptSheet sheetTemp = (RptSheet)sheets.get(i);
                KDTable tbl = sheetTemp.getTable();
                TablePorperts p = (TablePorperts)tbl.getUserObject();
                if (p != null) {
                    sheetKeys.add(p.get((Object)"keys"));
                }
                if (sheetTemp.getParams() == null) continue;
                sheetParams.add(sheetTemp.getParams());
            }
        }
        CslReportInfo info = null;
        if (this.editData instanceof CslReportInfo) {
            info = new CslReportInfo();
            CslReportInfo report = (CslReportInfo)this.editData;
            info.setName(report.getName());
            info.setOrgTree(CSLContextHelper.getCSLContext().getCurOrgBound());
            info.setNumber(report.getNumber());
            info.setStartDate(report.getStartDate());
            info.setEndDate(report.getEndDate());
            info.setReportDate(report.getReportDate());
            info.setYear(report.getYear());
            info.setPeriod(report.getPeriod());
            info.setPeriodType(report.getPeriodType());
            info.setCompany(report.getCompany());
            info.setCurrency(report.getCurrency());
            info.setSourceCurrency(report.getSourceCurrency());
            info.setId(report.getId());
            info.getOrgRela().addCollection(report.getOrgRela());
            info.getSheetParam().addCollection(sheetParams);
            info.setOrgUnit(report.getOrgUnit());
            info.setCU(report.getCU());
        } else if (this.editData instanceof ReportBaseInfo) {
            info = new ReportInfo();
            ReportBaseInfo report = (ReportBaseInfo)this.editData;
            info.setName(report.getName());
            info.setNumber(report.getNumber());
            info.setStartDate(report.getStartDate());
            info.setEndDate(report.getEndDate());
            info.setYear(report.getYear());
            info.setPeriod(report.getPeriod());
            if (report.getPeriodType() != null) {
                info.setPeriodType(report.getPeriodType());
            }
            info.setCompany(report.getCompany());
            info.setCurrency(report.getCurrency());
            info.setId(report.getId());
            info.getOrgRela().addCollection(report.getOrgRela());
            info.getSheetParam().addCollection(sheetParams);
            RptSrcTypeEnum type = report.getSourceType();
            if (type != null) {
                info.setSourceType(report.getSourceType());
            }
            info.put("myBgPeriod", this.editData.get("bgPeriod"));
            info.put("myBgOrgUnit", this.editData.get("orgUnit"));
            info.put("myState", this.editData.get("state"));
        }
        if (info != null) {
            info.put("keys", sheetKeys);
        }
        return info;
    }

    @Override
    public void actionCreateBgFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateBgFormula_actionPerformed(e);
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (e.getActionCommand().equalsIgnoreCase("BgFormula")) {
            BgFillHelper.createBgFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.editData, "BgFormula");
        } else if (e.getActionCommand().equalsIgnoreCase("BgActualS")) {
            BgFillHelper.createBgFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.editData, "BgActualS");
        } else if (e.getActionCommand().equalsIgnoreCase("BgBal")) {
            BgFillHelper.createBgFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.editData, "BgBal");
        } else if (e.getActionCommand().equalsIgnoreCase("BgFormulaF")) {
            BgFillHelper.createBgFormulaFromItemFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.editData, "BgFormula");
        } else if (e.getActionCommand().equalsIgnoreCase("BgActualSF")) {
            BgFillHelper.createBgFormulaFromItemFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.editData, "BgActualS");
        } else if (e.getActionCommand().equalsIgnoreCase("BgBalF")) {
            BgFillHelper.createBgFormulaFromItemFormula(this.pnlTables.getCurrentPage(), orgUnitId, (IObjectValue)this.editData, "BgBal");
        }
    }

    @Override
    public void actionMultiModifyFormula_actionPerformed(ActionEvent e) throws Exception {
        BgFillHelper.mutiUpdateFormula((IUIObject)this, this.pnlTables.getCurrentPage());
    }

    @Override
    public void actionMutiUpdateFormula_actionPerformed(ActionEvent arg0) throws Exception {
        BgFillHelper.mutiUpdateBgItemFormula((IUIObject)this, this.pnlTables.getCurrentPage(), this.bgFormInfo.getBgPeriod().getNumber());
    }

    public MainStatusBar getMainStatusBar() {
        return this.statusBar == null ? null : super.getMainStatusBar();
    }

    protected void addOther() {
        super.addOther();
    }

    public void actionFormatCellMerge_actionPerformed(ActionEvent e) throws Exception {
        int i = 0;
        int n = 0;
        int r = 0;
        int c = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        StringBuffer str = new StringBuffer();
        ICell cell = null;
        KDTSelectBlock block = null;
        KDTable table = this.pnlTables.getCurrentPage();
        KDTRange range = table.getSelectManager().toRange();
        n = range.size();
        for (i = 0; i < n; ++i) {
            block = (KDTSelectBlock)range.get(i);
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            colBegin = block.getBeginCol();
            colEnd = block.getEndCol();
            for (r = rowBegin; r <= rowEnd; ++r) {
                for (c = colBegin; c <= colEnd; ++c) {
                    cell = table.getCell(r, c);
                    if (BgFSHelper.checkHasFormulaOfCell(cell)) {
                        str.append(TableToolkit.xy2range((int)c, (int)r) + ",");
                        continue;
                    }
                    if (!BgFSHelper.checkHasExpressionsOfCell(cell)) continue;
                    str.append(TableToolkit.xy2range((int)c, (int)r) + ",");
                }
            }
        }
        if (str.toString().length() >= 1) {
            str.delete(str.length() - 1, str.length());
            throw new BgFormException(BgFormException.CANTMERGE, new String[]{str.toString()});
        }
        super.actionFormatCellMerge_actionPerformed(e);
    }

    @Override
    public void actionBgExamineCheck_actionPerformed(ActionEvent e) throws Exception {
        boolean isWorkFlow = false;
        if (this.getUIContext().get("Owner") != null && (this.getUIContext().get("Owner") instanceof MultiApproveUI || this.getUIContext().get("Owner") instanceof MessageCenterUI)) {
            isWorkFlow = true;
            if (this.getOprtState().equals(OprtState.EDIT) && this.getModifyingManager().getModifiedCount() > 0L) {
                this.isShowMessage = false;
                this.actionFileSave_actionPerformed(e);
                this.isShowMessage = true;
            }
        } else {
            String bgFormType = (String)this.getUIContext().get("bgFormType");
            if ((bgFormType == null || bgFormType.equals("budgetEditType")) && (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) && this.getModifyingManager().getModifiedCount() > 0L) {
                this.isShowMessage = false;
                this.actionFileSave_actionPerformed(e);
                this.isShowMessage = true;
            }
        }
        if (this.getExamineInterface().canExamine(new BOSUuid[]{this.getBgExmCheckReportId()})) {
            this.xNum = BgNFCHelper.returnExamineX((BOSUuid[])new BOSUuid[]{this.getBgExmCheckReportId()}, (Object)((Object)this));
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            this.dialog = win instanceof Frame ? (!isWorkFlow ? new LongTimeDialog((Frame)win) : null) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
            if (this.dialog != null) {
                this.dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = BgProcessUI.this.getExamineInterface().examines(new BOSUuid[]{BgProcessUI.this.getBgExmCheckReportId()}, BgProcessUI.this.xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            BgProcessUI.this.openBgExamineViewUI(result, null);
                        } else {
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                        }
                    }
                });
                this.dialog.show();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantCheckBgExamine"));
        }
    }

    protected BOSUuid getBgExmCheckReportId() {
        return this.editData.getId();
    }

    protected void openBgExamineViewUI(Object obj, Boolean isModel) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openBgExamineViewType(isModel)).create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String openBgExamineViewType(Boolean isModel) {
        if (isModel != null && isModel.booleanValue()) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        if (this.getUIContext().get("Owner") != null && (this.getUIContext().get("Owner") instanceof MultiApproveUI || this.getUIContext().get("Owner") instanceof MessageCenterUI)) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void processCurrPageCalculate(ActionEvent e) throws Exception {
        this.setPeriodAndOrg();
        this.actionBackCalcCurrPage_actionPerformed(e);
    }

    private void setPeriodAndOrg() throws EASBizException, BOSException {
        RptSheetParamCollection infoCol;
        BgPeriodInfo period = this.bgFormInfo.getBgPeriod();
        int year = this.bgFormInfo.getBgPeriod().getYear();
        int halfYear = period.getHalfYear();
        int month = period.getMonth();
        int quart = period.getQuarter();
        boolean startMonth = false;
        int endNonth = 12;
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.bgFormInfo.getCompany().getId()));
        int periodStartYear = -10000;
        int periodEndYear = 10000;
        int periodStartMonth = -10000;
        int periodEndMonth = 10000;
        if (company != null) {
            PeriodInfo endPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            if (startPeriod != null && endPeriod != null) {
                periodStartMonth = startPeriod.getPeriodNumber();
                periodEndMonth = endPeriod.getPeriodNumber();
            }
        } else {
            periodEndYear = year;
            periodStartYear = year;
            periodStartMonth = 1;
            periodEndMonth = 12;
        }
        BgPeriodEnum periodType = period.getPeriodType();
        if (periodType.getValue() == 1) {
            this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.YEARLY);
            infoCol = this.bgFormInfo.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(1);
                info.setEndPeriod(1);
                info.setReport((VirtualSheetParamInfo)this.bgFormInfo);
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                if (infoCol == null) {
                    logger.error((Object)"bgFormInfo.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)1);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.YEARLY);
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setStartPeriod(1);
                    info.setEndPeriod(1);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)1);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.YEARLY);
            }
        } else if (periodType.getValue() == 2) {
            this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
            infoCol = this.bgFormInfo.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(halfYear);
                info.setEndPeriod(halfYear);
                info.setReport(this.editData);
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                if (infoCol == null) {
                    logger.error((Object)"bgFormInfo.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)halfYear);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setStartPeriod(halfYear);
                    info.setEndPeriod(halfYear);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)halfYear);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
            }
        } else if (periodType.getValue() == 3) {
            this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
            infoCol = this.editData.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(quart);
                info.setEndPeriod(quart);
                info.setReport(this.editData);
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                if (infoCol == null) {
                    logger.error((Object)"editData.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)quart);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                    info.setStartPeriod(quart);
                    info.setEndPeriod(quart);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)quart);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
            }
        } else if (periodType.getValue() == 4) {
            this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            infoCol = this.editData.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(month);
                info.setEndPeriod(month);
                info.setReport(this.editData);
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                if (infoCol == null) {
                    logger.error((Object)"editData.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
                this.bgFormInfo.setYear(year);
                this.bgFormInfo.setPeriod((short)month);
                this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setStartPeriod(month);
                    info.setEndPeriod(month);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                    this.bgFormInfo.setYear(year);
                    this.bgFormInfo.setPeriod((short)month);
                    this.bgFormInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                }
            }
        }
    }

    public void actionInsertCellComment_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertCellComment_actionPerformed(e);
        this.getModifyingManager().addModifiedCount(1L);
    }

    public void actionInsertSheetComment_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertSheetComment_actionPerformed(e);
        this.getModifyingManager().addModifiedCount(1L);
    }

    public void actionInsertRptComment_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertRptComment_actionPerformed(e);
        this.getModifyingManager().addModifiedCount(1L);
    }

    public void actionFormatCell_actionPerformed(ActionEvent e) throws Exception {
        KDTable tbl = this.pnlTables.getCurrentPage();
        if (tbl != null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                tbl.showStyleDesigner((Frame)this.getUIWindow(), true);
            } else if (win instanceof Dialog) {
                tbl.showStyleDesigner((Dialog)this.getUIWindow(), true);
            }
        }
    }

    public void actionFileImport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"ReportProcessUI_Import"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            KDSSheet sheet;
            String fileName = file.getPath();
            KDSBook books = POIXlsReader.parse((String)fileName);
            if (books == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"openFileError"));
                SysUtil.abort();
            }
            if ((sheet = books.getSheet((Object)new Integer(0))) == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError"));
                SysUtil.abort();
            }
            this.alias.clear();
            this.writeToSheet(sheet, this.pnlTables.getCurrentPage());
            this.processCurrPageCalculate(null);
            this.alias.clear();
        }
    }

    private void writeToSheet(KDSSheet from, KDTable to) {
        if (from == null || to == null) {
            return;
        }
        ICell cellTo = null;
        RptCell rptCell = null;
        KDSCell fromCell = null;
        int compareValue = 0;
        StringBuffer msg = new StringBuffer();
        BigDecimal value = null;
        int rowCount = from.getRowCount();
        int colCount = from.getColumnCount();
        for (int i = 0; i <= rowCount; ++i) {
            for (int j = 0; j <= colCount; ++j) {
                block16: {
                    cellTo = to.getCell(i, j);
                    fromCell = from.getCell(i, j, false);
                    if (cellTo == null || fromCell == null || fromCell.getValue() == null || fromCell.getValue().toString().length() <= 0) continue;
                    if (cellTo.getUserObject() != null && cellTo.getUserObject() instanceof RptCell) {
                        rptCell = (RptCell)cellTo.getUserObject();
                        if (BgFSHelper.checkHasFormulaOfCell(rptCell)) {
                            try {
                                value = new BigDecimal(fromCell.getValue().toString().trim().replaceAll(",", ""));
                                compareValue = value.compareTo(BgConstants.BIGZERO);
                                if (compareValue > 0) {
                                    if (BgFSHelper.checkHasOverstepMax(value)) {
                                        msg.append(TableToolkit.xy2range((int)j, (int)i) + ",");
                                        cellTo.setValue(null);
                                    } else {
                                        cellTo.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value));
                                    }
                                    break block16;
                                }
                                if (compareValue < 0) {
                                    if (BgFSHelper.checkHasOverstepMin(value)) {
                                        msg.append(TableToolkit.xy2range((int)j, (int)i) + ",");
                                        cellTo.setValue(null);
                                    } else {
                                        cellTo.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value));
                                    }
                                    break block16;
                                }
                                cellTo.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value));
                            }
                            catch (Exception ex) {
                                cellTo.setValue(null);
                            }
                        } else {
                            cellTo.setValue(fromCell.getValue());
                        }
                    } else {
                        cellTo.setValue(fromCell.getValue());
                    }
                }
                this.alias.remove(TableToolkit.xy2range((int)cellTo.getColumnIndex(), (int)cellTo.getRowIndex()));
            }
        }
        if (msg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)(msg.substring(0, msg.length() - 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"valueHasOverstep")));
        }
    }

    public void showFormula(String formulaString) {
        if (formulaString == null && this.formulaStr != null) {
            return;
        }
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        String _tmpformulaStr = null;
        RptSheet sheet = null;
        KDTable table = null;
        ICell cell = null;
        ICell _tmpCell = null;
        int n = this.pnlTables.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = this.pnlTables.getSheet(i);
            table = sheet.getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = table.getCell(rowIndex, colIndex);
                    if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
                    _tmpformulaStr = BgFSHelper.getFormulaOfCell(cell);
                    if (_tmpformulaStr.equals(formulaString)) {
                        _tmpCell = cell;
                        continue;
                    }
                    if (!_tmpformulaStr.equals(this.formulaStr)) continue;
                    cell.getStyleAttributes().setBackground(this.backColor);
                }
            }
            if (_tmpCell == null) continue;
            this.formulaStr = BgFSHelper.getFormulaOfCell(_tmpCell);
            this.backColor = _tmpCell.getStyleAttributes().getBackground();
            this.xyPosition = TableToolkit.xy2range((int)_tmpCell.getColumnIndex(), (int)_tmpCell.getRowIndex());
            _tmpCell.getStyleAttributes().setBackground(Color.RED);
            break;
        }
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re) {
            Object obj;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            if (this.filterUI != null) {
                this.filterUI.destroyWindow();
            }
            if (this.cqDialog != null && this.cqDialog.getWindow() != null) {
                if (this.cqDialog.getWindow().getUIObject() != null) {
                    this.cqDialog.getWindow().getUIObject().destroyWindow();
                }
                this.cqDialog.getWindow().close();
            }
            if (this.getUIContext().get("OPEN_FORMULA") != null && (obj = this.getUIContext().get("Owner")) != null && obj instanceof BgExamineViewUI) {
                ((BgExamineViewUI)((Object)obj)).removeSelectOfUI(this.bgFormInfo.getId());
            }
            if (!"VIEW".equals(this.getOprtState()) && this.bgFormInfo != null && this.bgFormInfo.getId() != null) {
                BgClientHelper.releaseMutexService(this.bgFormInfo.getId().toString());
            }
        }
        return re;
    }

    protected void setCellStyleToText(ICell cell, CodeExpr codeExpr) {
        String funcName;
        if (cell == null || BgFSHelper.checkHasFormulaOfCell(cell)) {
            return;
        }
        if (codeExpr == null && (codeExpr = this.getCodeExpr(cell)) == null) {
            return;
        }
        if (codeExpr instanceof MethodInvokeExpr && ("bgRptDate".equalsIgnoreCase(funcName = ((MethodInvokeExpr)codeExpr).methodName) || "RptDate".equalsIgnoreCase(funcName) || "BgGetOrgNum".equalsIgnoreCase(funcName))) {
            cell.getStyleAttributes().setNumberFormat("@");
        }
    }

    private CodeExpr getCodeExpr(ICell cell) {
        String expression = cell.getExpressions();
        if (expression == null || "".equals(expression)) {
            return null;
        }
        if (expression.charAt(0) == '=') {
            expression = "value" + expression;
        }
        ExprStmt stmt = null;
        try {
            stmt = RptFormulaParser.parse((String)expression);
        }
        catch (ParserException e) {
            logger.error((Object)"parsing expression error");
        }
        if (stmt == null) {
            return null;
        }
        BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
        return expr.right;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUDGETMANAGEMENT;
    }

    protected void submitVoucherBatch() {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        try {
            if (company != null && this.getFormInterface().checkHasPeriod(company.getId())) {
                super.submitVoucherBatch();
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.removeNotify();
        }
        return re;
    }

    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertRow_actionPerformed(e);
    }

    @Override
    public void actionBgPeriodEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgPeriodEdit_actionPerformed(e);
        this.cqDialog = this.getCommonQueryDialog();
        if (this.cqDialog.show()) {
            CustomerParams _cp = this.getFilterUI().getCustomerParams();
            this._filterParam = this.getFilterUI().getFilterObject(_cp);
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            this.dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    List formula = BgProcessUI.this.getFormulaValueOfSheet();
                    return null;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof Map) {
                        BgProcessUI.this.setFormulaValueOfSheet((Map)result);
                    }
                }
            });
            this.dialog.show();
        }
    }

    @Override
    public void actionTransCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.actionTransCurrency_actionPerformed(e);
        UIContext uiCtx = new UIContext((Object)this);
        IUIWindow uiSelect = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectTransCurrWayUI.class.getName(), (Map)uiCtx, null, null);
        uiSelect.show();
        boolean isCancel = ((BgSelectTransCurrWayUI)uiSelect.getUIObject()).isCancel();
        int selectDimen = ((BgSelectTransCurrWayUI)uiSelect.getUIObject()).getSELECT_DIMEN();
        if (!isCancel) {
            if (selectDimen == 1) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"orgUnitInfo", (Object)this.bgFormInfo.getOrgUnit());
                uiContext.put((Object)"selfPanelUiName", (Object)BgTransCurrencyFilterUI.class.getName());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            } else if (selectDimen == 2) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"orgUnitInfo", (Object)this.bgFormInfo.getOrgUnit());
                uiContext.put((Object)"selfPanelUiName", (Object)BgTransCurrencyFilter2UI.class.getName());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
        }
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.cqDialog != null) {
            return this.cqDialog;
        }
        this.cqDialog = new CommonQueryDialog();
        this.cqDialog.setOwner((Component)((Object)this));
        this.cqDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.cqDialog.setEntityViewInfo(new EntityViewInfo());
        this.cqDialog.setQueryObjectPK(this.mainQueryPk);
        this.cqDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormPeriodEdit"));
        this.cqDialog.setWidth(820);
        this.cqDialog.setHeight(620);
        this.cqDialog.addUserPanel((KDPanel)this.getFilterUI());
        this.cqDialog.setShowFilter(false);
        this.cqDialog.setShowSorter(false);
        this.cqDialog.setShowToolbar(false);
        this.cqDialog.setDisVisiableDefaultView(false);
        return this.cqDialog;
    }

    protected BgFormPeriodEditUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BgFormPeriodEditUI((Object)this, this.bgFormInfo.getOrgUnit());
        }
        return this.filterUI;
    }

    protected List getFormulaValueOfSheet() {
        ArrayList<BgFormDiversityData> formulaList = new ArrayList<BgFormDiversityData>();
        RptSheet sheet = null;
        KDTable table = null;
        ICell cell = null;
        String formulaString = null;
        String valueString = null;
        String zeroString = "0";
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        BgFormDiversityData divData = null;
        int sheetCount = this.pnlTables.getSheets().size();
        for (int index = 0; index < sheetCount; ++index) {
            sheet = this.pnlTables.getSheet(index);
            table = sheet.getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = table.getCell(rowIndex, colIndex);
                    if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaString = BgFSHelper.getFormulaOfCell(cell);
                    valueString = cell.getValue() != null ? cell.getValue().toString() : zeroString;
                    divData = new BgFormDiversityData();
                    divData.setFormula(formulaString);
                    try {
                        divData.setNewValue(new BigDecimal(valueString));
                    }
                    catch (Exception ex) {
                        divData.setNewValue(BgConstants.BIGZERO);
                    }
                    formulaList.add(divData);
                }
            }
        }
        return formulaList;
    }

    protected void setFormulaValueOfSheet(Map valueMap) {
        if (valueMap == null || valueMap.isEmpty()) {
            return;
        }
        RptSheet sheet = null;
        KDTable table = null;
        ICell cell = null;
        BgFormPeriodData data = null;
        BgPeriodInfo bgPeriodInfo = null;
        BigDecimal value = null;
        BigDecimal rateValue = null;
        String formulaString = null;
        String key = null;
        String[] formulaStr = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        List targetData = ((BgFormPeriodFilterParam)this._filterParam).getTargetData();
        this.isProcess = false;
        int sheetCount = this.pnlTables.getSheets().size();
        for (int index = 0; index < sheetCount; ++index) {
            sheet = this.pnlTables.getSheet(index);
            table = sheet.getTable();
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = table.getCell(rowIndex, colIndex);
                    if (!BgFSHelper.checkHasFormulaOfCell(cell) || (formulaStr = this.getFormulaInfo(this.formulaMap, formulaString = BgFSHelper.getFormulaOfCell(cell))) == null) continue;
                    int in = targetData.size();
                    for (int i = 0; i < in; ++i) {
                        data = (BgFormPeriodData)targetData.get(i);
                        bgPeriodInfo = data.getBgPeriodInfo();
                        rateValue = data.getRateValue().divide(BgConstants.HUNDRED, 8, 4);
                        key = !StringUtils.isEmpty((String)formulaStr[BgSHelper.paraItem]) ? formulaStr[BgSHelper.paraItem] : "";
                        key = !StringUtils.isEmpty((String)formulaStr[BgSHelper.paraElement]) ? key + "_" + formulaStr[BgSHelper.paraElement] : key + "_";
                        key = !StringUtils.isEmpty((String)formulaStr[BgSHelper.paraCurrency]) ? key + "_" + formulaStr[BgSHelper.paraCurrency] : key + "_";
                        if (StringUtils.isEmpty((String)formulaStr[BgSHelper.paraPeriod]) || !formulaStr[BgSHelper.paraPeriod].equals(bgPeriodInfo.getNumber()) || !valueMap.containsKey(key)) continue;
                        value = (BigDecimal)valueMap.get(key);
                        value = value.multiply(rateValue);
                        this.setFormulaValueIOfCell(cell, value);
                    }
                }
            }
        }
        this.isProcess = true;
    }

    protected void setFormulaValueIOfCell(ICell cell, BigDecimal value) {
        if (cell == null || value == null) {
            return;
        }
        cell.setValue((Object)CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value));
    }

    public boolean isProcess() {
        return this.isProcess;
    }

    public void setProcess(boolean isProcess) {
        this.isProcess = isProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectBgFormInfo() throws Exception {
        int i;
        INewOrgViewFacade facade = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo tmpOrgUnitInfo = null;
        OrgUnitCollection orgUnitCol = null;
        orgUnitInfo = this.bgFormInfo.getOrgUnit();
        facade = NewOrgViewFacadeFactory.getRemoteInstance();
        orgUnitCol = facade.getChildren(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (orgUnitCol != null && !orgUnitCol.isEmpty()) {
            String tmpId = null;
            Object ip = null;
            FullOrgUnitCollection orgRangesColl = null;
            HashMap orgRangesMap = new HashMap();
            try {
                int i2;
                orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
                if (orgRangesColl != null) {
                    int in = orgRangesColl.size();
                    for (i2 = 0; i2 < in; ++i2) {
                        orgRangesMap.put(orgRangesColl.get(i2).getId().toString(), null);
                    }
                }
                for (i2 = orgUnitCol.size() - 1; i2 >= 0; --i2) {
                    tmpId = orgUnitCol.get(i2).getId().toString();
                    if (orgRangesMap.containsKey(tmpId)) continue;
                    orgUnitCol.removeObject(i2);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handUIExceptionAndAbort(ex);
            }
        }
        if (orgUnitCol == null || orgUnitCol.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NoSubOrgNotCollect"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitCol);
        uiContextOrg.put((Object)"CUID", (Object)orgUnitInfo.getId().toString());
        uiContextOrg.put((Object)"ID", (Object)this.editData.getId().toString());
        uiContextOrg.put((Object)"selfPanelUiName", (Object)BgSubOrgUnitSelectUIForForm.class.getName());
        uiContextOrg.put((Object)"OwnerUI", (Object)this);
        uiContextOrg.put((Object)"OwnerUIOwner", this.getUIContext().get("Owner"));
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        Hashtable map = new Hashtable();
        Map returnData = null;
        HashMap<BOSUuid, Object> orgUnitMap = new HashMap<BOSUuid, Object>();
        ArrayList subOrgs = null;
        ArrayList<FullOrgUnitInfo> newOrgs = null;
        BgFormInfo tmpInfo = new BgFormInfo();
        tmpInfo.setId(this.bgFormInfo.getId());
        tmpInfo.setState(this.bgFormInfo.getState());
        tmpInfo.setBgScheme(this.bgFormInfo.getBgScheme());
        tmpInfo.setBgTemplate(this.bgFormInfo.getBgTemplate());
        tmpInfo.setBgPeriod(this.bgFormInfo.getBgPeriod());
        tmpInfo.setCurrency(this.bgFormInfo.getCurrency());
        returnData = (Map)((AssignSolutionUI)orgSelectorUI.getUIObject()).getReturnData();
        if (returnData == null || returnData.get("returnValue") == null || ((ArrayList)returnData.get("returnValue")).size() == 0) {
            return;
        }
        subOrgs = (ArrayList)returnData.get("returnValue");
        int n = subOrgs.size();
        for (i = 0; i < n; ++i) {
            tmpOrgUnitInfo = (FullOrgUnitInfo)subOrgs.get(i);
            orgUnitMap.put(tmpOrgUnitInfo.getId(), null);
        }
        map.putAll(BgFacadeFactory.getRemoteInstance().filterFormCollectInfo(tmpInfo, orgUnitMap, true));
        if (!map.isEmpty()) {
            newOrgs = new ArrayList<FullOrgUnitInfo>();
            n = subOrgs.size();
            for (i = 0; i < n; ++i) {
                tmpOrgUnitInfo = (FullOrgUnitInfo)subOrgs.get(i);
                if (!map.containsKey(tmpOrgUnitInfo.getId().toString())) continue;
                newOrgs.add(tmpOrgUnitInfo);
            }
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cantCollect"));
            SysUtil.abort();
        }
        int[] parameter = new int[]{this.isBudget() ? 1 : 0, this.isGatherCell() ? 1 : 0, this.isGatherEnumErate() ? 1 : 0, this.isGatherEnumErateItem() ? 1 : 0, this.isGatherEnumErateFodian() ? 1 : 0, this.isGatherAdjust() ? 1 : 0};
        KDF kdf = null;
        RptSheet sheet = null;
        KDTable table = null;
        try {
            kdf = new KDF();
            int in = this.pnlTables.getSheets().size();
            for (int i3 = 0; i3 < in; ++i3) {
                sheet = this.pnlTables.getSheet(i3);
                table = sheet.getTable();
                BgFSHelper.initAliasObject(table);
                kdf.addTable((IDObject)table);
            }
            tmpInfo.setKDF(kdf);
            this.beforeCollect();
            BgFCHelper.showCollectInfo(this.pnlTables.getSheets(), tmpInfo, this.formulaMap, this);
            this.getModifyingManager().addModifiedCount(1L);
            this.bgFormInfo.setDataSource(BgFormDataSourceEnum.FORMCOLLECT);
            ((BgFormInfo)this.editDataUI.getEditDataObject()).setDataSource(BgFormDataSourceEnum.FORMCOLLECT);
            this.afterCollect();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            tmpInfo = null;
        }
        if (this.bgFormInfo.getBgScheme().isIsFormal() && this.isHaveItemformulaFromChldren()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"256_BgFormProcessUI"));
        }
    }

    protected boolean isBudget() {
        return true;
    }

    protected void beforeCollect() throws Exception {
    }

    protected void afterCollect() throws Exception {
    }

    protected boolean isHaveItemformulaFromChldren() {
        int pageCount = this.pnlTables.getTabCount();
        KDTable table = null;
        IRow row = null;
        IColumn column = null;
        ICell icell = null;
        Map userObject = null;
        int rowCount = 0;
        int columnCount = 0;
        for (int i = 0; i < pageCount; ++i) {
            table = this.pnlTables.getPageAt(i);
            if (table == null) continue;
            rowCount = table.getExpandedRowCount();
            columnCount = table.getExpandedColumnCount();
            for (int j = 0; j < rowCount; ++j) {
                row = table.getRow(j);
                if (row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(userObject = (Map)row.getUserObject()).containsKey("SIGN_DATA_SOURCE") || !userObject.get("SIGN_DATA_SOURCE").equals("DATA_SOURCE_COLLECT")) continue;
                for (int k = 0; k < columnCount; ++k) {
                    icell = row.getCell(k);
                    if (!BgFSHelper.checkHasFormulaOfCell(icell)) continue;
                    return true;
                }
            }
            for (int k = 0; k < columnCount; ++k) {
                column = table.getColumn(k);
                if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(userObject = (Map)column.getUserObject()).containsKey("SIGN_DATA_SOURCE") || !userObject.get("SIGN_DATA_SOURCE").equals("DATA_SOURCE_COLLECT")) continue;
                for (int j = 0; j < rowCount; ++j) {
                    icell = table.getCell(j, k);
                    if (!BgFSHelper.checkHasFormulaOfCell(icell)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    public void setCurrencyMap(Map currencyMap) {
        this.currencyMap = currencyMap;
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public void setFormulaMap(Map formulaMap) {
        this.formulaMap = formulaMap;
    }
}

