/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgQueryFormFilterParam;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.AbstractBgRptFilterUI;
import com.kingdee.eas.ma.budget.client.BgBalanceMainUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.BgCompareOneMainUI;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgDifferMainUI;
import com.kingdee.eas.ma.budget.client.BgFormQueryMainUI;
import com.kingdee.eas.ma.budget.client.BgItemAnalyseMainUI;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgTraceMainUI;
import com.kingdee.eas.ma.budget.client.CompanyTreeSelectUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class BgRptFilterUI
extends AbstractBgRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgRptFilterUI.class);
    protected boolean isFromFund = false;
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private BgRptFilterParam rptFilterParam;
    protected KDDialog companySelectDlg = null;
    private BgTemplateInfo tmptInfo = null;
    private int preRowPos = -1;
    private Map companyMap = new HashMap(32);
    protected Set longNumberSet = new HashSet(32);
    private Map bgTypeNameMap = new HashMap();
    private Map bgPeriodMap = new HashMap();
    public BgPeriodDialog beginF7;
    public BgPeriodDialog endF7;
    protected CostCenterOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentCostUnit();
    protected CostCenterOrgUnitInfo curOrgUnitinfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
    private String[] companyIds = null;
    private String[] companyNames = null;
    private Vector orgUnitVec;
    public OrgViewType[] orgView = null;
    private Vector bgSchemeVec;
    private Map relatedSchemeMap;
    private Vector bgTemplateVec;
    private boolean isMultiOrg = false;
    private boolean isProcessed = true;
    protected BgPeriodInfo retBeginPeriod;
    protected BgPeriodInfo retEndPeriod;
    protected String[] periodIds;
    protected BgAnalysisTypeEnum bgAnalyType = null;
    protected boolean isLoadQuery = true;
    protected boolean isLoadBgBalance = true;
    protected BgAnalysisTypeEnum rptType;
    protected BgSchemeCollection bgSchemeCol = null;
    protected BgTemplateCollection bgTemplateCol = null;
    protected boolean isUserUpdate = true;
    private IBgAnalyseFacade analyseFacade = null;

    public BgRptFilterUI() throws Exception {
    }

    public BgRptFilterUI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
    }

    @Override
    public void onLoad() throws Exception {
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
        Vector vec = BgHelper.getOrgViewTypes(org);
        this.orgView = new OrgViewType[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            this.orgView[i] = (OrgViewType)vec.get(i);
        }
        super.onLoad();
        if (this.isLoadQuery) {
            this.init();
        } else {
            this.isLoadQuery = true;
        }
    }

    private void init() throws Exception {
        this.comboBgPeriod.setEnabled(false);
        BgClientHelper.setSelectObject(this.comboBgRptType, (Object)BgAnalysisTypeEnum.BGFORMQUERY);
        this.comboBgRptType.setEnabled(false);
        if (this.rptFilterParam == null) {
            this.initCompanyState();
            this.initOrg();
            this.initScheme();
            if (this.isLoadQuery) {
                this.setBgTemplateSelect();
            }
        }
    }

    protected void initScheme() {
        try {
            BgClientHelper.initComboBgScheme((Component)((Object)this), this.comboBgScheme, this.currentCompany.getId().toString());
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    public void initOrg() throws Exception {
        BgCostCenterOrgViewF7 orgF7 = new BgCostCenterOrgViewF7((IUIObject)this);
        orgF7.setCuID(this.currentCompany.getId().toString());
        orgF7.setMultiSelect(true);
        orgF7.setIsShowSub(true);
        orgF7.setTitle(EASResource.getString((String)resourcePath, (String)"SelectOrgUnit"));
        String uiClassName = null;
        if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGFORMQUERY)) {
            uiClassName = BgFormQueryMainUI.class.getName();
        } else if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGBALANCE)) {
            uiClassName = BgBalanceMainUI.class.getName();
        } else if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
            uiClassName = BgCompareOneMainUI.class.getName();
        } else if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGTRACE)) {
            uiClassName = BgTraceMainUI.class.getName();
        } else if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGQUERY)) {
            uiClassName = BgItemAnalyseMainUI.class.getName();
        } else if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGCOMPAREANALYSIS)) {
            uiClassName = BgCompareAndAnalysisMainUI.class.getName();
        } else if (this.rptType != null && this.rptType.equals((Object)BgAnalysisTypeEnum.BGDIFFER)) {
            uiClassName = BgDifferMainUI.class.getName();
        }
        if (uiClassName != null) {
            orgF7.setUIActionPK((IMetaDataPK)new MetaDataPK(uiClassName), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
        Object obj = this.prmtOrgUnit.getValue();
        if (obj == null || ((Object[])obj)[0] == null) {
            this.curOrgUnitinfo.put("treeType", (Object)new Integer(5));
            if (this.curOrgUnitinfo != null) {
                this.prmtOrgUnit.setValue((Object)this.curOrgUnitinfo);
            }
        }
        this.prmtOrgUnit.setEditFormat("$id$");
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEnabledMultiSelection(true);
    }

    protected void initCompanyState() {
        if (this.curOrgUnitinfo.isIsLeaf()) {
            this.prmtOrgUnit.setEnabled(false);
        } else {
            this.prmtOrgUnit.setEnabled(true);
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object[] objs;
        super.prmtOrgUnit_dataChanged(e);
        if (!this.isUserUpdate) {
            return;
        }
        if (!this.isLoadQuery) {
            return;
        }
        Object obj = this.prmtOrgUnit.getValue();
        this.longNumberSet.clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[] && (objs = (Object[])obj)[0] == null) {
            return;
        }
        this.isMultiOrg = false;
        CostCenterOrgUnitInfo orgInfo = null;
        CostCenterOrgUnitInfo orgUnitInfo = null;
        String[] orgUnitIds = null;
        String[] orgUnitNames = null;
        Vector<CostCenterOrgUnitInfo> companyVec = new Vector<CostCenterOrgUnitInfo>();
        if (obj instanceof CostCenterOrgUnitInfo) {
            orgInfo = (CostCenterOrgUnitInfo)obj;
            this.isMultiOrg = false;
            this.setCompanyIds(new String[]{orgInfo.getId().toString()});
            this.setCompanyNames(new String[]{orgInfo.getName()});
            companyVec.add(orgInfo);
            this.setOrgUnitVec(companyVec);
        } else {
            Object[] oarr = (Object[])obj;
            this.isMultiOrg = (oarr = this.dealSelectorOrgUnitInfo(oarr)).length > 1;
            orgInfo = (CostCenterOrgUnitInfo)oarr[0];
            orgUnitIds = new String[oarr.length];
            orgUnitNames = new String[oarr.length];
            for (int i = 0; i < oarr.length; ++i) {
                orgUnitInfo = (CostCenterOrgUnitInfo)oarr[i];
                this.companyMap.put(orgUnitInfo.getId().toString(), orgUnitInfo);
                this.longNumberSet.add(orgUnitInfo.getLongNumber());
                orgUnitIds[i] = orgUnitInfo.getId().toString();
                orgUnitNames[i] = orgUnitInfo.getName();
                companyVec.add(orgUnitInfo);
            }
            this.setCompanyIds(orgUnitIds);
            this.setCompanyNames(orgUnitNames);
            this.setOrgUnitVec(companyVec);
        }
        CostCenterOrgUnitInfo companyInfo = this.currentCompany;
        this.comboBgScheme.removeAllItems();
        this.comboBgTemplate.removeAllItems();
        this.comboBgPeriod.setSelectedItem(null);
        if (companyInfo != null && companyInfo.getId() != null) {
            BgAnalysisTypeEnum bgRptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
            if (this.isMultiOrg) {
                String[] companyIds = this.getCompanyIds();
                if (companyIds != null && companyIds.length > 0) {
                    HashSet<BOSUuid> subOrgUnitMap = new HashSet<BOSUuid>();
                    for (int i = 0; i < companyIds.length; ++i) {
                        subOrgUnitMap.add(BOSUuid.read((String)companyIds[i]));
                    }
                    IBgFacade ibgFacade = BgFacadeFactory.getRemoteInstance();
                    this.bgSchemeCol = this.getInterface().getCommonBgScheme(orgInfo.getId(), subOrgUnitMap, false, false, true);
                    if (!this.bgSchemeCol.isEmpty()) {
                        BgSchemeInfo bgSchemeInfo = null;
                        this.isProcessed = false;
                        Iterator iter = this.bgSchemeCol.iterator();
                        while (iter.hasNext()) {
                            bgSchemeInfo = (BgSchemeInfo)iter.next();
                            this.comboBgScheme.addItem((Object)bgSchemeInfo);
                        }
                        this.isProcessed = true;
                        this.comboBgScheme.setSelectedIndex(0);
                        this.comboBgScheme.setEnabled(true);
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
                    }
                }
            } else {
                BgClientHelper.initComboBgScheme((Component)((Object)this), this.comboBgScheme, this.getCompanyIds()[0]);
                if (this.comboBgScheme.getItemCount() <= 0) {
                    this.prmtBeginPeriod.setEnabled(false);
                    this.prmtEndPeriod.setEnabled(false);
                } else {
                    this.prmtBeginPeriod.setEnabled(true);
                    this.prmtEndPeriod.setEnabled(true);
                }
            }
            if (e != null) {
                this.setBgTemplateSelect();
            }
        } else {
            this.comboBgScheme.removeAllItems();
        }
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public Vector getOrgUnitVec() {
        return this.orgUnitVec;
    }

    public void setOrgUnitVec(Vector orgUnitVec) {
        this.orgUnitVec = orgUnitVec;
    }

    protected KDDialog initDialog() throws Exception {
        if (this.companySelectDlg != null) {
            return this.companySelectDlg;
        }
        this.companySelectDlg = new KDDialog(BgClientHelper.getFrameAncestor((Component)((Object)this)), true);
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI();
        companySelectUI.setDialog((JDialog)this.companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        this.companySelectDlg.getContentPane().setLayout(new BorderLayout());
        this.companySelectDlg.getContentPane().add((Component)((Object)companySelectUI), "Center");
        this.companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.companySelectDlg);
        this.companySelectDlg.setResizable(false);
        this.companySelectDlg.setTitle(companySelectUI.getUITitle());
        companySelectUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    // empty if block
                }
            }
        });
        return this.companySelectDlg;
    }

    @Override
    protected void comboBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgScheme_itemStateChanged(e);
        if (this.comboBgScheme.getSelectedIndex() >= 0) {
            if (!this.isLoadQuery) {
                return;
            }
            if (this.isProcessed) {
                this.setBgTemplateSelect();
            }
        }
    }

    private void repairData() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("data"));
        IBgTemplate iBgT = BgTemplateFactory.getRemoteInstance();
        BgTemplateInfo info = iBgT.getBgTemplateInfo((IObjectPK)new ObjectUuidPK("22aQywEIEADgAAA1wKgSnjNH0yA="), sic);
        String[] idArray = new String[]{"3A4WOQEIEADgAA3nwKgTyDNH0yA=", "3A4WOQEIEADgAA3ywKgTyDNH0yA=", "3A4WOQEIEADgAA4AwKgTyDNH0yA=", "3A4WOQEIEADgAA4bwKgTyDNH0yA=", "3A4WOQEIEADgAA4LwKgTyDNH0yA=", "3A4WOQEIEADgAA4nwKgTyDNH0yA=", "3A4WOQEIEADgAA52wKgTyDNH0yA=", "3A4WOQEIEADgAA6GwKgTyDNH0yA=", "3A4WOQEIEADgAAr0wKgTyDNH0yA=", "3A4WOQEIEADgAArlwKgTyDNH0yA=", "3A4WOQEIEADgAAs2wKgTyDNH0yA=", "3A4WOQEIEADgAAscwKgTyDNH0yA=", "3A4WOQEIEADgAAsNwKgTyDNH0yA=", "3A4WOQEIEADgAAspwKgTyDNH0yA=", "3A4WOQEIEADgAAuMwKgTyDNH0yA=", "3A4WOQEIEADgAAuZwKgTyDNH0yA="};
        for (int i = 0; i < idArray.length; ++i) {
            BgTemplateInfo info1 = iBgT.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(idArray[i]), sic);
            info1.setMapData(info.getMapData());
            iBgT.update((IObjectPK)new ObjectUuidPK(idArray[i]), (CoreBaseInfo)info1);
        }
    }

    @Override
    protected void comboBgPeriod_itemStateChanged(ItemEvent e) throws Exception {
        BgPeriodEnum bienum = (BgPeriodEnum)((Object)this.comboBgPeriod.getSelectedItem());
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
        this.comboBgPeriod.setEnabled(false);
        if (bgSchemeInfo == null || bienum == null) {
            return;
        }
        if (this.beginF7 == null) {
            this.beginF7 = new BgPeriodDialog((CoreUIObject)this);
        }
        this.beginF7.setBgPeriodEnum(bienum);
        this.beginF7.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
        this.beginF7.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
        this.prmtBeginPeriod.setSelector((KDPromptSelector)this.beginF7);
        if (this.endF7 == null) {
            this.endF7 = new BgPeriodDialog((CoreUIObject)this);
        }
        this.endF7.setBgPeriodEnum(bienum);
        this.endF7.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
        this.endF7.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
        this.prmtEndPeriod.setSelector((KDPromptSelector)this.endF7);
    }

    protected void setBgTemplateSelect() throws Exception {
        if (this.comboBgScheme.getSelectedItem() == null) {
            return;
        }
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
        this.comboBgTemplate.removeAllItems();
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null) {
            this.comboBgPeriod.setSelectedItem((Object)bgSchemeInfo.getPeriod());
            this.prmtBeginPeriod.setValue(null);
            this.prmtEndPeriod.setValue(null);
            if (this.beginF7 == null) {
                this.beginF7 = new BgPeriodDialog((CoreUIObject)this);
            }
            this.beginF7.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
            this.beginF7.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
            this.prmtBeginPeriod.setSelector((KDPromptSelector)this.beginF7);
            if (this.endF7 == null) {
                this.endF7 = new BgPeriodDialog((CoreUIObject)this);
            }
            this.endF7.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
            this.endF7.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
            this.prmtEndPeriod.setSelector((KDPromptSelector)this.endF7);
            IBgFacade ibgFacade = BgFacadeFactory.getRemoteInstance();
            if (this.isMultiOrg) {
                BOSUuid[] subOrgUnitMap = new BOSUuid[this.companyIds.length];
                for (int i = 0; i < this.companyIds.length; ++i) {
                    subOrgUnitMap[i] = BOSUuid.read((String)this.companyIds[i]);
                }
                this.bgTemplateCol = this.getInterface().getCommonBgTemplate(bgSchemeInfo.getId(), subOrgUnitMap);
                if (this.bgTemplateCol != null) {
                    this.comboBgTemplate.addItems(this.bgTemplateCol.toArray());
                }
            } else {
                this.bgTemplateCol = ibgFacade.getCommonBgTemplateInfo(bgSchemeInfo.getId(), null);
                if (this.bgTemplateCol != null) {
                    this.comboBgTemplate.addItems(this.bgTemplateCol.toArray());
                }
            }
        }
    }

    protected BgRptFilterParam getRptFilterParam() {
        if (this.rptFilterParam == null) {
            this.rptFilterParam = new BgRptFilterParam();
        }
        return this.rptFilterParam;
    }

    public Object getParam() {
        BgRptFilterParam param = this.getRptFilterParam();
        param.setBgRptType((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem()));
        param.setOrgUnitVec(this.getOrgUnitVec());
        if (this.comboBgScheme.getSelectedItem() != null) {
            BgSchemeInfo schemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
            if (this.isMultiOrg) {
                param.setBgSchemeId(schemeInfo.getRootId().toString());
                param.setThisBgSchemeId(schemeInfo.getId().toString());
                BgSchemeInfo bgSchemeInfo = null;
                if (!this.bgSchemeCol.isEmpty()) {
                    String[] bgSchemeId = new String[this.bgSchemeCol.size()];
                    int n = this.bgSchemeCol.size();
                    for (int i = 0; i < n; ++i) {
                        bgSchemeInfo = this.bgSchemeCol.get(i);
                        bgSchemeId[i] = bgSchemeInfo.getId().toString();
                    }
                    param.setBgSchemeIds(bgSchemeId);
                }
            } else {
                param.setBgSchemeId(schemeInfo.getId().toString());
                param.setThisBgSchemeId(schemeInfo.getId().toString());
                param.setBgSchemeIds(new String[]{schemeInfo.getId().toString()});
                param.setBgSchemeNames(new String[]{schemeInfo.getName()});
            }
        }
        param.setIsSum(this.chkIsSum.isSelected());
        BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
        BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
        if (beginPeriod != null) {
            param.setBeginPeriodId(beginPeriod.getId().toString());
        }
        if (endPeriod != null) {
            param.setEndPeriodId(endPeriod.getId().toString());
        }
        this.bgPeriodMap.clear();
        this.bgPeriodMap.put("BeginBgPeriod", beginPeriod);
        this.bgPeriodMap.put("EndBgPeriod", endPeriod);
        param.setBgPeriodMap(this.bgPeriodMap);
        beginPeriod = this.retBeginPeriod;
        endPeriod = this.retEndPeriod;
        param.setBeginPeriod(beginPeriod);
        param.setEndPeriod(endPeriod);
        if (this.getCompanyIds() != null && this.getCompanyIds().length > 1 && this.getCompanyIds()[0] != null) {
            if (this.chkIsSum.isSelected()) {
                int curLongLength = this.currentCompany.getLongNumber().split("!").length;
                HashSet<String> newLongNumberSet = new HashSet<String>(this.longNumberSet);
                newLongNumberSet.add(this.currentCompany.getLongNumber());
                for (String longNumber : this.longNumberSet) {
                    String[] longNumArray = longNumber.split("!");
                    if (longNumArray.length - curLongLength <= 1) continue;
                    int curOrgLength = this.currentCompany.getLongNumber().length();
                    for (int i = curLongLength; i < longNumArray.length - 1; ++i) {
                        curOrgLength = curOrgLength + longNumArray[i].length() + 1;
                        newLongNumberSet.add(longNumber.substring(0, longNumber.indexOf("!", curOrgLength)));
                    }
                }
                CostCenterOrgUnitCollection orgUnitColl = this.getOrgUnitColl(newLongNumberSet);
                if (orgUnitColl != null && orgUnitColl.size() > 0) {
                    String[] ids = new String[orgUnitColl.size()];
                    for (int i = 0; i < orgUnitColl.size(); ++i) {
                        ids[i] = orgUnitColl.get(i).getId().toString();
                    }
                    param.setOrgUnitIds(ids);
                }
            } else {
                param.setOrgUnitIds(this.getCompanyIds());
            }
        } else {
            param.setOrgUnitIds(this.getCompanyIds());
        }
        Object id = null;
        Object bgTypeName = null;
        this.bgTypeNameMap.clear();
        if (this.comboBgTemplate.getSelectedItem() != null) {
            BgTemplateInfo bgTemInfo = (BgTemplateInfo)this.comboBgTemplate.getSelectedItem();
            param.setCurrentBgTemplate(bgTemInfo.getId().toString());
            this.bgTypeNameMap.put(bgTemInfo.getId().toString(), bgTemInfo.getName());
            if (this.isMultiOrg) {
                BgTemplateInfo bgTemplateInfo = null;
                if (!this.bgTemplateCol.isEmpty()) {
                    String[] bgTemplateId = new String[this.bgTemplateCol.size()];
                    int n = this.bgTemplateCol.size();
                    for (int i = 0; i < n; ++i) {
                        bgTemplateInfo = this.bgTemplateCol.get(i);
                        bgTemplateId[i] = bgTemplateInfo.getId().toString();
                    }
                    param.setBgTemplateIds(bgTemplateId);
                }
            } else {
                param.setBgTemplateIds(new String[]{bgTemInfo.getId().toString()});
            }
        }
        param.setBgTemplate(this.bgTypeNameMap);
        param.setBgPeriodType(((BgPeriodEnum)((Object)this.comboBgPeriod.getSelectedItem())).getValue());
        param.setPeriodIds(this.periodIds);
        return param;
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        BgRptFilterParam param = null;
        param = this.getRptFilterParam();
        param.setBgRptType((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem()));
        param.setOrgUnitVec(this.getOrgUnitVec());
        if (this.comboBgScheme.getSelectedItem() != null) {
            BgSchemeInfo schemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
            if (this.isMultiOrg) {
                param.setBgSchemeId(schemeInfo.getRootId().toString());
                param.setThisBgSchemeId(schemeInfo.getId().toString());
                BgSchemeInfo bgSchemeInfo = null;
                if (!this.bgSchemeCol.isEmpty()) {
                    String[] bgSchemeId = new String[this.bgSchemeCol.size()];
                    int n = this.bgSchemeCol.size();
                    for (int i = 0; i < n; ++i) {
                        bgSchemeInfo = this.bgSchemeCol.get(i);
                        bgSchemeId[i] = bgSchemeInfo.getId().toString();
                    }
                    param.setBgSchemeIds(bgSchemeId);
                }
            } else {
                param.setBgSchemeId(schemeInfo.getId().toString());
                param.setThisBgSchemeId(schemeInfo.getId().toString());
                param.setBgSchemeIds(new String[]{schemeInfo.getId().toString()});
                param.setBgSchemeNames(new String[]{schemeInfo.getName()});
            }
        }
        param.setIsSum(this.chkIsSum.isSelected());
        BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
        BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
        if (beginPeriod != null) {
            param.setBeginPeriodId(beginPeriod.getId().toString());
        }
        if (endPeriod != null) {
            param.setEndPeriodId(endPeriod.getId().toString());
        }
        this.bgPeriodMap.clear();
        this.bgPeriodMap.put("BeginBgPeriod", beginPeriod);
        this.bgPeriodMap.put("EndBgPeriod", endPeriod);
        param.setBgPeriodMap(this.bgPeriodMap);
        if (param instanceof BgQueryFormFilterParam) {
            param.setBeginPeriod(beginPeriod);
            param.setEndPeriod(endPeriod);
        } else {
            beginPeriod = this.retBeginPeriod;
            endPeriod = this.retEndPeriod;
            param.setBeginPeriod(beginPeriod);
            param.setEndPeriod(endPeriod);
        }
        if (this.getCompanyIds() != null && this.getCompanyIds().length > 1 && this.getCompanyIds()[0] != null) {
            if (this.chkIsSum.isSelected()) {
                int curLongLength = this.currentCompany.getLongNumber().split("!").length;
                HashSet<String> newLongNumberSet = new HashSet<String>(this.longNumberSet);
                newLongNumberSet.add(this.currentCompany.getLongNumber());
                for (String longNumber : this.longNumberSet) {
                    String[] longNumArray = longNumber.split("!");
                    if (longNumArray.length - curLongLength <= 1) continue;
                    int curOrgLength = this.currentCompany.getLongNumber().length();
                    for (int i = curLongLength; i < longNumArray.length - 1; ++i) {
                        curOrgLength = curOrgLength + longNumArray[i].length() + 1;
                        newLongNumberSet.add(longNumber.substring(0, longNumber.indexOf("!", curOrgLength)));
                    }
                }
                CostCenterOrgUnitCollection orgUnitColl = this.getOrgUnitColl(newLongNumberSet);
                if (orgUnitColl != null && orgUnitColl.size() > 0) {
                    String[] ids = new String[orgUnitColl.size()];
                    for (int i = 0; i < orgUnitColl.size(); ++i) {
                        ids[i] = orgUnitColl.get(i).getId().toString();
                    }
                    param.setOrgUnitIds(ids);
                }
            } else {
                param.setOrgUnitIds(this.getCompanyIds());
            }
        } else {
            param.setOrgUnitIds(this.getCompanyIds());
        }
        Object id = null;
        Object bgTypeName = null;
        this.bgTypeNameMap.clear();
        if (this.comboBgTemplate.getSelectedItem() != null) {
            BgTemplateInfo bgTemInfo = (BgTemplateInfo)this.comboBgTemplate.getSelectedItem();
            param.setCurrentBgTemplate(bgTemInfo.getId().toString());
            this.bgTypeNameMap.put(bgTemInfo.getId().toString(), bgTemInfo.getName());
            if (this.isMultiOrg) {
                BgTemplateInfo bgTemplateInfo = null;
                if (!this.bgTemplateCol.isEmpty()) {
                    String[] bgTemplateId = new String[this.bgTemplateCol.size()];
                    int n = this.bgTemplateCol.size();
                    for (int i = 0; i < n; ++i) {
                        bgTemplateInfo = this.bgTemplateCol.get(i);
                        bgTemplateId[i] = bgTemplateInfo.getId().toString();
                    }
                    param.setBgTemplateIds(bgTemplateId);
                }
            } else {
                param.setBgTemplateIds(new String[]{bgTemInfo.getId().toString()});
            }
        }
        param.setBgTemplate(this.bgTypeNameMap);
        if (this.comboBgPeriod.getSelectedItem() != null) {
            param.setBgPeriodType(((BgPeriodEnum)((Object)this.comboBgPeriod.getSelectedItem())).getValue());
        }
        param.setPeriodIds(this.periodIds);
        try {
            this.setFilterObject(cp, param);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return cp;
    }

    protected CostCenterOrgUnitCollection getOrgUnitColl(Set longNumberSet) {
        CostCenterOrgUnitCollection companyColl = null;
        try {
            ICostCenterOrgUnit iCompany = CostCenterOrgUnitFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumberSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("longNumber"));
            selector.add(new SelectorItemInfo("isLeaf"));
            selector.add(new SelectorItemInfo("isFreeze"));
            selector.add(new SelectorItemInfo("level"));
            selector.add(new SelectorItemInfo("parent"));
            selector.add(new SelectorItemInfo("parent.id"));
            selector.add(new SelectorItemInfo("parent.name"));
            selector.add(new SelectorItemInfo("parent.number"));
            selector.add(new SelectorItemInfo("isCU"));
            viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sortItemInfo = new SorterItemInfo("longNumber");
            sortItemInfo.setSortType(SortType.ASCEND);
            sorter.add(sortItemInfo);
            viewInfo.getSorter().addObjectCollection((IObjectCollection)sorter);
            companyColl = iCompany.getCostCenterOrgUnitCollection(viewInfo);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return companyColl;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        FilterParam param = (FilterParam)this.getFilterObject(cp);
        if (param == null || !(param instanceof BgRptFilterParam)) {
            return;
        }
        this.rptFilterParam = (BgRptFilterParam)param;
        this.bgAnalyType = this.rptFilterParam.getBgRptType();
        this.isLoadQuery = false;
        this.prmtOrgUnit.setValue((Object)this.rptFilterParam.getOrgUnitVec().toArray());
        this.isLoadQuery = true;
        try {
            this.prmtOrgUnit_dataChanged(null);
            this.isLoadQuery = false;
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String bgSchemeId = this.rptFilterParam.getThisBgSchemeId();
        this.isLoadQuery = false;
        for (int i = 0; i < this.comboBgScheme.getItemCount(); ++i) {
            if (!bgSchemeId.equals(((BgSchemeInfo)this.comboBgScheme.getItemAt(i)).getId().toString())) continue;
            this.comboBgScheme.setSelectedIndex(i);
            try {
                this.setBgTemplateSelect();
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            break;
        }
        this.isLoadQuery = true;
        this.comboBgPeriod.setSelectedItem((Object)BgPeriodEnum.getEnum(this.rptFilterParam.getBgPeriodType()));
        String bgTemplateId = this.rptFilterParam.getBgTemplate().keySet().toArray()[0].toString();
        this.isLoadQuery = false;
        for (int i = 0; i < this.comboBgTemplate.getItemCount(); ++i) {
            if (!bgTemplateId.equals(((BgTemplateInfo)this.comboBgTemplate.getItemAt(i)).getId().toString())) continue;
            this.comboBgTemplate.setSelectedIndex(i);
            break;
        }
        this.isLoadQuery = false;
        this.chkIsSum.setSelected(this.rptFilterParam.isIsSum());
        this.prmtBeginPeriod.setData(this.rptFilterParam.getBgPeriodMap().get("BeginBgPeriod"));
        this.prmtEndPeriod.setData(this.rptFilterParam.getBgPeriodMap().get("EndBgPeriod"));
        this.isLoadBgBalance = false;
        this.isLoadQuery = true;
    }

    public boolean verify() {
        Object obj = this.prmtOrgUnit.getValue();
        if (this.getCompanyIds() == null || this.getCompanyIds().length < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectUnit"));
            return false;
        }
        if (this.comboBgScheme.isEditable() && this.comboBgScheme.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            return false;
        }
        if (this.comboBgTemplate.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgTemplate"));
            return false;
        }
        BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, this.prmtBeginPeriod, this.prmtEndPeriod);
        this.retBeginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
        this.retEndPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
        BgAnalysisTypeEnum rptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
        if (rptType.equals((Object)BgAnalysisTypeEnum.BGBALANCE) || rptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE) || rptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE) || rptType.equals((Object)BgAnalysisTypeEnum.BGQUERY) || rptType.equals((Object)BgAnalysisTypeEnum.BGDIFFER) || rptType.equals((Object)BgAnalysisTypeEnum.BGFORMQUERY) || rptType.equals((Object)BgAnalysisTypeEnum.FUNDFORMQUERY) || rptType.equals((Object)BgAnalysisTypeEnum.FUNDBALANCE) || rptType.equals((Object)BgAnalysisTypeEnum.FUNDCOMPARE) || rptType.equals((Object)BgAnalysisTypeEnum.FUNDDIFFER)) {
            BgSchemeInfo schemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
            BgPeriodEnum periodType = (BgPeriodEnum)((Object)this.comboBgPeriod.getSelectedItem());
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            try {
                BgPeriodCollection periodColl = null;
                if (periodType.getValue() == 8) {
                    if (!beginPeriod.getId().toString().equals(endPeriod.getId().toString())) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"304_BgRptFilterUI"));
                        return false;
                    }
                    periodColl = new BgPeriodCollection();
                    periodColl.add(beginPeriod);
                } else {
                    if (!(beginPeriod.getPeriodType().getValue() != 8 && endPeriod.getPeriodType().getValue() != 8 || beginPeriod.getId().toString().equals(endPeriod.getId().toString()))) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"305_BgRptFilterUI"));
                        return false;
                    }
                    if (!rptType.equals((Object)BgAnalysisTypeEnum.BGFORMQUERY)) {
                        if (beginPeriod.getPeriodType().getValue() == 8) {
                            periodColl = new BgPeriodCollection();
                            periodColl.add(beginPeriod);
                        } else {
                            periodColl = this.getAccumPeriodColl(beginPeriod.getPeriodType().getValue(), BgHelper.getDayBegin(schemeInfo.getDateFrom()), BgHelper.getDayEnd(schemeInfo.getDateTo()));
                        }
                    } else {
                        periodColl = this.getAccumPeriodColl(beginPeriod.getPeriodType().getValue(), BgHelper.getDayBegin(this.retBeginPeriod.getBeginDate()), BgHelper.getDayEnd(this.retEndPeriod.getEndDate()));
                    }
                }
                if (periodColl == null || periodColl != null && periodColl.size() < 1) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BgSchemeBgPeriodMsg"));
                    return false;
                }
                boolean beginBln1 = BgHelper.compareBgPeriodBegin2End(periodColl.get(0), beginPeriod);
                boolean beginBln2 = BgHelper.compareBgPeriodBegin2End(beginPeriod, periodColl.get(periodColl.size() - 1));
                boolean beginBln3 = BgHelper.compareBgPeriodBegin2End(beginPeriod, periodColl.get(0));
                boolean endBln1 = BgHelper.compareBgPeriodBegin2End(periodColl.get(0), endPeriod);
                boolean endBln2 = BgHelper.compareBgPeriodBegin2End(endPeriod, periodColl.get(periodColl.size() - 1));
                boolean endBln3 = BgHelper.compareBgPeriodBegin2End(periodColl.get(periodColl.size() - 1), endPeriod);
                if (beginBln1 && beginBln2 || endBln1 && endBln2 || beginBln3 && endBln3) {
                    this.retBeginPeriod = beginBln1 ? beginPeriod : periodColl.get(0);
                    this.retEndPeriod = endBln2 ? endPeriod : periodColl.get(periodColl.size() - 1);
                }
                this.periodIds = new String[periodColl.size()];
                for (int i = 0; i < periodColl.size(); ++i) {
                    this.periodIds[i] = periodColl.get(i).getId().toString();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.verify();
    }

    protected BgPeriodCollection getAccumPeriodColl(int bgPeriodType, Date beginDate, Date endDate) throws Exception {
        return BgHelper.getBgPeriodCollection(bgPeriodType, beginDate, endDate);
    }

    public String[] getCompanyNames() {
        return this.companyNames;
    }

    public void setCompanyNames(String[] companyNames) {
        this.companyNames = companyNames;
    }

    public boolean isFromFund() {
        return this.isFromFund;
    }

    public void setFromFund(boolean isFromFund) {
        this.isFromFund = isFromFund;
    }

    public OrgUnitInfo getBaseOrgUnitInfo() {
        return this.currentCompany;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] dealSelectorOrgUnitInfo(Object[] orgUnitInfo) {
        int i;
        if (orgUnitInfo == null || orgUnitInfo.length <= 1) {
            return orgUnitInfo;
        }
        String longnumber = null;
        String tmpLongnumber = null;
        String baseLongnumer = null;
        String[] numbers = null;
        String[] baseNumbers = null;
        CostCenterOrgUnitInfo[] costCenterOrgUnits = null;
        CostCenterOrgUnitInfo fullOrgUnitInfo = null;
        CostCenterOrgUnitCollection fullOrgUnitColl = null;
        HashMap<String, String[]> numberMap = new HashMap<String, String[]>();
        Set<String> orgUnitSet = new HashSet<String>();
        int n = orgUnitInfo.length;
        for (i = 0; i < n; ++i) {
            fullOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnitInfo[i];
            longnumber = fullOrgUnitInfo.getLongNumber();
            numbers = longnumber.split("!");
            baseLongnumer = baseLongnumer == null ? longnumber : baseLongnumer;
            numberMap.put(longnumber, numbers);
        }
        baseLongnumer = this.getCommonLongNumber(baseLongnumer, numberMap);
        baseNumbers = baseLongnumer.split("!");
        orgUnitSet.add(baseLongnumer);
        n = orgUnitInfo.length;
        for (i = 0; i < n; ++i) {
            fullOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnitInfo[i];
            longnumber = fullOrgUnitInfo.getLongNumber();
            numbers = longnumber.split("!");
            if (!longnumber.startsWith(baseLongnumer)) continue;
            if (longnumber.equals(baseLongnumer)) {
                orgUnitSet.add(longnumber);
                continue;
            }
            tmpLongnumber = baseLongnumer;
            int jn = numbers.length;
            for (int j = baseNumbers.length; j < jn; ++j) {
                tmpLongnumber = tmpLongnumber + "!" + numbers[j];
                orgUnitSet.add(tmpLongnumber);
            }
        }
        orgUnitSet = this.orgUnitSetToNum(orgUnitSet);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", orgUnitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("longnumber");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        try {
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
            fullOrgUnitColl = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
            if (fullOrgUnitColl != null && !fullOrgUnitColl.isEmpty()) {
                costCenterOrgUnits = new CostCenterOrgUnitInfo[fullOrgUnitColl.size()];
                int n2 = fullOrgUnitColl.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    fullOrgUnitInfo = fullOrgUnitColl.get(i2);
                    if (fullOrgUnitInfo.getLongNumber().equals(baseLongnumer)) {
                        this.currentCompany = new CostCenterOrgUnitInfo();
                        this.currentCompany.setId(fullOrgUnitInfo.getId());
                        this.currentCompany.setNumber(fullOrgUnitInfo.getNumber());
                        this.currentCompany.setName(fullOrgUnitInfo.getName());
                        this.currentCompany.setLongNumber(fullOrgUnitInfo.getLongNumber());
                    }
                    costCenterOrgUnits[i2] = fullOrgUnitInfo;
                }
            }
        }
        catch (BOSException bOSException) {
        }
        if (costCenterOrgUnits != null && costCenterOrgUnits.length > 0) {
            this.isUserUpdate = false;
            this.prmtOrgUnit.setData((Object)costCenterOrgUnits);
            this.isUserUpdate = true;
        }
        return costCenterOrgUnits;
    }

    private Set orgUnitSetToNum(Set orgUnitSet) {
        HashSet<String> set = new HashSet<String>();
        String[] numbers = null;
        String num = null;
        Iterator iter = orgUnitSet.iterator();
        while (iter.hasNext()) {
            numbers = null;
            num = null;
            String longNum = (String)iter.next();
            numbers = longNum.split("!");
            num = numbers[numbers.length - 1];
            set.add(num);
        }
        return set;
    }

    protected String getCommonLongNumber(String longnumber, Map numberMap) {
        if (longnumber == null || numberMap == null || numberMap.isEmpty()) {
            return "";
        }
        String tmpLongnumber2 = null;
        String[] numbers = null;
        StringBuffer str = new StringBuffer();
        for (String tmpLongnumber2 : numberMap.keySet()) {
            if (tmpLongnumber2.startsWith(longnumber)) continue;
            numbers = longnumber.split("!");
            int n = numbers.length - 1;
            for (int i = 0; i < n; ++i) {
                str.append(numbers[i] + "!");
            }
            longnumber = str.delete(str.length() - 1, str.length()).toString();
            longnumber = this.getCommonLongNumber(longnumber, numberMap);
        }
        return longnumber;
    }

    public void clear() {
        super.clear();
        this.prmtOrgUnit.setData((Object)this.curOrgUnitinfo);
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        if (this.analyseFacade == null) {
            this.analyseFacade = BgAnalyseFacadeFactory.getRemoteInstance();
        }
        return this.analyseFacade;
    }
}

