/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BGTEMPLATE_STATUS_Enum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgSchemeFacadeFactory;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgSchemeFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgSchemeEditUI;
import com.kingdee.eas.ma.budget.client.BgTemplateImportUI;
import com.kingdee.eas.ma.nbudget.client.BgNCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSchemeEditUI
extends AbstractBgSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeEditUI.class);
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean isUseIntermitNumber = false;
    private FullOrgUnitInfo orgUnitInfo = null;
    Hashtable selectedTemplates = new Hashtable();
    public Hashtable needSubmitDataMap = new Hashtable();

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeLoad() throws EASBizException {
        FullOrgUnitInfo ccOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String CUID = ccOrgUnitInfo.getId().toString();
        BgSchemeInfo bgTemplateInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            bgTemplateInfo = new BgSchemeInfo();
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            this.setHasCodeNumber(BgHelper.hasNumber((CoreBaseInfo)bgTemplateInfo, CUID, codingRuleManager));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgHelper.hasDisplayNumber((CoreBaseInfo)bgTemplateInfo, CUID, codingRuleManager));
                this.setUseIntermitNumber(BgHelper.isUseIntermitNumber((CoreBaseInfo)bgTemplateInfo, CUID, codingRuleManager));
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        finally {
            codingRuleManager = null;
        }
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        this.kdtBgSchemeNodes.checkParsed();
        super.onLoad();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            // empty if block
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (this.editData != null && this.editData.getId() != null && this.editData.getRootId() != null && !this.editData.getId().toString().equals(this.editData.getRootId().toString())) {
                this.chkSubmitByScheme.setEnabled(false);
                this.chkReportByScheme.setEnabled(false);
            } else {
                this.chkSubmitByScheme.setEnabled(true);
                this.chkReportByScheme.setEnabled(true);
            }
        }
        this.kDLabelTemplate.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.kdtBgSchemeNodes.getStyleAttributes().setLocked(true);
        this.kdtBgSchemeNodes.getSelectManager().setSelectMode(2);
        this.initBgShcmeTable();
        this.menuBiz.setVisible(false);
        String format = BgNationalFormatUIUtil.getNationalDateFormatString();
        this.kdtBgSchemeNodes.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
    }

    private void initBgShcmeTable() {
        if (this.kdtBgSchemeNodes.getRowCount() < 1) {
            return;
        }
        int rowcount = this.kdtBgSchemeNodes.getRowCount();
        for (int j = 0; j < rowcount; ++j) {
            int status = 0;
            if (this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue() != null && this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue() instanceof BizEnumValueInfo) {
                status = ((BizEnumValueInfo)this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue()).getInt();
            } else if (this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue() != null && this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue() instanceof Integer) {
                status = (Integer)this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue();
            } else if (this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue() != null && this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue() instanceof BGTEMPLATE_STATUS_Enum) {
                status = ((BGTEMPLATE_STATUS_Enum)((Object)this.kdtBgSchemeNodes.getRow(j).getCell("bgtemplateStatus").getValue())).getValue();
            }
            if (status != 10) continue;
            this.kdtBgSchemeNodes.getRow(j).getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtParentSchemeName.setEditable(false);
        if (this.editData == null) {
            return;
        }
        if (this.getOprtState().equals("VIEW")) {
            this.txtNumber.setEditable(false);
            this.mltName.setEditable(false);
            this.pkDateFrom.setEditable(false);
            this.pkDateFrom.setEnabled(false);
            this.pkDateTo.setEditable(false);
            this.pkDateTo.setEnabled(false);
            this.comboPeriod.setEditable(false);
            this.comboPeriod.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnImportTemplate.setEnabled(false);
            this.btnRemoveTemplate.setEnabled(false);
        } else {
            this.btnImportTemplate.setEnabled(true);
            this.btnRemoveTemplate.setEnabled(true);
        }
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        if (this.getOprtState().equals("ADDNEW")) {
            this.txtNumber.setEditable(true);
            this.mltName.setEditable(true);
            this.pkDateFrom.setEditable(true);
            this.pkDateFrom.setEnabled(true);
            this.pkDateTo.setEditable(true);
            this.pkDateTo.setEnabled(true);
            this.comboPeriod.setEditable(true);
            this.comboPeriod.setEnabled(true);
            if (this.orgUnitInfo != null) {
                this.editData.setOrgUnit(this.orgUnitInfo);
                this.bizOrgUnit.setValue((Object)this.orgUnitInfo);
            }
        } else {
            this.comboPeriod.setSelectedItem((Object)this.editData.getPeriod());
            if (this.orgUnitInfo != null) {
                this.editData.setOrgUnit(this.orgUnitInfo);
                this.bizOrgUnit.setValue((Object)this.orgUnitInfo);
                try {
                    IBgScheme ibgScheme = BgSchemeFactory.getRemoteInstance();
                    String bgSchemeId = null;
                    if (this.getUIContext().get("ID") != null) {
                        bgSchemeId = this.getUIContext().get("ID").toString();
                    } else if (this.editData != null && this.editData.getId() != null) {
                        bgSchemeId = this.editData.getId().toString();
                    }
                    if (bgSchemeId != null) {
                        BgTemplateCollection templateColl = ibgScheme.getTemplateBySchemeToAddTem(bgSchemeId);
                        Iterator iter = templateColl.iterator();
                        while (iter.hasNext()) {
                            BgTemplateInfo info = (BgTemplateInfo)iter.next();
                            if (info.getTemplateStatus().getValue() != 0) continue;
                            this.selectedTemplates.put(info.getId().toString(), info);
                        }
                    }
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                if (this.getOprtState().equals("EDIT")) {
                    boolean isAssinged = false;
                    try {
                        String id = (String)this.getUIContext().get("ID");
                        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
                        isAssinged = iBgScheme.hasChildScheme(id);
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                    catch (BOSException e) {
                        this.handUIException(e);
                    }
                    if (isAssinged || this.editData.getParentScheme() != null || this.getUIContext().get("IsQuotedByBgForm") != null && this.getUIContext().get("IsQuotedByBgForm").equals(Boolean.TRUE)) {
                        this.txtNumber.setEditable(false);
                        this.mltName.setEditable(false);
                        this.pkDateFrom.setEditable(false);
                        this.pkDateFrom.setEnabled(false);
                        this.pkDateTo.setEditable(false);
                        this.pkDateTo.setEnabled(false);
                        this.comboPeriod.setEditable(false);
                        this.comboPeriod.setEnabled(false);
                        this.btnImportTemplate.setEnabled(true);
                        this.btnRemoveTemplate.setEnabled(true);
                    }
                    if (this.editData.getId() != null && this.editData.getId().toString().equals(this.editData.getRootId().toString())) {
                        this.pkDateTo.setEditable(true);
                        this.pkDateTo.setEnabled(true);
                    }
                }
            }
        }
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        int i;
        BgSchemeInfo info = (BgSchemeInfo)this.getBizInterface().getValue(pk, this.getSelectors());
        BgTemplateCollection bgTemColl = new BgTemplateCollection();
        if (info.getBgSchemeNodes().size() > 0) {
            for (i = 0; i < info.getBgSchemeNodes().size(); ++i) {
                bgTemColl.add(info.getBgSchemeNodes().get(i).getBgTemplate());
            }
        }
        BgHelper.sortCollection(bgTemColl, new String[]{"number"});
        if (bgTemColl != null) {
            for (i = 0; i < bgTemColl.size(); ++i) {
                info.getBgSchemeNodes().get(i).setBgTemplate(bgTemColl.get(i));
            }
        }
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("dateFrom"));
        sic.add(new SelectorItemInfo("dateTo"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("parentScheme.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.number"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.creator.*"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.isAllowChange"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.creator.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.createTime"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.description"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("formallyYearScheme"));
        sic.add(new SelectorItemInfo("isSubmitByScheme"));
        sic.add(new SelectorItemInfo("isReportByScheme"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.templateStatus"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(true);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnImportTemplate.setTextIconDisStyle((short)3);
        this.btnRemoveTemplate.setTextIconDisStyle((short)3);
        this.btnImportTemplate.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.btnRemoveTemplate.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnCheckFormula.setTextIconDisStyle((short)3);
        this.btnCheckFormula.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.menuView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.actionEdit.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        BgSchemeInfo schemeInfo = new BgSchemeInfo();
        schemeInfo.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get("EditOrg"));
        this.comboPeriod.setSelectedIndex(0);
        schemeInfo.setPeriod((BgPeriodEnum)((Object)this.comboPeriod.getSelectedItem()));
        schemeInfo.setCU(schemeInfo.getOrgUnit().getCU());
        String CUID = schemeInfo.getOrgUnit().getId().toString();
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            this.getNumberByCodingRule((IObjectValue)schemeInfo, CUID);
        } else if (this.isHasCodeNumber() && this.isUseIntermitNumber()) {
            String num = "";
            schemeInfo.setNumber(num);
            this.txtNumber.setText(num);
            this.txtNumber.setEnabled(false);
        }
        return schemeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    private String getImportUIName() {
        return BgTemplateImportUI.class.getName();
    }

    @Override
    protected void btnImportTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.btnImportTemplate_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", this.getUIContext().get("ID"));
        uiContext.put((Object)"EditOrg", (Object)this.orgUnitInfo);
        uiContext.put((Object)"templates", (Object)this.selectedTemplates);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getImportUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        boolean isConfirm = ((BgTemplateImportUI)uiWindow.getUIObject()).isConfirm();
        if (isConfirm) {
            this.kdtBgSchemeNodes.removeRows();
            Hashtable selectedTemplatesFromImport = ((BgTemplateImportUI)uiWindow.getUIObject()).getSelectedTemplates();
            String key = null;
            Iterator it = selectedTemplatesFromImport.keySet().iterator();
            while (it.hasNext()) {
                BgSchemeNodeInfo bgSchemeNodeInfo = new BgSchemeNodeInfo();
                bgSchemeNodeInfo.setId(BOSUuid.create((BOSObjectType)bgSchemeNodeInfo.getBOSType()));
                key = (String)it.next();
                BgTemplateInfo bgTempInfo = (BgTemplateInfo)selectedTemplatesFromImport.get(key);
                bgSchemeNodeInfo.setBgScheme(this.editData);
                bgSchemeNodeInfo.setBgTemplate(bgTempInfo);
                IRow iRow = this.kdtBgSchemeNodes.addRow();
                iRow.setUserObject((Object)bgSchemeNodeInfo);
                iRow.getCell("number").setValue((Object)bgTempInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgTempInfo.getName());
                iRow.getCell("creator").setValue((Object)bgTempInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgTempInfo.getCreateTime());
                iRow.getCell("description").setValue((Object)bgTempInfo.getDescription());
                iRow.getCell("templateid").setValue((Object)bgTempInfo.getId());
                iRow.getCell("bgtemplateStatus").setValue((Object)bgTempInfo.getTemplateStatus());
                this.selectedTemplates.put(bgTempInfo.getId().toString(), bgTempInfo);
                if (this.needSubmitDataMap.containsKey(bgTempInfo.getId().toString())) continue;
                this.needSubmitDataMap.put(bgTempInfo.getId(), bgTempInfo.getId().toString());
            }
        } else {
            uiWindow.close();
            SysUtil.abort();
        }
        BgTemplateCollection coll = new BgTemplateCollection();
        BgSchemeNodeCollection nodeColl = new BgSchemeNodeCollection();
        if (this.kdtBgSchemeNodes.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < this.kdtBgSchemeNodes.getRowCount(); ++i) {
            BgSchemeNodeInfo schemeNodeInfo = (BgSchemeNodeInfo)this.kdtBgSchemeNodes.getRow(i).getUserObject();
            nodeColl.add((BgSchemeNodeInfo)this.kdtBgSchemeNodes.getRow(i).getUserObject());
            BgTemplateInfo info = schemeNodeInfo.getBgTemplate();
            coll.add(info);
        }
        BgHelper.sortCollection(coll, new String[]{"number"});
        this.kdtBgSchemeNodes.removeRows();
        for (int n = 0; n < coll.size(); ++n) {
            BgTemplateInfo info = coll.get(n);
            IRow iRow = this.kdtBgSchemeNodes.addRow();
            BgSchemeNodeInfo bgSchemeNodeInfo = new BgSchemeNodeInfo();
            bgSchemeNodeInfo.setId(BOSUuid.create((BOSObjectType)bgSchemeNodeInfo.getBOSType()));
            bgSchemeNodeInfo.setBgScheme(this.editData);
            bgSchemeNodeInfo.setBgTemplate(info);
            iRow.setUserObject((Object)bgSchemeNodeInfo);
            iRow.getCell("number").setValue((Object)info.getNumber());
            iRow.getCell("name").setValue((Object)info.getName());
            iRow.getCell("creator").setValue((Object)info.getCreator().getName());
            iRow.getCell("createTime").setValue((Object)info.getCreateTime());
            iRow.getCell("description").setValue((Object)info.getDescription());
            iRow.getCell("templateid").setValue((Object)info.getId());
            iRow.getCell("bgtemplateStatus").setValue((Object)info.getTemplateStatus());
        }
        this.initBgShcmeTable();
    }

    @Override
    protected void btnRemoveTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveTemplate_actionPerformed(e);
        if (this.kdtBgSchemeNodes.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        KDTSelectBlock selectBlock = this.kdtBgSchemeNodes.getSelectManager().get();
        int topIndex = selectBlock.getBeginRow();
        int buttomIndex = selectBlock.getEndRow();
        for (int i = topIndex; i <= buttomIndex; ++i) {
            IRow iRow = this.kdtBgSchemeNodes.getRow(i);
            String templateId = null;
            templateId = iRow.getCell("templateid").getValue().toString();
            if (this.getOprtState().equals("EDIT")) {
                String schemeId = this.getUIContext().get("ID").toString();
                if (BgSchemeHelper.checkTemplateQuoted(schemeId, templateId)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"TemplateQuoted"));
                    SysUtil.abort();
                }
                String bgSchemId = (String)this.getUIContext().get("ID");
                if (BgSchemeHelper.checkTemplateHasChild(templateId) && BgSchemeHelper.checkTempAssignedInBgScheme(templateId, bgSchemId)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"TemplateHasChild"));
                    SysUtil.abort();
                }
            }
            this.kdtBgSchemeNodes.removeRow(i);
            if (iRow.getUserObject() != null) {
                BgSchemeNodeInfo nodeInfo = (BgSchemeNodeInfo)iRow.getUserObject();
                this.editData.getBgSchemeNodes().remove(nodeInfo);
            }
            this.selectedTemplates.remove(templateId);
            if (this.needSubmitDataMap.containsKey(templateId)) continue;
            this.needSubmitDataMap.put(templateId, templateId);
        }
        this.initBgShcmeTable();
    }

    public boolean checkBeforeWindowClosing() {
        if (this.oprtState.equals("VIEW")) {
            return true;
        }
        boolean isAddNew = false;
        if (this.getUIContext() != null && this.getUIContext().get("isAddNew") != null && ((Boolean)this.getUIContext().get("isAddNew")).booleanValue()) {
            isAddNew = true;
        }
        if (this.save) {
            return true;
        }
        if (this.getOprtState().equals("VIEW")) {
            return true;
        }
        if (this.needSubmitDataMap != null && this.needSubmitDataMap.size() > 0 || this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    return !this.actionSave.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    @Override
    protected void comboPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboPeriod.getSelectedIndex() == -1) {
            this.chkFormallyYearScheme.setSelected(false);
            return;
        }
        BgPeriodEnum period = (BgPeriodEnum)((Object)this.comboPeriod.getSelectedItem());
        if (period.getValue() == 1) {
            if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
                this.chkFormallyYearScheme.setEnabled(true);
                return;
            }
        } else {
            this.chkFormallyYearScheme.setSelected(false);
            this.chkFormallyYearScheme.setEnabled(false);
            return;
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.vertifyTime();
        }
        this.editData.getBgSchemeNodes().clear();
        if (this.txtNumber.isEnabled() && (this.txtNumber.getText() == null || this.txtNumber.getText().equals(""))) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NumberNull"));
            return;
        }
        if (this.mltName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() == null || this.mltName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().equals("")) {
            this.mltName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NameNull"));
            return;
        }
        if (this.pkDateFrom.getValue() == null) {
            this.pkDateFrom.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"DateFromNull"));
            this.pkDateFrom.requestFocus(true);
            return;
        }
        if (this.pkDateTo.getValue() == null) {
            this.pkDateTo.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"DateToNull"));
            this.pkDateTo.requestFocus(true);
            return;
        }
        Date dateFrom = BgHelper.getDayBegin((Date)this.pkDateFrom.getValue());
        Date dateTo = BgHelper.getDayBegin((Date)this.pkDateTo.getValue());
        if (dateTo.before(dateFrom)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"DateToBeforeDateFrom"));
            this.pkDateTo.requestFocus(true);
            return;
        }
        if (this.kdtBgSchemeNodes.getRowCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"OneTemplateAtLeast"));
            SysUtil.abort();
        }
        boolean isAssinged = false;
        if (this.getUIContext() != null && this.getUIContext().get("isAddNew") != null && !((Boolean)this.getUIContext().get("isAddNew")).booleanValue()) {
            String id = (String)this.getUIContext().get("ID");
            IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
            isAssinged = iBgScheme.hasChildScheme(id);
        }
        this.editData.setIsFiling(false);
        if (this.getMetaDataPK().getFullName().equals(BgSchemeEditUI.class.getName())) {
            if (isAssinged) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"SchemeAssignedConfirmSave"));
                if (result == 0) {
                    IBgSchemeFacade iBgSchemeFacade = BgSchemeFacadeFactory.getRemoteInstance();
                    iBgSchemeFacade.updateDownSchemeSubmitWay(this.chkSubmitByScheme.isSelected(), this.chkReportByScheme.isSelected(), this.editData.getId().toString());
                    super.actionSubmit_actionPerformed(e);
                }
            } else {
                super.actionSubmit_actionPerformed(e);
            }
            this.getUIWindow().close();
        } else {
            IBgSchemeFacade iBgSchemeFacade = BgSchemeFacadeFactory.getRemoteInstance();
            iBgSchemeFacade.updateDownSchemeSubmitWay(this.chkSubmitByScheme.isSelected(), this.chkReportByScheme.isSelected(), this.editData.getId().toString());
            super.actionSubmit_actionPerformed(e);
        }
        BgNCHelper.refreshListUI((CoreUI)((CoreUI)this.getUIContext().get("Owner")));
    }

    protected boolean isSubmitLoad() {
        return false;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getUIContext().get("OrgUnitInfo") == null) {
            return null;
        }
        OrgUnitInfo org = (OrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
        return new ObjectUuidPK(org.getId().toString());
    }

    @Override
    protected void btnCheckFormula_actionPerformed(ActionEvent e) throws Exception {
        super.btnCheckFormula_actionPerformed(e);
        ArrayList<String> bgTemIdList = new ArrayList<String>();
        IBgSchemeFacade iScheme = BgSchemeFacadeFactory.getRemoteInstance();
        for (int i = 0; i < this.kdtBgSchemeNodes.getRowCount(); ++i) {
            IRow row = this.kdtBgSchemeNodes.getRow(i);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof BgSchemeNodeInfo)) continue;
            String id = ((BgSchemeNodeInfo)row.getUserObject()).getBgTemplate().getId().toString();
            bgTemIdList.add(id);
        }
        Map formulaDumMap = iScheme.checkFormulaDump(bgTemIdList);
        UIContext context = new UIContext((Object)this);
        context.put((Object)"formulaDumMap", (Object)formulaDumMap);
        context.put((Object)"orgName", (Object)((FullOrgUnitInfo)this.bizOrgUnit.getData()).getName());
        context.put((Object)"owner", (Object)this);
        IUIWindow uiWindow1 = null;
        try {
            uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.ItemFormulaDumpUI", (Map)context);
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
        uiWindow1.show();
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsFormal()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"SchemeExecutedNoDel"));
            SysUtil.abort();
        }
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        if (this.editData.getId() != null && iBgScheme.isQuotedByBgForm(this.editData.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"SchemeQuotedNotDelete"));
            return;
        }
        if (this.editData.getId() != null && iBgScheme.hasChildScheme(this.editData.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"SchemeHasChildNotDelete"));
            return;
        }
        super.actionRemove_actionPerformed(e);
        BgNCHelper.refreshListUI((CoreUI)((CoreUI)this.getUIContext().get("Owner")));
    }

    public boolean isUseIntermitNumber() {
        return this.isUseIntermitNumber;
    }

    public void setUseIntermitNumber(boolean isUseIntermitNumber) {
        this.isUseIntermitNumber = isUseIntermitNumber;
    }

    public void vertifyTime() throws ParseException, BOSException, EASBizException {
        boolean isAssinged = false;
        String id = (String)this.getUIContext().get("ID");
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        isAssinged = iBgScheme.hasChildScheme(id);
        Date dateTo = this.editData.getDateTo();
        if (isAssinged && dateTo.compareTo((Date)this.pkDateTo.getValue()) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"assignedSchemeDateError"), dateTo.toString()));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid userPK = SysContext.getSysContext().getCurrentUserInfo().getId();
        BOSUuid orgPK = SysContext.getSysContext().getCurrentOrgUnit().getId();
        PermissionHelper.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userPK), (IObjectPK)new ObjectUuidPK(orgPK), (String)"bg_scheme02_addNew");
        super.actionAddNew_actionPerformed(e);
    }
}

